/*
 * Decompiled with CFR 0.152.
 */
package mumart.micromod.xm;

import mumart.micromod.xm.GlobalVol;
import mumart.micromod.xm.Instrument;
import mumart.micromod.xm.Module;
import mumart.micromod.xm.Note;
import mumart.micromod.xm.Sample;

public class Channel {
    private static final int FP_SHIFT = 15;
    private static final int FP_ONE = 32768;
    private static final int FP_MASK = Short.MAX_VALUE;
    private static final int[] period_table = new int[]{54784, 54390, 53999, 53610, 53224, 52841, 52461, 52084, 51709, 51337, 50968, 50601, 50237, 49876, 49517, 49161, 48807, 48456, 48107, 47761, 47418, 47076, 46738, 46401, 46068, 45736, 45407, 45081, 44756, 44434, 44115, 43797, 43482, 43169, 42859, 42550, 42244, 41940, 41639, 41339, 41042, 40746, 40453, 40162, 39873, 39586, 39302, 39019, 38738, 38459, 38183, 37908, 37635, 37365, 37096, 36829, 36564, 36301, 36040, 35780, 35523, 35267, 35014, 34762, 34512, 34263, 34017, 33772, 33529, 33288, 33049, 32811, 32575, 32340, 32108, 31877, 31647, 31420, 31194, 30969, 30746, 30525, 30306, 30088, 29871, 29656, 29443, 29231, 29021, 28812, 28605, 28399, 28195, 27992, 27790, 27590, 27392, 27195, 26999, 26805, 26612, 26421, 26231, 26042};
    private static final int[] freq_table = new int[]{267616, 269555, 271509, 273476, 275458, 277454, 279464, 281489, 283529, 285584, 287653, 289738, 291837, 293952, 296082, 298228, 300389, 302566, 304758, 306966, 309191, 311431, 313688, 315961, 318251, 320557, 322880, 325220, 327576, 329950, 332341, 334749, 337175, 339618, 342079, 344558, 347055, 349570, 352103, 354655, 357225, 359813, 362420, 365047, 367692, 370356, 373040, 375743, 378466, 381209, 383971, 386754, 389556, 392379, 395222, 398086, 400971, 403877, 406803, 409751, 412720, 415711, 418723, 421758, 424814, 427892, 430993, 434116, 437262, 440430, 443622, 446837, 450075, 453336, 456621, 459930, 463263, 466620, 470001, 473407, 476838, 480293, 483773, 487279, 490810, 494367, 497949, 501557, 505192, 508853, 512540, 516254, 519995, 523763, 527558, 531381, 535232, 539111, 543017, 546952, 550915, 554908, 558929, 562979};
    private static final short[] arp_tuning = new short[]{4096, 4340, 4598, 4871, 5161, 5468, 5793, 6137, 6502, 6889, 7298, 7732, 8192, 8679, 9195, 9742};
    private static final short[] sine_table;
    private Module module;
    private GlobalVol global_vol;
    private Instrument instrument;
    private Sample sample;
    private boolean key_on;
    private int note_key;
    private int note_ins;
    private int note_vol;
    private int note_effect;
    private int note_param;
    private int volume;
    private int panning;
    private int fine_tune;
    private int sample_idx;
    private int sample_fra;
    private int step;
    private int ampl;
    private int pann;
    private int fade_out_vol;
    private int vol_env_tick;
    private int pan_env_tick;
    private int period;
    private int porta_period;
    private int retrig_count;
    private int fx_count;
    private int auto_vibrato_count;
    private int porta_up_param;
    private int porta_down_param;
    private int tone_porta_param;
    private int offset_param;
    private int fine_porta_up_param;
    private int fine_porta_down_param;
    private int extra_fine_porta_param;
    private int vslide_param;
    private int global_vslide_param;
    private int panning_slide_param;
    private int fine_vslide_up_param;
    private int fine_vslide_down_param;
    private int retrig_volume;
    private int retrig_ticks;
    private int tremor_on_ticks;
    private int tremor_off_ticks;
    private int vibrato_type;
    private int vibrato_phase;
    private int vibrato_speed;
    private int vibrato_depth;
    private int tremolo_type;
    private int tremolo_phase;
    private int tremolo_speed;
    private int tremolo_depth;
    private int tremolo_add;
    private int vibrato_add;
    private int arpeggio_add;
    private int id;
    private int sample_rate;
    private int random_seed;
    public int pl_row;

    static {
        short[] sArray = new short[32];
        sArray[1] = 24;
        sArray[2] = 49;
        sArray[3] = 74;
        sArray[4] = 97;
        sArray[5] = 120;
        sArray[6] = 141;
        sArray[7] = 161;
        sArray[8] = 180;
        sArray[9] = 197;
        sArray[10] = 212;
        sArray[11] = 224;
        sArray[12] = 235;
        sArray[13] = 244;
        sArray[14] = 250;
        sArray[15] = 253;
        sArray[16] = 255;
        sArray[17] = 253;
        sArray[18] = 250;
        sArray[19] = 244;
        sArray[20] = 235;
        sArray[21] = 224;
        sArray[22] = 212;
        sArray[23] = 197;
        sArray[24] = 180;
        sArray[25] = 161;
        sArray[26] = 141;
        sArray[27] = 120;
        sArray[28] = 97;
        sArray[29] = 74;
        sArray[30] = 49;
        sArray[31] = 24;
        sine_table = sArray;
    }

    public Channel(Module module, int id, int sample_rate, GlobalVol global_vol) {
        this.module = module;
        this.id = this.random_seed = id;
        this.sample_rate = sample_rate;
        this.global_vol = global_vol;
        this.instrument = new Instrument();
        this.sample = this.instrument.samples[0];
    }

    /*
     * Unable to fully structure code
     */
    public void resample(int[] out_buf, int offset, int length, boolean interpolate) {
        block5: {
            if (this.ampl <= 0) {
                return;
            }
            l_ampl = this.ampl * (255 - this.pann) >> 8;
            r_ampl = this.ampl * this.pann >> 8;
            sam_idx = this.sample_idx;
            sam_fra = this.sample_fra;
            step = this.step;
            loop_len = this.sample.loop_length;
            loop_ep1 = this.sample.loop_start + loop_len;
            sample_data = this.sample.sample_data;
            out_idx = offset << 1;
            out_ep1 = offset + length << 1;
            if (!interpolate) ** GOTO lbl45
            while (out_idx < out_ep1) {
                block6: {
                    if (sam_idx < loop_ep1) break block6;
                    if (loop_len > 1) ** GOTO lbl19
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        sam_idx -= loop_len;
lbl19:
                        // 2 sources

                        ** while (sam_idx >= loop_ep1)
                    }
                }
                c = sample_data[sam_idx];
                m = sample_data[sam_idx + 1] - c;
                y = (m * sam_fra >> 15) + c;
                v0 = out_idx++;
                out_buf[v0] = out_buf[v0] + (y * l_ampl >> 15);
                v1 = out_idx++;
                out_buf[v1] = out_buf[v1] + (y * r_ampl >> 15);
                sam_idx += (sam_fra += step) >> 15;
                sam_fra &= 32767;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                block7: {
                    if (sam_idx < loop_ep1) break block7;
                    if (loop_len > 1) ** GOTO lbl36
                    break;
lbl-1000:
                    // 1 sources

                    {
                        sam_idx -= loop_len;
lbl36:
                        // 2 sources

                        ** while (sam_idx >= loop_ep1)
                    }
                }
                y = sample_data[sam_idx];
                v2 = out_idx++;
                out_buf[v2] = out_buf[v2] + (y * l_ampl >> 15);
                v3 = out_idx++;
                out_buf[v3] = out_buf[v3] + (y * r_ampl >> 15);
                sam_idx += (sam_fra += step) >> 15;
                sam_fra &= 32767;
lbl45:
                // 2 sources

                ** while (out_idx < out_ep1)
            }
        }
    }

    public void update_sample_idx(int length) {
        this.sample_fra += this.step * length;
        this.sample_idx += this.sample_fra >> 15;
        int loop_start = this.sample.loop_start;
        int loop_length = this.sample.loop_length;
        int loop_offset = this.sample_idx - loop_start;
        if (loop_offset > 0) {
            this.sample_idx = loop_start;
            if (loop_length > 1) {
                this.sample_idx += loop_offset % loop_length;
            }
        }
        this.sample_fra &= Short.MAX_VALUE;
    }

    public void row(Note note) {
        this.note_key = note.key;
        this.note_ins = note.instrument;
        this.note_vol = note.volume;
        this.note_effect = note.effect;
        this.note_param = note.param;
        ++this.retrig_count;
        this.fx_count = 0;
        this.arpeggio_add = 0;
        this.tremolo_add = 0;
        this.vibrato_add = 0;
        if (this.note_effect != 269) {
            this.trigger();
        }
        switch (this.note_effect) {
            case 1: {
                if (this.note_param <= 0) break;
                this.porta_up_param = this.note_param;
                break;
            }
            case 2: {
                if (this.note_param <= 0) break;
                this.porta_down_param = this.note_param;
                break;
            }
            case 3: {
                if (this.note_param <= 0) break;
                this.tone_porta_param = this.note_param;
                break;
            }
            case 4: {
                if (this.note_param >> 4 > 0) {
                    this.vibrato_speed = this.note_param >> 4;
                }
                if ((this.note_param & 0xF) > 0) {
                    this.vibrato_depth = this.note_param & 0xF;
                }
                this.vibrato();
                break;
            }
            case 5: {
                if (this.note_param <= 0) break;
                this.vslide_param = this.note_param;
                break;
            }
            case 6: {
                if (this.note_param > 0) {
                    this.vslide_param = this.note_param;
                }
                this.vibrato();
                break;
            }
            case 7: {
                if (this.note_param >> 4 > 0) {
                    this.tremolo_speed = this.note_param >> 4;
                }
                if ((this.note_param & 0xF) > 0) {
                    this.tremolo_depth = this.note_param & 0xF;
                }
                this.tremolo();
                break;
            }
            case 8: {
                this.panning = this.note_param & 0xFF;
                break;
            }
            case 9: {
                if (this.note_param > 0) {
                    this.offset_param = this.note_param;
                }
                this.sample_idx = this.offset_param << 8;
                this.sample_fra = 0;
                break;
            }
            case 10: {
                if (this.note_param <= 0) break;
                this.vslide_param = this.note_param;
                break;
            }
            case 12: {
                this.volume = this.note_param >= 64 ? 64 : this.note_param & 0x3F;
                break;
            }
            case 16: {
                this.global_vol.volume = this.note_param >= 64 ? 64 : this.note_param & 0x3F;
                break;
            }
            case 17: {
                if (this.note_param <= 0) break;
                this.global_vslide_param = this.note_param;
                break;
            }
            case 20: {
                this.key_on = false;
                break;
            }
            case 21: {
                this.vol_env_tick = this.pan_env_tick = this.note_param & 0xFF;
                break;
            }
            case 25: {
                if (this.note_param <= 0) break;
                this.panning_slide_param = this.note_param;
                break;
            }
            case 27: {
                if (this.note_param >> 4 > 0) {
                    this.retrig_volume = this.note_param >> 4;
                }
                if ((this.note_param & 0xF) > 0) {
                    this.retrig_ticks = this.note_param & 0xF;
                }
                this.retrig_vol_slide();
                break;
            }
            case 29: {
                if (this.note_param >> 4 > 0) {
                    this.tremor_on_ticks = this.note_param >> 4;
                }
                if ((this.note_param & 0xF) > 0) {
                    this.tremor_off_ticks = this.note_param & 0xF;
                }
                this.tremor();
                break;
            }
            case 33: {
                if (this.note_param > 0) {
                    this.extra_fine_porta_param = this.note_param;
                }
                switch (this.extra_fine_porta_param & 0xF0) {
                    case 16: {
                        this.period -= this.extra_fine_porta_param & 0xF;
                    }
                    case 32: {
                        this.period += this.extra_fine_porta_param & 0xF;
                    }
                }
                break;
            }
            case 257: {
                if (this.note_param > 0) {
                    this.fine_porta_up_param = this.note_param;
                }
                this.period -= this.fine_porta_up_param << 2;
                break;
            }
            case 258: {
                if (this.note_param > 0) {
                    this.fine_porta_down_param = this.note_param;
                }
                this.period += this.fine_porta_down_param << 2;
                break;
            }
            case 260: {
                if (this.note_param >= 8) break;
                this.vibrato_type = this.note_param;
                break;
            }
            case 261: {
                this.fine_tune = (this.note_param & 0xF) << 4;
                if (this.fine_tune <= 127) break;
                this.fine_tune -= 256;
                break;
            }
            case 263: {
                if (this.note_param >= 8) break;
                this.tremolo_type = this.note_param;
                break;
            }
            case 266: {
                if (this.note_param > 0) {
                    this.fine_vslide_up_param = this.note_param;
                }
                this.volume += this.fine_vslide_up_param;
                if (this.volume <= 64) break;
                this.volume = 64;
                break;
            }
            case 267: {
                if (this.note_param > 0) {
                    this.fine_vslide_down_param = this.note_param;
                }
                this.volume -= this.fine_vslide_down_param;
                if (this.volume >= 0) break;
                this.volume = 0;
                break;
            }
            case 268: {
                if (this.note_param > 0) break;
                this.volume = 0;
                break;
            }
            case 269: {
                if (this.note_param > 0) break;
                this.trigger();
            }
        }
        this.auto_vibrato();
        this.calculate_frequency();
        this.calculate_amplitude();
        this.update_envelopes();
    }

    public void tick() {
        this.vibrato_add = 0;
        ++this.fx_count;
        ++this.retrig_count;
        if (this.note_effect != 269 || this.fx_count > this.note_param) {
            switch (this.note_vol & 0xF0) {
                case 96: {
                    this.volume -= this.note_vol & 0xF;
                    if (this.volume >= 0) break;
                    this.volume = 0;
                    break;
                }
                case 112: {
                    this.volume += this.note_vol & 0xF;
                    if (this.volume <= 64) break;
                    this.volume = 64;
                    break;
                }
                case 176: {
                    this.vibrato_phase += this.vibrato_speed;
                    this.vibrato();
                    break;
                }
                case 208: {
                    this.panning -= this.note_vol & 0xF;
                    if (this.panning >= 0) break;
                    this.panning = 0;
                    break;
                }
                case 224: {
                    this.panning += this.note_vol & 0xF;
                    if (this.panning <= 255) break;
                    this.panning = 255;
                    break;
                }
                case 240: {
                    this.tone_portamento();
                }
            }
        }
        switch (this.note_effect) {
            case 1: {
                this.period -= this.porta_up_param << 2;
                if (this.period >= 0) break;
                this.period = 0;
                break;
            }
            case 2: {
                this.period += this.porta_down_param << 2;
                if (this.period <= 65535) break;
                this.period = 65535;
                break;
            }
            case 3: {
                this.tone_portamento();
                break;
            }
            case 4: {
                this.vibrato_phase += this.vibrato_speed;
                this.vibrato();
                break;
            }
            case 5: {
                this.tone_portamento();
                this.volume_slide(this.vslide_param);
                break;
            }
            case 6: {
                this.vibrato_phase += this.vibrato_speed;
                this.vibrato();
                this.volume_slide(this.vslide_param);
                break;
            }
            case 7: {
                this.tremolo_phase += this.tremolo_speed;
                this.tremolo();
                break;
            }
            case 10: {
                this.volume_slide(this.vslide_param);
                break;
            }
            case 14: {
                if (this.fx_count > 2) {
                    this.fx_count = 0;
                }
                if (this.fx_count == 0) {
                    this.arpeggio_add = 0;
                }
                if (this.fx_count == 1) {
                    this.arpeggio_add = this.note_param >> 4;
                }
                if (this.fx_count != 2) break;
                this.arpeggio_add = this.note_param & 0xF;
                break;
            }
            case 17: {
                this.global_vol.volume += (this.global_vslide_param >> 4) - (this.global_vslide_param & 0xF);
                if (this.global_vol.volume < 0) {
                    this.global_vol.volume = 0;
                }
                if (this.global_vol.volume <= 64) break;
                this.global_vol.volume = 64;
                break;
            }
            case 25: {
                this.panning += (this.panning_slide_param >> 4) - (this.panning_slide_param & 0xF);
                if (this.panning < 0) {
                    this.panning = 0;
                }
                if (this.panning <= 255) break;
                this.panning = 255;
                break;
            }
            case 27: {
                this.retrig_vol_slide();
                break;
            }
            case 29: {
                this.tremor();
                break;
            }
            case 265: {
                if (this.fx_count < this.note_param) break;
                this.fx_count = 0;
                this.sample_fra = 0;
                this.sample_idx = 0;
                break;
            }
            case 268: {
                if (this.note_param != this.fx_count) break;
                this.volume = 0;
                break;
            }
            case 269: {
                if (this.note_param != this.fx_count) break;
                this.trigger();
            }
        }
        this.auto_vibrato();
        this.calculate_frequency();
        this.calculate_amplitude();
        this.update_envelopes();
    }

    private void update_envelopes() {
        if (this.instrument.volume_envelope.enabled) {
            if (!this.key_on) {
                this.fade_out_vol -= this.instrument.volume_fade_out;
                if (this.fade_out_vol < 0) {
                    this.fade_out_vol = 0;
                }
            }
            this.vol_env_tick = this.instrument.volume_envelope.next_tick(this.vol_env_tick, this.key_on);
        }
        if (this.instrument.panning_envelope.enabled) {
            this.pan_env_tick = this.instrument.panning_envelope.next_tick(this.pan_env_tick, this.key_on);
        }
    }

    private void auto_vibrato() {
        int depth = this.instrument.vibrato_depth & 0x7F;
        if (depth > 0) {
            int sweep = this.instrument.vibrato_sweep & 0x7F;
            int rate = this.instrument.vibrato_rate & 0x7F;
            int type = this.instrument.vibrato_type;
            if (this.auto_vibrato_count < sweep) {
                depth = depth * this.auto_vibrato_count / sweep;
            }
            this.vibrato_add += this.waveform(this.auto_vibrato_count * rate >> 2, type + 4) * depth >> 8;
            ++this.auto_vibrato_count;
        }
    }

    private void volume_slide(int param) {
        int vol = this.volume + (param >> 4) - (param & 0xF);
        if (vol > 64) {
            vol = 64;
        }
        if (vol < 0) {
            vol = 0;
        }
        this.volume = vol;
    }

    private void tone_portamento() {
        int source = this.period;
        int dest = this.porta_period;
        if (source < dest) {
            if ((source += this.tone_porta_param << 2) > dest) {
                source = dest;
            }
        } else if (source > dest && (source -= this.tone_porta_param << 2) < dest) {
            source = dest;
        }
        this.period = source;
    }

    private void vibrato() {
        this.vibrato_add += this.waveform(this.vibrato_phase, this.vibrato_type & 3) * this.vibrato_depth >> 5;
    }

    private void tremolo() {
        this.tremolo_add = this.waveform(this.tremolo_phase, this.tremolo_type & 3) * this.tremolo_depth >> 6;
    }

    private int waveform(int phase, int type) {
        int amplitude = 0;
        switch (type) {
            default: {
                amplitude = sine_table[phase & 0x1F];
                if ((phase & 0x20) <= 0) break;
                amplitude = -amplitude;
                break;
            }
            case 6: {
                amplitude = ((phase + 32 & 0x3F) << 3) - 255;
                break;
            }
            case 1: 
            case 7: {
                amplitude = 255 - ((phase + 32 & 0x3F) << 3);
                break;
            }
            case 2: 
            case 5: {
                amplitude = (phase & 0x20) > 0 ? 255 : -255;
                break;
            }
            case 3: 
            case 8: {
                amplitude = this.random_seed - 255;
                this.random_seed = this.random_seed * 65 + 17 & 0x1FF;
            }
        }
        return amplitude;
    }

    private void tremor() {
        if (this.retrig_count >= this.tremor_on_ticks) {
            this.tremolo_add = -64;
        }
        if (this.retrig_count >= this.tremor_on_ticks + this.tremor_off_ticks) {
            this.retrig_count = 0;
            this.tremolo_add = 0;
        }
    }

    private void retrig_vol_slide() {
        if (this.retrig_count >= this.retrig_ticks) {
            this.sample_fra = 0;
            this.sample_idx = 0;
            this.retrig_count = 0;
            switch (this.retrig_volume) {
                case 1: {
                    --this.volume;
                    break;
                }
                case 2: {
                    this.volume -= 2;
                    break;
                }
                case 3: {
                    this.volume -= 4;
                    break;
                }
                case 4: {
                    this.volume -= 8;
                    break;
                }
                case 5: {
                    this.volume -= 16;
                    break;
                }
                case 6: {
                    this.volume -= this.volume / 3;
                    break;
                }
                case 7: {
                    this.volume >>= 1;
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    ++this.volume;
                    break;
                }
                case 10: {
                    this.volume += 2;
                    break;
                }
                case 11: {
                    this.volume += 4;
                    break;
                }
                case 12: {
                    this.volume += 8;
                    break;
                }
                case 13: {
                    this.volume += 16;
                    break;
                }
                case 14: {
                    this.volume += this.volume >> 1;
                    break;
                }
                case 15: {
                    this.volume <<= 1;
                }
            }
            if (this.volume < 0) {
                this.volume = 0;
            }
            if (this.volume > 64) {
                this.volume = 64;
            }
        }
    }

    private void calculate_frequency() {
        if (this.module.linear_periods) {
            int x;
            int c;
            int tone;
            int i;
            int m;
            int y;
            int freq;
            int per = this.period + this.vibrato_add - (this.arpeggio_add << 6);
            if (per < 28) {
                per = 28;
            }
            if (per > 7680) {
                per = 7680;
            }
            this.step = (freq = (y = ((m = freq_table[(i = ((tone = 7680 - per) >> 3) % 96) + 1] - (c = freq_table[i])) * (x = tone & 7) >> 3) + c) >> 9 - tone / 768) < 65536 ? (freq << 15) / this.sample_rate : (freq << 12) / (this.sample_rate >> 3);
        } else {
            int per = this.period + this.vibrato_add;
            if (per < 28) {
                per = 28;
            }
            int freq = 14317456 / per;
            this.step = (freq = freq * arp_tuning[this.arpeggio_add] >> 12 & 0x7FFFF) < 65536 ? (freq << 15) / this.sample_rate : (freq << 12) / (this.sample_rate >> 3);
        }
    }

    private void calculate_amplitude() {
        int vol;
        int env_vol;
        int n = env_vol = this.key_on ? 64 : 0;
        if (this.instrument.volume_envelope.enabled) {
            env_vol = this.instrument.volume_envelope.calculate_ampl(this.vol_env_tick);
        }
        if ((vol = this.volume + this.tremolo_add) > 64) {
            vol = 64;
        }
        if (vol < 0) {
            vol = 0;
        }
        vol = vol * 32768 >> 7;
        vol = vol * this.fade_out_vol >> 15;
        this.ampl = vol * this.global_vol.volume * env_vol >> 12;
        int env_pan = 32;
        if (this.instrument.panning_envelope.enabled) {
            env_pan = this.instrument.panning_envelope.calculate_ampl(this.pan_env_tick);
        }
        int pan_range = this.panning < 128 ? this.panning : 255 - this.panning;
        this.pann = this.panning + (pan_range * (env_pan - 32) >> 5);
    }

    private void trigger() {
        if (this.note_ins > 0 && this.note_ins <= this.module.num_instruments) {
            this.instrument = this.module.instruments[this.note_ins];
            this.sample = this.instrument.samples[this.instrument.key_to_sample[this.note_key < 97 ? this.note_key : 0]];
            this.volume = this.sample.volume >= 64 ? 64 : this.sample.volume & 0x3F;
            this.panning = this.sample.panning & 0xFF;
            this.fine_tune = (byte)this.sample.fine_tune;
            this.pan_env_tick = 0;
            this.vol_env_tick = 0;
            this.fade_out_vol = 32768;
            this.key_on = true;
        }
        if (this.note_vol >= 16 && this.note_vol < 96) {
            this.volume = this.note_vol < 80 ? this.note_vol - 16 : 64;
        }
        switch (this.note_vol & 0xF0) {
            case 128: {
                this.volume -= this.note_vol & 0xF;
                if (this.volume >= 0) break;
                this.volume = 0;
                break;
            }
            case 144: {
                this.volume += this.note_vol & 0xF;
                if (this.volume <= 64) break;
                this.volume = 64;
                break;
            }
            case 160: {
                if ((this.note_vol & 0xF) <= 0) break;
                this.vibrato_speed = this.note_vol & 0xF;
                break;
            }
            case 176: {
                if ((this.note_vol & 0xF) > 0) {
                    this.vibrato_depth = this.note_vol & 0xF;
                }
                this.vibrato();
                break;
            }
            case 192: {
                this.panning = (this.note_vol & 0xF) * 17;
                break;
            }
            case 240: {
                if ((this.note_vol & 0xF) <= 0) break;
                this.tone_porta_param = this.note_vol & 0xF;
            }
        }
        if (this.note_key > 0) {
            if (this.note_key > 96) {
                this.key_on = false;
            } else {
                int key = this.note_key + this.sample.rel_note;
                if (key < 1) {
                    key = 1;
                }
                if (key > 120) {
                    key = 120;
                }
                if (this.module.linear_periods) {
                    this.porta_period = 7680 - (key - 1 << 6) - (this.fine_tune >> 1);
                } else {
                    int tone = 768 + (key - 1 << 6) + (this.fine_tune >> 1);
                    int i = (tone >> 3) % 96;
                    int c = period_table[i];
                    int m = period_table[i + 1] - c;
                    int x = tone & 7;
                    int y = (m * x >> 3) + c;
                    this.porta_period = y >> tone / 768;
                }
                if (this.note_effect != 3 && this.note_effect != 5 && (this.note_vol & 0xF0) != 240) {
                    this.period = this.porta_period;
                    this.sample_fra = 0;
                    this.sample_idx = 0;
                    if (this.vibrato_type < 4) {
                        this.vibrato_phase = 0;
                    }
                    if (this.tremolo_type < 4) {
                        this.tremolo_phase = 0;
                    }
                    this.auto_vibrato_count = 0;
                    this.retrig_count = 0;
                }
            }
        }
    }
}

