/*
 * Decompiled with CFR 0.152.
 */
package mumart.micromod.xm;

public class Envelope {
    public boolean enabled;
    public boolean sustain;
    public boolean looped;
    public int sustain_tick;
    public int loop_start_tick;
    public int loop_end_tick;
    public int num_points = 1;
    public int[] points_tick = new int[1];
    public int[] points_ampl = new int[1];

    public int next_tick(int tick, boolean key_on) {
        if (this.looped && ++tick >= this.loop_end_tick) {
            tick = this.loop_start_tick;
        }
        if (this.sustain && key_on && tick >= this.sustain_tick) {
            tick = this.sustain_tick;
        }
        return tick;
    }

    public int calculate_ampl(int tick) {
        int ampl = this.points_ampl[this.num_points - 1];
        if (tick < this.points_tick[this.num_points - 1]) {
            int point = 0;
            int idx = 1;
            while (idx < this.num_points) {
                if (this.points_tick[idx] <= tick) {
                    point = idx;
                }
                ++idx;
            }
            int dt = this.points_tick[point + 1] - this.points_tick[point];
            int da = this.points_ampl[point + 1] - this.points_ampl[point];
            ampl = this.points_ampl[point];
            ampl += (da << 24) / dt * (tick - this.points_tick[point]) >> 24;
        }
        return ampl;
    }

    public void toStringBuffer(StringBuffer out) {
        out.append("Enabled: " + this.enabled + '\n');
        out.append("Sustain: " + this.sustain + '\n');
        out.append("Looped: " + this.looped + '\n');
        out.append("Sustain Tick: " + this.sustain_tick + '\n');
        out.append("Loop Start Tick: " + this.loop_start_tick + '\n');
        out.append("Loop End Tick: " + this.loop_end_tick + '\n');
        out.append("Num Points: " + this.num_points + '\n');
        out.append("Points: ");
        int point = 0;
        while (point < this.num_points) {
            out.append("(" + this.points_tick[point] + ", " + this.points_ampl[point] + "), ");
            ++point;
        }
        out.append('\n');
    }
}

