/*
 * Decompiled with CFR 0.152.
 */
package mumart.micromod.xm;

import mumart.micromod.replay.Replay;
import mumart.micromod.xm.Channel;
import mumart.micromod.xm.GlobalVol;
import mumart.micromod.xm.Module;
import mumart.micromod.xm.Note;
import mumart.micromod.xm.Pattern;

public class IBXM
implements Replay {
    public static final String VERSION = "20100928 (c)2010 mumart@gmail.com";
    private Module module;
    private int[] ramp_buf;
    private Channel[] channels;
    private boolean interpolate;
    private int sampling_rate;
    private int tick_len;
    private int ramp_len;
    private int ramp_rate;
    private int seq_pos;
    private int break_seq_pos;
    private int row;
    private int next_row;
    private int tick;
    private int speed;
    private int pl_count;
    private int pl_channel;
    private GlobalVol global_vol;
    private Note note;

    public IBXM(Module module, int sampling_rate, boolean interpolate) {
        this.module = module;
        this.sampling_rate = sampling_rate;
        this.interpolate = interpolate;
        if (sampling_rate < 16000) {
            throw new IllegalArgumentException("Unsupported sampling rate!");
        }
        this.ramp_len = 256;
        while (this.ramp_len * 1024 > sampling_rate) {
            this.ramp_len /= 2;
        }
        this.ramp_buf = new int[this.ramp_len * 2];
        this.ramp_rate = 256 / this.ramp_len;
        this.channels = new Channel[module.num_channels];
        this.global_vol = new GlobalVol();
        this.note = new Note();
        this.set_sequence_pos(0);
    }

    @Override
    public String get_version() {
        return VERSION;
    }

    @Override
    public int get_sampling_rate() {
        return this.sampling_rate;
    }

    @Override
    public int get_mix_buffer_length() {
        return this.sampling_rate * 5 / 32 + this.ramp_len * 2;
    }

    @Override
    public String get_string(int index) {
        if (index == 0) {
            return this.module.song_name;
        }
        if (index < 0 || index > this.module.num_instruments) {
            return null;
        }
        return this.module.instruments[index].name;
    }

    @Override
    public void set_sequence_pos(int pos) {
        if (pos >= this.module.sequence_length) {
            pos = 0;
        }
        this.break_seq_pos = pos;
        this.next_row = 0;
        this.tick = 1;
        this.speed = this.module.default_speed > 0 ? this.module.default_speed : 6;
        this.set_tempo(this.module.default_tempo > 0 ? this.module.default_tempo : 125);
        this.global_vol.volume = 64;
        this.pl_channel = -1;
        this.pl_count = -1;
        int idx = 0;
        while (idx < this.module.num_channels) {
            this.channels[idx] = new Channel(this.module, idx, this.sampling_rate, this.global_vol);
            ++idx;
        }
        idx = 0;
        int end = this.ramp_len * 2;
        while (idx < end) {
            this.ramp_buf[idx] = 0;
            ++idx;
        }
        this.tick();
    }

    @Override
    public int calculate_song_duration() {
        int duration = 0;
        this.set_sequence_pos(0);
        boolean song_end = false;
        while (!song_end) {
            duration += this.tick_len;
            song_end = this.tick();
        }
        this.set_sequence_pos(0);
        return duration;
    }

    @Override
    public int seek(int sample_pos) {
        this.set_sequence_pos(0);
        int current_pos = 0;
        while (sample_pos - current_pos >= this.tick_len) {
            int idx = 0;
            while (idx < this.module.num_channels) {
                this.channels[idx].update_sample_idx(this.tick_len);
                ++idx;
            }
            current_pos += this.tick_len;
            this.tick();
        }
        return current_pos;
    }

    @Override
    public int get_audio(int[] output_buf) {
        int out_idx = 0;
        int out_ep1 = this.tick_len + this.ramp_len << 1;
        while (out_idx < out_ep1) {
            output_buf[out_idx++] = 0;
        }
        int chan_idx = 0;
        while (chan_idx < this.module.num_channels) {
            Channel chan = this.channels[chan_idx];
            chan.resample(output_buf, 0, this.tick_len + this.ramp_len, this.interpolate);
            chan.update_sample_idx(this.tick_len);
            ++chan_idx;
        }
        this.volume_ramp(output_buf);
        this.tick();
        return this.tick_len;
    }

    private void set_tempo(int tempo) {
        this.tick_len = this.sampling_rate * 5 / (tempo * 2) & 0xFFFFFFFE;
    }

    private void volume_ramp(int[] mix_buf) {
        int offset = 0;
        int a1 = 0;
        while (a1 < 256) {
            int a2 = 256 - a1;
            int s1 = mix_buf[offset] * a1;
            int s2 = this.ramp_buf[offset] * a2;
            mix_buf[offset++] = s1 + s2 >> 8;
            s1 = mix_buf[offset] * a1;
            s2 = this.ramp_buf[offset] * a2;
            mix_buf[offset++] = s1 + s2 >> 8;
            a1 += this.ramp_rate;
        }
        System.arraycopy(mix_buf, this.tick_len << 1, this.ramp_buf, 0, offset);
    }

    private boolean tick() {
        boolean song_end = false;
        if (--this.tick <= 0) {
            this.tick = this.speed;
            song_end = this.row();
        } else {
            int idx = 0;
            while (idx < this.module.num_channels) {
                this.channels[idx].tick();
                ++idx;
            }
        }
        return song_end;
    }

    private boolean row() {
        boolean song_end = false;
        if (this.break_seq_pos >= 0) {
            if (this.break_seq_pos >= this.module.sequence_length) {
                this.next_row = 0;
                this.break_seq_pos = 0;
            }
            while (this.module.sequence[this.break_seq_pos] >= this.module.num_patterns) {
                ++this.break_seq_pos;
                if (this.break_seq_pos < this.module.sequence_length) continue;
                this.next_row = 0;
                this.break_seq_pos = 0;
            }
            if (this.break_seq_pos <= this.seq_pos) {
                song_end = true;
            }
            this.seq_pos = this.break_seq_pos;
            int idx = 0;
            while (idx < this.module.num_channels) {
                this.channels[idx].pl_row = 0;
                ++idx;
            }
            this.break_seq_pos = -1;
        }
        Pattern pattern = this.module.patterns[this.module.sequence[this.seq_pos]];
        this.row = this.next_row;
        if (this.row >= pattern.num_rows) {
            this.row = 0;
        }
        this.next_row = this.row + 1;
        if (this.next_row >= pattern.num_rows) {
            this.break_seq_pos = this.seq_pos + 1;
            this.next_row = 0;
        }
        int note_idx = this.row * this.module.num_channels;
        int chan_idx = 0;
        while (chan_idx < this.module.num_channels) {
            Channel channel = this.channels[chan_idx];
            pattern.get_note(note_idx + chan_idx, this.note);
            if (this.note.effect == 14) {
                this.note.effect = 0x100 | this.note.param >> 4;
                this.note.param &= 0xF;
            }
            if (this.note.effect == 0 && this.note.param > 0) {
                this.note.effect = 14;
            }
            channel.row(this.note);
            switch (this.note.effect) {
                case 11: {
                    if (this.pl_count >= 0) break;
                    this.break_seq_pos = this.note.param;
                    this.next_row = 0;
                    break;
                }
                case 13: {
                    if (this.pl_count >= 0) break;
                    this.break_seq_pos = this.seq_pos + 1;
                    this.next_row = (this.note.param >> 4) * 10 + (this.note.param & 0xF);
                    break;
                }
                case 15: {
                    if (this.note.param <= 0) break;
                    if (this.note.param < 32) {
                        this.tick = this.speed = this.note.param;
                        break;
                    }
                    this.set_tempo(this.note.param);
                    break;
                }
                case 262: {
                    if (this.note.param == 0) {
                        channel.pl_row = this.row;
                    }
                    if (channel.pl_row >= this.row) break;
                    if (this.pl_count < 0) {
                        this.pl_count = this.note.param;
                        this.pl_channel = chan_idx;
                    }
                    if (this.pl_channel != chan_idx) break;
                    if (this.pl_count == 0) {
                        channel.pl_row = this.row + 1;
                    } else {
                        this.next_row = channel.pl_row;
                        this.break_seq_pos = -1;
                    }
                    --this.pl_count;
                    break;
                }
                case 270: {
                    this.tick = this.speed + this.speed * this.note.param;
                }
            }
            ++chan_idx;
        }
        return song_end;
    }
}

