/*
 * Decompiled with CFR 0.152.
 */
package mumart.micromod.xm;

import mumart.micromod.xm.Envelope;
import mumart.micromod.xm.Instrument;
import mumart.micromod.xm.Pattern;
import mumart.micromod.xm.Sample;

public class Module {
    public String song_name;
    public int num_channels;
    public int num_instruments;
    public int num_patterns;
    public int sequence_length;
    public int restart_pos;
    public int default_speed;
    public int default_tempo;
    public boolean linear_periods;
    public int[] sequence;
    public Pattern[] patterns;
    public Instrument[] instruments;

    public Module() {
        this.song_name = "Blank";
        this.num_channels = 4;
        this.num_instruments = 1;
        this.num_patterns = 1;
        this.sequence_length = 1;
        this.default_speed = 6;
        this.default_tempo = 125;
        this.sequence = new int[1];
        this.patterns = new Pattern[1];
        Pattern pattern = this.patterns[0] = new Pattern();
        pattern.num_rows = 64;
        pattern.data = new byte[pattern.num_rows * this.num_channels * 5];
        this.instruments = new Instrument[this.num_instruments + 1];
        this.instruments[0] = this.instruments[1] = new Instrument();
    }

    public Module(byte[] module_data) {
        if (!Module.ascii(module_data, 0, 17).equals("Extended Module: ")) {
            throw new IllegalArgumentException("Not an XM file!");
        }
        if (Module.ushortle(module_data, 58) != 260) {
            throw new IllegalArgumentException("XM format version must be 0x0104!");
        }
        this.song_name = Module.ascii(module_data, 17, 20);
        boolean delta_env = Module.ascii(module_data, 38, 20).startsWith("DigiBooster Pro");
        int data_offset = 60 + Module.intle(module_data, 60);
        this.sequence_length = Module.ushortle(module_data, 64);
        this.restart_pos = Module.ushortle(module_data, 66);
        this.num_channels = Module.ushortle(module_data, 68);
        this.num_patterns = Module.ushortle(module_data, 70);
        this.num_instruments = Module.ushortle(module_data, 72);
        this.linear_periods = (Module.ushortle(module_data, 74) & 1) > 0;
        this.default_speed = Module.ushortle(module_data, 76);
        this.default_tempo = Module.ushortle(module_data, 78);
        this.sequence = new int[this.sequence_length];
        int seq_idx = 0;
        while (seq_idx < this.sequence_length) {
            int entry = module_data[80 + seq_idx] & 0xFF;
            this.sequence[seq_idx] = entry < this.num_patterns ? entry : 0;
            ++seq_idx;
        }
        this.patterns = new Pattern[this.num_patterns];
        int pat_idx = 0;
        while (pat_idx < this.num_patterns) {
            Pattern pattern = this.patterns[pat_idx] = new Pattern();
            if (module_data[data_offset + 4] != 0) {
                throw new IllegalArgumentException("Unknown pattern packing type!");
            }
            pattern.num_rows = Module.ushortle(module_data, data_offset + 5);
            int pattern_data_length = Module.ushortle(module_data, data_offset + 7);
            int num_notes = pattern.num_rows * this.num_channels;
            pattern.data = new byte[num_notes * 5];
            data_offset += Module.intle(module_data, data_offset);
            int next_offset = data_offset + pattern_data_length;
            if (pattern_data_length > 0) {
                int pattern_data_offset = 0;
                int note = 0;
                while (note < num_notes) {
                    int flags = module_data[data_offset];
                    if ((flags & 0x80) == 0) {
                        flags = 31;
                    } else {
                        ++data_offset;
                    }
                    int n = 0;
                    while (n < 5) {
                        byte b = (flags & 1) > 0 ? module_data[data_offset++] : (byte)0;
                        pattern.data[pattern_data_offset++] = b;
                        flags >>= 1;
                        ++n;
                    }
                    ++note;
                }
            }
            data_offset = next_offset;
            ++pat_idx;
        }
        this.instruments = new Instrument[this.num_instruments + 1];
        this.instruments[0] = new Instrument();
        int ins_idx = 1;
        while (ins_idx <= this.num_instruments) {
            Instrument instrument = this.instruments[ins_idx] = new Instrument();
            instrument.name = Module.ascii(module_data, data_offset + 4, 22);
            instrument.num_samples = Module.ushortle(module_data, data_offset + 27);
            int num_samples = instrument.num_samples;
            if (num_samples > 0) {
                instrument.samples = new Sample[num_samples];
                int key_idx = 0;
                while (key_idx < 96) {
                    instrument.key_to_sample[key_idx + 1] = module_data[data_offset + 33 + key_idx] & 0xFF;
                    ++key_idx;
                }
                Envelope vol_env = instrument.volume_envelope = new Envelope();
                vol_env.points_tick = new int[12];
                vol_env.points_ampl = new int[12];
                int point_tick = 0;
                int point = 0;
                while (point < 12) {
                    int point_offset = data_offset + 129 + point * 4;
                    vol_env.points_tick[point] = point_tick = (delta_env ? point_tick : 0) + Module.ushortle(module_data, point_offset);
                    vol_env.points_ampl[point] = Module.ushortle(module_data, point_offset + 2);
                    ++point;
                }
                Envelope pan_env = instrument.panning_envelope = new Envelope();
                pan_env.points_tick = new int[12];
                pan_env.points_ampl = new int[12];
                point_tick = 0;
                int point2 = 0;
                while (point2 < 12) {
                    int point_offset = data_offset + 177 + point2 * 4;
                    pan_env.points_tick[point2] = point_tick = (delta_env ? point_tick : 0) + Module.ushortle(module_data, point_offset);
                    pan_env.points_ampl[point2] = Module.ushortle(module_data, point_offset + 2);
                    ++point2;
                }
                vol_env.num_points = module_data[data_offset + 225];
                pan_env.num_points = module_data[data_offset + 226];
                vol_env.sustain_tick = vol_env.points_tick[module_data[data_offset + 227]];
                vol_env.loop_start_tick = vol_env.points_tick[module_data[data_offset + 228]];
                vol_env.loop_end_tick = vol_env.points_tick[module_data[data_offset + 229]];
                pan_env.sustain_tick = pan_env.points_tick[module_data[data_offset + 230]];
                pan_env.loop_start_tick = pan_env.points_tick[module_data[data_offset + 231]];
                pan_env.loop_end_tick = pan_env.points_tick[module_data[data_offset + 232]];
                vol_env.enabled = (module_data[data_offset + 233] & 1) > 0;
                vol_env.sustain = (module_data[data_offset + 233] & 2) > 0;
                vol_env.looped = (module_data[data_offset + 233] & 4) > 0;
                pan_env.enabled = (module_data[data_offset + 234] & 1) > 0;
                pan_env.sustain = (module_data[data_offset + 234] & 2) > 0;
                pan_env.looped = (module_data[data_offset + 234] & 4) > 0;
                instrument.vibrato_type = module_data[data_offset + 235] & 0xFF;
                instrument.vibrato_sweep = module_data[data_offset + 236] & 0xFF;
                instrument.vibrato_depth = module_data[data_offset + 237] & 0xFF;
                instrument.vibrato_rate = module_data[data_offset + 238] & 0xFF;
                instrument.volume_fade_out = Module.ushortle(module_data, data_offset + 239);
            }
            data_offset += Module.intle(module_data, data_offset);
            int sample_header_offset = data_offset;
            data_offset += num_samples * 40;
            int sam_idx = 0;
            while (sam_idx < num_samples) {
                int ampl;
                Sample sample = instrument.samples[sam_idx] = new Sample();
                int sample_data_bytes = Module.intle(module_data, sample_header_offset);
                int sample_loop_start = Module.intle(module_data, sample_header_offset + 4);
                int sample_loop_length = Module.intle(module_data, sample_header_offset + 8);
                sample.volume = module_data[sample_header_offset + 12];
                sample.fine_tune = module_data[sample_header_offset + 13];
                boolean looped = (module_data[sample_header_offset + 14] & 3) > 0;
                boolean ping_pong = (module_data[sample_header_offset + 14] & 2) > 0;
                boolean sixteen_bit = (module_data[sample_header_offset + 14] & 0x10) > 0;
                sample.panning = module_data[sample_header_offset + 15] & 0xFF;
                sample.rel_note = module_data[sample_header_offset + 16];
                sample.name = Module.ascii(module_data, sample_header_offset + 18, 22);
                sample_header_offset += 40;
                int sample_data_length = sample_data_bytes;
                if (sixteen_bit) {
                    sample_data_length /= 2;
                    sample_loop_start /= 2;
                    sample_loop_length /= 2;
                }
                if (sample_loop_start + sample_loop_length > sample_data_length) {
                    looped = false;
                }
                if (looped && ping_pong) {
                    sample_data_length += sample_loop_length;
                }
                sample.sample_data = new short[sample_data_length + 1];
                short[] sample_data = sample.sample_data;
                if (sixteen_bit) {
                    ampl = 0;
                    int out_end = sample_data_bytes / 2;
                    int out_idx = 0;
                    while (out_idx < out_end) {
                        int in_idx = data_offset + out_idx * 2;
                        ampl = (short)(ampl + (module_data[in_idx] & 0xFF));
                        sample_data[out_idx] = ampl = (int)((short)(ampl + ((module_data[in_idx + 1] & 0xFF) << 8)));
                        ++out_idx;
                    }
                } else {
                    ampl = 0;
                    int out_idx = 0;
                    while (out_idx < sample_data_bytes) {
                        ampl = (byte)(ampl + (module_data[data_offset + out_idx] & 0xFF));
                        sample_data[out_idx] = (short)(ampl << 8);
                        ++out_idx;
                    }
                }
                if (looped) {
                    if (ping_pong) {
                        int loop_end = sample_loop_start + sample_loop_length;
                        int loop_idx = 0;
                        while (loop_idx < sample_loop_length) {
                            sample_data[loop_end + loop_idx] = sample_data[loop_end - loop_idx - 1];
                            ++loop_idx;
                        }
                        sample_loop_length *= 2;
                    }
                } else {
                    sample_loop_start = sample_data_length;
                    sample_loop_length = 0;
                }
                sample.loop_start = sample_loop_start;
                sample.loop_length = sample_loop_length;
                sample_data[sample_loop_start + sample_loop_length] = sample_data[sample_loop_start];
                data_offset += sample_data_bytes;
                ++sam_idx;
            }
            ++ins_idx;
        }
    }

    private static int ushortle(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    private static int intle(byte[] buf, int offset) {
        int value = buf[offset] & 0xFF;
        value |= (buf[offset + 1] & 0xFF) << 8;
        value |= (buf[offset + 2] & 0xFF) << 16;
        return value |= (buf[offset + 3] & 0x7F) << 24;
    }

    private static String ascii(byte[] buf, int offset, int len) {
        char[] str = new char[len];
        int idx = 0;
        while (idx < len) {
            int c = buf[offset + idx] & 0xFF;
            str[idx] = (char)(c < 32 ? 32 : (char)c);
            ++idx;
        }
        return new String(str);
    }

    public void toStringBuffer(StringBuffer out) {
        out.append("Song Name: " + this.song_name + '\n' + "Num Channels: " + this.num_channels + '\n' + "Num Instruments: " + this.num_instruments + '\n' + "Num Patterns: " + this.num_patterns + '\n' + "Sequence Length: " + this.sequence_length + '\n' + "Restart Pos: " + this.restart_pos + '\n' + "Default Speed: " + this.default_speed + '\n' + "Default Tempo: " + this.default_tempo + '\n' + "Linear Periods: " + this.linear_periods + '\n');
        out.append("Sequence: ");
        int seq_idx = 0;
        while (seq_idx < this.sequence.length) {
            out.append(String.valueOf(this.sequence[seq_idx]) + ", ");
            ++seq_idx;
        }
        out.append('\n');
        int pat_idx = 0;
        while (pat_idx < this.patterns.length) {
            out.append("Pattern " + pat_idx + ":\n");
            this.patterns[pat_idx].toStringBuffer(out);
            ++pat_idx;
        }
        int ins_idx = 1;
        while (ins_idx < this.instruments.length) {
            out.append("Instrument " + ins_idx + ":\n");
            this.instruments[ins_idx].toStringBuffer(out);
            ++ins_idx;
        }
    }
}

