

' Color constants
%ColorAliceBlue=&HFFF0F8FF
%ColorAntiqueWhite=&HFFFAEBD7
%ColorAquamarine=&HFF7FFFD4
%ColorArmyGreen=&HFF669966
%ColorAutumnOrange=&HFFFF6633
%ColorAvocadoGreen=&HFF669933
%ColorAzure=&HFFF0FFFF
%ColorBabyBlue=&HFF6699FF
%ColorBananaYellow=&HFFCCCC33
%ColorBeige=&HFFF5F5DC
%ColorBisque=&HFFFFE4C4
%ColorBlack=&HFF000000
%ColorBlanchedAlmond=&HFFFFEBCD
%ColorBlue=&HFF0000FF
%ColorBlueViolet=&HFF8A2BE2
%ColorBrown=&HFFA52A2A
%ColorBurlyWood=&HFFDEB887
%ColorCadetBlue=&HFF5F9EA0
%ColorChalk=&HFFFFFF99
%ColorChartreuse=&HFF7FFF00
%ColorChocolate=&HFFD2691E
%ColorCoral=&HFFFF7F50
%ColorCornflowerBlue=&HFF6495ED
%ColorCornsilk=&HFFFFF8DC
%ColorCrimson=&HFFDC143C
%ColorCyan=&HFF00FFFF
%ColorDarkBlue=&HFF00008B
%ColorDarkBrown=&HFF663333
%ColorDarkCrimson=&HFF993366
%ColorDarkCyan=&HFF008B8B
%ColorDarkGold=&HFFCC9933
%ColorDarkGoldenrod=&HFFB8860B
%ColorDarkGray=&HFFA9A9A9
%ColorDarkGreen=&HFF006400
%ColorDarkKhaki=&HFFBDB76B
%ColorDarkMagenta=&HFF8B008B
%ColorDarkOliveGreen=&HFF556B2F
%ColorDarkOrange=&HFFFF8C00
%ColorDarkOrchid=&HFF9932CC
%ColorDarkRed=&HFF8B0000
%ColorDarkSalmon=&HFFE9967A
%ColorDarkSeaGreen=&HFF8FBC8B
%ColorDarkSlateBlue=&HFF483D8B
%ColorDarkSlateGray=&HFF2F4F4F
%ColorDarkTurquoise=&HFF00CED1
%ColorDarkViolet=&HFF9400D3
%ColorDeepAzure=&HFF6633FF
%ColorDeepPink=&HFFFF1493
%ColorDeepPurple=&HFF330066
%ColorDeepRiver=&HFF6600CC
%ColorDeepRose=&HFFCC3399
%ColorDeepSkyBlue=&HFF00BFFF
%ColorDefault=0
%ColorDeepYellow=&HFFFFCC00
%ColorDesertBlue=&HFF336699
%ColorDimGray=&HFF696969
%ColorDodgerBlue=&HFF1E90FF
%ColorDullGreen=&HFF99CC66
%ColorEasterPurple=&HFFCC99FF
%ColorFadeGreen=&HFF99CC99
%ColorFirebrick=&HFFB22222
%ColorFloralWhite=&HFFFFFAF0
%ColorForestGreen=&HFF228B22
%ColorGainsboro=&HFFDCDCDC
%ColorGhostGreen=&HFFCCFFCC
%ColorGhostWhite=&HFFF8F8FF
%ColorGold=&HFFFFD700
%ColorGoldenrod=&HFFDAA520
%ColorGrape=&HFF663399
%ColorGrassGreen=&HFF009933
%ColorGray=&HFF808080
%ColorGreen=&HFF008000
%ColorGreenYellow=&HFFADFF2F
%ColorHoneydew=&HFFF0FFF0
%ColorHotPink=&HFFFF69B4
%ColorIndianRed=&HFFCD5C5C
%ColorIndigo=&HFF4B0082
%ColorIvory=&HFFFFFFF0
%ColorKentuckyGreen=&HFF339966
%ColorKhaki=&HFFF0E68C
%ColorLavender=&HFFE6E6FA
%ColorLavenderBlush=&HFFFFF0F5
%ColorLawnGreen=&HFF7CFC00
%ColorLemonChiffon=&HFFFFFACD
%ColorLightBlue=&HFFADD8E6
%ColorLightCoral=&HFFF08080
%ColorLightCyan=&HFFE0FFFF
%ColorLightGoldenrod=&HFFEEDD82
%ColorLightGoldenrodYellow=&HFFFAFAD2
%ColorLightGray=&HFFD3D3D3
%ColorLightGreen=&HFF90EE90
%ColorLightOrange=&HFFFF9933
%ColorLightPink=&HFFFFB6C1
%ColorLightSalmon=&HFFFFA07A
%ColorLightSeaGreen=&HFF20B2AA
%ColorLightSkyBlue=&HFF87CEFA
%ColorLightSlateGray=&HFF778899
%ColorLightSteelBlue=&HFFB0C4DE
%ColorLightViolet=&HFFFF99FF
%ColorLightYellow=&HFFFFFFE0
%ColorLime=&HFF00FF00
%ColorLimeGreen=&HFF32CD32
%ColorLinen=&HFFFAF0E6
%ColorMagenta=&HFFFF00FF
%ColorMaroon=&HFF800000
%ColorMartianGreen=&HFF99CC33
%ColorMediumAquamarine=&HFF66CDAA
%ColorMediumBlue=&HFF0000CD
%ColorMediumOrchid=&HFFBA55D3
%ColorMediumPurple=&HFF9370DB
%ColorMediumSeaGreen=&HFF3CB371
%ColorMediumSlateBlue=&HFF7B68EE
%ColorMediumSpringGreen=&HFF00FA9A
%ColorMediumTurquoise=&HFF48D1CC
%ColorMediumVioletRed=&HFFC71585
%ColorMidnightBlue=&HFF191970
%ColorMintCream=&HFFF5FFFA
%ColorMistyRose=&HFFFFE4E1
%ColorMoccasin=&HFFFFE4B5
%ColorMoonGreen=&HFFCCFF66
%ColorMossGreen=&HFF336666
%ColorNavajoWhite=&HFFFFDEAD
%ColorNavy=&HFF000080
%ColorOceanGreen=&HFF669999
%ColorOldLace=&HFFFDF5E6
%ColorOlive=&HFF808000
%ColorOliveDrab=&HFF6B8E23
%ColorOrange=&HFFFFA500
%ColorOrangeRed=&HFFFF4500
%ColorOrchid=&HFFDA70D6
%ColorPaleGoldenrod=&HFFEEE8AA
%ColorPaleGreen=&HFF98FB98
%ColorPaleTurquoise=&HFFAFEEEE
%ColorPaleVioletRed=&HFFDB7093
%ColorPaleYellow=&HFFFFFFCC
%ColorPapayaWhip=&HFFFFEFD5
%ColorPeachPuff=&HFFFFDAB9
%ColorPeru=&HFFCD853F
%ColorPink=&HFFFFC0CB
%ColorPlum=&HFFDDA0DD
%ColorPowderBlue=&HFFB0E0E6
%ColorPurple=&HFF800080
%ColorRed=&HFFFF0000
%ColorRosyBrown=&HFFBC8F8F
%ColorRoyalBlue=&HFF4169E1
%ColorSaddleBrown=&HFF8B4513
%ColorSalmon=&HFFFA8072
%ColorSand=&HFFFFCC99
%ColorSandyBrown=&HFFF4A460
%ColorSeaGreen=&HFF2E8B57
%ColorSeaShell=&HFFFFF5EE
%ColorSienna=&HFFA0522D
%ColorSilver=&HFFC0C0C0
%ColorSkyBlue=&HFF87CEEB
%ColorSlateBlue=&HFF6A5ACD
%ColorSlateGray=&HFF708090
%ColorSnow=&HFFFFFAFA
%ColorSpringGreen=&HFF00FF7F
%ColorSteelBlue=&HFF4682B4
%ColorTan=&HFFD2B48C
%ColorTeal=&HFF008080
%ColorThistle=&HFFD8BFD8
%ColorTomato=&HFFFF6347
%ColorTransparent = &HFFFFFFFE
%ColorTropicalPink=&HFFFF6666
%ColorTurquoise=&HFF40E0D0
%ColorViolet=&HFFEE82EE
%ColorVioletRed=&HFFD02090
%ColorWalnut=&HFF663300
%ColorWheat=&HFFF5DEB3
%ColorWhite=&HFFFFFFFF
%ColorWhiteSmoke=&HFFF5F5F5
%ColorYellow=&HFFFFFF00
%ColorYellowGreen=&HFF9ACD32



' No data symbol
%RMC_NO_DATA    = &HC521974F    


' Control styles
%RMC_CTRLSTYLEFLAT         = 0
%RMC_CTRLSTYLEFLATSHADOW   = 1
%RMC_CTRLSTYLE3D           = 2
%RMC_CTRLSTYLE3DLIGHT      = 3
%RMC_CTRLSTYLEIMAGE        = 4
%RMC_CTRLSTYLEIMAGETILED   = 5

'Chart types
%RMC_BARSINGLE            = 1
%RMC_BARGROUP             = 2
%RMC_BARSTACKED           = 3
%RMC_BARSTACKED100        = 4
%RMC_FLOATINGBAR          = 5
%RMC_FLOATINGBARGROUP     = 6
%RMC_LINE                 = 21
%RMC_AREA                 = 22
%RMC_LINE_INDEXED         = 23
%RMC_AREA_INDEXED         = 24
%RMC_AREA_STACKED         = 25
%RMC_AREA_STACKED100      = 26
%RMC_LINE_STACKED         = 27
%RMC_LINE_STACKED100      = 28
%RMC_VOLUMEBAR            = 31
%RMC_HIGHLOW              = 41
%RMC_GRIDLESS             = 51
%RMC_XYCHART              = 70
%RMC_GRIDBASED            = 10  ' only for tRMC_INFO

' BarSeries styles
%RMC_BAR_FLAT              = 1
%RMC_BAR_FLAT_GRADIENT1    = 2
%RMC_BAR_FLAT_GRADIENT2    = 3
%RMC_BAR_HOVER             = 4
%RMC_COLUMN_FLAT           = 5
%RMC_BAR_3D                = 6
%RMC_BAR_3D_GRADIENT       = 7
%RMC_COLUMN_3D             = 8
%RMC_COLUMN_3D_GRADIENT    = 9
%RMC_COLUMN_FLUTED         = 10

' LineSeries styles
%RMC_LINE_FLAT                  = 21
%RMC_LINE_FLAT_DOT              = 19
%RMC_LINE_FLAT_DASH             = 18
%RMC_LINE_FLAT_DASHDOT          = 17
%RMC_LINE_FLAT_DASHDOTDOT       = 16
%RMC_LINE_FASTLINE              = 15
%RMC_LINE_CABLE                 = 22
%RMC_LINE_3D                    = 23
%RMC_LINE_3D_GRADIENT           = 24
%RMC_AREA_FLAT                  = 25
%RMC_AREA_FLAT_GRADIENT_V       = 26
%RMC_AREA_FLAT_GRADIENT_H       = 27
%RMC_AREA_FLAT_GRADIENT_C       = 28
%RMC_AREA_3D                    = 29
%RMC_AREA_3D_GRADIENT_V         = 30
%RMC_AREA_3D_GRADIENT_H         = 31
%RMC_AREA_3D_GRADIENT_C         = 32
%RMC_LINE_FLAT_SHADOW           = 33
%RMC_LINE_CABLE_SHADOW          = 34
%RMC_LINE_SYMBOLONLY            = 35

' HighLowSeries styles
%RMC_OHLC                   = 1
%RMC_CANDLESTICK            = 2

' GridlessSeries styles
%RMC_PIE_FLAT               = 51
%RMC_PIE_GRADIENT           = 52
%RMC_PIE_3D                 = 53
%RMC_PIE_3D_GRADIENT        = 54
%RMC_DONUT_FLAT             = 55
%RMC_DONUT_GRADIENT         = 56
%RMC_DONUT_3D               = 57
%RMC_DONUT_3D_GRADIENT      = 58
%RMC_PYRAMIDE               = 59
%RMC_PYRAMIDE3              = 60

' XY-Series styles
%RMC_XY_LINE                = 70
%RMC_XY_LINE_DOT            = 69
%RMC_XY_LINE_DASH           = 68
%RMC_XY_LINE_DASHDOT        = 67
%RMC_XY_LINE_DASHDOTDOT     = 66
%RMC_XY_FASTLINE            = 65
%RMC_XY_SYMBOL              = 71
%RMC_XY_LINESYMBOL          = %RMC_XY_LINE
%RMC_XY_CABLE               = 73
%RMC_XY_CABLESYMBOL         = %RMC_XY_CABLE

' Pie and Donut alignments
%RMC_FULL                   = 1
%RMC_HALF_TOP               = 2
%RMC_HALF_RIGHT             = 3
%RMC_HALF_BOTTOM            = 4
%RMC_HALF_LEFT              = 5

' Line styles for data- and label axes
%RMC_LINESTYLESOLID       = 0
%RMC_LINESTYLEDASH        = 1
%RMC_LINESTYLEDOT         = 2
%RMC_LINESTYLEDASHDOT     = 3
%RMC_LINESTYLENONE        = 6

' BiColor mode for data- and label axes
%RMC_BICOLOR_NONE         = 0
%RMC_BICOLOR_DATAAXIS     = 1
%RMC_BICOLOR_LABELAXIS    = 2
%RMC_BICOLOR_BOTH         = 3  

' Orientation of the data- and label axes
%RMC_DATAAXISLEFT         = 1
%RMC_DATAAXISRIGHT        = 2
%RMC_DATAAXISTOP          = 3
%RMC_DATAAXISBOTTOM       = 4
%RMC_LABELAXISLEFT        = 5
%RMC_LABELAXISRIGHT       = 6
%RMC_LABELAXISTOP         = 7
%RMC_LABELAXISBOTTOM      = 8
%RMC_YAXISLEFT            = 9
%RMC_YAXISRIGHT           = 10
%RMC_XAXISTOP             = 11
%RMC_XAXISBOTTOM          = 12

' Text alignments 
%RMC_TEXTCENTER           = 0
%RMC_TEXTLEFT             = 1
%RMC_TEXTRIGHT            = 2
%RMC_TEXTDOWNWARD         = 3
%RMC_TEXTUPWARD           = 4

' Additional styles for line series
%RMC_LSTYLE_LINE            = 1
%RMC_LSTYLE_SPLINE          = 2
%RMC_LSTYLE_STAIR           = 3
%RMC_LSTYLE_LINE_AREA       = 4 ' Draws a line and a transparent area
%RMC_LSTYLE_SPLINE_AREA     = 5 ' Draws a spline and a transparent area
%RMC_LSTYLE_STAIR_AREA      = 6 ' Draws a stair and a transparent area

' Symbols for line series
' Symbols
%RMC_SYMBOL_NONE             = 0
%RMC_SYMBOL_BULLET           = 21
%RMC_SYMBOL_ROUND            = 1
%RMC_SYMBOL_DIAMOND          = 2
%RMC_SYMBOL_SQUARE           = 3
%RMC_SYMBOL_STAR             = 4
%RMC_SYMBOL_ARROW_DOWN       = 5
%RMC_SYMBOL_ARROW_UP         = 6
%RMC_SYMBOL_POINT            = 7
%RMC_SYMBOL_CIRCLE           = 8
%RMC_SYMBOL_RECTANGLE        = 9
%RMC_SYMBOL_CROSS            = 10
%RMC_SYMBOL_BULLET_SMALL     = 22
%RMC_SYMBOL_ROUND_SMALL      = 11
%RMC_SYMBOL_DIAMOND_SMALL    = 12
%RMC_SYMBOL_SQUARE_SMALL     = 13
%RMC_SYMBOL_STAR_SMALL       = 14
%RMC_SYMBOL_ARROW_DOWN_SMALL = 15
%RMC_SYMBOL_ARROW_UP_SMALL   = 16
%RMC_SYMBOL_POINT_SMALL      = 17
%RMC_SYMBOL_CIRCLE_SMALL     = 18
%RMC_SYMBOL_RECTANGLE_SMALL  = 19
%RMC_SYMBOL_CROSS_SMALL      = 20

' Hatchmodes
%RMC_HATCHBRUSH_OFF          = 0
%RMC_HATCHBRUSH_ON           = 1
%RMC_HATCHBRUSH_ONPRINTING   = 2


' Orientation for the legend
%RMC_LEGEND_NONE          = -1
%RMC_LEGEND_TOP           = 1
%RMC_LEGEND_LEFT          = 2
%RMC_LEGEND_RIGHT         = 3
%RMC_LEGEND_BOTTOM        = 4
%RMC_LEGEND_UL            = 5
%RMC_LEGEND_UR            = 6
%RMC_LEGEND_LL            = 7
%RMC_LEGEND_LR            = 8
%RMC_LEGEND_ONVLABELS     = 9
%RMC_LEGEND_CUSTOM        = 10
%RMC_LEGEND_CUSTOM_TOP    = 11
%RMC_LEGEND_CUSTOM_LEFT   = 12
%RMC_LEGEND_CUSTOM_RIGHT  = 13
%RMC_LEGEND_CUSTOM_BOTTOM = 14
%RMC_LEGEND_CUSTOM_UL     = 15
%RMC_LEGEND_CUSTOM_UR     = 16
%RMC_LEGEND_CUSTOM_LL     = 17
%RMC_LEGEND_CUSTOM_LR     = 18
%RMC_LEGEND_CUSTOM_CENTER = 19
%RMC_LEGEND_CUSTOM_CR     = 20
%RMC_LEGEND_CUSTOM_CL     = 21


' Legendstyle
%RMC_LEGENDNORECT         = 1
%RMC_LEGENDRECT           = 2
%RMC_LEGENDRECTSHADOW     = 3
%RMC_LEGENDROUNDRECT      = 4
%RMC_LEGENDROUNDRECTSHADOW= 5

' Errors
%RMC_ERROR_MAXINST        = -1
%RMC_ERROR_MAXREGION      = -2
%RMC_ERROR_MAXSERIES      = -3
%RMC_ERROR_ALLOC          = -4
%RMC_ERROR_NODATA         = -5
%RMC_ERROR_CTRLID         = -6
%RMC_ERROR_SERIESINDEX    = -7
%RMC_ERROR_CREATEBITMAP   = -8
%RMC_ERROR_WRONGREGION    = -9
%RMC_ERROR_PARENTHANDLE   = -10
%RMC_ERROR_CREATEWINDOW   = -11
%RMC_ERROR_INIGDIP        = -12
%RMC_ERROR_PRINT          = -13
%RMC_ERROR_NOGDIP         = -14
%RMC_ERROR_RMCFILE        = -15
%RMC_ERROR_FILEFOUND      = -16
%RMC_ERROR_READLINES      = -17
%RMC_ERROR_XYAXIS         = -18
%RMC_ERROR_LEGENDTEXT     = -19
%RMC_ERROR_EMF            = -20
%RMC_ERROR_NODATA_COUNT   = -21
%RMC_ERROR_NODATA_ZERO    = -22
%RMC_ERROR_NOCOLOR        = -23
%RMC_ERROR_CLIPBOARD      = -24
%RMC_ERROR_CBINFO         = -25
%RMC_ERROR_FILECREATE     = -26
%RMC_ERROR_DATAINDEX      = -28
%RMC_ERROR_AXISALIGNMENT  = -29
%RMC_ERROR_RANGE          = -30
%RMC_ERROR_WRONGSERIESTYPE= -31
%RMC_ERROR_MAXCUSTOM      = -50
%RMC_ERROR_CUSTOMINDEX    = -51
%RMC_ERROR_LEGENDSIZE     = 1

' Options for Value labels
%RMC_VLABEL_NONE                 = 0
%RMC_VLABEL_DEFAULT              = 1
%RMC_VLABEL_PERCENT              = 5
%RMC_VLABEL_ABSOLUTE             = 6
%RMC_VLABEL_TWIN                 = 7
%RMC_VLABEL_LEGENDONLY           = 8
%RMC_VLABEL_DEFAULT_NOZERO       = 11
%RMC_VLABEL_PERCENT_NOZERO       = 15
%RMC_VLABEL_ABSOLUTE_NOZERO      = 16
%RMC_VLABEL_TWIN_NOZERO          = 17

%RMC_MOUSEMOVE          = &H200
%RMC_LBUTTONDOWN        = &H201
%RMC_LBUTTONUP          = &H202
%RMC_LBUTTONDBLCLK      = &H203
%RMC_RBUTTONDOWN        = &H204
%RMC_RBUTTONUP          = &H205
%RMC_RBUTTONDBLCLK      = &H206
%RMC_MBUTTONDOWN        = &H207
%RMC_MBUTTONUP          = &H208
%RMC_MBUTTONDBLCLK      = &H209
%RMC_SHIFTLBUTTONDOWN   = &H20A
%RMC_SHIFTLBUTTONUP     = &H20B
%RMC_SHIFTLBUTTONDBLCLK = &H20C
%RMC_SHIFTRBUTTONDOWN   = &H20D
%RMC_SHIFTRBUTTONUP     = &H20E
%RMC_SHIFTRBUTTONDBLCLK = &H20F
%RMC_SHIFTMBUTTONDOWN   = &H210
%RMC_SHIFTMBUTTONUP     = &H211
%RMC_SHIFTMBUTTONDBLCLK = &H212
%RMC_CTRLLBUTTONDOWN    = &H213
%RMC_CTRLLBUTTONUP      = &H214
%RMC_CTRLLBUTTONDBLCLK  = &H215
%RMC_CTRLRBUTTONDOWN    = &H216
%RMC_CTRLRBUTTONUP      = &H217
%RMC_CTRLRBUTTONDBLCLK  = &H218
%RMC_CTRLMBUTTONDOWN    = &H219
%RMC_CTRLMBUTTONUP      = &H21A
%RMC_CTRLMBUTTONDBLCLK  = &H21B

%RMC_EMF        = 1
%RMC_EMFPLUS    = 2
%RMC_BMP        = 3

' Custom Objects
%RMC_CO_TEXT          = 1
%RMC_CO_BOX           = 2
%RMC_CO_CIRCLE        = 3
%RMC_CO_LINE          = 4
%RMC_CO_IMAGE         = 5
%RMC_CO_SYMBOL        = 6
%RMC_CO_POLYGON       = 7


' Anchors for custom lines
%RMC_ANCHOR_NONE         = 0
%RMC_ANCHOR_ROUND        = 1
%RMC_ANCHOR_BULLET       = 2
%RMC_ANCHOR_ARROW_CLOSED = 3
%RMC_ANCHOR_ARROW_OPEN   = 4

' Line alignment for custom text
%RMC_LINE_HORIZONTAL    = 0
%RMC_LINE_UPWARD        = 1
%RMC_LINE_DOWNWARD      = 3

' Styles for custom box/text
%RMC_BOX_NONE                = 0
%RMC_BOX_FLAT                = 1
%RMC_BOX_ROUNDEDGE           = 2
%RMC_BOX_RHOMBUS             = 3
%RMC_BOX_GRADIENTH           = 4
%RMC_BOX_GRADIENTV           = 5
%RMC_BOX_3D                  = 6
%RMC_BOX_FLAT_SHADOW         = 7
%RMC_BOX_GRADIENTH_SHADOW    = 8
%RMC_BOX_GRADIENTV_SHADOW    = 9
%RMC_BOX_3D_SHADOW           = 10

' Styles for custom Circle
%RMC_CIRCLE_FLAT             = 1
%RMC_CIRCLE_BULLET           = 2

' Zoom mode
%RMC_ZOOM_DISABLE            = 0
%RMC_ZOOM_EXTERNAL           = 1
%RMC_ZOOM_INTERNAL           = 2

' nChartType in tRMC_INFO holds one of these when in zoom- or magnifier-mode
%RMC_ZOOM_MODE               = -99
%RMC_MAGNIFIER_MODE          = -98

TYPE tRMC_INFO
    nXPos        AS LONG
    nYPos        AS LONG
    nXMove       AS LONG
    nYMove       AS LONG
    nRegionIndex AS LONG
    nRLeft       AS LONG
    nRTop        AS LONG
    nRRight      AS LONG
    nRBottom     AS LONG
    nSeriesIndex AS LONG
    nDataIndex   AS LONG
    nChartType   AS LONG
    nSLeft       AS LONG
    nSTop        AS LONG
    nSRight      AS LONG
    nSBottom     AS LONG
    nSTop2       AS LONG
    nSBottom2    AS LONG
    nGLeft       AS LONG
    nGTop        AS LONG
    nGRight      AS LONG
    nGBottom     AS LONG
    nGCol        AS LONG
    nGRow        AS LONG
    nData1       AS DOUBLE
    nData2       AS DOUBLE
    nData3       AS DOUBLE
    nData4       AS DOUBLE
    nVirtData1   AS DOUBLE
    nVirtData2   AS DOUBLE
    nVirtData3   AS DOUBLE
    nVirtData4   AS DOUBLE
END TYPE




' Type declarations for the short function calls
' (those with an 'I' at the end of the name, like RMC_CreateChartI())

' ***** RMC_AddBarSeriesI() *****
TYPE tRMC_BARSERIES
    nType               AS LONG
    nStyle              AS LONG
    nIsLucent           AS LONG
    nColor              AS LONG
    nIsHorizontal       AS LONG
    nWhichDataAxis      AS LONG
    nValueLabelOn       AS LONG
    nPointsPerColumn    AS LONG
    nHatchMode          AS LONG
END TYPE
' *****************************

' ***** RMC_AddCaptionI() *****
TYPE tRMC_CAPTION
    nBackColor  AS LONG
    nTextColor  AS LONG
    nFontSize   AS LONG
    nIsBold     AS LONG
    sText       AS ASCIZ * 200
END TYPE
' *****************************

' ***** RMC_AddDataAxisI() *****
TYPE tRMC_DATAAXIS
    nAlignment      AS LONG
    nMinValue       AS DOUBLE
    nMaxValue       AS DOUBLE
    nTickCount      AS LONG
    nFontsize       AS LONG
    nTextColor      AS LONG
    nLineColor      AS LONG
    nLineStyle      AS LONG
    nDecimalDigits  AS LONG
    nLabelAlignment AS LONG
    sUnit           AS ASCIZ * 16
    sText           AS ASCIZ * 100
    sLabels         AS ASCIZ * 500
END TYPE
' *********************************

' ***** RMC_AddGridI() *****
TYPE tRMC_GRID
    nGridBackColor AS LONG
    nAsGradient    AS LONG
    nBiColor       AS LONG
    nLeft          AS LONG
    nTop           AS LONG
    nWidth         AS LONG
    nHeight        AS LONG
END TYPE
' ************************

' RMC_AddGridlessSeries() *****
TYPE tRMC_GRIDLESSSERIES
    nStyle              AS LONG
    nPieAlignment       AS LONG
    nExplodemode        AS LONG
    nIsLucent           AS LONG
    nValueLabelOn       AS LONG
    nHatchMode          AS LONG
    nStartAngle         AS LONG
END TYPE
' *****************************

' ***** RMC_AddLabelAxisI() *****
TYPE tRMC_LABELAXIS
    nCount          AS LONG
    nTickCount      AS LONG
    nAlignment      AS LONG
    nFontsize       AS LONG
    nTextColor      AS LONG
    nTextAlignment  AS LONG
    nLineColor      AS LONG
    nLineStyle      AS LONG
    sText           AS ASCIZ * 100
END TYPE
' *************************

' ***** RMC_AddLegendI() *****
TYPE tRMC_LEGEND
    nLegendAlign     AS LONG
    nLegendBackColor AS LONG
    nLegendStyle     AS LONG
    nLegendTextColor AS LONG
    nLegendFontSize  AS LONG
    nLegendIsBold    AS LONG
END TYPE
'***************************

' ***** RMC_AddLineSeriesI(), RMC_AddLineSeries2I() *****
TYPE tRMC_LINESERIES
    nType               AS LONG
    nStyle              AS LONG
    nLineStyle          AS LONG
    nIsLucent           AS LONG
    nColor              AS LONG
    nSeriesSymbol       AS LONG
    nWhichDataAxis      AS LONG
    nValueLabelOn       AS LONG
    nHatchMode          AS LONG
END TYPE
' *********************************

' ***** RMC_AddRegionI: *****
TYPE tRMC_REGION
    nTop        AS LONG
    nLeft       AS LONG
    nWidth      AS LONG
    nHeight     AS LONG
    sFooter     AS ASCIZ * 200
    nShowBorder AS LONG
END TYPE
' *****************************

' ***** RMC_AddXAxisI(), RMC_AddYAxisI() *****
TYPE tRMC_XYAXIS
    nAlignment      AS LONG
    nMinValue       AS DOUBLE
    nMaxValue       AS DOUBLE
    nTickCount      AS LONG
    nFontsize       AS LONG
    nTextColor      AS LONG
    nLineColor      AS LONG
    nLineStyle      AS LONG
    nDecimalDigits  AS LONG
    nLabelAlignment AS LONG
    sUnit           AS ASCIZ * 16
    sText           AS ASCIZ * 100
    sLabels         AS ASCIZ * 500
END TYPE
' *********************************

' ***** RMC_CreateChartI: *****
TYPE tRMC_CHART
    nTop            AS LONG
    nLeft           AS LONG
    nWidth          AS LONG
    nHeight         AS LONG
    nBackColor      AS LONG
    nCtrlStyle      AS LONG
    nExportOnly     AS LONG
    sBgImage        AS ASCIZ * 100
    sFontName       AS ASCIZ * 50
    nToolTipWidth   AS LONG
    nBitmapBKColor  AS LONG
END TYPE
' *********************

' ***** RMC_AddXYSeriesI() *****
TYPE tRMC_XYSERIES
    nColor              AS LONG
    nStyle              AS LONG
    nLineStyle          AS LONG
    nSeriesSymbol       AS LONG
    nWhichXAxis         AS LONG
    nWhichYAxis         AS LONG
    nValueLabelOn       AS LONG
END TYPE
' *********************************


' Functions


DECLARE FUNCTION RMC_AddBarSeries LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG,_
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF nFirstDataValue AS DOUBLE, _
                 OPTIONAL BYVAL nDataValuesCount AS LONG, _
                 OPTIONAL BYVAL nType  AS LONG, _
                 OPTIONAL BYVAL nStyle AS LONG, _
                 OPTIONAL BYVAL nIsLucent AS LONG, _
                 OPTIONAL BYVAL nColor AS LONG, _
                 OPTIONAL BYVAL nIsHorizontal AS LONG, _
                 OPTIONAL BYVAL nWhichDataAxis AS LONG, _
                 OPTIONAL BYVAL nValueLabelOn AS LONG, _
                 OPTIONAL BYVAL nPointsPerColumn AS LONG, _
                 OPTIONAL BYVAL nHatchMode AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddBarSeriesI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF nFirstDataValue AS DOUBLE, _
                 BYVAL nDataValuesCount AS LONG, _
                 BYREF T AS tRMC_BARSERIES _
                 ) AS LONG

DECLARE FUNCTION RMC_AddCaption LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF sCaption AS ASCIZ, _
                 OPTIONAL BYVAL nTitelBackColor AS LONG, _
                 OPTIONAL BYVAL nTitelTextColor AS LONG, _
                 OPTIONAL BYVAL nTitelFontSize AS LONG, _
                 OPTIONAL BYVAL nTitelIsBold AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddCaptionI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF T AS tRMC_CAPTION _
                 ) AS LONG

DECLARE FUNCTION RMC_AddDataAxis LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYVAL nAlignment AS LONG, _
                 OPTIONAL BYVAL nMinValue AS DOUBLE, _
                 OPTIONAL BYVAL nMaxValue AS DOUBLE, _
                 OPTIONAL BYVAL nTickCount AS LONG, _
                 OPTIONAL BYVAL nFontsize AS LONG, _
                 OPTIONAL BYVAL nTextColor AS LONG, _
                 OPTIONAL BYVAL nLineColor AS LONG, _
                 OPTIONAL BYVAL nLineStyle AS LONG, _
                 OPTIONAL BYVAL nDecimalDigits AS LONG, _
                 OPTIONAL BYREF sUnit AS ASCIZ, _
                 OPTIONAL BYREF sText AS ASCIZ, _
                 OPTIONAL BYREF sLabels AS ASCIZ, _
                 OPTIONAL BYREF nLabelAlignment AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddDataAxisI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF T AS tRMC_DATAAXIS _
                 ) AS LONG

DECLARE FUNCTION RMC_AddGrid LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYVAL nBackColor AS LONG, _
                 OPTIONAL BYVAL nAsGradient AS LONG, _
                 OPTIONAL BYVAL nLeft AS LONG, _
                 OPTIONAL BYVAL nTop AS LONG, _
                 OPTIONAL BYVAL nWidth AS LONG, _
                 OPTIONAL BYVAL nHeight AS LONG, _
                 OPTIONAL BYVAL nBiColor AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddGridI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF T AS tRMC_GRID _
                 ) AS LONG

DECLARE FUNCTION RMC_AddGridlessSeries LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF nFirstDataValue AS DOUBLE, _
                 OPTIONAL BYVAL nDataValuesCount AS LONG, _
                 OPTIONAL BYREF nFirstColorElement AS LONG, _
                 OPTIONAL BYVAL nColorElementsCount AS LONG, _
                 OPTIONAL BYVAL nStyle  AS LONG, _
                 OPTIONAL BYVAL nPieAlignment  AS LONG, _
                 OPTIONAL BYVAL nExplodemode AS LONG, _
                 OPTIONAL BYVAL nIsLucent AS LONG, _
                 OPTIONAL BYVAL nValueLabelOn AS LONG, _
                 OPTIONAL BYVAL nHatchMode AS LONG, _
                 OPTIONAL BYVAL nStartAngle AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddGridlessSeriesI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF nFirstDataValue AS DOUBLE, _
                 BYVAL nDataValuesCount AS LONG, _
                 BYREF nFirstColorElement AS LONG, _
                 BYVAL nColorElementsCount AS LONG, _
                 BYREF T AS tRMC_GRIDLESSSERIES _
                 ) AS LONG

DECLARE FUNCTION RMC_AddHighLowSeries LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF nFirstDataValue AS DOUBLE, _
                 OPTIONAL BYVAL nDataValuesCount AS LONG, _
                 OPTIONAL BYREF nFirstPPCValue AS LONG, _
                 OPTIONAL BYVAL nPPCValuesCount AS LONG, _
                 OPTIONAL BYVAL nStyle AS LONG, _
                 OPTIONAL BYVAL nWhichDataAxis AS LONG, _
                 OPTIONAL BYVAL nColorLow AS LONG, _
                 OPTIONAL BYVAL nColorHigh AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_AddLabelAxis LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF sLabel AS ASCIZ, _
                 OPTIONAL BYVAL nCount AS LONG, _
                 OPTIONAL BYVAL nTickCount AS LONG, _
                 OPTIONAL BYVAL nAlignment AS LONG, _
                 OPTIONAL BYVAL nFontsize AS LONG, _
                 OPTIONAL BYVAL nTextColor AS LONG, _
                 OPTIONAL BYVAL nTextAlignment AS LONG, _
                 OPTIONAL BYVAL nLineColor AS LONG, _
                 OPTIONAL BYVAL nLineStyle AS LONG, _
                 OPTIONAL BYREF sText AS ASCIZ _
                 ) AS LONG
DECLARE FUNCTION RMC_AddLabelAxisI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF sLabel AS ASCIZ, _
                 BYREF T AS tRMC_LABELAXIS _
                 ) AS LONG

DECLARE FUNCTION RMC_AddLegend LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF sLegendText AS ASCIZ, _
                 OPTIONAL BYVAL nLegendAlign AS LONG, _
                 OPTIONAL BYVAL nLegendBackColor AS LONG, _
                 OPTIONAL BYVAL nLegendStyle AS LONG, _
                 OPTIONAL BYVAL nLegendTextColor AS LONG, _
                 OPTIONAL BYVAL nLegendFontSize AS LONG, _
                 OPTIONAL BYVAL nLegendIsBold AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddLegendI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF sLegendText AS ASCIZ, _
                 BYREF T AS tRMC_LEGEND _
                 ) AS LONG

DECLARE FUNCTION RMC_AddLineSeries LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF nFirstDataValue AS DOUBLE, _
                 OPTIONAL BYVAL nDataValuesCount AS LONG, _
                 OPTIONAL BYREF nFirstPPCValue AS LONG, _
                 OPTIONAL BYVAL nPPCValuesCount AS LONG, _
                 OPTIONAL BYVAL nChartType  AS LONG, _
                 OPTIONAL BYVAL nStyle AS LONG, _
                 OPTIONAL BYVAL nLineStyle AS LONG, _
                 OPTIONAL BYVAL nIsLucent AS LONG, _
                 OPTIONAL BYVAL nColor AS LONG, _
                 OPTIONAL BYVAL nChartSymbol AS LONG, _
                 OPTIONAL BYVAL nWhichDataAxis AS LONG, _
                 OPTIONAL BYVAL nValueLabelOn AS LONG, _
                 OPTIONAL BYVAL nHatchMode AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddLineSeriesI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF nFirstDataValue AS DOUBLE, _
                 BYVAL nDataValuesCount AS LONG, _
                 BYREF nFirstPPCValue AS LONG, _
                 BYVAL nPPCValuesCount AS LONG, _
                 BYREF T AS tRMC_LINESERIES _
                 )  AS LONG

DECLARE FUNCTION RMC_AddRegion LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 OPTIONAL BYVAL nLeft AS LONG, _
                 OPTIONAL BYVAL nTop  AS LONG, _
                 OPTIONAL BYVAL nWidth AS LONG, _
                 OPTIONAL BYVAL nHeight AS LONG, _
                 OPTIONAL BYREF sFooter AS ASCIZ, _
                 OPTIONAL BYVAL nShowBorder AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddRegionI LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYREF T AS tRMC_REGION _
                 ) AS LONG
                 
DECLARE FUNCTION RMC_AddToolTips LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL hWnd AS LONG, _
                 OPTIONAL BYVAL nToolTipWidth AS LONG _
                 ) AS LONG                 

DECLARE FUNCTION RMC_AddVolumeBarSeries LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPTIONAL BYREF nFirstDataValue AS DOUBLE, _
                 OPTIONAL BYVAL nDataValuesCount AS LONG, _
                 OPTIONAL BYREF nFirstPPCValue AS LONG, _
                 OPTIONAL BYVAL nPPCValuesCount AS LONG, _
                 OPTIONAL BYVAL nColor AS LONG, _
                 OPTIONAL BYVAL nWhichDataAxis AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_AddXAxis LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nRegion AS LONG, _
                    BYVAL nAlignment AS LONG, _
                    OPTIONAL BYVAL nMinValue AS DOUBLE, _
                    OPTIONAL BYVAL nMaxValue AS DOUBLE, _
                    OPTIONAL BYVAL nTickCount AS LONG, _
                    OPTIONAL BYVAL nFontsize AS LONG, _
                    OPTIONAL BYVAL nTextColor AS LONG, _
                    OPTIONAL BYVAL nLineColor AS LONG, _
                    OPTIONAL BYVAL nLineStyle AS LONG, _
                    OPTIONAL BYVAL nDecimalDigits AS LONG, _
                    OPTIONAL BYREF sUnit      AS ASCIZ, _
                    OPTIONAL BYREF sText AS ASCIZ, _
                    OPTIONAL BYREF sLables AS ASCIZ, _
                    OPTIONAL BYVAL nLabelAlignment AS LONG _
                    ) AS LONG
DECLARE FUNCTION RMC_AddXAxisI LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nRegion AS LONG, _
                    BYREF T AS tRMC_XYAXIS _
                    ) AS LONG

DECLARE FUNCTION RMC_AddYAxis LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nRegion AS LONG, _
                    BYVAL nAlignment AS LONG, _
                    OPTIONAL BYVAL nMinValue AS DOUBLE, _
                    OPTIONAL BYVAL nMaxValue AS DOUBLE, _
                    OPTIONAL BYVAL nTickCount AS LONG, _
                    OPTIONAL BYVAL nFontsize AS LONG, _
                    OPTIONAL BYVAL nTextColor AS LONG, _
                    OPTIONAL BYVAL nLineColor AS LONG, _
                    OPTIONAL BYVAL nLineStyle AS LONG, _
                    OPTIONAL BYVAL nDecimalDigits AS LONG, _
                    OPTIONAL BYREF sUnit      AS ASCIZ, _
                    OPTIONAL BYREF sText AS ASCIZ, _
                    OPTIONAL BYREF sLables AS ASCIZ, _
                    OPTIONAL BYVAL nLabelAlignment AS LONG _
                    ) AS LONG
DECLARE FUNCTION RMC_AddYAxisI LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nRegion AS LONG, _
                    BYREF T AS tRMC_XYAXIS _
                    ) AS LONG

DECLARE FUNCTION RMC_AddXYSeries LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 OPT BYREF nFirstXDataValue AS DOUBLE, _
                 OPT BYVAL nDataXValuesCount AS LONG, _
                 OPT BYREF nFirstYDataValue AS DOUBLE, _
                 OPT BYVAL nDataYValuesCount AS LONG, _
                 OPTIONAL BYVAL nColor AS LONG, _
                 OPTIONAL BYVAL nStyle AS LONG, _
                 OPTIONAL BYVAL nLineStyle AS LONG, _
                 OPTIONAL BYVAL nSymbolStyle AS LONG, _
                 OPTIONAL BYVAL nWhichXAxis AS LONG, _
                 OPTIONAL BYVAL nWhichYAxis AS LONG, _
                 OPTIONAL BYVAL nValueLabelOn AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_AddXYSeriesI LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nRegion AS LONG, _
                    BYREF nFirstXDataValue AS DOUBLE, _
                    BYVAL nDataXValuesCount AS LONG, _
                    BYREF nFirstYDataValue AS DOUBLE, _
                    BYVAL nDataYValuesCount AS LONG, _
                    T AS tRMC_XYSERIES _
                    ) AS LONG

DECLARE FUNCTION RMC_CalcAverage LIB "RMCHART.DLL" ( _
                   BYVAL nCtrlId AS LONG,_
                   BYVAL nRegion AS LONG, _
                   BYVAL nSeriesIndex AS LONG, _                   
                   BYREF nAverage AS DOUBLE, _
                   BYREF nXStart AS LONG, _
                   BYREF nYStart AS LONG, _
                   BYREF nXEnd AS LONG, _
                   BYREF nYEnd AS LONG, _
                   OPTIONAL BYREF sHighLowIndex AS ASCIZ _
                   ) AS LONG


DECLARE FUNCTION RMC_CalcTrend LIB "RMCHART.DLL" ( _
                   BYVAL nCtrlId AS LONG,_
                   BYVAL nRegion AS LONG, _
                   BYVAL nSeriesIndex AS LONG, _                   
                   BYREF nFirstValue AS DOUBLE, _
                   BYREF nLastValue AS DOUBLE, _
                   BYREF nXStart AS LONG, _
                   BYREF nYStart AS LONG, _
                   BYREF nXEnd AS LONG, _
                   BYREF nYEnd AS LONG, _
                   OPTIONAL BYREF sHighLowIndex AS ASCIZ _
                   ) AS LONG
                   
DECLARE FUNCTION RMC_COBox LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nCOIndex AS LONG, _
                    BYVAL nLeft AS LONG, _
                    BYVAL nTop AS LONG, _
                    BYVAL nWidth AS LONG, _
                    BYVAL nHeight AS LONG, _
                    OPTIONAL BYVAL nStyle AS LONG, _
                    OPTIONAL BYVAL nBGColor AS LONG, _
                    OPTIONAL BYVAL nLineColor AS LONG, _
                    OPTIONAL BYVAL nTransparency AS LONG _
                    ) AS LONG

DECLARE FUNCTION RMC_COCircle LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nCOIndex AS LONG, _
                    BYVAL nXCenter AS LONG, _
                    BYVAL nYCenter AS LONG, _
                    BYVAL nWidth AS LONG, _
                    OPTIONAL BYVAL nStyle AS LONG, _
                    OPTIONAL BYVAL nBGColor AS LONG, _
                    OPTIONAL BYVAL nLineColor AS LONG, _
                    OPTIONAL BYVAL nTransparency AS LONG _
                    ) AS LONG                    

DECLARE FUNCTION RMC_CODash LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlId AS LONG,_
                    BYVAL nCOIndex AS LONG, _
                    BYVAL nXStart AS LONG, _
                    BYVAL nYStart AS LONG, _
                    BYVAL nXEnd AS LONG, _
                    BYVAL nYEnd AS LONG, _
                    OPTIONAL BYVAL nStyle AS LONG, _
                    OPTIONAL BYVAL nColor AS LONG, _
                    OPTIONAL BYVAL nAsSpline AS LONG, _
                    OPTIONAL BYVAL nLineWidth AS LONG, _
                    OPTIONAL BYVAL nStartCap AS LONG, _
                    OPTIONAL BYVAL nEndCap AS LONG _
                    ) AS LONG

DECLARE FUNCTION RMC_CODelete LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlId AS LONG,_
                    BYVAL nIndex AS LONG _
                    ) AS LONG

DECLARE FUNCTION RMC_COGetTextWH LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nIndex AS LONG, _
                    BYREF nWH AS LONG _
                    ) AS LONG


DECLARE FUNCTION RMC_COImage LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nCOIndex AS LONG, _
                    BYREF sImagePath AS ASCIZ, _
                    BYVAL nLeft AS LONG, _
                    BYVAL nTop AS LONG, _
                    OPTIONAL BYVAL nWidth AS LONG, _
                    OPTIONAL BYVAL nHeight AS LONG _
                    ) AS LONG                    

DECLARE FUNCTION RMC_COLine LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlId AS LONG,_
                    BYVAL nCOIndex AS LONG, _
                    BYREF nXPoints AS LONG, _
                    BYREF nYPoints AS LONG, _
                    BYVAL nPointsCount AS LONG, _                         
                    OPTIONAL BYVAL nStyle AS LONG, _
                    OPTIONAL BYVAL nColor AS LONG, _
                    OPTIONAL BYVAL nAsSpline AS LONG, _
                    OPTIONAL BYVAL nLineWidth AS LONG, _
                    OPTIONAL BYVAL nStartCap AS LONG, _
                    OPTIONAL BYVAL nEndCap AS LONG _
                    ) AS LONG                     

DECLARE FUNCTION RMC_COPolygon LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlId AS LONG,_
                    BYVAL nCOIndex AS LONG, _
                    BYREF nXPoints AS LONG, _
                    BYREF nYPoints AS LONG, _
                    BYVAL nPointsCount AS LONG, _                         
                    OPTIONAL BYVAL nBGColor AS LONG, _
                    OPTIONAL BYVAL nLineColor AS LONG, _
                    OPTIONAL BYVAL nAsSpline AS LONG, _                    
                    OPTIONAL BYVAL nTransparency AS LONG _
                    ) AS LONG

DECLARE FUNCTION RMC_COSymbol LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nCOIndex AS LONG, _
                    BYVAL nXCenter AS LONG, _
                    BYVAL nYCenter AS LONG, _
                    OPTIONAL BYVAL nStyle AS LONG, _
                    OPTIONAL BYVAL nColor AS LONG _
                    ) AS LONG                    

DECLARE FUNCTION RMC_COText LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlID AS LONG, _
                    BYVAL nCOIndex AS LONG, _
                    BYREF sText AS ASCIZ, _
                    BYVAL nLeft AS LONG, _
                    BYVAL nTop AS LONG, _
                    OPTIONAL BYVAL nWidth AS LONG, _
                    OPTIONAL BYVAL nHeight AS LONG, _
                    OPTIONAL BYVAL nStyle AS LONG, _
                    OPTIONAL BYVAL nBGColor AS LONG, _
                    OPTIONAL BYVAL nLineColor AS LONG, _
                    OPTIONAL BYVAL nTransparency AS LONG, _
                    OPTIONAL BYVAL nLineAlignment AS LONG, _
                    OPTIONAL BYVAL nTextColor AS LONG, _
                    OPTIONAL BYREF sTextProperties AS ASCIZ _
                    ) AS LONG

DECLARE FUNCTION RMC_COVisible LIB "RMCHART.DLL" ( _
                    BYVAL nCtrlId AS LONG,_
                    BYVAL nIndex AS LONG, _
                    BYVAL nHide AS LONG _
                    ) AS LONG

DECLARE FUNCTION RMC_CreateChart LIB "RMCHART.DLL" ( _
                 BYVAL nParentHndl AS LONG, _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG, _
                 BYVAL nWidth AS LONG, _
                 BYVAL nHeight AS LONG, _
                 OPTIONAL BYVAL nBackColor AS LONG, _
                 OPTIONAL BYVAL nCtrlStyle AS LONG, _
                 OPTIONAL BYVAL nExportOnly AS LONG, _
                 OPTIONAL BYREF sBgImage AS ASCIZ, _
                 OPTIONAL BYREF sFontName AS ASCIZ, _
                 OPTIONAL BYVAL nToolTipWidth AS LONG, _
                 OPTIONAL BYVAL nBitmapBKColor AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_CreateChartI LIB "RMCHART.DLL" ( _
                 BYVAL nParentHndl AS LONG, _
                 BYVAL nCtrlID AS LONG, _
                 BYREF T AS tRMC_CHART _
                 ) AS LONG

DECLARE FUNCTION RMC_CreateChartFromFile LIB "RMCHART.DLL" ( _
                 BYVAL nParentHndl AS LONG,_
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG, _
                 BYVAL nExportOnly AS LONG, _
                 BYREF sRMCFile AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_CreateChartOnDC LIB "RMCHART.DLL" ( _
                 BYVAL nParentDC AS LONG, _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG, _
                 BYVAL nWidth AS LONG, _
                 BYVAL nHeight AS LONG, _
                 OPTIONAL BYVAL nBackColor AS LONG, _
                 OPTIONAL BYVAL nCtrlStyle AS LONG, _
                 OPTIONAL BYVAL nExportOnly AS LONG, _
                 OPTIONAL BYREF sBgImage AS ASCIZ, _
                 OPTIONAL BYREF sFontName AS ASCIZ, _
                 OPTIONAL BYVAL nBitmapBKColor AS LONG _
                 ) AS LONG
DECLARE FUNCTION RMC_CreateChartOnDCI LIB "RMCHART.DLL" ( _
                 BYVAL nParentDC AS LONG, _
                 BYVAL nCtrlID AS LONG, _
                 BYREF T AS tRMC_CHART _
                 ) AS LONG
DECLARE FUNCTION RMC_CreateChartFromFileOnDC LIB "RMCHART.DLL" ( _
                 BYVAL nParentDC AS LONG,_
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG, _
                 BYVAL nExportOnly AS LONG, _
                 BYREF sRMCFile AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_CreateChartOnDC_PB8 LIB "RMCHART.DLL" ( _
                 BYVAL nParentDC AS LONG, _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG, _
                 BYVAL nWidth AS LONG, _
                 BYVAL nHeight AS LONG, _
                 OPTIONAL BYVAL nBackColor AS LONG, _
                 OPTIONAL BYVAL nCtrlStyle AS LONG, _
                 OPTIONAL BYVAL nExportOnly AS LONG, _
                 OPTIONAL BYREF sBgImage AS ASCIZ, _
                 OPTIONAL BYREF sFontName AS ASCIZ _
                 ) AS LONG
DECLARE FUNCTION RMC_CreateChartOnDCI_PB8 LIB "RMCHART.DLL" ( _
                 BYVAL nParentDC AS LONG, _
                 BYVAL nCtrlID AS LONG, _
                 BYREF T AS tRMC_CHART _
                 ) AS LONG
DECLARE FUNCTION RMC_CreateChartFromFileOnDC_PB8 LIB "RMCHART.DLL" ( _
                 BYVAL nParentDC AS LONG,_
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG, _
                 BYVAL nExportOnly AS LONG, _
                 BYREF sRMCFile AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_DeleteChart LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Draw LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Draw2Clipboard LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 OPTIONAL BYVAL nType AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Draw2File LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYREF sFileName AS ASCIZ, _
                 OPTIONAL BYVAL nWidth AS LONG, _
                 OPTIONAL BYVAL nHeight AS LONG, _
                 OPTIONAL BYVAL nJPGQualityLevel AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Draw2Printer LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 OPTIONAL BYVAL nPrinterDC AS LONG, _
                 OPTIONAL BYVAL nLeft AS LONG, _
                 OPTIONAL BYVAL nTop AS LONG, _
                 OPTIONAL BYVAL nWidth AS LONG, _
                 OPTIONAL BYVAL nHeight AS LONG, _
                 OPTIONAL BYVAL nType AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetChartsizeFromFile LIB "RMCHART.DLL" ( _
                 BYREF sRMCFile AS ASCIZ, _
                 BYREF nWidth AS LONG, _
                 BYREF nHeight AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetCtrlLeft LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetCtrlTop LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetCtrlWidth LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetCtrlHeight LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetData LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeriesIndex AS LONG, _
                 BYVAL nDataIndex AS LONG, _
                 BYREF nData AS DOUBLE, _
                 OPTIONAL BYVAL nYData AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetDataCount LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeriesIndex AS LONG, _
                 BYREF nDataCount AS LONG _
                 ) AS LONG                 

DECLARE FUNCTION RMC_GetDataLocation LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeriesIndex AS LONG, _
                 BYVAL nData AS DOUBLE, _
                 BYREF nXYPos AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetDataLocationXY LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeriesIndex AS LONG, _
                 BYVAL nDataX AS DOUBLE, _
                 BYVAL nDataY AS DOUBLE, _
                 BYREF nXPos AS LONG, _
                 BYREF nYPos AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetSeriesDataRange LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYREF nFirst AS LONG, _
                 BYREF nLast AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetVersion LIB "RMCHART.DLL"( _
                 ) AS DOUBLE

DECLARE FUNCTION RMC_GetGridLocation LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF nLeft AS LONG, _
                 BYREF nTop AS LONG, _
                 BYREF nRight AS LONG, _
                 BYREF nBottom AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetImageSizeFromFile LIB "RMCHART.DLL" ( _
                 BYREF sImagePath AS ASCIZ, _
                 BYREF nWidth AS LONG, _
                 BYREF nHeight AS LONG _
                 ) AS LONG                 

DECLARE FUNCTION RMC_GetINFO LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYREF TINFO AS tRMC_INFO, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nIndex AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_GetINFOXY LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYREF TINFO AS tRMC_INFO, _
                 BYVAL nX AS LONG, _
                 BYVAL nY AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Magnifier LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nEnable AS LONG, _
                 OPTIONAL BYVAL nSize AS LONG, _
                 OPTIONAL BYVAL nColor AS LONG, _
                 OPTIONAL BYVAL nLineColor AS LONG, _
                 OPTIONAL BYVAL nTransparency AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Paint LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_ReadDataFromFile LIB "RMCHART.DLL" ( _
                 BYREF aData() AS DOUBLE, _
                 BYVAL sFileName AS STRING, _
                 OPTIONAL BYVAL sLines AS STRING, _
                 OPTIONAL BYVAL sFields AS STRING, _
                 OPTIONAL BYVAL sFieldDelimiter AS STRING, _
                 OPTIONAL BYVAL nReverse AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_ReadStringFromFile LIB "RMCHART.DLL" ( _
                 BYREF sValue() AS STRING, _
                 BYVAL sFileName AS STRING, _
                 OPTIONAL BYVAL sLines AS STRING, _
                 OPTIONAL BYVAL sFields AS STRING, _
                 OPTIONAL BYVAL sFieldDelimiter AS STRING, _
                 OPTIONAL BYVAL nReverse AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_Reset LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_RND LIB "RMCHART.DLL" ( _
                 BYVAL n1 AS LONG, _
                 BYVAL n2 AS LONG _
                 ) AS LONG                 

DECLARE FUNCTION RMC_SaveBMP LIB "RMCHART.DLL" ( _
                 BYVAL hBmp AS LONG, BYREF sFileName AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCaptionText LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF sText AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCaptionBGColor LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nColor AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCaptionTextColor LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nColor AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCaptionFontSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontSize AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetCaptionFontBold LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nFontBold AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCtrlBGColor LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nColor AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCtrlBGImage LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYREF sBgImage AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCtrlFont  LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYREF sFontName AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_SetCtrlPos LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nLeft AS LONG, _
                  BYVAL nTop AS LONG, _
                  OPTIONAL BYVAL nRelative AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetCtrlSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nWidth AS LONG, _
                  BYVAL nHeight AS LONG, _
                  OPTIONAL BYVAL nRelative AS LONG, _
                  OPTIONAL BYVAL nRecalcMode AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetCtrlStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlId AS LONG, _
                  BYVAL nStyle AS LONG _
                  ) AS LONG
                 
DECLARE FUNCTION RMC_SetCustomToolTipText LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlId AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nDataIndex AS LONG, _
                  BYREF sText AS ASCIZ _
                  ) AS LONG                 

DECLARE FUNCTION RMC_SetDAXAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nAlignment AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXDecimalDigits LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nDecimalDigits AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXFontSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontSize AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXLabelAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nLabelAlignment AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXLabels LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sLabels AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG                  

DECLARE FUNCTION RMC_SetDAXLineColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXLineStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nStyle AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXMaxValue LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nMaxValue AS DOUBLE, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXMinValue LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nMinValue AS DOUBLE, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXText LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sText AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXTextColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXTickcount LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nTickCount AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetDAXUnit LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sUnit AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetGridBGColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG _
                  ) AS LONG
                  
DECLARE FUNCTION RMC_SetGridBiColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nBiColor AS LONG _
                  ) AS LONG                  

DECLARE FUNCTION RMC_SetGridGradient LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nHasGradient AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetGridMargin LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nLeft AS LONG, _
                  BYVAL nTop  AS LONG, _
                  BYVAL nWidth AS LONG, _
                  BYVAL nHeight AS LONG _
                  ) AS LONG
                  
DECLARE FUNCTION RMC_SetHelpingGrid LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nSize AS LONG, _
                  OPTIONAL BYVAL nGridColor AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nAlignment AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXCount LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nLabelAxisCount AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXFontSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontSize AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXLabelAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nAlignment AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXLabels LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sLabels AS ASCIZ _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXLabelsFile LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlId AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sFileName AS ASCIZ, _
                  OPTIONAL BYREF sLines AS ASCIIZ, _
                  OPTIONAL BYREF sFields AS ASCIIZ, _
                  OPTIONAL BYREF sFieldDelimiter AS ASCIIZ _
                  ) AS LONG                  

DECLARE FUNCTION RMC_SetLAXLabelsRange LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlId AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFirst AS LONG, _
                  BYVAL nLast AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXLineColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXLineStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nStyle AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXText LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sText AS ASCIZ _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXTextColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLAXTickCount LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nTickCount AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLegendAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nAlignment AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLegendBGColor LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nColor AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetLegendFontBold LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontBold AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLegendFontSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontSize AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLegendHide LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nHide AS LONG _
                  )  AS LONG                  

DECLARE FUNCTION RMC_SetLegendStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nStyle AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetLegendText LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF sLegendText AS ASCIZ _
                 ) AS LONG

DECLARE FUNCTION RMC_SetLegendTextColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetRegionFooter LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sFooter AS ASCIZ _
                  ) AS LONG

DECLARE FUNCTION RMC_SetRegionMargin LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nLeft AS LONG, _
                  BYVAL nTop  AS LONG, _
                  BYVAL nWidth AS LONG, _
                  BYVAL nHeight AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetRegionBorder LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nShowBorder AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetRMCFile LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYREF sRMCFile AS ASCIZ _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nColor AS LONG, _
                  OPTIONAL BYVAL nIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesExplodeMode LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nExplodeMode AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesData LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYREF nData AS DOUBLE, _
                 BYVAL nDataCount AS LONG, _
                 OPTIONAL BYVAL nYData AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSeriesDataAxis LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nWhichAxis AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSeriesDataFile LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYREF sFileName AS ASCIZ, _
                 OPTIONAL BYREF sLines AS ASCIZ, _
                 OPTIONAL BYREF sFields AS ASCIZ, _
                 OPTIONAL BYREF sFieldDelimiter AS ASCIZ, _
                 OPTIONAL BYVAL nYData AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSeriesDataRange LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nFirst AS LONG, _
                 BYVAL nLast AS LONG _
                 ) AS LONG


DECLARE FUNCTION RMC_SetSeriesHatchMode LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nHatchMode AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesHide LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nHide AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesHighLowColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nColorLow AS LONG, _
                  BYVAL nColorHigh AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesLinestyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nLinestyle AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesLucent LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nLucent AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesPPColumn LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nPointsPerColumn AS LONG _
                 ) AS LONG
                 
DECLARE FUNCTION RMC_SetSeriesPPColumnArray LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYREF nFirstPPCValue AS LONG, _
                 BYVAL nPPCValuesCount AS LONG _
                 ) AS LONG                 

DECLARE FUNCTION RMC_SetSeriesSingleData LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nData AS DOUBLE, _
                 BYVAL nDataIndex AS LONG, _
                 OPTIONAL BYVAL nYData AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSeriesStartAngle LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nStartAngle AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSeriesStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nStyle AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesSymbol LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nSymbol AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesValuelabel LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nValuelabel AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesVertical LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nSeries AS LONG, _
                  BYVAL nVertical AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetSeriesXAxis LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nWhichXAxis AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSeriesYAxis LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlId AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYVAL nSeries AS LONG, _
                 BYVAL nWhichYAxis AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetSingleBarColors  LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nRegion AS LONG, _
                 BYREF nFirstColorElement AS LONG, _
                 BYVAL nColorElementsCount AS LONG _
                 ) AS LONG


DECLARE FUNCTION RMC_SetToolTipWidth LIB "RMCHART.DLL" ( _
                 BYVAL nCtrlID AS LONG, _
                 BYVAL nWidth AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetWatermark LIB "RMCHART.DLL" ( _
                 BYREF sWaterMark AS ASCIZ, _
                 OPTIONAL BYVAL nWMColor AS LONG, _
                 OPTIONAL BYVAL nWMLucentValue AS LONG, _
                 OPTIONAL BYVAL nAlignment AS LONG, _
                 OPTIONAL BYVAL nFontSize AS LONG _
                 ) AS LONG

DECLARE FUNCTION RMC_SetXAXAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nAlignment AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nAlignment AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXDecimalDigits LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nDecimalDigits AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXDecimalDigits LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nDecimalDigits AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXFontSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontSize AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXFontSize LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nFontSize AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXLabels LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sLabels AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXLabels LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sLabels AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG  
                  
DECLARE FUNCTION RMC_SetXAXLabelAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nLabelAlignment AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG                                  

DECLARE FUNCTION RMC_SetYAXLabelAlignment LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nLabelAlignment AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG                                                    

DECLARE FUNCTION RMC_SetXAXLineColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXLineColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXLineStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nStyle AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXLineStyle LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nStyle AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXMaxValue LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nMaxValue AS DOUBLE, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXMaxValue LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nMaxValue AS DOUBLE, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXMinValue LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nMinValue AS DOUBLE, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXMinValue LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nMinValue AS DOUBLE, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXText LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sText AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXText LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sText AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXTextColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXTextColor LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nColor AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXTickcount LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nTickCount AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXTickcount LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYVAL nTickCount AS LONG, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetXAXUnit LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sUnit AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_SetYAXUnit LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nRegion AS LONG, _
                  BYREF sUnit AS ASCIZ, _
                  OPTIONAL BYVAL nAxisIndex AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_ShowToolTips LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nX AS LONG, _
                  BYVAL nY AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_Split LIB "RMCHART.DLL" ( _
                  BYVAL sData AS STRING, _
                  BYREF asData() AS STRING _
                  ) AS LONG

DECLARE FUNCTION RMC_Split2Double LIB "RMCHART.DLL" ( _
                  BYVAL sData AS STRING, _
                  BYREF aData() AS DOUBLE _
                  ) AS LONG

DECLARE FUNCTION RMC_Split2Long LIB "RMCHART.DLL" ( _
                  BYVAL sData AS STRING, _
                  BYREF aData() AS LONG _
                  ) AS LONG

DECLARE FUNCTION RMC_WriteRMCFile LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYREF sFileName AS ASCIZ _
                  ) AS LONG

DECLARE FUNCTION RMC_Zoom LIB "RMCHART.DLL" ( _
                  BYVAL nCtrlID AS LONG, _
                  BYVAL nMode AS LONG, _
                  OPTIONAL BYVAL nColor AS LONG, _
                  OPTIONAL BYVAL nLineColor AS LONG, _
                  OPTIONAL BYVAL nTransparency AS LONG _
                  ) AS LONG



' If you want to stamp your own watermark, put here
' your individual watermark and properties for the watermark (WM).
' See the help file for more informations.
$RMC_USERWM = ""                      ' Your watermark
%RMC_USERWMCOLOR = %ColorBlack        ' Color for the watermark
%RMC_USERWMLUCENT = 30                ' Lucent factor between 1(=not visible) and 255(=opaque)
%RMC_USERWMALIGN = %RMC_TEXTCENTER    ' Alignment for the watermark
%RMC_USERFONTSIZE = 0                 ' Fontsize; if 0: maximal size is used
' ******************************************************************
