

' Plasma-like effect with FBGFX
' -----------------------------


 ' allocatate local workspace on stack
 push ebp
 mov  ebp,esp
 sub  esp,40


 ' variables bound to parent
 ' #x      row pos
 ' #y      column pos
 ' #i      step
 ' #w      width of window client
 ' #h      height of window client
 ' #syn    parent loop flag
 ' #compo  composite color
 ' #c      plasma factor
 ' #t      plasma factor


 ' local variable macros
 def  #v128    ebp-04
 def  #v64     ebp-08
 def  #fifteen ebp-12
 def  #two     ebp-16
 def  #divisor ebp-20

 ' these do not require an initial value
 def  #red     ebp-24
 def  #green   ebp-28
 def  #blue    ebp-32

 ' initialise local variables
 ' (constants for the FPU) 
 mov [#v128],    128
 mov [#v64],      64
 mov [#fifteen],  15
 mov [#two],       2
 mov [#divisor], 100

'-----
 fild  dword [#x]           ' Sin((x+y+t)/100)
 fiadd dword [#y]
 fadd  dword [#t] 
 fidiv dword [#divisor]
 fsin
 
 fild  dword [#x]           ' Cos((x-t)/100)
 fsub  dword [#t] 
 fidiv dword [#divisor] 
 fcos
 faddp st(1)
 
 fild  dword  [#y]           ' Cos((y-t)/100)
 fsub  dword  [#t] 
 fidiv dword  [#divisor] 
 fcos
 faddp st(1) 
 
 fild  dword [#x]           ' Cos((x-y+t)/100)
 fisub dword [#y]
 fadd  dword [#t] 
 fidiv dword [#divisor]
 fcos                     
 faddp st(1)              ')
 
 fimul dword [#two]        '*2
 
 fld   dword [#t]           ' Sin(t/100)*15
 fidiv dword [#divisor]
 fsin
 fimul dword [#fifteen]
 faddp st(1) 
 
 fstp dword [#c]           ' -> store to c
'----- 
 fld dword [#c]  
 fcos
 fimul dword [#v64]
 fiadd dword [#v128]
 fistp dword [#Green]           ' -> store to Green


'-----
 fld   dword [#c]  
 fsin
 fimul dword [#v64]
 fiadd dword [#v128]
 fistp dword [#Red]           ' -> store to Red
'----- 
 fld   dword [#c]  
 fchs                 ' change sign
 fidiv dword [#two]     
 fcos
 fimul dword [#v64]
 fiadd dword [#v128]
 fistp dword [#Blue]           ' -> store to Blue

'-----
'compose rgb color
 xor eax,eax
 add eax,255
 shl eax,8 ' alpha byte optional
 add eax,[#red]
 shl eax,8
 add eax,[#green]
 shl eax,8
 add eax,[#blue]
 mov [#compo],eax ' composite ARGB color

 '-----
 ' increment  x y and clear syn flag afer each screen cycle
 mov eax,[#x]
 mov ecx,[#y]
 (
     add eax,[#i]   ' increment x
     cmp eax,[#w]   '
     jl exit       '
     xor eax,eax    ' zero x
     add ecx,[#i]   ' increment y
     cmp ecx,[#h]   '
     jl exit
     xor ecx,ecx    ' zero y
     mov [#syn],ecx ' zero sync
 )
 mov [#x],eax
 mov [#y],ecx

 ' deallocate local workspace from stack
 add esp,40
 pop ebp

 ret
