' PlasmaColor3
' 15:00 05/06/2008


' -----------------------------
' Standard macros
' -----------------------------

 def build_parameters
 ( 
 indexers "ebp" offset 4 ascending
 )

 def build_local
 ( 
 indexers "ebp" offset 0 descending
 )

 def allocate_stack_space
 (
 push ebp
 mov  ebp,esp
 add esp,offset
 )

 def deallocate_stack_space
 (
 mov esp,ebp
 pop ebp
 )

 def build_libspace
 (
 indexers "esi" offset 0 ascending
 esi=getmem %1
 var 4 libspace
 mov libspace,esi
 )

 def free_libspace
 (
 freemem libspace
 )


' -----------------------------
' Plasma-like effect with FBGFX
' -----------------------------

' using local variables (and defined type for colors )

 ' variables bound to parent
 ' #x      row pos
 ' #y      column pos
 ' #i      step
 ' #w      width of window client
 ' #h      height of window client
 ' #syn    parent loop flag
 ' #compo  composite color
 ' #c      plasma factor
 ' #t      plasma factor

 build_parameters
 'none

 build_local

 var  4 v128,v64,fifteen,two,divisor
 type bgra_color 4 blue 4 green 4 red 4 alpha
 var  bgra_color cc
 
 allocate_stack_space


 'subroutines
 call initialise_local_vars
 call main_plasma_calcs
 call compose_argb_color
 call next_pixel
 '
 deallocate_stack_space
 ret

 '-------------------------


 ' (constants for the FPU) 

 .initialise_local_vars
 mov v128,      128
 mov v64,       64
 mov fifteen,   15
 mov two,       2
 mov divisor,   100
 ret


 main_plasma_calcs:

 fild  dword [#x]           ' Sin((x+y+t)/100)
 fiadd dword [#y]
 fadd  dword [#t] 
 fidiv dword divisor
 fsin
 
 fild  dword [#x]           ' Cos((x-t)/100)
 fsub  dword [#t] 
 fidiv dword divisor 
 fcos
 faddp st(1)
 
 fild  dword  [#y]           ' Cos((y-t)/100)
 fsub  dword  [#t] 
 fidiv dword  divisor 
 fcos
 faddp st(1) 
 
 fild  dword [#x]           ' Cos((x-y+t)/100)
 fisub dword [#y]
 fadd  dword [#t] 
 fidiv dword divisor
 fcos                     
 faddp st(1)              ')
 
 fimul dword two        '*2
 
 fld   dword [#t]           ' Sin(t/100)*15
 fidiv dword divisor
 fsin
 fimul dword fifteen
 faddp st(1) 
 
 fstp dword [#c]           ' -> store to c
'----- 
 fld dword [#c]  
 fcos
 fimul dword v64
 fiadd dword v128
 fistp dword cc.Green           ' -> store to Green


'-----
 fld   dword [#c]  
 fsin
 fimul dword v64
 fiadd dword v128
 fistp dword cc.Red           ' -> store to Red
'----- 
 fld   dword [#c]  
 fchs                 ' change sign
 fidiv dword two     
 fcos
 fimul dword v64
 fiadd dword v128
 fistp dword cc.Blue           ' -> store to Blue

 ret 


 .compose_argb_color
 xor eax,eax
 add eax,255
 shl eax,8 ' alpha byte optional
 add eax,cc.red
 shl eax,8
 add eax,cc.green
 shl eax,8
 add eax,cc.blue
 mov [#compo],eax ' composite ARGB color

 ret



 ' increment  x y and clear syn flag afer each screen cycle

 .next_pixel
 mov eax,[#x]
 mov ecx,[#y]
 (
     add eax,[#i]   ' increment x
     cmp eax,[#w]   '
     jl exit        '
     xor eax,eax    ' zero x
     add ecx,[#i]   ' increment y
     cmp ecx,[#h]   '
     jl exit        '
     xor ecx,ecx    ' zero y
     mov [#syn],ecx ' zero sync
 )
 mov [#x],eax
 mov [#y],ecx

 ret

