' PlasmaColor3
' 13:37 10/06/2008


' -----------------------------
' Plasma-like effect with FBGFX
' -----------------------------

' using local variables (and defined type for colors )

 ' variables bound to parent
 ' #x      row pos
 ' #y      column pos
 ' #i      step
 ' #w      width of window client
 ' #h      height of window client
 ' #syn    parent loop flag
 ' #compo  composite color
 ' #c      plasma factor
 ' #t      plasma factor

; ENTRY POINTS
;-------------
o2 !4
jmp long initialise
o2 !4
jmp long process    ; O2_PROC1
o2 !4
jmp long terminate  ; O2_PROC2


; reference point table
;----------------------
o2 !40
dd 00 00 00 00



 initialise:
;-----------
                   ; ebx holds address of runtime functions table
                   ; assume esi edi and ebx are preserved
 push ecx          ; ecx holds address of this code string

 indexers `esi` offset 0 ascending

 var  4 sz,v128,v64,fifteen,two,divisor
 type bgra_color 4 blue 4 green 4 red 4 alpha
 var  bgra_color cc

 ;esi=dataspace 100; inline embedded memory
 esi=getmemory 100 ; pass address of sz holding length
                   ; this replaces the previous varbase in esi
 pop ecx           ; restore address of this code string           ' 
 mov [ecx+64],esi  ; save mem pointer to known inline address

 call initialise_local_vars

 ret


 process:
;--------
 mov esi,[ecx+64]
 call main_plasma_calcs
 call compose_argb_color
 call next_pixel
 ret
 
 terminate:
;----------
 mov esi,[ecx+64]
 freememory esi
 ret

;-------------------------
; SUBROUTINES 
;-------------------------


 ' (constants for the FPU) 

.initialise_local_vars
;---------------------

 mov v128,      128
 mov v64,       64
 mov fifteen,   15
 mov two,       2
 mov divisor,   100
 ret


 main_plasma_calcs:
;------------------

 fild  dword [#x]           ' Sin((x+y+t)/100)
 fiadd dword [#y]
 fadd  dword [#t] 
 fidiv dword divisor
 fsin
 
 fild  dword [#x]           ' Cos((x-t)/100)
 fsub  dword [#t] 
 fidiv dword divisor 
 fcos
 faddp st(1)
 
 fild  dword  [#y]           ' Cos((y-t)/100)
 fsub  dword  [#t] 
 fidiv dword  divisor 
 fcos
 faddp st(1) 
 
 fild  dword [#x]           ' Cos((x-y+t)/100)
 fisub dword [#y]
 fadd  dword [#t] 
 fidiv dword divisor
 fcos                     
 faddp st(1)              ')
 
 fimul dword two        '*2
 
 fld   dword [#t]           ' Sin(t/100)*15
 fidiv dword divisor
 fsin
 fimul dword fifteen
 faddp st(1) 
 fstp dword [#c]           ' -> store to c
'----- 
 fld dword [#c]  
 fcos
 fimul dword v64
 fiadd dword v128
 fistp dword cc.Green           ' -> store to Green
'-----
 fld   dword [#c]  
 fsin
 fimul dword v64
 fiadd dword v128
 fistp dword cc.Red           ' -> store to Red
'----- 
 fld   dword [#c]  
 fchs                 ' change sign
 fidiv dword two     
 fcos
 fimul dword v64
 fiadd dword v128
 fistp dword cc.Blue           ' -> store to Blue

 ret 


.compose_argb_color
;------------------

 xor eax,eax
 add eax,255
 shl eax,8 ' alpha byte optional
 add eax,cc.red
 shl eax,8
 add eax,cc.green
 shl eax,8
 add eax,cc.blue
 mov [#compo],eax ' composite ARGB color

 ret




.next_pixel
;----------

 ' increment  x y and clear syn flag afer each screen cycle
 mov eax,[#x]
 mov ecx,[#y]
 (
     add eax,[#i]   ' increment x
     cmp eax,[#w]   '
     jl exit        '
     xor eax,eax    ' zero x
     add ecx,[#i]   ' increment y
     cmp ecx,[#h]   '
     jl exit        '
     xor ecx,ecx    ' zero y
     mov [#syn],ecx ' zero sync
 )
 mov [#x],eax
 mov [#y],ecx

 ret

