' TB VERSION FROM 02 DEC 2009 -B
'/*******************************************************************************
' * Copyright (c) 2008-2009 The Khronos Group Inc.
' *
' * Permission is hereby granted, free of charge, to any person obtaining a
' * copy of this software and/or associated documentation files (the
' * "Materials"), to deal in the Materials without restriction, including
' * without limitation the rights to use, copy, modify, merge, publish,
' * distribute, sublicense, and/or sell copies of the Materials, and to
' * permit persons to whom the Materials are furnished to do so, subject to
' * the following conditions:
' *
' * The above copyright notice and this permission notice shall be included
' * in all copies or substantial portions of the Materials.
' *
' * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
' * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
' * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
' * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
' * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
' * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
' * MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
' ******************************************************************************/

' $Revision: 9283 $ on $Date: 2009-10-14 10:18:57 -0700 (Wed, 14 Oct 2009) $ 
%OPENCL_CL_H                = 1
         
#IF Not %DEF(%CL_PLATFORM_H)                 
  #INCLUDE Once "thinbasic_cl_platform.inc"
#EndIf

' ALIASes moved to thinbasic_cl_platform.inc

' Error Codes
GLOBAL CL_SUCCESS AS LONG =  0
GLOBAL CL_DEVICE_NOT_FOUND AS LONG =  -1
GLOBAL CL_DEVICE_NOT_AVAILABLE AS LONG =  -2
GLOBAL CL_COMPILER_NOT_AVAILABLE AS LONG =  -3
GLOBAL CL_MEM_OBJECT_ALLOCATION_FAILURE AS LONG =  -4
GLOBAL CL_OUT_OF_RESOURCES AS LONG =  -5
GLOBAL CL_OUT_OF_HOST_MEMORY AS LONG =  -6
GLOBAL CL_PROFILING_INFO_NOT_AVAILABLE AS LONG =  -7
GLOBAL CL_MEM_COPY_OVERLAP AS LONG =  -8
GLOBAL CL_IMAGE_FORMAT_MISMATCH AS LONG =  -9
GLOBAL CL_IMAGE_FORMAT_NOT_SUPPORTED AS LONG =  -10
GLOBAL CL_BUILD_PROGRAM_FAILURE AS LONG =  -11
GLOBAL CL_MAP_FAILURE AS LONG =  -12

GLOBAL CL_INVALID_VALUE AS LONG =  -30
GLOBAL CL_INVALID_DEVICE_TYPE AS LONG =  -31
GLOBAL CL_INVALID_PLATFORM AS LONG =  -32
GLOBAL CL_INVALID_DEVICE AS LONG =  -33
GLOBAL CL_INVALID_CONTEXT AS LONG =  -34
GLOBAL CL_INVALID_QUEUE_PROPERTIES AS LONG =  -35
GLOBAL CL_INVALID_COMMAND_QUEUE AS LONG =  -36
GLOBAL CL_INVALID_HOST_PTR AS LONG =  -37
GLOBAL CL_INVALID_MEM_OBJECT AS LONG =  -38
GLOBAL CL_INVALID_IMAGE_FORMAT_DESCRIPTOR AS LONG =  -39
GLOBAL CL_INVALID_IMAGE_SIZE AS LONG =  -40
GLOBAL CL_INVALID_SAMPLER AS LONG =  -41
GLOBAL CL_INVALID_BINARY AS LONG =  -42
GLOBAL CL_INVALID_BUILD_OPTIONS AS LONG =  -43
GLOBAL CL_INVALID_PROGRAM AS LONG =  -44
GLOBAL CL_INVALID_PROGRAM_EXECUTABLE AS LONG =  -45
GLOBAL CL_INVALID_KERNEL_NAME AS LONG =  -46
GLOBAL CL_INVALID_KERNEL_DEFINITION AS LONG =  -47
GLOBAL CL_INVALID_KERNEL AS LONG =  -48
GLOBAL CL_INVALID_ARG_INDEX AS LONG =  -49
GLOBAL CL_INVALID_ARG_VALUE AS LONG =  -50
GLOBAL CL_INVALID_ARG_SIZE AS LONG =  -51
GLOBAL CL_INVALID_KERNEL_ARGS AS LONG =  -52
GLOBAL CL_INVALID_WORK_DIMENSION AS LONG =  -53
GLOBAL CL_INVALID_WORK_GROUP_SIZE AS LONG =  -54
GLOBAL CL_INVALID_WORK_ITEM_SIZE AS LONG =  -55
GLOBAL CL_INVALID_GLOBAL_OFFSET AS LONG =  -56
GLOBAL CL_INVALID_EVENT_WAIT_LIST AS LONG =  -57
GLOBAL CL_INVALID_EVENT AS LONG =  -58
GLOBAL CL_INVALID_OPERATION AS LONG =  -59
GLOBAL CL_INVALID_GL_OBJECT AS LONG =  -60
GLOBAL CL_INVALID_BUFFER_SIZE AS LONG =  -61
GLOBAL CL_INVALID_MIP_LEVEL AS LONG =  -62
GLOBAL CL_INVALID_GLOBAL_WORK_SIZE AS LONG =  -63

' OpenCL Version
GLOBAL CL_VERSION_1_0 AS LONG =  1

' cl_bool
GLOBAL CL_FALSE AS LONG =  0
GLOBAL CL_TRUE AS LONG =  1

' cl_platform_info
GLOBAL CL_PLATFORM_PROFILE AS LONG =  &h00900
GLOBAL CL_PLATFORM_VERSION AS LONG =  &h00901
GLOBAL CL_PLATFORM_NAME AS LONG =  &h00902
GLOBAL CL_PLATFORM_VENDOR AS LONG =  &h00903
GLOBAL CL_PLATFORM_EXTENSIONS AS LONG =  &h00904

' cl_device_type - bitfield
GLOBAL CL_DEVICE_TYPE_DEFAULT AS LONG =  1 '(1 << 0)
GLOBAL CL_DEVICE_TYPE_CPU AS LONG =  2 '(1 << 1)
GLOBAL CL_DEVICE_TYPE_GPU AS LONG =  4 '(1 << 2)
GLOBAL CL_DEVICE_TYPE_ACCELERATOR AS LONG =  8 '(1 << 3)
GLOBAL CL_DEVICE_TYPE_ALL AS LONG =  &h0FFFFFFFF

' cl_device_info
GLOBAL CL_DEVICE_TYPE AS LONG =  &h01000
GLOBAL CL_DEVICE_VENDOR_ID AS LONG =  &h01001
GLOBAL CL_DEVICE_MAX_COMPUTE_UNITS AS LONG =  &h01002
GLOBAL CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS AS LONG =  &h01003
GLOBAL CL_DEVICE_MAX_WORK_GROUP_SIZE AS LONG =  &h01004
GLOBAL CL_DEVICE_MAX_WORK_ITEM_SIZES AS LONG =  &h01005
GLOBAL CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR AS LONG =  &h01006
GLOBAL CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT AS LONG =  &h01007
GLOBAL CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT AS LONG =  &h01008
GLOBAL CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG AS LONG =  &h01009
GLOBAL CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT AS LONG =  &h0100A
GLOBAL CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE AS LONG =  &h0100B
GLOBAL CL_DEVICE_MAX_CLOCK_FREQUENCY AS LONG =  &h0100C
GLOBAL CL_DEVICE_ADDRESS_BITS AS LONG =  &h0100D
GLOBAL CL_DEVICE_MAX_READ_IMAGE_ARGS AS LONG =  &h0100E
GLOBAL CL_DEVICE_MAX_WRITE_IMAGE_ARGS AS LONG =  &h0100F
GLOBAL CL_DEVICE_MAX_MEM_ALLOC_SIZE AS LONG =  &h01010
GLOBAL CL_DEVICE_IMAGE2D_MAX_WIDTH AS LONG =  &h01011
GLOBAL CL_DEVICE_IMAGE2D_MAX_HEIGHT AS LONG =  &h01012
GLOBAL CL_DEVICE_IMAGE3D_MAX_WIDTH AS LONG =  &h01013
GLOBAL CL_DEVICE_IMAGE3D_MAX_HEIGHT AS LONG =  &h01014
GLOBAL CL_DEVICE_IMAGE3D_MAX_DEPTH AS LONG =  &h01015
GLOBAL CL_DEVICE_IMAGE_SUPPORT AS LONG =  &h01016
GLOBAL CL_DEVICE_MAX_PARAMETER_SIZE AS LONG =  &h01017
GLOBAL CL_DEVICE_MAX_SAMPLERS AS LONG =  &h01018
GLOBAL CL_DEVICE_MEM_BASE_ADDR_ALIGN AS LONG =  &h01019
GLOBAL CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE AS LONG =  &h0101A
GLOBAL CL_DEVICE_SINGLE_FP_CONFIG AS LONG =  &h0101B
GLOBAL CL_DEVICE_GLOBAL_MEM_CACHE_TYPE AS LONG =  &h0101C
GLOBAL CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE AS LONG =  &h0101D
GLOBAL CL_DEVICE_GLOBAL_MEM_CACHE_SIZE AS LONG =  &h0101E
GLOBAL CL_DEVICE_GLOBAL_MEM_SIZE AS LONG =  &h0101F
GLOBAL CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE AS LONG =  &h01020
GLOBAL CL_DEVICE_MAX_CONSTANT_ARGS AS LONG =  &h01021
GLOBAL CL_DEVICE_LOCAL_MEM_TYPE AS LONG =  &h01022
GLOBAL CL_DEVICE_LOCAL_MEM_SIZE AS LONG =  &h01023
GLOBAL CL_DEVICE_ERROR_CORRECTION_SUPPORT AS LONG =  &h01024
GLOBAL CL_DEVICE_PROFILING_TIMER_RESOLUTION AS LONG =  &h01025
GLOBAL CL_DEVICE_ENDIAN_LITTLE AS LONG =  &h01026
GLOBAL CL_DEVICE_AVAILABLE AS LONG =  &h01027
GLOBAL CL_DEVICE_COMPILER_AVAILABLE AS LONG =  &h01028
GLOBAL CL_DEVICE_EXECUTION_CAPABILITIES AS LONG =  &h01029
GLOBAL CL_DEVICE_QUEUE_PROPERTIES AS LONG =  &h0102A
GLOBAL CL_DEVICE_NAME AS LONG =  &h0102B
GLOBAL CL_DEVICE_VENDOR AS LONG =  &h0102C
GLOBAL CL_DRIVER_VERSION AS LONG =  &h0102D
GLOBAL CL_DEVICE_PROFILE AS LONG =  &h0102E
GLOBAL CL_DEVICE_VERSION AS LONG =  &h0102F
GLOBAL CL_DEVICE_EXTENSIONS AS LONG =  &h01030
GLOBAL CL_DEVICE_PLATFORM AS LONG =  &h01031

' cl_device_fp_config - bitfield
GLOBAL CL_FP_DENORM AS LONG =  1 '(1 << 0)
GLOBAL CL_FP_INF_NAN AS LONG =  2 '(1 << 1)
GLOBAL CL_FP_ROUND_TO_NEAREST AS LONG =  4 '(1 << 2)
GLOBAL CL_FP_ROUND_TO_ZERO AS LONG =  8 '(1 << 3)
GLOBAL CL_FP_ROUND_TO_INF AS LONG =  16'(1 << 4)
GLOBAL CL_FP_FMA AS LONG =  32'(1 << 5)

' cl_device_mem_cache_type
GLOBAL CL_NONE AS LONG =  &h00
GLOBAL CL_READ_ONLY_CACHE AS LONG =  &h01
GLOBAL CL_READ_WRITE_CACHE AS LONG =  &h02

' cl_device_local_mem_type
GLOBAL CL_LOCAL AS LONG =  &h01
GLOBAL CL_GLOBAL AS LONG =  &h02

' cl_device_exec_capabilities - bitfield
GLOBAL CL_EXEC_KERNEL AS LONG =  1 '(1 << 0)
GLOBAL CL_EXEC_NATIVE_KERNEL AS LONG =  2 '(1 << 1)

' cl_command_queue_properties - bitfield
GLOBAL CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE AS LONG =  1 '(1 << 0)
GLOBAL CL_QUEUE_PROFILING_ENABLE AS LONG =  2 '(1 << 1)

' cl_context_info
GLOBAL CL_CONTEXT_REFERENCE_COUNT AS LONG =  &h01080
GLOBAL CL_CONTEXT_DEVICES AS LONG =  &h01081
GLOBAL CL_CONTEXT_PROPERTIES AS LONG =  &h01082

' cl_context_properties
GLOBAL CL_CONTEXT_PLATFORM AS LONG =  &h01084

' cl_command_queue_info
GLOBAL CL_QUEUE_CONTEXT AS LONG =  &h01090
GLOBAL CL_QUEUE_DEVICE AS LONG =  &h01091
GLOBAL CL_QUEUE_REFERENCE_COUNT AS LONG =  &h01092
GLOBAL CL_QUEUE_PROPERTIES AS LONG =  &h01093

' cl_mem_flags - bitfield
GLOBAL CL_MEM_READ_WRITE AS LONG =  1 '(1 << 0)
GLOBAL CL_MEM_WRITE_ONLY AS LONG =  2 '(1 << 1)
GLOBAL CL_MEM_READ_ONLY AS LONG =  4 '(1 << 2)
GLOBAL CL_MEM_USE_HOST_PTR AS LONG =  8 '(1 << 3)
GLOBAL CL_MEM_ALLOC_HOST_PTR AS LONG =  16'(1 << 4)
GLOBAL CL_MEM_COPY_HOST_PTR AS LONG =  32'(1 << 5)

' cl_channel_order
GLOBAL CL_R AS LONG =  &h010B0
GLOBAL CL_A AS LONG =  &h010B1
GLOBAL CL_RG AS LONG =  &h010B2
GLOBAL CL_RA AS LONG =  &h010B3
GLOBAL CL_RGB AS LONG =  &h010B4
GLOBAL CL_RGBA AS LONG =  &h010B5
GLOBAL CL_BGRA AS LONG =  &h010B6
GLOBAL CL_ARGB AS LONG =  &h010B7
GLOBAL CL_INTENSITY AS LONG =  &h010B8
GLOBAL CL_LUMINANCE AS LONG =  &h010B9

' cl_channel_type
GLOBAL CL_SNORM_INT8 AS LONG =  &h010D0
GLOBAL CL_SNORM_INT16 AS LONG =  &h010D1
GLOBAL CL_UNORM_INT8 AS LONG =  &h010D2
GLOBAL CL_UNORM_INT16 AS LONG =  &h010D3
GLOBAL CL_UNORM_SHORT_565 AS LONG =  &h010D4
GLOBAL CL_UNORM_SHORT_555 AS LONG =  &h010D5
GLOBAL CL_UNORM_INT_101010 AS LONG =  &h010D6
GLOBAL CL_SIGNED_INT8 AS LONG =  &h010D7
GLOBAL CL_SIGNED_INT16 AS LONG =  &h010D8
GLOBAL CL_SIGNED_INT32 AS LONG =  &h010D9
GLOBAL CL_UNSIGNED_INT8 AS LONG =  &h010DA
GLOBAL CL_UNSIGNED_INT16 AS LONG =  &h010DB
GLOBAL CL_UNSIGNED_INT32 AS LONG =  &h010DC
GLOBAL CL_HALF_FLOAT AS LONG =  &h010DD
GLOBAL CL_FLOAT AS LONG =  &h010DE

' cl_mem_object_type
GLOBAL CL_MEM_OBJECT_BUFFER AS LONG =  &h010F0
GLOBAL CL_MEM_OBJECT_IMAGE2D AS LONG =  &h010F1
GLOBAL CL_MEM_OBJECT_IMAGE3D AS LONG =  &h010F2

' cl_mem_info
GLOBAL CL_MEM_TYPE AS LONG =  &h01100
GLOBAL CL_MEM_FLAGS AS LONG =  &h01101
GLOBAL CL_MEM_SIZE AS LONG =  &h01102
GLOBAL CL_MEM_HOST_PTR AS LONG =  &h01103
GLOBAL CL_MEM_MAP_COUNT AS LONG =  &h01104
GLOBAL CL_MEM_REFERENCE_COUNT AS LONG =  &h01105
GLOBAL CL_MEM_CONTEXT AS LONG =  &h01106

' cl_image_info
GLOBAL CL_IMAGE_FORMAT AS LONG =  &h01110
GLOBAL CL_IMAGE_ELEMENT_SIZE AS LONG =  &h01111
GLOBAL CL_IMAGE_ROW_PITCH AS LONG =  &h01112
GLOBAL CL_IMAGE_SLICE_PITCH AS LONG =  &h01113
GLOBAL CL_IMAGE_WIDTH AS LONG =  &h01114
GLOBAL CL_IMAGE_HEIGHT AS LONG =  &h01115
GLOBAL CL_IMAGE_DEPTH AS LONG =  &h01116

' cl_addressing_mode
GLOBAL CL_ADDRESS_NONE AS LONG =  &h01130
GLOBAL CL_ADDRESS_CLAMP_TO_EDGE AS LONG =  &h01131
GLOBAL CL_ADDRESS_CLAMP AS LONG =  &h01132
GLOBAL CL_ADDRESS_REPEAT AS LONG =  &h01133

' cl_filter_mode
GLOBAL CL_FILTER_NEAREST AS LONG =  &h01140
GLOBAL CL_FILTER_LINEAR AS LONG =  &h01141

' cl_sampler_info
GLOBAL CL_SAMPLER_REFERENCE_COUNT AS LONG =  &h01150
GLOBAL CL_SAMPLER_CONTEXT AS LONG =  &h01151
GLOBAL CL_SAMPLER_NORMALIZED_COORDS AS LONG =  &h01152
GLOBAL CL_SAMPLER_ADDRESSING_MODE AS LONG =  &h01153
GLOBAL CL_SAMPLER_FILTER_MODE AS LONG =  &h01154

' cl_map_flags - bitfield
GLOBAL CL_MAP_READ AS LONG =  1 '(1 << 0)
GLOBAL CL_MAP_WRITE AS LONG =  2 '(1 << 1)

' cl_program_info
GLOBAL CL_PROGRAM_REFERENCE_COUNT AS LONG =  &h01160
GLOBAL CL_PROGRAM_CONTEXT AS LONG =  &h01161
GLOBAL CL_PROGRAM_NUM_DEVICES AS LONG =  &h01162
GLOBAL CL_PROGRAM_DEVICES AS LONG =  &h01163
GLOBAL CL_PROGRAM_SOURCE AS LONG =  &h01164
GLOBAL CL_PROGRAM_BINARY_SIZES AS LONG =  &h01165
GLOBAL CL_PROGRAM_BINARIES AS LONG =  &h01166

' cl_program_build_info
GLOBAL CL_PROGRAM_BUILD_STATUS AS LONG =  &h01181
GLOBAL CL_PROGRAM_BUILD_OPTIONS AS LONG =  &h01182
GLOBAL CL_PROGRAM_BUILD_LOG AS LONG =  &h01183

' cl_build_status
GLOBAL CL_BUILD_SUCCESS AS LONG =  0
GLOBAL CL_BUILD_NONE AS LONG =  -1
GLOBAL CL_BUILD_ERROR AS LONG =  -2
GLOBAL CL_BUILD_IN_PROGRESS AS LONG =  -3

' cl_kernel_info
GLOBAL CL_KERNEL_FUNCTION_NAME AS LONG =  &h01190
GLOBAL CL_KERNEL_NUM_ARGS AS LONG =  &h01191
GLOBAL CL_KERNEL_REFERENCE_COUNT AS LONG =  &h01192
GLOBAL CL_KERNEL_CONTEXT AS LONG =  &h01193
GLOBAL CL_KERNEL_PROGRAM AS LONG =  &h01194

' cl_kernel_work_group_info
GLOBAL CL_KERNEL_WORK_GROUP_SIZE AS LONG =  &h011B0
GLOBAL CL_KERNEL_COMPILE_WORK_GROUP_SIZE AS LONG =  &h011B1
GLOBAL CL_KERNEL_LOCAL_MEM_SIZE AS LONG =  &h011B2

' cl_event_info
GLOBAL CL_EVENT_COMMAND_QUEUE AS LONG =  &h011D0
GLOBAL CL_EVENT_COMMAND_TYPE AS LONG =  &h011D1
GLOBAL CL_EVENT_REFERENCE_COUNT AS LONG =  &h011D2
GLOBAL CL_EVENT_COMMAND_EXECUTION_STATUS AS LONG =  &h011D3

' cl_command_type
GLOBAL CL_COMMAND_NDRANGE_KERNEL AS LONG =  &h011F0
GLOBAL CL_COMMAND_TASK AS LONG =  &h011F1
GLOBAL CL_COMMAND_NATIVE_KERNEL AS LONG =  &h011F2
GLOBAL CL_COMMAND_READ_BUFFER AS LONG =  &h011F3
GLOBAL CL_COMMAND_WRITE_BUFFER AS LONG =  &h011F4
GLOBAL CL_COMMAND_COPY_BUFFER AS LONG =  &h011F5
GLOBAL CL_COMMAND_READ_IMAGE AS LONG =  &h011F6
GLOBAL CL_COMMAND_WRITE_IMAGE AS LONG =  &h011F7
GLOBAL CL_COMMAND_COPY_IMAGE AS LONG =  &h011F8
GLOBAL CL_COMMAND_COPY_IMAGE_TO_BUFFER AS LONG =  &h011F9
GLOBAL CL_COMMAND_COPY_BUFFER_TO_IMAGE AS LONG =  &h011FA
GLOBAL CL_COMMAND_MAP_BUFFER AS LONG =  &h011FB
GLOBAL CL_COMMAND_MAP_IMAGE AS LONG =  &h011FC
GLOBAL CL_COMMAND_UNMAP_MEM_OBJECT AS LONG =  &h011FD
GLOBAL CL_COMMAND_MARKER AS LONG =  &h011FE
GLOBAL CL_COMMAND_ACQUIRE_GL_OBJECTS AS LONG =  &h011FF
GLOBAL CL_COMMAND_RELEASE_GL_OBJECTS AS LONG =  &h01200

' command execution status
GLOBAL CL_COMPLETE AS LONG =  &h00
GLOBAL CL_RUNNING AS LONG =  &h01
GLOBAL CL_SUBMITTED AS LONG =  &h02
GLOBAL CL_QUEUED AS LONG =  &h03

' cl_profiling_info
GLOBAL CL_PROFILING_COMMAND_QUEUED AS LONG =  &h01280
GLOBAL CL_PROFILING_COMMAND_SUBMIT AS LONG =  &h01281
GLOBAL CL_PROFILING_COMMAND_START AS LONG =  &h01282
GLOBAL CL_PROFILING_COMMAND_END AS LONG =  &h01283

' ====================================================================================================== '

' Platform API
DECLARE FUNCTION clGetPlatformIDs LIB "OpenCL.DLL" ALIAS "clGetPlatformIDs" ( _
  BYVAL type_cl_uint , _ ' num_entries                                                                ' ORIGINAL: cl_uint /* num_entries */,
  BYREF type_cl_platform_id  , _ ' platforms                                                          ' ORIGINAL: cl_platform_id * /* platforms */,
  BYREF type_cl_uint  ) AS type_cl_int                                                                ' ORIGINAL: cl_uint * /* num_platforms */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetPlatformInfo LIB "OpenCL.DLL" ALIAS "clGetPlatformInfo" ( _
  BYVAL type_cl_platform_id , _ ' platform                                                            ' ORIGINAL: cl_platform_id /* platform */,
  BYVAL type_cl_platform_info , _ ' param_name                                                        ' ORIGINAL: cl_platform_info /* param_name */,
  BYVAL DWORD , _ ' param_value_size                                                                  ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Device APIs
DECLARE FUNCTION clGetDeviceIDs LIB "OpenCL.DLL" ALIAS "clGetDeviceIDs" ( _
  BYVAL type_cl_platform_id , _ ' platform                                                            ' ORIGINAL: cl_platform_id /* platform */,
  BYVAL type_cl_device_type , _ ' device_type                                                         ' ORIGINAL: cl_device_type /* device_type */,
  BYVAL type_cl_uint , _ ' num_entries                                                                ' ORIGINAL: cl_uint /* num_entries */,
  BYREF type_cl_device_id  , _ ' devices                                                              ' ORIGINAL: cl_device_id * /* devices */,
  BYREF type_cl_uint  ) AS type_cl_int                                                                ' ORIGINAL: cl_uint * /* num_devices */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetDeviceInfo LIB "OpenCL.DLL" ALIAS "clGetDeviceInfo" ( _
  BYVAL type_cl_device_id , _ ' device                                                                ' ORIGINAL: cl_device_id /* device */,
  BYVAL type_cl_device_info , _ ' param_name                                                          ' ORIGINAL: cl_device_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Context APIs
DECLARE FUNCTION clCreateContext LIB "OpenCL.DLL" ALIAS "clCreateContext" ( _
  BYVAL type_cl_context_properties  , _ ' properties                                                  ' ORIGINAL: const cl_context_properties * /* properties */,
  BYVAL type_cl_uint , _ ' num_devices                                                                ' ORIGINAL: cl_uint /* num_devices */,
  BYREF type_cl_device_id  , _ ' devices                                                              ' ORIGINAL: const cl_device_id * /* devices */,
  BYREF ANY ,_                                                                                        ' ORIGINAL: void (*pfn_notify)(const char *, const void *, size_t, void *) /* pfn_notify */,
  BYREF ANY        , _ ' user_data                                                                    ' ORIGINAL: void * /* user_data */,
  BYREF type_cl_int  ) AS type_cl_context                                                             ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clCreateContextFromType LIB "OpenCL.DLL" ALIAS "clCreateContextFromType" ( _
  ByVal type_cl_context_properties  , _ ' properties                                                  ' ORIGINAL: const cl_context_properties * /* properties */,
  BYVAL type_cl_device_type , _ ' device_type                                                         ' ORIGINAL: cl_device_type /* device_type */,
  BYREF ANY, _                                                                                        ' ORIGINAL: void (*pfn_notify)(const char *, const void *, size_t, void *) /* pfn_notify */,
  BYREF ANY        , _ ' user_data                                                                    ' ORIGINAL: void * /* user_data */,
  BYREF type_cl_int  ) AS type_cl_context                                                             ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainContext LIB "OpenCL.DLL" ALIAS "clRetainContext" ( _
  BYVAL type_cl_context ) AS type_cl_int                                                              ' ORIGINAL: cl_context /* context */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseContext LIB "OpenCL.DLL" ALIAS "clReleaseContext" ( _
  BYVAL type_cl_context ) AS type_cl_int                                                              ' ORIGINAL: cl_context /* context */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetContextInfo LIB "OpenCL.DLL" ALIAS "clGetContextInfo" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_context_info , _ ' param_name                                                         ' ORIGINAL: cl_context_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYVAL DWORD        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Command Queue APIs
DECLARE FUNCTION clCreateCommandQueue LIB "OpenCL.DLL" ALIAS "clCreateCommandQueue" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_device_id , _ ' device                                                                ' ORIGINAL: cl_device_id /* device */,
  BYVAL type_cl_command_queue_properties , _ ' properties                                             ' ORIGINAL: cl_command_queue_properties /* properties */,
  BYREF type_cl_int  ) AS type_cl_command_queue                                                       ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainCommandQueue LIB "OpenCL.DLL" ALIAS "clRetainCommandQueue" ( _
  BYVAL type_cl_command_queue ) AS type_cl_int                                                        ' ORIGINAL: cl_command_queue /* command_queue */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseCommandQueue LIB "OpenCL.DLL" ALIAS "clReleaseCommandQueue" ( _
  BYVAL type_cl_command_queue ) AS type_cl_int                                                        ' ORIGINAL: cl_command_queue /* command_queue */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetCommandQueueInfo LIB "OpenCL.DLL" ALIAS "clGetCommandQueueInfo" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_command_queue_info , _ ' param_name                                                   ' ORIGINAL: cl_command_queue_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clSetCommandQueueProperty LIB "OpenCL.DLL" ALIAS "clSetCommandQueueProperty" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_command_queue_properties , _ ' properties                                             ' ORIGINAL: cl_command_queue_properties /* properties */,
  BYVAL type_cl_bool , _ ' enable                                                                     ' ORIGINAL: cl_bool /* enable */,
  BYREF type_cl_command_queue_properties  ) AS type_cl_int                                            ' ORIGINAL: cl_command_queue_properties * /* old_properties */) CL_API_SUFFIX__VERSION_1_0;

' Memory Object APIs
DECLARE FUNCTION clCreateBuffer LIB "OpenCL.DLL" ALIAS "clCreateBuffer" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
  BYVAL DWORD       , _ ' size                                                                        ' ORIGINAL: size_t /* size */,
  BYVAL DWORD        , _ ' host_ptr                                                                     ' ORIGINAL: void * /* host_ptr */,
  BYREF type_cl_int  ) AS type_cl_mem                                                                 ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clCreateImage2D LIB "OpenCL.DLL" ALIAS "clCreateImage2D" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
  BYREF udt_cl_image_format  , _ ' image_format                                                           ' ORIGINAL: const cl_image_format * /* image_format */,
  BYVAL DWORD       , _ ' image_width                                                                 ' ORIGINAL: size_t /* image_width */,
  BYVAL DWORD       , _ ' image_height                                                                ' ORIGINAL: size_t /* image_height */,
  BYVAL DWORD       , _ ' image_row_pitch                                                             ' ORIGINAL: size_t /* image_row_pitch */,
  BYREF ANY        , _ ' host_ptr                                                                     ' ORIGINAL: void * /* host_ptr */,
  BYREF type_cl_int  ) AS type_cl_mem                                                                 ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clCreateImage3D LIB "OpenCL.DLL" ALIAS "clCreateImage3D" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
  BYREF udt_cl_image_format  , _ ' image_format                                                           ' ORIGINAL: const cl_image_format * /* image_format */,
  BYVAL DWORD       , _ ' image_width                                                                 ' ORIGINAL: size_t /* image_width */,
  BYVAL DWORD       , _ ' image_height                                                                ' ORIGINAL: size_t /* image_height */,
  BYVAL DWORD       , _ ' image_depth                                                                 ' ORIGINAL: size_t /* image_depth */,
  BYVAL DWORD       , _ ' image_row_pitch                                                             ' ORIGINAL: size_t /* image_row_pitch */,
  BYVAL DWORD       , _ ' image_slice_pitch                                                           ' ORIGINAL: size_t /* image_slice_pitch */,
  BYREF ANY        , _ ' host_ptr                                                                     ' ORIGINAL: void * /* host_ptr */,
  BYREF type_cl_int  ) AS type_cl_mem                                                                 ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainMemObject LIB "OpenCL.DLL" ALIAS "clRetainMemObject" ( _
  BYVAL type_cl_mem ) AS type_cl_int                                                                  ' ORIGINAL: cl_mem /* memobj */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseMemObject LIB "OpenCL.DLL" ALIAS "clReleaseMemObject" ( _
  BYVAL type_cl_mem ) AS type_cl_int                                                                  ' ORIGINAL: cl_mem /* memobj */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetSupportedImageFormats LIB "OpenCL.DLL" ALIAS "clGetSupportedImageFormats" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
  BYVAL type_cl_mem_object_type , _ ' image_type                                                      ' ORIGINAL: cl_mem_object_type /* image_type */,
  BYVAL type_cl_uint , _ ' num_entries                                                                ' ORIGINAL: cl_uint /* num_entries */,
  BYREF udt_cl_image_format  , _ ' image_formats                                                     ' ORIGINAL: cl_image_format * /* image_formats */,
  BYREF type_cl_uint  ) AS type_cl_int                                                                ' ORIGINAL: cl_uint * /* num_image_formats */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetMemObjectInfo LIB "OpenCL.DLL" ALIAS "clGetMemObjectInfo" ( _
  BYVAL type_cl_mem , _ ' memobj                                                                      ' ORIGINAL: cl_mem /* memobj */,
  BYVAL type_cl_mem_info , _ ' param_name                                                             ' ORIGINAL: cl_mem_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetImageInfo LIB "OpenCL.DLL" ALIAS "clGetImageInfo" ( _
  BYVAL type_cl_mem , _ ' image                                                                       ' ORIGINAL: cl_mem /* image */,
  BYVAL type_cl_image_info , _ ' param_name                                                           ' ORIGINAL: cl_image_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Sampler APIs
DECLARE FUNCTION clCreateSampler LIB "OpenCL.DLL" ALIAS "clCreateSampler" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_bool , _ ' normalized_coords                                                          ' ORIGINAL: cl_bool /* normalized_coords */,
  BYVAL type_cl_addressing_mode , _ ' addressing_mode                                                 ' ORIGINAL: cl_addressing_mode /* addressing_mode */,
  BYVAL type_cl_filter_mode , _ ' filter_mode                                                         ' ORIGINAL: cl_filter_mode /* filter_mode */,
  BYREF type_cl_int  ) AS type_cl_sampler                                                             ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainSampler LIB "OpenCL.DLL" ALIAS "clRetainSampler" ( _
  BYVAL type_cl_sampler ) AS type_cl_int                                                              ' ORIGINAL: cl_sampler /* sampler */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseSampler LIB "OpenCL.DLL" ALIAS "clReleaseSampler" ( _
  BYVAL type_cl_sampler ) AS type_cl_int                                                              ' ORIGINAL: cl_sampler /* sampler */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetSamplerInfo LIB "OpenCL.DLL" ALIAS "clGetSamplerInfo" ( _
  BYVAL type_cl_sampler , _ ' sampler                                                                 ' ORIGINAL: cl_sampler /* sampler */,
  BYVAL type_cl_sampler_info , _ ' param_name                                                         ' ORIGINAL: cl_sampler_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Program Object APIs
DECLARE FUNCTION clCreateProgramWithSource LIB "OpenCL.DLL" ALIAS "clCreateProgramWithSource" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_uint , _ ' count                                                                      ' ORIGINAL: cl_uint /* count */,
  BYVAL DWORD  , _ ' strings                                                                         ' ORIGINAL: const char ** /* strings */,
  BYREF DWORD  , _ ' lengths                                                                          ' ORIGINAL: const size_t * /* lengths */,
  BYREF type_cl_int  ) AS type_cl_program                                                             ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clCreateProgramWithBinary LIB "OpenCL.DLL" ALIAS "clCreateProgramWithBinary" ( _
  BYVAL type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
  BYVAL type_cl_uint , _ ' num_devices                                                                ' ORIGINAL: cl_uint /* num_devices */,
  BYREF type_cl_device_id  , _ ' device_list                                                          ' ORIGINAL: const cl_device_id * /* device_list */,
  BYREF DWORD    , _ ' lengths                                                                        ' ORIGINAL: const size_t * /* lengths */,
  BYREF ASCIIZ  , _ ' binaries                                                                        ' ORIGINAL: const unsigned char ** /* binaries */,
  BYREF type_cl_int  , _ ' binary_status                                                              ' ORIGINAL: cl_int * /* binary_status */,
  BYREF type_cl_int  ) AS type_cl_program                                                             ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainProgram LIB "OpenCL.DLL" ALIAS "clRetainProgram" ( _
  BYVAL type_cl_program ) AS type_cl_int                                                              ' ORIGINAL: cl_program /* program */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseProgram LIB "OpenCL.DLL" ALIAS "clReleaseProgram" ( _
  BYVAL type_cl_program ) AS type_cl_int                                                              ' ORIGINAL: cl_program /* program */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clBuildProgram LIB "OpenCL.DLL" ALIAS "clBuildProgram" ( _
  BYVAL type_cl_program , _ ' program                                                                 ' ORIGINAL: cl_program /* program */,
  BYVAL type_cl_uint, _ ' num_devices                                                                 ' ORIGINAL: cl_uint /* num_devices */,
  BYREF type_cl_device_id  , _ ' device_list                                                          ' ORIGINAL: const cl_device_id * /* device_list */,
  BYREF ASCIIZ  , _ ' options                                                                         ' ORIGINAL: const char * /* options */,
  BYVAL DWORD,_                                                                                         ' ORIGINAL: void (*pfn_notify)(cl_program /* program */, void * /* user_data */),
  BYREF ANY        ) AS type_cl_int                                                                   ' ORIGINAL: void * /* user_data */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clUnloadCompiler LIB "OpenCL.DLL" ALIAS "clUnloadCompiler" ( _
  ) AS type_cl_int                                                                                   ' ORIGINAL: void) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetProgramInfo LIB "OpenCL.DLL" ALIAS "clGetProgramInfo" ( _
  BYVAL type_cl_program , _ ' program                                                                 ' ORIGINAL: cl_program /* program */,
  BYVAL type_cl_program_info , _ ' param_name                                                         ' ORIGINAL: cl_program_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetProgramBuildInfo LIB "OpenCL.DLL" ALIAS "clGetProgramBuildInfo" ( _
  BYVAL type_cl_program , _ ' program                                                                 ' ORIGINAL: cl_program /* program */,
  BYVAL type_cl_device_id , _ ' device                                                                ' ORIGINAL: cl_device_id /* device */,
  BYVAL type_cl_program_build_info , _ ' param_name                                                   ' ORIGINAL: cl_program_build_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Kernel Object APIs
DECLARE FUNCTION clCreateKernel LIB "OpenCL.DLL" ALIAS "clCreateKernel" ( _
  BYVAL type_cl_program , _ ' program                                                                 ' ORIGINAL: cl_program /* program */,
  BYVAL DWORD  , _ ' kernel_name                                                                     ' ORIGINAL: const char * /* kernel_name */,
  BYREF type_cl_int  ) AS type_cl_kernel                                                              ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clCreateKernelsInProgram LIB "OpenCL.DLL" ALIAS "clCreateKernelsInProgram" ( _
  BYVAL type_cl_program , _ ' program                                                                 ' ORIGINAL: cl_program /* program */,
  BYVAL type_cl_uint , _ ' num_kernels                                                                ' ORIGINAL: cl_uint /* num_kernels */,
  BYREF type_cl_kernel  , _ ' kernels                                                                 ' ORIGINAL: cl_kernel * /* kernels */,
  BYREF type_cl_uint  ) AS type_cl_int                                                                ' ORIGINAL: cl_uint * /* num_kernels_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainKernel LIB "OpenCL.DLL" ALIAS "clRetainKernel" ( _
  BYVAL type_cl_kernel ) AS type_cl_int                                                               ' ORIGINAL: cl_kernel /* kernel */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseKernel LIB "OpenCL.DLL" ALIAS "clReleaseKernel" ( _
  BYVAL type_cl_kernel ) AS type_cl_int                                                               ' ORIGINAL: cl_kernel /* kernel */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clSetKernelArg LIB "OpenCL.DLL" ALIAS "clSetKernelArg" ( _
  BYVAL type_cl_kernel , _ ' kernel                                                                   ' ORIGINAL: cl_kernel /* kernel */,
  BYVAL type_cl_uint , _ ' arg_index                                                                  ' ORIGINAL: cl_uint /* arg_index */,
  BYVAL DWORD       , _ ' arg_size                                                                    ' ORIGINAL: size_t /* arg_size */,
  BYVAL DWORD  ) AS type_cl_int                                                                         ' ORIGINAL: const void * /* arg_value */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetKernelInfo LIB "OpenCL.DLL" ALIAS "clGetKernelInfo" ( _
  BYVAL type_cl_kernel , _ ' kernel                                                                   ' ORIGINAL: cl_kernel /* kernel */,
  BYVAL type_cl_kernel_info , _ ' param_name                                                          ' ORIGINAL: cl_kernel_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetKernelWorkGroupInfo LIB "OpenCL.DLL" ALIAS "clGetKernelWorkGroupInfo" ( _
  BYVAL type_cl_kernel , _ ' kernel                                                                   ' ORIGINAL: cl_kernel /* kernel */,
  BYVAL type_cl_device_id , _ ' device                                                                ' ORIGINAL: cl_device_id /* device */,
  BYVAL type_cl_kernel_work_group_info , _ ' param_name                                               ' ORIGINAL: cl_kernel_work_group_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Event Object APIs
DECLARE FUNCTION clWaitForEvents LIB "OpenCL.DLL" ALIAS "clWaitForEvents" ( _
  BYVAL type_cl_uint , _ ' num_events                                                                 ' ORIGINAL: cl_uint /* num_events */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: const cl_event * /* event_list */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clGetEventInfo LIB "OpenCL.DLL" ALIAS "clGetEventInfo" ( _
  BYVAL type_cl_event , _ ' event                                                                     ' ORIGINAL: cl_event /* event */,
  BYVAL type_cl_event_info , _ ' param_name                                                           ' ORIGINAL: cl_event_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clRetainEvent LIB "OpenCL.DLL" ALIAS "clRetainEvent" ( _
  BYVAL type_cl_event ) AS type_cl_int                                                                ' ORIGINAL: cl_event /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clReleaseEvent LIB "OpenCL.DLL" ALIAS "clReleaseEvent" ( _
  BYVAL type_cl_event ) AS type_cl_int                                                                ' ORIGINAL: cl_event /* event */) CL_API_SUFFIX__VERSION_1_0;

' Profiling APIs
DECLARE FUNCTION clGetEventProfilingInfo LIB "OpenCL.DLL" ALIAS "clGetEventProfilingInfo" ( _
  BYVAL type_cl_event , _ ' event                                                                     ' ORIGINAL: cl_event /* event */,
  BYVAL type_cl_profiling_info , _ ' param_name                                                       ' ORIGINAL: cl_profiling_info /* param_name */,
  BYVAL DWORD       , _ ' param_value_size                                                            ' ORIGINAL: size_t /* param_value_size */,
  BYREF ANY        , _ ' param_value                                                                  ' ORIGINAL: void * /* param_value */,
  BYREF DWORD  ) AS type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

' Flush and Finish APIs
DECLARE FUNCTION clFlush LIB "OpenCL.DLL" ALIAS "clFlush" ( _
  BYVAL type_cl_command_queue ) AS type_cl_int                                                        ' ORIGINAL: cl_command_queue /* command_queue */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clFinish LIB "OpenCL.DLL" ALIAS "clFinish" ( _
  BYVAL type_cl_command_queue ) AS type_cl_int                                                        ' ORIGINAL: cl_command_queue /* command_queue */) CL_API_SUFFIX__VERSION_1_0;

' Enqueued Commands APIs
DECLARE FUNCTION clEnqueueReadBuffer LIB "OpenCL.DLL" ALIAS "clEnqueueReadBuffer" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' buffer                                                                      ' ORIGINAL: cl_mem /* buffer */,
  BYVAL type_cl_bool , _ ' blocking_read                                                              ' ORIGINAL: cl_bool /* blocking_read */,
  BYVAL DWORD       , _ ' offset                                                                      ' ORIGINAL: size_t /* offset */,
  BYVAL DWORD       , _ ' cb                                                                          ' ORIGINAL: size_t /* cb */,
  BYREF ANY        , _ ' ptr                                                                          ' ORIGINAL: void * /* ptr */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueWriteBuffer LIB "OpenCL.DLL" ALIAS "clEnqueueWriteBuffer" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' buffer                                                                      ' ORIGINAL: cl_mem /* buffer */,
  BYVAL type_cl_bool , _ ' blocking_write                                                             ' ORIGINAL: cl_bool /* blocking_write */,
  BYVAL DWORD       , _ ' offset                                                                      ' ORIGINAL: size_t /* offset */,
  BYVAL DWORD       , _ ' cb                                                                          ' ORIGINAL: size_t /* cb */,
  BYREF ANY  , _ ' ptr                                                                                ' ORIGINAL: const void * /* ptr */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueCopyBuffer LIB "OpenCL.DLL" ALIAS "clEnqueueCopyBuffer" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' src_buffer                                                                  ' ORIGINAL: cl_mem /* src_buffer */,
  BYVAL type_cl_mem , _ ' dst_buffer                                                                  ' ORIGINAL: cl_mem /* dst_buffer */,
  BYVAL DWORD       , _ ' src_offset                                                                  ' ORIGINAL: size_t /* src_offset */,
  BYVAL DWORD       , _ ' dst_offset                                                                  ' ORIGINAL: size_t /* dst_offset */,
  BYVAL DWORD       , _ ' cb                                                                          ' ORIGINAL: size_t /* cb */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueReadImage LIB "OpenCL.DLL" ALIAS "clEnqueueReadImage" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' image                                                                       ' ORIGINAL: cl_mem /* image */,
  BYVAL type_cl_bool , _ ' blocking_read                                                              ' ORIGINAL: cl_bool /* blocking_read */,
  BYREF DWORD    , _ ' origin[3]                                                                      ' ORIGINAL: const size_t * /* origin[3] */,
  BYREF DWORD    , _ ' region[3]                                                                      ' ORIGINAL: const size_t * /* region[3] */,
  BYVAL DWORD       , _ ' row_pitch                                                                   ' ORIGINAL: size_t /* row_pitch */,
  BYVAL DWORD       , _ ' slice_pitch                                                                 ' ORIGINAL: size_t /* slice_pitch */,
  BYREF ANY        , _ ' ptr                                                                          ' ORIGINAL: void * /* ptr */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueWriteImage LIB "OpenCL.DLL" ALIAS "clEnqueueWriteImage" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' image                                                                       ' ORIGINAL: cl_mem /* image */,
  BYVAL type_cl_bool , _ ' blocking_write                                                             ' ORIGINAL: cl_bool /* blocking_write */,
  BYREF DWORD    , _ ' origin[3]                                                                      ' ORIGINAL: const size_t * /* origin[3] */,
  BYREF DWORD    , _ ' region[3]                                                                      ' ORIGINAL: const size_t * /* region[3] */,
  BYVAL DWORD       , _ ' input_row_pitch                                                             ' ORIGINAL: size_t /* input_row_pitch */,
  BYVAL DWORD       , _ ' input_slice_pitch                                                           ' ORIGINAL: size_t /* input_slice_pitch */,
  BYREF ANY   , _ ' ptr                                                                               ' ORIGINAL: const void * /* ptr */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueCopyImage LIB "OpenCL.DLL" ALIAS "clEnqueueCopyImage" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' src_image                                                                   ' ORIGINAL: cl_mem /* src_image */,
  BYVAL type_cl_mem , _ ' dst_image                                                                   ' ORIGINAL: cl_mem /* dst_image */,
  BYREF DWORD    , _ ' src_origin[3]                                                        ' ORIGINAL: const size_t * /* src_origin[3] */,
  BYREF DWORD    , _ ' dst_origin[3]                                                        ' ORIGINAL: const size_t * /* dst_origin[3] */,
  BYREF DWORD    , _ ' region[3]                                                            ' ORIGINAL: const size_t * /* region[3] */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                    ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueCopyImageToBuffer LIB "OpenCL.DLL" ALIAS "clEnqueueCopyImageToBuffer" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' src_image                                                                   ' ORIGINAL: cl_mem /* src_image */,
  BYVAL type_cl_mem , _ ' dst_buffer                                                                  ' ORIGINAL: cl_mem /* dst_buffer */,
  BYREF DWORD    , _ ' src_origin[3]                                                        ' ORIGINAL: const size_t * /* src_origin[3] */,
  BYREF DWORD    , _ ' region[3]                                                            ' ORIGINAL: const size_t * /* region[3] */,
  BYVAL DWORD       , _ ' dst_offset                                                                  ' ORIGINAL: size_t /* dst_offset */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                    ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueCopyBufferToImage LIB "OpenCL.DLL" ALIAS "clEnqueueCopyBufferToImage" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' src_buffer                                                                  ' ORIGINAL: cl_mem /* src_buffer */,
  BYVAL type_cl_mem , _ ' dst_image                                                                   ' ORIGINAL: cl_mem /* dst_image */,
  BYVAL DWORD       , _ ' src_offset                                                                  ' ORIGINAL: size_t /* src_offset */,
  BYREF DWORD    , _ ' dst_origin[3]                                                        ' ORIGINAL: const size_t * /* dst_origin[3] */,
  BYREF DWORD    , _ ' region[3]                                                            ' ORIGINAL: const size_t * /* region[3] */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                    ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueMapBuffer LIB "OpenCL.DLL" ALIAS "clEnqueueMapBuffer" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' buffer                                                                      ' ORIGINAL: cl_mem /* buffer */,
  BYVAL type_cl_bool , _ ' blocking_map                                                               ' ORIGINAL: cl_bool /* blocking_map */,
  BYVAL type_cl_map_flags , _ ' map_flags                                                             ' ORIGINAL: cl_map_flags /* map_flags */,
  BYVAL DWORD       , _ ' offset                                                                      ' ORIGINAL: size_t /* offset */,
  BYVAL DWORD       , _ ' cb                                                                          ' ORIGINAL: size_t /* cb */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  , _ ' event                                                                    ' ORIGINAL: cl_event * /* event */,
  BYREF type_cl_int  ) AS DWORD                                                                       ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueMapImage LIB "OpenCL.DLL" ALIAS "clEnqueueMapImage" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' image                                                                       ' ORIGINAL: cl_mem /* image */,
  BYVAL type_cl_bool , _ ' blocking_map                                                               ' ORIGINAL: cl_bool /* blocking_map */,
  BYVAL type_cl_map_flags , _ ' map_flags                                                             ' ORIGINAL: cl_map_flags /* map_flags */,
  BYREF DWORD    , _ ' origin[3]                                                                      ' ORIGINAL: const size_t * /* origin[3] */,
  BYREF DWORD    , _ ' region[3]                                                                      ' ORIGINAL: const size_t * /* region[3] */,
  BYREF DWORD  , _ ' image_row_pitch                                                                  ' ORIGINAL: size_t * /* image_row_pitch */,
  BYREF DWORD  , _ ' image_slice_pitch                                                                ' ORIGINAL: size_t * /* image_slice_pitch */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  , _ ' event                                                                    ' ORIGINAL: cl_event * /* event */,
  BYREF type_cl_int  ) AS DWORD                                                                       ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueUnmapMemObject LIB "OpenCL.DLL" ALIAS "clEnqueueUnmapMemObject" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_mem , _ ' memobj                                                                      ' ORIGINAL: cl_mem /* memobj */,
  BYREF ANY        , _ ' mapped_ptr                                                                   ' ORIGINAL: void * /* mapped_ptr */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueNDRangeKernel LIB "OpenCL.DLL" ALIAS "clEnqueueNDRangeKernel" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_kernel , _ ' kernel                                                                   ' ORIGINAL: cl_kernel /* kernel */,
  BYVAL type_cl_uint , _ ' work_dim                                                                   ' ORIGINAL: cl_uint /* work_dim */,
  BYREF DWORD    , _ ' global_work_offset                                                             ' ORIGINAL: const size_t * /* global_work_offset */,
  BYREF DWORD    , _ ' global_work_size                                                               ' ORIGINAL: const size_t * /* global_work_size */,
  BYREF DWORD    , _ ' local_work_size                                                                ' ORIGINAL: const size_t * /* local_work_size */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueTask LIB "OpenCL.DLL" ALIAS "clEnqueueTask" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_kernel , _ ' kernel                                                                   ' ORIGINAL: cl_kernel /* kernel */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueNativeKernel LIB "OpenCL.DLL" ALIAS "clEnqueueNativeKernel" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYREF ANY, _                                                                                        ' ORIGINAL:            void (*user_func)(void *),
  BYREF ANY        , _ ' args                                                                         ' ORIGINAL: void * /* args */,
  BYVAL DWORD       , _ ' cb_args                                                                     ' ORIGINAL: size_t /* cb_args */,
  BYVAL type_cl_uint , _ ' num_mem_objects                                                            ' ORIGINAL: cl_uint /* num_mem_objects */,
  BYREF type_cl_mem  , _ ' mem_list                                                                   ' ORIGINAL: const cl_mem * /* mem_list */,
  BYVAL DWORD   , _ ' args_mem_loc                                                                    ' ORIGINAL: const void ** /* args_mem_loc */,
  BYVAL type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
  BYREF type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: const cl_event * /* event_wait_list */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueMarker LIB "OpenCL.DLL" ALIAS "clEnqueueMarker" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueWaitForEvents LIB "OpenCL.DLL" ALIAS "clEnqueueWaitForEvents" ( _
  BYVAL type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
  BYVAL type_cl_uint , _ ' num_events                                                                 ' ORIGINAL: cl_uint /* num_events */,
  BYREF type_cl_event  ) AS type_cl_int                                                               ' ORIGINAL: const cl_event * /* event_list */) CL_API_SUFFIX__VERSION_1_0;

DECLARE FUNCTION clEnqueueBarrier LIB "OpenCL.DLL" ALIAS "clEnqueueBarrier" ( _
  BYVAL type_cl_command_queue ) AS type_cl_int                                                        ' ORIGINAL: cl_command_queue /* command_queue */) CL_API_SUFFIX__VERSION_1_0;

' Extension function access
'
' Returns the extension function address for the given function name,
' or NULL if a valid function can not be found. The client must
' check to make sure the address is not NULL, before using or
' calling the returned function address.
'
DECLARE FUNCTION clGetExtensionFunctionAddress LIB "OpenCL.DLL" ALIAS "clGetExtensionFunctionAddress" ( _
  BYREF ASCIIZ  ) AS DWORD                                                                   ' ORIGINAL: const char * /* func_name */) CL_API_SUFFIX__VERSION_1_0;
