' TB VERSION FROM 02 DEC 2009 -B
'/*******************************************************************************
' * Copyright (c) 2008-2009 The Khronos Group Inc.
' *
' * Permission is hereby granted, free of charge, to any person obtaining a
' * copy of this software and/or associated documentation files (the
' * "Materials"), to deal in the Materials without restriction, including
' * without limitation the rights to use, copy, modify, merge, publish,
' * distribute, sublicense, and/or sell copies of the Materials, and to
' * permit persons to whom the Materials are furnished to do so, subject to
' * the following conditions:
' *
' * The above copyright notice and this permission notice shall be included
' * in all copies or substantial portions of the Materials.
' *
' * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
' * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
' * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
' * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
' * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
' * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
' * MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
' ******************************************************************************/

' $Revision: 8748 $ On $Date: 2009-08-27 04:24:36 -0700 (Thu, 27 Aug 2009) $ 

#IF Not %DEF(%CL_PLATFORM_H)                 
  #INCLUDE Once "thinbasic_cl_platform.inc"  
#EndIf
#INCLUDE Once "thinbasic_gl.inc"

' NOTE:  Make sure that appropriate GL header file is included separately

Alias DWord As type_cl_gl_object_type   ' cl_uint
Alias DWord As type_cl_gl_texture_info
Alias DWord As type_cl_gl_platform_info

' cl_gl_object_type
global CL_GL_OBJECT_BUFFER             as long = &h02000
global CL_GL_OBJECT_TEXTURE2D          as long = &h02001
global CL_GL_OBJECT_TEXTURE3D          as long = &h02002
global CL_GL_OBJECT_RENDERBUFFER       as long = &h02003

' cl_gl_texture_info
Global CL_GL_TEXTURE_TARGET            As Long = &h02004
Global CL_GL_MIPMAP_LEVEL              As Long = &h02005

Declare Function clCreateFromGLBuffer Lib "OpenCL.DLL" Alias "clCreateFromGLBuffer" ( _
	ByVal type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
	ByVal type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
	ByVal GLuint , _ ' bufobj                                                                           ' ORIGINAL: GLuint /* bufobj */,
	ByRef Long ) As type_cl_mem                                                                         ' ORIGINAL: Int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clCreateFromGLTexture2D Lib "OpenCL.DLL" Alias "clCreateFromGLTexture2D" ( _
	ByVal type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
	ByVal type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
	ByVal GLenum , _ ' target                                                                           ' ORIGINAL: GLenum /* target */,
	ByVal GLint , _ ' miplevel                                                                          ' ORIGINAL: GLint /* miplevel */,
	ByVal GLuint , _ ' texture                                                                          ' ORIGINAL: GLuint /* texture */,
	ByRef type_cl_int  ) As type_cl_mem                                                                 ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clCreateFromGLTexture3D Lib "OpenCL.DLL" Alias "clCreateFromGLTexture3D" ( _
	ByVal type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
	ByVal type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
	ByVal GLenum , _ ' target                                                                           ' ORIGINAL: GLenum /* target */,
	ByVal GLint , _ ' miplevel                                                                          ' ORIGINAL: GLint /* miplevel */,
	ByVal GLuint , _ ' texture                                                                          ' ORIGINAL: GLuint /* texture */,
	ByRef type_cl_int  ) As type_cl_mem                                                                 ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clCreateFromGLRenderbuffer Lib "OpenCL.DLL" Alias "clCreateFromGLRenderbuffer" ( _
	ByVal type_cl_context , _ ' context                                                                 ' ORIGINAL: cl_context /* context */,
	ByVal type_cl_mem_flags , _ ' flags                                                                 ' ORIGINAL: cl_mem_flags /* flags */,
	ByVal GLuint , _ ' renderbuffer                                                                     ' ORIGINAL: GLuint /* renderbuffer */,
	ByRef type_cl_int  ) As type_cl_mem                                                                 ' ORIGINAL: cl_int * /* errcode_ret */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clGetGLObjectInfo Lib "OpenCL.DLL" Alias "clGetGLObjectInfo" ( _
	ByVal type_cl_mem , _ ' memobj                                                                      ' ORIGINAL: cl_mem /* memobj */,
	ByRef type_cl_gl_object_type , _ ' gl_object_type                                                   ' ORIGINAL: cl_gl_object_type * /* gl_object_type */,
	ByRef GLuint  ) As type_cl_int                                                                      ' ORIGINAL: GLuint * /* gl_object_name */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clGetGLTextureInfo Lib "OpenCL.DLL" Alias "clGetGLTextureInfo" ( _
	ByVal type_cl_mem , _ ' memobj                                                                      ' ORIGINAL: cl_mem /* memobj */,
	ByVal type_cl_gl_texture_info , _ ' param_name                                                      ' ORIGINAL: cl_gl_texture_info /* param_name */,
	ByVal DWord , _ ' param_value_size                                                                  ' ORIGINAL: size_t /* param_value_size */,
	ByVal DWord  , _ ' param_value                                                                      ' ORIGINAL: void * /* param_value */,
	ByRef DWord  ) As type_cl_int                                                                       ' ORIGINAL: size_t * /* param_value_size_ret */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clEnqueueAcquireGLObjects Lib "OpenCL.DLL" Alias "clEnqueueAcquireGLObjects" ( _
	ByVal type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
	ByVal type_cl_uint , _ ' num_objects                                                                ' ORIGINAL: cl_uint /* num_objects */,
	ByRef type_cl_mem  , _ ' mem_objects                                                                ' ORIGINAL: Const cl_mem * /* mem_objects */,
	ByVal type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
	ByRef type_cl_event  , _ ' event_wait_list                                                    ' ORIGINAL: Const cl_event * /* event_wait_list */,
	ByRef type_cl_event  ) As type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;

Declare Function clEnqueueReleaseGLObjects Lib "OpenCL.DLL" Alias "clEnqueueReleaseGLObjects" ( _
	ByVal type_cl_command_queue , _ ' command_queue                                                     ' ORIGINAL: cl_command_queue /* command_queue */,
	ByVal type_cl_uint , _ ' num_objects                                                                ' ORIGINAL: cl_uint /* num_objects */,
	ByRef type_cl_mem  , _ ' mem_objects                                                          ' ORIGINAL: Const cl_mem * /* mem_objects */,
	ByVal type_cl_uint , _ ' num_events_in_wait_list                                                    ' ORIGINAL: cl_uint /* num_events_in_wait_list */,
	ByRef type_cl_event  , _ ' event_wait_list                                                          ' ORIGINAL: Const cl_event * /* event_wait_list */,
	ByRef type_cl_event  ) As type_cl_int                                                               ' ORIGINAL: cl_event * /* event */) CL_API_SUFFIX__VERSION_1_0;
