' TB VERSION FROM 02 DEC 2009 -B
'/*******************************************************************************
' * Copyright (c) 2008-2009 The Khronos Group Inc.
' *
' * Permission is hereby granted, free of charge, to any person obtaining a
' * copy of this software and/or associated documentation files (the
' * "Materials"), to deal in the Materials without restriction, including
' * without limitation the rights to use, copy, modify, merge, publish,
' * distribute, sublicense, and/or sell copies of the Materials, and to
' * permit persons to whom the Materials are furnished to do so, subject to
' * the following conditions:
' *
' * The above copyright notice and this permission notice shall be included
' * in all copies or substantial portions of the Materials.
' *
' * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
' * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
' * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
' * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
' * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
' * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
' * MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
' ******************************************************************************/

' $Revision: 9283 $ on $Date: 2009-10-14 10:18:57 -0700 (Wed, 14 Oct 2009) $ 
%CL_PLATFORM_H              = 1
           
%CL_API_SUFFIX__VERSION_1_0 = 1
%CL_EXTENSION_WEAK_LINK     = 1


' scalar types  '

Alias Byte As type_cl_char
Alias Byte As type_cl_uchar

Alias Integer As type_cl_short
Alias Word As type_cl_ushort

Alias Long As type_cl_int
Alias DWord As type_cl_uint

Alias Quad As type_cl_long
Alias Quad As type_cl_ulong

Alias Word As type_cl_half
Alias Single As type_cl_float
Alias Double As type_cl_double      
                   
' ============================================================================ '

Alias type_cl_uint As type_cl_platform_id
Alias type_cl_uint As type_cl_device_id
Alias type_cl_uint As type_cl_context
Alias type_cl_uint As type_cl_command_queue
Alias type_cl_uint As type_cl_mem
Alias type_cl_uint As type_cl_program
Alias type_cl_uint As type_cl_kernel
Alias type_cl_uint As type_cl_event
Alias type_cl_uint As type_cl_sampler

Alias type_cl_uint As type_cl_bool
Alias type_cl_ulong As type_cl_bitfield
Alias type_cl_bitfield As type_cl_device_type
Alias type_cl_uint As type_cl_platform_info
Alias type_cl_uint As type_cl_device_info
Alias type_cl_bitfield As type_cl_device_address_info
Alias type_cl_bitfield As type_cl_device_fp_config
Alias type_cl_uint As type_cl_device_mem_cache_type
Alias type_cl_uint As type_cl_device_local_mem_type
Alias type_cl_bitfield As type_cl_device_exec_capabilities
Alias type_cl_bitfield As type_cl_command_queue_properties

Alias DWord As type_cl_context_properties
Alias type_cl_uint As type_cl_context_info
Alias type_cl_uint As type_cl_command_queue_info
Alias type_cl_uint As type_cl_channel_order
Alias type_cl_uint As type_cl_channel_type
Alias type_cl_bitfield As type_cl_mem_flags
Alias type_cl_uint As type_cl_mem_object_type
Alias type_cl_uint As type_cl_mem_info
Alias type_cl_uint As type_cl_image_info
Alias type_cl_uint As type_cl_addressing_mode
Alias type_cl_uint As type_cl_filter_mode
Alias type_cl_uint As type_cl_sampler_info
Alias type_cl_bitfield As type_cl_map_flags
Alias type_cl_uint As type_cl_program_info
Alias type_cl_uint As type_cl_program_build_info
Alias type_cl_int As type_cl_build_status
Alias type_cl_uint As type_cl_kernel_info
Alias type_cl_uint As type_cl_kernel_work_group_info
Alias type_cl_uint As type_cl_event_info
Alias type_cl_uint As type_cl_command_type
Alias type_cl_uint As type_cl_profiling_info

Type udt_cl_image_format
    image_channel_order     As type_cl_channel_order
    image_channel_data_type As type_cl_channel_type
End Type

' ============================================================================ '                   


'
' Vector types
'
'  Note:   OpenCL requires that all types be naturally aligned.
'          This means that vector types must be naturally aligned.
'          For example, a vector of four floats must be aligned to
'          a 16 byte boundary (calculated as 4 * the natural 4-byte
'          alignment of the float).  The alignment qualifiers here
'          will only function properly if your compiler supports them
'          and if you don't actively work to defeat them.  For example,
'          in order for a cl_float4 to be 16 byte aligned in a struct,
'          the start of the struct must itself be 16-byte aligned.
'
'          Maintaining proper alignment is the user's responsibility.
'


Type udt_cl_char2
	x As type_cl_char
	y As type_cl_char
End Type


Type udt_cl_char4
	x As type_cl_char
	y As type_cl_char
	z As type_cl_char
	w As type_cl_char
End Type


Type udt_cl_char8
	a As type_cl_char
	b As type_cl_char
	c As type_cl_char
	d As type_cl_char
	e As type_cl_char
	f As type_cl_char
	g As type_cl_char
	h As type_cl_char
End Type


Type udt_cl_char16
	a As type_cl_char
	b As type_cl_char
	c As type_cl_char
	d As type_cl_char
	e As type_cl_char
	f As type_cl_char
	g As type_cl_char
	h As type_cl_char
	i As type_cl_char
	j As type_cl_char
	k As type_cl_char
	l As type_cl_char
	m As type_cl_char
	n As type_cl_char
	o As type_cl_char
	p As type_cl_char
End Type


Type udt_cl_uchar2
	x As type_cl_uchar
	y As type_cl_uchar
End Type


Type udt_cl_uchar4
	x As type_cl_uchar
	y As type_cl_uchar
	z As type_cl_uchar
	w As type_cl_uchar
End Type


Type udt_cl_uchar8
	a As type_cl_uchar
	b As type_cl_uchar
	c As type_cl_uchar
	d As type_cl_uchar
	e As type_cl_uchar
	f As type_cl_uchar
	g As type_cl_uchar
	h As type_cl_uchar
End Type


Type udt_cl_uchar16
	a As type_cl_uchar
	b As type_cl_uchar
	c As type_cl_uchar
	d As type_cl_uchar
	e As type_cl_uchar
	f As type_cl_uchar
	g As type_cl_uchar
	h As type_cl_uchar
	i As type_cl_uchar
	j As type_cl_uchar
	k As type_cl_uchar
	l As type_cl_uchar
	m As type_cl_uchar
	n As type_cl_uchar
	o As type_cl_uchar
	p As type_cl_uchar
End Type


Type udt_cl_short2
	x As type_cl_short
	y As type_cl_short
End Type


Type udt_cl_short4
	x As type_cl_short
	y As type_cl_short
	z As type_cl_short
	w As type_cl_short
End Type


Type udt_cl_short8
	a As type_cl_short
	b As type_cl_short
	c As type_cl_short
	d As type_cl_short
	e As type_cl_short
	f As type_cl_short
	g As type_cl_short
	h As type_cl_short
End Type


Type udt_cl_short16
	a As type_cl_short
	b As type_cl_short
	c As type_cl_short
	d As type_cl_short
	e As type_cl_short
	f As type_cl_short
	g As type_cl_short
	h As type_cl_short
	i As type_cl_short
	j As type_cl_short
	k As type_cl_short
	l As type_cl_short
	m As type_cl_short
	n As type_cl_short
	o As type_cl_short
	p As type_cl_short
End Type


Type udt_cl_ushort2
	x As type_cl_ushort
	y As type_cl_ushort
End Type


Type udt_cl_ushort4
	x As type_cl_ushort
	y As type_cl_ushort
	z As type_cl_ushort
	w As type_cl_ushort
End Type


Type udt_cl_ushort8
	a As type_cl_ushort
	b As type_cl_ushort
	c As type_cl_ushort
	d As type_cl_ushort
	e As type_cl_ushort
	f As type_cl_ushort
	g As type_cl_ushort
	h As type_cl_ushort
End Type


Type udt_cl_ushort16
	a As type_cl_ushort
	b As type_cl_ushort
	c As type_cl_ushort
	d As type_cl_ushort
	e As type_cl_ushort
	f As type_cl_ushort
	g As type_cl_ushort
	h As type_cl_ushort
	i As type_cl_ushort
	j As type_cl_ushort
	k As type_cl_ushort
	l As type_cl_ushort
	m As type_cl_ushort
	n As type_cl_ushort
	o As type_cl_ushort
	p As type_cl_ushort
End Type


Type udt_cl_int2
	x As type_cl_int
	y As type_cl_int
End Type


Type udt_cl_int4
	x As type_cl_int
	y As type_cl_int
	z As type_cl_int
	w As type_cl_int
End Type


Type udt_cl_int8
	a As type_cl_int
	b As type_cl_int
	c As type_cl_int
	d As type_cl_int
	e As type_cl_int
	f As type_cl_int
	g As type_cl_int
	h As type_cl_int
End Type


Type udt_cl_int16
	a As type_cl_int
	b As type_cl_int
	c As type_cl_int
	d As type_cl_int
	e As type_cl_int
	f As type_cl_int
	g As type_cl_int
	h As type_cl_int
	i As type_cl_int
	j As type_cl_int
	k As type_cl_int
	l As type_cl_int
	m As type_cl_int
	n As type_cl_int
	o As type_cl_int
	p As type_cl_int
End Type


Type udt_cl_uint2
	x As type_cl_uint
	y As type_cl_uint
End Type


Type udt_cl_uint4
	x As type_cl_uint
	y As type_cl_uint
	z As type_cl_uint
	w As type_cl_uint
End Type


Type udt_cl_uint8
	a As type_cl_uint
	b As type_cl_uint
	c As type_cl_uint
	d As type_cl_uint
	e As type_cl_uint
	f As type_cl_uint
	g As type_cl_uint
	h As type_cl_uint
End Type


Type udt_cl_uint16
	a As type_cl_uint
	b As type_cl_uint
	c As type_cl_uint
	d As type_cl_uint
	e As type_cl_uint
	f As type_cl_uint
	g As type_cl_uint
	h As type_cl_uint
	i As type_cl_uint
	j As type_cl_uint
	k As type_cl_uint
	l As type_cl_uint
	m As type_cl_uint
	n As type_cl_uint
	o As type_cl_uint
	p As type_cl_uint
End Type


Type udt_cl_long2
	x As type_cl_long
	y As type_cl_long
End Type


Type udt_cl_long4
	x As type_cl_long
	y As type_cl_long
	z As type_cl_long
	w As type_cl_long
End Type


Type udt_cl_long8
	a As type_cl_long
	b As type_cl_long
	c As type_cl_long
	d As type_cl_long
	e As type_cl_long
	f As type_cl_long
	g As type_cl_long
	h As type_cl_long
End Type


Type udt_cl_long16
	a As type_cl_long
	b As type_cl_long
	c As type_cl_long
	d As type_cl_long
	e As type_cl_long
	f As type_cl_long
	g As type_cl_long
	h As type_cl_long
	i As type_cl_long
	j As type_cl_long
	k As type_cl_long
	l As type_cl_long
	m As type_cl_long
	n As type_cl_long
	o As type_cl_long
	p As type_cl_long
End Type


Type udt_cl_ulong2
	x As type_cl_ulong
	y As type_cl_ulong
End Type


Type udt_cl_ulong4
	x As type_cl_ulong
	y As type_cl_ulong
	z As type_cl_ulong
	w As type_cl_ulong
End Type


Type udt_cl_ulong8
	a As type_cl_ulong
	b As type_cl_ulong
	c As type_cl_ulong
	d As type_cl_ulong
	e As type_cl_ulong
	f As type_cl_ulong
	g As type_cl_ulong
	h As type_cl_ulong
End Type


Type udt_cl_ulong16
	a As type_cl_ulong
	b As type_cl_ulong
	c As type_cl_ulong
	d As type_cl_ulong
	e As type_cl_ulong
	f As type_cl_ulong
	g As type_cl_ulong
	h As type_cl_ulong
	i As type_cl_ulong
	j As type_cl_ulong
	k As type_cl_ulong
	l As type_cl_ulong
	m As type_cl_ulong
	n As type_cl_ulong
	o As type_cl_ulong
	p As type_cl_ulong
End Type


Type udt_cl_float2
	x As type_cl_float
	y As type_cl_float
End Type


Type udt_cl_float4
	x As type_cl_float
	y As type_cl_float
	z As type_cl_float
	w As type_cl_float
End Type


Type udt_cl_float8
	a As type_cl_float
	b As type_cl_float
	c As type_cl_float
	d As type_cl_float
	e As type_cl_float
	f As type_cl_float
	g As type_cl_float
	h As type_cl_float
End Type


Type udt_cl_float16
	a As type_cl_float
	b As type_cl_float
	c As type_cl_float
	d As type_cl_float
	e As type_cl_float
	f As type_cl_float
	g As type_cl_float
	h As type_cl_float
	i As type_cl_float
	j As type_cl_float
	k As type_cl_float
	l As type_cl_float
	m As type_cl_float
	n As type_cl_float
	o As type_cl_float
	p As type_cl_float
End Type


Type udt_cl_double2
	x As type_cl_double
	y As type_cl_double
End Type


Type udt_cl_double4
	x As type_cl_double
	y As type_cl_double
	z As type_cl_double
	w As type_cl_double
End Type


Type udt_cl_double8
	a As type_cl_double
	b As type_cl_double
	c As type_cl_double
	d As type_cl_double
	e As type_cl_double
	f As type_cl_double
	g As type_cl_double
	h As type_cl_double
End Type


Type udt_cl_double16
	a As type_cl_double
	b As type_cl_double
	c As type_cl_double
	d As type_cl_double
	e As type_cl_double
	f As type_cl_double
	g As type_cl_double
	h As type_cl_double
	i As type_cl_double
	j As type_cl_double
	k As type_cl_double
	l As type_cl_double
	m As type_cl_double
	n As type_cl_double
	o As type_cl_double
	p As type_cl_double
End Type

' There are no vector types for half '

Global CL_CHAR_BIT As Long =  8
Global CL_SCHAR_MAX As Long =  127
Global CL_SCHAR_MIN As Long =  (-127-1)
Global CL_CHAR_MAX As Long =  CL_SCHAR_MAX
Global CL_CHAR_MIN As Long =  CL_SCHAR_MIN
Global CL_UCHAR_MAX As Long =  255
Global CL_SHRT_MAX As Long =  32767
Global CL_SHRT_MIN As Long =  (-32767-1)
Global CL_USHRT_MAX As Long =  65535
Global CL_INT_MAX As Long =  2147483647
Global CL_INT_MIN As Long =  (-2147483647-1)
Global CL_UINT_MAX As Long =  &h0ffffffff
Global CL_LONG_MAX As Quad =  (&h07FFFFFFFFFFFFFFF)
Global CL_LONG_MIN As Quad =  (-&h07FFFFFFFFFFFFFFF - 1)
Global CL_ULONG_MAX As Quad =  (&h0FFFFFFFFFFFFFFFF)

Global CL_FLT_DIG As Long =  6
Global CL_FLT_MANT_DIG As Long =  24
Global CL_FLT_MAX_10_EXP As Long =  +38
Global CL_FLT_MAX_EXP As Long =  +128
Global CL_FLT_MIN_10_EXP As Long =  -37
Global CL_FLT_MIN_EXP As Long =  -125
Global CL_FLT_RADIX As Long =  2
Global CL_FLT_MAX As Ext =  340282346638528859811704183484516925440.0
Global CL_FLT_MIN As Ext =  1.175494350822287507969 * 10 ^(-38)
Global CL_FLT_EPSILON As Long =  10^(-35)

Global CL_DBL_DIG As Long =  15
Global CL_DBL_MANT_DIG As Long =  53
Global CL_DBL_MAX_10_EXP As Long =  (+308)
Global CL_DBL_MAX_EXP As Long =  (+1024)
Global CL_DBL_MIN_10_EXP As Long =  (-307)
Global CL_DBL_MIN_EXP As Long =  (-1021)
Global CL_DBL_RADIX As Long =  2
'Global CL_DBL_MAX As Long =  "(NOT PORTED)"
Global CL_DBL_MIN As Ext =  2.225073858507201383090*10^(-308)
Global CL_DBL_EPSILON As Ext =  2.220446049250313080847*10^(-16)
