var m_nSliderFirstPos = -1;
var hCutWnd = wincut.GetHandle();
var hCutPlayerWnd = wincut.player.GetHandle();
var nCutDiskClearSizi = "";
var m_strCutDisk = "";
var m_nCutFlag = -1;
var m_nCutPlayStatus= 1;
var m_nCutPlayVolume = 1;
var m_bcutsystray = false;
var m_nplaystate= -1;//0:play,1:pause,-1:stop
var m_cutfinishedaction = -1;
var m_strCutShowMsg = "";

//7501~8000
var CutAccelKeyMap =
[
	[7501, "ALT|VIRTKEY", 102],//f
	[7502, "ALT|VIRTKEY", 70],//F
	
	[7503, "ALT|VIRTKEY", 101],//e
	[7504, "ALT|VIRTKEY", 69],//E
	
	[7505, "ALT|VIRTKEY", 97],//a
	[7506, "ALT|VIRTKEY", 65],//A
	
	[7507, "ALT|VIRTKEY", 116],//t
	[7508, "ALT|VIRTKEY", 84],//T
	
	[7509, "ALT|VIRTKEY", 104],//h
	[7510, "ALT|VIRTKEY", 72],//H
	
	
];

function OnCutHotKeySet( args )
{
	switch( args[2] )
	{
		case 7501:
		case 7502:
			wincut.file1.Popup();
			break;
		case 7503:
		case 7504:
			wincut.edit1.Popup();
			break;
		case 7505:
		case 7506:
			wincut.action1.Popup();
			break;
		case 7507:
		case 7508:
			wincut.tools1.Popup();
			break;
		case 7509:
		case 7510:
			wincut.help1.Popup();
			break;
			
	}
}

function InitCutWindow()
{
	if(!Product.IsValidateReg())
	{
		wincut.title.SetText( LanguageStr("_videocutter") + " (" + LanguageStr("_unreg") + ")" );
	}
	else
	{
		wincut.title.SetText( LanguageStr("_videocutter") );
	}
	InitCutWindowState();
	

	g_videoeditor.InitVideoEditor( hCutWnd, hCutPlayerWnd, 2 );
	
	//UILIb8δ޸ĺ,ʱ
//	wincut.RegisterAccelHandle( CutAccelKeyMap,"OnCutHotKeySet");
}
function CutWindowMinimize()
{
	window1.Minimize();
	wincut.Minimize();
}
function CloseCutterWin()
{
	//add by pengl
	onplay_stop_cut();		
	update_player_btn_cut(3);
	//end
	m_faceinterface = 0;
	OnCutClearView1();
	g_videoeditor.UnInitVideoEditor();
	
	wincut.imageview2.ClearAllItem();
	wincut.outsourceedit.SetText("");
	wincut.outtargetedit.SetText("");
	window1.RestoreWindow();
	wincut.Close();
//	wincutshow = false;
//	window1.SetVisible( true );
}

function OnCutCheckUpdate( args )
{
	OnCheckUpdate( wincut );
}

function SetCutVolumeRange( args )
{
	wincut.volumeslider.SetRange( args[2], args[3] );
}

function SetCutVolumeCurrent( args )
{
	wincut.volumeslider.SetPos( args[2] );
}

function OnCutSystrayShow( args )
{
	if( m_bcutsystray )
	{
		wincut.RestoreWindow();
	}
	window1.RestoreWindow();
	g_Systray.DeleteSysTray();
//	wincut.RestoreWindow();
}

function OnCutSystrayAbout( args )
{
	OnAbout(wincut);
}

function OnCutAbout( args )
{
	OnAbout( wincut );
}

function CutSysNotify(nMsg, ParentObj, ParmObj)
{
	switch(nMsg)
	{
		case WM_RBUTTONUP:
			wincut.systray.s1.SetText( LanguageStr("_systrayshow") + " " +  Product.GetProductName() );
			wincut.systray.s2.SetText( LanguageStr("_about") + " " +  Product.GetProductName() );
			wincut.systray.Popup();
			break;
		case WM_LBUTTONDBLCLK:
			window1.RestoreWindow();
		//	window1.Minimize();
			g_Systray.DeleteSysTray();
			break; 
		case WM_LBUTTONUP:
			break; 
	}
}

function CutShowFileOpenErroLog( args )
{
	cutlogwin.logstatic.SetText( args[2] );
	cutlogwin.ShowModal(wincut);
}

function TellUserNoSupportCut( args )
{
	if( args[2] == 0 )
		ShowMsg(wincut, LanguageStr("_strfileformatNO"),Product.GetProductName(),1 );
	else if( args[2] == 1 )
		ShowMsg(wincut, LanguageStr("_strfilecodecNO"),Product.GetProductName(),1 );
}

function OnCutRunBackground( args )
{
	window1.RestoreWindow();
	window1.HideWindow();
	m_bcutsystray = false;
	g_Systray.SetParentWnd(	hCutWnd );
	g_Systray.AddSysTray("xili-video-editor.ico", CutSysNotify );
	g_Systray.SetTipText( Product.GetProductName() );
}

function CutOutSysNotify(nMsg, ParentObj, ParmObj)
{
	switch(nMsg)
	{
		case WM_RBUTTONUP:
			wincut.systray.s1.SetText( LanguageStr("_systrayshow") + " " +  Product.GetProductName() );
			wincut.systray.s2.SetText( LanguageStr("_about") + " " +  Product.GetProductName() );
			wincut.systray.Popup();
			break;
		case WM_LBUTTONDBLCLK:
			window1.RestoreWindow();
			wincut.RestoreWindow();
			g_Systray.DeleteSysTray();
			break; 
		case WM_LBUTTONUP:
			break; 
	}
	
}

function OnCutOutRunBackground( args )
{
	m_bcutsystray = true;
	var hCutOutWnd = cutoutwin.GetHandle();
	g_Systray.SetParentWnd(	hCutOutWnd );
	g_Systray.AddSysTray("xili-video-editor.ico", CutOutSysNotify);
	g_Systray.SetTipText( Product.GetProductName() );
	window1.HideWindow();
	wincut.HideWindow();
}

function OnCutNoOperate( args )
{
	wincut.tools1.afterdone.noaction.SetCheck( true );
	wincut.tools1.afterdone.autoshutdown.SetCheck( false );
	wincut.tools1.afterdone.intodormancystate.SetCheck( false );
	wincut.tools1.afterdone.intostandby.SetCheck( false );
	wincut.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 0 );
	m_cutfinishedaction = 0;
}

function OnCutAutoShutDown( args )
{
	wincut.tools1.afterdone.noaction.SetCheck( false );
	wincut.tools1.afterdone.autoshutdown.SetCheck( true );
	wincut.tools1.afterdone.intodormancystate.SetCheck( false );
	wincut.tools1.afterdone.intostandby.SetCheck( false );
	wincut.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 1 );
	m_cutfinishedaction = 1;
}

function OnCutDormancyState( args )
{
	wincut.tools1.afterdone.noaction.SetCheck( false );
	wincut.tools1.afterdone.autoshutdown.SetCheck( false );
	wincut.tools1.afterdone.intodormancystate.SetCheck( true );
	wincut.tools1.afterdone.intostandby.SetCheck( false );
	wincut.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 2 );
	m_cutfinishedaction = 2;
}

function OnCutIntoStandBy( args )
{
	wincut.tools1.afterdone.noaction.SetCheck( false );
	wincut.tools1.afterdone.autoshutdown.SetCheck( false );
	wincut.tools1.afterdone.intodormancystate.SetCheck( false );
	wincut.tools1.afterdone.intostandby.SetCheck( true );
	wincut.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 3 );
	m_cutfinishedaction = 3;
}

function OnCutExitThis( args )
{
	wincut.tools1.afterdone.noaction.SetCheck( false );
	wincut.tools1.afterdone.autoshutdown.SetCheck( false );
	wincut.tools1.afterdone.intodormancystate.SetCheck( false );
	wincut.tools1.afterdone.intostandby.SetCheck( false );
	wincut.tools1.afterdone.exitthis.SetCheck( true );
	g_videoeditor.SetFinishedAction( 4 );
	m_cutfinishedaction = 4;
}

function CutShowCountDownNumber( args )
{
	countdownwin.countdown.SetText( args[2] );
}

function CutShowCountDownWin( args )
{
	countdownwin.title.SetText( Product.GetProductName() );
	countdownwin.countdown.SetText( args[2] );
//	ShowMsg(m_cutfinishedaction,LanguageStr("_strExitThis"), 1 );
	if( m_cutfinishedaction == 0 )//NoAction
	{
		return;
	}
	else if( m_cutfinishedaction == 1 )//ShutDown
	{
		countdownwin.message.SetText( LanguageStr("_strshoudown") );
	}
	else if( m_cutfinishedaction == 2 )//DormancyState
	{
		countdownwin.message.SetText( LanguageStr("_strDormancy") );
	}
	else if( m_cutfinishedaction == 3 )//IntoStandBy
	{
		countdownwin.message.SetText( LanguageStr("_strIntoStandBy") );
	}
	else if( m_cutfinishedaction == 4 )//ExitThis
	{
		countdownwin.message.SetText( LanguageStr("_strExitThis") );
	}
	countdownwin.ShowModal(cutoutwin);
}

function CloseCutApp( args )
{
	cutoutwin.Close();
	wincut.Close();
	window1.Close();
}

function SetCutFace1( args )
{
	var nTime = wincut.playslider.GetPos();
	var item = wincut.imageview1.GetCurSel();
	LoadSkin( "Imtoo" );
//	wincut.playslider.SetPos(nTime);
	Product.SetString( "SkinName", "Imtoo" );
	AdjustLangAndSkinStatus( 0, -1 );
	RefreshListView1AndView2(nTime);
	if( item[0] > 0 )
	{
		wincut.imageview1.SetCurSel( item[1] );
	}
}

function SetCutFace2( args )
{
	var nTime = wincut.playslider.GetPos();
	var item = wincut.imageview1.GetCurSel();
	LoadSkin( "Xilisoft" );
//	wincut.playslider.SetPos(nTime);
	Product.SetString( "SkinName", "Xilisoft" );
	AdjustLangAndSkinStatus( 1, -1 );
	RefreshListView1AndView2(nTime);
	if( item[0] > 0 )
	{
		wincut.imageview1.SetCurSel( item[1] );
	}
}

function SetCutLang1( args )
{
	var nTime = wincut.playslider.GetPos();
	var item = wincut.imageview1.GetCurSel();
	RefreshLanguage( "Chinese(Simplified)" );
	Product.SetString( "language", "Chinese(Simplified)" );
	AdjustLangAndSkinStatus( -1, 0 );
	RefreshListView1AndView2(nTime);
	OnGoMenuBuy();
	if( item[0] > 0 )
	{
		wincut.imageview1.SetCurSel( item[1] );
	}
}

function SetCutLang2( args )
{
	var nTime = wincut.playslider.GetPos();
	var item = wincut.imageview1.GetCurSel();
	RefreshLanguage( "English" );
	Product.SetString( "language", "English" );
	AdjustLangAndSkinStatus( -1, 1 );
	RefreshListView1AndView2(nTime);
	OnGoMenuBuy();
	if( item[0] > 0 )
	{
		wincut.imageview1.SetCurSel( item[1] );
	}
}

function SetCutLang3( args )
{
	var nTime = wincut.playslider.GetPos();
	var item = wincut.imageview1.GetCurSel();
	RefreshLanguage( "Deutsch" );
	Product.SetString( "language", "Deutsch" );
	AdjustLangAndSkinStatus( -1, 2 );
	RefreshListView1AndView2(nTime);
	OnGoMenuBuy();
	if( item[0] > 0 )
	{
		wincut.imageview1.SetCurSel( item[1] );
	}
}

function SetCutLang4( args )
{
	var nTime = wincut.playslider.GetPos();
	var item = wincut.imageview1.GetCurSel();
	RefreshLanguage( "Japanese" );
	Product.SetString( "language", "Japanese" );
	AdjustLangAndSkinStatus( -1, 3 );
	RefreshListView1AndView2(nTime);
	OnGoMenuBuy();
	if( item[0] > 0 )
	{
		wincut.imageview1.SetCurSel( item[1] );
	}
}

function RefreshListView1AndView2( args )
{
//	var nTime = wincut.playslider.GetPos();
	wincut.imageview1.ClearAllItem();
	wincut.imageview2.ClearAllItem();
	wincut.playslider.SetPos(args);
	g_videoeditor.CutSliderPosChange( args );
	g_videoeditor.RefreshCutImageView1();
}

function InitCutWindowState()
{
	if( wincut.outsourceedit.GetText() == "" )
	{
//		wincut.splittarget.SetEnable( false );
//		wincut.outtargetedit.SetEnable( false );
//		wincut.targetbtn.SetEnable( false );
		
		wincut.intervalzoomin.SetEnable( false );
		wincut.intervalzoomout.SetEnable( false );
		
		wincut.playermarkin.SetEnable( false );
		wincut.edit1.setstartpoint.SetEnable( false );
		wincut.playermarkout.SetEnable( false );
		wincut.edit1.setendpoint.SetEnable( false );
		wincut.cutterremove.SetEnable( false );
		wincut.edit1.remove1.SetEnable( false );
		wincut.imageview1edit1.remove1.SetEnable( false );
		wincut.cutterclear.SetEnable( false );
		wincut.edit1.clear.SetEnable( false );
		wincut.imageview1edit1.clear.SetEnable( false );
		wincut.playerpreviouspoint.SetEnable( false );
		wincut.edit1.skipuppoint.SetEnable( false );
		wincut.playernextfpoint.SetEnable( false );	
		wincut.edit1.skipnextpoint.SetEnable( false );
		//add by pengl
		update_player_btn_cut(4);
		//end

	}
	else
	{
		wincut.splittarget.SetEnable( true );
		wincut.outtargetedit.SetEnable( true );
		wincut.targetbtn.SetEnable( true );
		
		wincut.intervalzoomin.SetEnable( true );
		wincut.intervalzoomout.SetEnable( true );
	}
	
	if( wincut.imageview1.GetItemCount() > 0 )
	{
		wincut.cutterclear.SetEnable( true );
		wincut.edit1.clear.SetEnable( true );
		wincut.imageview1edit1.clear.SetEnable( true );
	}
	else
	{
		wincut.cutterremove.SetEnable( false );
		wincut.edit1.remove1.SetEnable( false );
		wincut.imageview1edit1.remove1.SetEnable( false );
		wincut.cutterclear.SetEnable( false );
		wincut.edit1.clear.SetEnable( false );
		wincut.imageview1edit1.clear.SetEnable( false );
		
	}
}

function OnCutOpenRegWin( args )
{
	OnOpenRegWin( wincut );
}

function SetCutShowMsgString( args )
{
	m_strCutShowMsg = args[2];
}
 
function OnCutterCut(args)
{
	//Դ
	var strPath = wincut.outsourceedit.GetText();
	if( strPath == "" )
	{
		ShowMsg(wincut, LanguageStr("_strADDFile"),Product.GetProductName(),1 );
		return;
	}
	
	//add by pengl
	onplay_stop_cut();		
	update_player_btn_cut(3);
	//end
	
	//ƵļǷ
	var bfileexist = g_videoeditor.CheckFileIsExist( strPath );
	if( !bfileexist )
	{
		g_videoeditor.GetFullMsgString( LanguageStr("_strFileNo"), strPath );
		ShowMsg(wincut, m_strCutShowMsg,Product.GetProductName(),1);
		return;
	}
	//ûǷѡ༭
	var nPointCount =  GetCutPointCount();
	if( nPointCount < 2 )
	{
		ShowMsg(wincut, LanguageStr("_strSelCutPoint"),Product.GetProductName(),1 );
		return;
	}
	//ĿļǷѡ
	var strTargetPath = wincut.outtargetedit.GetText();
	if( strTargetPath == "" )
	{
		ShowMsg(wincut, LanguageStr("_strSelTarFile"),Product.GetProductName(),1 );
		return;
	}
	//Ŀ·ǷЧ
	var filepatnIsvalid = g_videoeditor.CheckFilePathIsValid( strTargetPath );
	if( 1 == filepatnIsvalid )
	{
		ShowMsg(wincut, LanguageStr( "_pathInvalid" ), Product.GetProductName(), 1 );
		return;
	}
	else if( 2 == filepatnIsvalid )
	{
		ShowMsg(wincut, LanguageStr( "_filenameInvalid" ), Product.GetProductName(), 1 );
		return;
	}
	//ĿʣǷ<ĿļС
	var bDiskFreeSpace = g_videoeditor.CheckDiskFreeSpace( strTargetPath, LanguageStr("_strDiskFreeSpace") );
	if( !bDiskFreeSpace )
	{
		ShowMsg(wincut, nCutDiskClearSizi,Product.GetProductName(),1);
		return;
	}
	//ļϵͳǷ֧>4GB
	var bSupport = g_videoeditor.FileSystemIsSupport4GB( strTargetPath, LanguageStr( "_stragainselect" ) );
	if( !bSupport )
	{
		ShowMsg(wincut, m_strCutDisk, Product.GetProductName(), 1 );
		return;
	}
	//ĿļǷ,Ƿʹ
	var btargetfileexist = g_videoeditor.CheckFileIsExist( strTargetPath );
	if( btargetfileexist )
	{
		ShowMsg(wincut, LanguageStr( "_filecover" ), Product.GetProductName(), 2 );
		if( g_msgvalue == 1 )
		{
			var bSame = strPath == strTargetPath;//g_videoeditor.CompareSourceAndTargetPath( strPath, strTargetPath );
			if( bSame )
			{
				ShowMsg(wincut, LanguageStr( "_pathnosame" ), Product.GetProductName(), 1 );
				return;
			}
			else 
			{
				var bUse = g_videoeditor.FileIsUse( strTargetPath );
				if( bUse )
				{
					g_videoeditor.GetFullMsgString( LanguageStr("_fileIsUesd"), strTargetPath );
					ShowMsg(wincut, m_strCutShowMsg, Product.GetProductName(), 1 );
					return;
				}
			}
		}
		else if( g_msgvalue == 2 )
		{
			return;
		}
	}
	//ûѡļĿ¼Ƿд
	var bWriteFile = g_videoeditor.CheckFileIsWrite( strTargetPath );
	if( !bWriteFile )
	{
		ShowMsg(wincut, LanguageStr( "_fileiswrite" ), Product.GetProductName(), 1 );
		return;
	}
	//ʼļ
	g_videoeditor.OnStartEditor( strTargetPath );
}

function CutOnImage1RightClick( args )
{
	var item = wincut.imageview1.GetCurSel();
	if( item[0] > 0 && vcut_player_status == 0 && m_nplaystate < 0)
	{
		wincut.cutterremove.SetEnable( true );
		wincut.edit1.remove1.SetEnable( true );
		wincut.imageview1edit1.remove1.SetEnable( true );
	}
	else
	{
		wincut.cutterremove.SetEnable( false );
		wincut.edit1.remove1.SetEnable( false );
		wincut.imageview1edit1.remove1.SetEnable( false );
	}
	var picIndex = item[1];
	//ʾ
	if( item[0] > 0 )
	{
		var item1 = wincut.playslider.GetSelectRange();
		var nTemp = 0;
		for( var m = 1; m < item1[0]; ++m )
		{
			for( var n = m + 1; n < item1[0] + 1 ; ++n )
			{
				if( item1[n] < item1[m] )
				{
					nTemp = item1[n];
					item1[n] = item1[m];
					item1[m] = nTemp;
				}
			}
		}
		wincut.playslider.SetHighLight( item1[picIndex*2+1], item1[picIndex*2+2] );
	}
	else
	{
		wincut.playslider.SetHighLight( -1, -1 );
	}
	
	wincut.imageview1edit1.Popup();
}

function SetCutShowTimeString( args )
{
	cutoutwin.usedtimeshow.SetText( args[2] );
	cutoutwin.residualtimeshow.SetText( args[3] );
}

function GetCutSelectedFileTime( args )
{
	return wincut.playslider.GetSelectLength();
}

function SetCutProgressPos( args )
{
	cutoutwin.progre1.SetPos( args[2] );
	cutoutwin.progressscale.SetText( args[3] );
}

function CutFileNoSupport4GB( args )
{
	m_strCutDisk = args[2];
}

function SetCutClearDiskSize( args )
{
	nCutDiskClearSizi = args[2];
}

function OnCutSourceFile()
{
	var bret = g_videoeditor.OnAddfile();
	if( !bret )
	{
		return;
	}
	//add by pengl
	onplay_stop_cut();		
//	update_player_btn_cut(3);
	//end

	
	var strSourcePath = wincut.outsourceedit.GetText();
	if(  strSourcePath != "" )
	{
		var strTargetPath = wincut.outtargetedit.GetText();
		if(  strTargetPath != "" )
		{
			g_videoeditor.ResetTargetPath( strSourcePath, "", strTargetPath );
		}
	}
	
	
	
	//add by pengl
	onplay_stop_cut();	
	update_player_btn_cut(4);
	
	var fname = wincut.outsourceedit.GetText();
	if (fname.length > 0) {
		g_videoeditor.set_current_sel_file(fname);
		var slide_time = g_videoeditor.get_cut_file_duration();

		
		var time_val = slide_time;
		slide_time = g_videoeditor.get_integer(time_val);	
		
		wincut.playslider.SetRange(0, slide_time);
		wincut.playtime.SetText("00:00:00");
		wincut.playslider.SetPos(0);
		///////////////LiQiang 2007-07-23 15:23////////////
		InitCutWindowState();		
		wincut.splittarget.SetEnable( true );
		wincut.outtargetedit.SetEnable( true );
		wincut.targetbtn.SetEnable( true );
		wincut.intervalzoomin.SetEnable( true );
		wincut.intervalzoomout.SetEnable( true );
		wincut.playermarkin.SetEnable( true );
		wincut.edit1.setstartpoint.SetEnable( true );
		wincut.playermarkout.SetEnable( false );
		wincut.edit1.setendpoint.SetEnable( false );
		wincut.playslider.ClearTick();
		///////////////////////////////////////////////////
		update_player_btn_cut(1);
	}
	
	//end
}


function ShowCutSourceFile( args )
{
	var strPath = args[2];
	wincut.outsourceedit.SetText( strPath );
}


function OnCutTargetDirectory()
{
	var fname = wincut.outsourceedit.GetText();
	if( fname.length > 0 )
	{
		//add by pengl
		onplay_stop_cut();		
		update_player_btn_cut(3);
		//end
	}
	g_videoeditor.SelectTargetFile();
	
	if (fname.length > 0) {
		update_player_btn_cut(1);
	}
}


function ShowCutInterface( args )
{
	m_nCutFlag = 1;
	cutoutwin.outcutting.SetText( LanguageStr("_outcutting") );
	cutoutwin.cutoutputbtn.SetText( LanguageStr("_runbackground") );
	cutoutwin.cutoutputbtn.SetTipText( LanguageStr("_runbackground") );
	cutoutwin.cutabort.SetText( LanguageStr("_joinabout") );
	cutoutwin.cutabort.SetTipText( LanguageStr("_joinabout") );
	cutoutwin.progre1.SetPos( 0 );
	cutoutwin.progressscale.SetText( "0%" );
	cutoutwin.stdout.SetImage("defimage.png");
	cutoutwin.ShowModal(wincut);
}

function FinishCutterCut( args )
{
	m_nCutFlag = 2;
	if( !IsWindowVisible(hCutWnd) )
	{
		window1.RestoreWindow();
		wincut.RestoreWindow();
		g_Systray.DeleteSysTray();
	}
	cutoutwin.outcutting.SetText( LanguageStr("_FinishCut") );
	cutoutwin.cutoutputbtn.SetText( LanguageStr("_OpenTargetDirectory") );
	cutoutwin.cutoutputbtn.SetTipText( LanguageStr("_OpenTargetDirectory") );
	cutoutwin.cutabort.SetText( LanguageStr("_FinishCut2") );
	cutoutwin.cutabort.SetTipText( LanguageStr("_FinishCut2") );
	cutoutwin.progre1.SetPos( 100 );
	cutoutwin.progressscale.SetText( "100%" );
	cutoutwin.stdout.SetImage("defimage.png");
	cutoutwin.residualtimeshow.SetText( LanguageStr("_usedtimeshow") );
}

function OnCutRunBackAndOpenFiles( args )
{
	var strPath = wincut.outtargetedit.GetText();
	if( m_nCutFlag == 1 )//run background button
	{
		OnCutOutRunBackground();
	}
	else if( m_nCutFlag == 2 )//open target dirctory button
	{
		g_videoeditor.OpenTargetDirectory( strPath );
	}
}

function OnCutAbortAndFinish( args )
{
	if( m_nCutFlag == 1 )//abort button
	{
		ShowMsg(cutoutwin, LanguageStr("_IsUserConfirmCut"),Product.GetProductName(),2 );
		if( 1 == g_msgvalue )//"OK"
		{
			g_videoeditor.OnAbortEditor();
			cutoutwin.Close();
			m_nCutFlag = 0;
		}
		
	}
	else if( m_nCutFlag == 2 )//finish button
	{
		cutoutwin.Close();
		m_nCutFlag = 0;
	}
}

function ShowCutTargetDirectory( args )
{
	var strPath = args[2];
	wincut.outtargetedit.SetText( strPath );
}

function InsertBmp()
{
	//wincut.imageview1.InsertThumbNailByFileName("D:\\work\\cvsroot\\video_nls\\bin\\skin\\Xilisoft\\splitter_clearpoint.png","button",0,false);
	//wincut.imageview2.SetDir("skin\\Xilisoft");
}

function GetCutFileSourceFile( args )
{
	return wincut.outsourceedit.GetText();
}

function PopupCutExtNoSupport( args )
{
	ShowMsg(wincut, LanguageStr( "_ExtNoSupport" ), Product.GetProductName(), 1 );
}

function SetCutMarkin( args )
{
	var basictime = wincut.playslider.GetPos();
	var item1 = wincut.imageview2.GetCurSel();
	var picIndex = item1[1];
	var strTime = wincut.imageview2.GetText( picIndex, 0 );
	g_videoeditor.SetCutCurStartPointInfo( basictime, picIndex, strTime );

	
	m_nSliderFirstPos = wincut.playslider.GetPos();
	wincut.playslider.SetTick( m_nSliderFirstPos,"" );
	
	wincut.playermarkin.SetEnable( false );
	wincut.edit1.setstartpoint.SetEnable( false );
	wincut.playermarkout.SetEnable( true );	
	wincut.edit1.setendpoint.SetEnable( true );
	
}

function SetCutMarkout( args )
{
	var endpos = wincut.playslider.GetPos();
	var item2 = wincut.imageview2.GetCurSel();
	var picIndex = item2[1];
	var strTime = wincut.imageview2.GetText( picIndex, 0 );
	g_videoeditor.SetCutCurEndPointInfo( endpos, picIndex, strTime );

	wincut.playslider.ClearTick();
	wincut.playslider.AddSelRange( m_nSliderFirstPos, endpos );
	SetCutImageView1( 0 );
	
	InitCutWindowState();
	wincut.playermarkin.SetEnable( true );
	wincut.edit1.setstartpoint.SetEnable( true );
	wincut.playermarkout.SetEnable( false );
	wincut.edit1.setendpoint.SetEnable( false );
	if( m_nplaystate == -1 || m_nplaystate == 1 )
	{
		var item1 = wincut.playslider.GetSelectRange();
//		Msg( item1 );
		var nTemp = 0;
		for( var m = 1; m < item1[0]; ++m )
			for( var n = m + 1; n < item1[0] + 1 ; ++n )
			{
				if( item1[n] < item1[m] )
				{
					nTemp = item1[n];
					item1[n] = item1[m];
					item1[m] = nTemp;
				}
			}

		if( endpos < item1[item1[0]] )
		{
			if( endpos > item1[1] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
			}
			else
			{
				wincut.playerpreviouspoint.SetEnable( false );
				wincut.edit1.skipuppoint.SetEnable( false );
			}
			wincut.playernextfpoint.SetEnable( true );	
			wincut.edit1.skipnextpoint.SetEnable( true );
		}
		else
		{
			wincut.playerpreviouspoint.SetEnable( true );
			wincut.edit1.skipuppoint.SetEnable( true );
			wincut.playernextfpoint.SetEnable( false );	
			wincut.edit1.skipnextpoint.SetEnable( false );
		}
	}
	
	if( vcut_player_status == 0 )//liqiang add 2007-09-14
	{
		wincut.playerpreview.SetEnable(true); //lipeng add
	}
	//liqiang add 2007-10-17
	wincut.playslider.SetHighLight( -1, -1 );
	wincut.cutterremove.SetEnable( false );
	wincut.edit1.remove1.SetEnable( false );
	wincut.imageview1edit1.remove1.SetEnable( false );
	//add end
}

function SetCutPlaySliderRange( args )
{

	wincut.playslider.SetRange( args[2], args[3] );
}

function GetCutSliderTime( args )
{
	return wincut.playslider.GetPos();
}

function SetCutImageView1( args )
{
/*	var item1 = wincut.playslider.GetSelectRange();
	var nTemp = 0;
	for( var m = 1; m < item1[0]; ++m )
		for( var n = m + 1; n < item1[0] + 1 ; ++n )
		{
			if( item1[n] < item1[m] )
			{
				nTemp = item1[n];
				item1[n] = item1[m];
				item1[m] = nTemp;
			}
		}*/
	wincut.imageview1.ClearAllItem();

/*	for( var i = 0; i < item1[0] / 2; ++i )
	{
		g_videoeditor.SetCutImageView1( i, item1[i*2+1], item1[i*2+2] );
	}*/
	g_videoeditor.RefreshCutImageView1();
}

function ShowCutImageView1Info( args )
{
	var strBitmap = args[2];
	var nIndex = args[3];
	var timeLenght = args[4];
	var timeSpan = args[5];
	wincut.imageview1.InsertThumbNail( strBitmap,LanguageStr("_CutSnippet") + nIndex, nIndex - 1, false, "0" );


	wincut.imageview1.SetText( nIndex - 1, 1, LanguageStr("_TimeLenght") + timeLenght );
	wincut.imageview1.SetItemText( nIndex - 1, 2, timeSpan );
}

function OnCutClearView1( args )
{
	wincut.imageview1.ClearAllItem();
	wincut.playslider.ClearAllPos();
	g_videoeditor.CutClearClipInformation();
	InitCutWindowState();	
	
	wincut.playerpreviouspoint.SetEnable( false );
	wincut.edit1.skipuppoint.SetEnable( false );
	wincut.playernextfpoint.SetEnable( false );	
	wincut.edit1.skipnextpoint.SetEnable( false );	
	
	wincut.playerpreview.SetEnable(false); //lipeng add
}

function OnCutRemoveView1( args )
{
	
	var item1 = wincut.playslider.GetSelectRange();
	var nTemp = 0;
	for( var m = 1; m < item1[0]; ++m )
		for( var n = m + 1; n < item1[0] + 1 ; ++n )
		{
			if( item1[n] < item1[m] )
			{
				nTemp = item1[n];
				item1[n] = item1[m];
				item1[m] = nTemp;
			}
		}
	var obj = wincut.imageview1.GetCurSel();
	g_videoeditor.CutRemoveClipInfomation( obj[1] );

	for( var j = 0; j < obj[0]; ++j )
	{
		wincut.imageview1.DeleteItem( obj[j+1] );
		item1[obj[j+1]*2+1] = -1;
		item1[obj[j+1]*2+2] = -1;
	}
	var nCount = wincut.imageview1.GetItemCount();

	for( var l = 0; l < nCount; ++l )
	{
		wincut.imageview1.SetItemText( l, 0, LanguageStr("_CutSnippet") + (l+1) );
	}
	
	
	wincut.playslider.ClearAllPos();

	
		for( var i = 0; i < item1[0] / 2; ++i )
		{
			if( item1[i*2+1] >= 0 && item1[i*2+2] >= 0 )
			{
				wincut.playslider.AddSelRange( item1[i*2+1], item1[i*2+2] );
			}
		}
	InitCutWindowState();
	obj = wincut.imageview1.GetCurSel();
	if( obj[0] > 0 )
	{
		wincut.cutterremove.SetEnable( true );
		wincut.edit1.remove1.SetEnable( true );
		wincut.imageview1edit1.remove1.SetEnable( true );		
	}
	else
	{
		wincut.cutterremove.SetEnable( false );
		wincut.edit1.remove1.SetEnable( false );
		wincut.imageview1edit1.remove1.SetEnable( false );
	}
	
	item1 = wincut.playslider.GetSelectRange();
	var nPos = wincut.playslider.GetPos();
		if( item1[0] > 0 )
		{
			if( nPos <= item1[1] )
			{
				wincut.playerpreviouspoint.SetEnable( false );
				wincut.edit1.skipuppoint.SetEnable( false );
				wincut.playernextfpoint.SetEnable( true );	
				wincut.edit1.skipnextpoint.SetEnable( true );
			}
			else if( nPos > item1[1] && nPos < item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( true );	
				wincut.edit1.skipnextpoint.SetEnable( true );
			}
			else if( nPos >= item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( false );
				wincut.edit1.skipnextpoint.SetEnable( false );	
			}
		}
		else 
		{
			wincut.playerpreviouspoint.SetEnable( false );
			wincut.edit1.skipuppoint.SetEnable( false );
			wincut.playernextfpoint.SetEnable( false );
			wincut.edit1.skipnextpoint.SetEnable( false );	
			
		}
	
	
	//lipeng add
	var cut_item = wincut.playslider.GetSelectRange();
	if (cut_item[0] > 0) 
		wincut.playerpreview.SetEnable(true);
	else
		wincut.playerpreview.SetEnable(false);
	//end		
}

function SetCutPreviousPoint( args )
{
//	var item1 = new Array();
	var item1 = wincut.playslider.GetSelectRange();
	var nTemp = 0;
	for( var m = 1; m < item1[0]; ++m )
		for( var n = m + 1; n < item1[0] + 1 ; ++n )
		{
			if( item1[n] < item1[m] )
			{
				nTemp = item1[n];
				item1[n] = item1[m];
				item1[m] = nTemp;
			}
		}

	for( var i = item1[0]; i > 0; --i )
	{
		var pos1 = wincut.playslider.GetPos();
		if( item1[i] < pos1 )
		{
			wincut.playslider.SetPos( item1[i] );
			g_videoeditor.CutSliderPosChange( item1[i] );
			if( item1[i] == item1[1] )
			{
//				wincut.playermarkin.SetEnable( false );			
				if( item1[0] > 1 )
				{
					wincut.playerpreviouspoint.SetEnable( false );
					wincut.edit1.skipuppoint.SetEnable( false );
					wincut.playernextfpoint.SetEnable( true );	
					wincut.edit1.skipnextpoint.SetEnable( true );
				}
				else
				{
					wincut.playerpreviouspoint.SetEnable( false );
					wincut.edit1.skipuppoint.SetEnable( false );
					wincut.playernextfpoint.SetEnable( false );	
					wincut.edit1.skipnextpoint.SetEnable( false );
				}
			}
			else if( item1[i] > item1[1] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				if( item1[i] < item1[item1[0]] )
				{
					wincut.playernextfpoint.SetEnable( true );
					wincut.edit1.skipnextpoint.SetEnable( true );	
				}
				else
				{
					wincut.playernextfpoint.SetEnable( false );
					wincut.edit1.skipnextpoint.SetEnable( false );	
				}
			}
			return;	
		}
	}
}

function SetCutNextPoint( args )
{

//	var item1 = new Array();
	var item1 = wincut.playslider.GetSelectRange();
	var nTemp = 0;
	for( var m = 1; m < item1[0]; ++m )
		for( var n = m + 1; n < item1[0] + 1 ; ++n )
		{
			if( item1[n] < item1[m] )
			{
				nTemp = item1[n];
				item1[n] = item1[m];
				item1[m] = nTemp;
			}
		}

	for( var i = 1; i < item1[0] + 1; ++i )
	{
		var pos1 = wincut.playslider.GetPos();
		if( item1[i] > pos1 )
		{
			wincut.playslider.SetPos( item1[i] );
			g_videoeditor.CutSliderPosChange( item1[i] );
			if( item1[i] == item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( false );	
				wincut.edit1.skipnextpoint.SetEnable( false );
			}
			else if( item1[i] < item1[item1[0]] )
			{
				wincut.playernextfpoint.SetEnable( true );
				wincut.edit1.skipnextpoint.SetEnable( true );	
				if( item1[i] > item1[1] )
				{
					wincut.playerpreviouspoint.SetEnable( true );
					wincut.edit1.skipuppoint.SetEnable( true );
				}
				else
				{
					wincut.playerpreviouspoint.SetEnable( false );
					wincut.edit1.skipuppoint.SetEnable( false );
				}
			}
			return;	
		}
	}
}

function GetCutPointCount( args )
{
//	var item1 = new Array();
	var item1 = wincut.playslider.GetSelectRange();
	return item1[0];
}

function GetUserCutPointPos( args )
{
//	var item1 = new Array();
	var item1 = wincut.playslider.GetSelectRange();
	return item1[ args[2] ];
}

function AbortCutterCut( args )
{

//	if( g_msgvalue == 1 )
	{
//		cutoutwin.Close();
	}
//	cutoutwin.stdout.SetImage("defimage.png");
}

function CutShowStdOut( args )
{
//	cutoutwin.stdout.SetText( args[2] );
}

function CutShowStdError( args )
{
//	cutoutwin.stdError.SetText( args[2] );
}

function SetCutOutWinPic( args )
{
	cutoutwin.stdout.SetHBitmap( args[2] );
}

function ClearUserCutPoint( args )
{
	wincut.playslider.ClearAllPos();
	wincut.playslider.SetPos( 0 );
	wincut.imageview1.ClearAllItem();
	InitCutWindowState();
	wincut.playerpreviouspoint.SetEnable( false );
	wincut.edit1.skipuppoint.SetEnable( false );
	wincut.playernextfpoint.SetEnable( false );	
	wincut.edit1.skipnextpoint.SetEnable( false );
}

function CutSliderBlockPosChange( args )
{
	//lipeng add
	if( wincut.outsourceedit.GetText() == "" )
		return;
	//end

	if (vcut_player_status == 0) {

		g_videoeditor.CutSliderPosChange( args[2] );

		wincut.imageview2.SetCurSel( 2 );
		
		var item1 = wincut.playslider.GetSelectRange();
		var nMin = wincut.playslider.GetRangeMin();
		var nMax = wincut.playslider.GetRangeMax();
	/*	if( args[2] > nMin && args[2] < nMax )
			{
				wincut.playermarkin.SetEnable( true );
			}
			else
			{
				wincut.playermarkin.SetEnable( false );
			}*/
		if( item1[0] > 0 )
		{
			if( args[2] <= item1[1] )
			{
				wincut.playerpreviouspoint.SetEnable( false );
				wincut.edit1.skipuppoint.SetEnable( false );
				wincut.playernextfpoint.SetEnable( true );	
				wincut.edit1.skipnextpoint.SetEnable( true );
			}
			else if( args[2] > item1[1] && args[2] < item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( true );	
				wincut.edit1.skipnextpoint.SetEnable( true );
			}
			else if( args[2] >= item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( false );
				wincut.edit1.skipnextpoint.SetEnable( false );	
			}
		}
		else 
		{
			wincut.playerpreviouspoint.SetEnable( false );
			wincut.edit1.skipuppoint.SetEnable( false );
			wincut.playernextfpoint.SetEnable( false );
			wincut.edit1.skipnextpoint.SetEnable( false );	
			
		}
	}
	else {	
		var pos = args[2];
//		Msg( "OK1222" );
		//add by pengl
		pos = pos*1000;
		g_videoeditor.VideoSeek(pos);
		//end
	}		
}

function OnCutSliderToButtonStateChange( args )
{
		g_videoeditor.CutSliderPosChange( args );
		
		wincut.imageview2.SetCurSel( 2 );
		
		var item1 = wincut.playslider.GetSelectRange();
		var nMin = wincut.playslider.GetRangeMin();
		var nMax = wincut.playslider.GetRangeMax();

		if( item1[0] > 0 )
		{
			if( args <= item1[1] )
			{
				wincut.playerpreviouspoint.SetEnable( false );
				wincut.edit1.skipuppoint.SetEnable( false );
				wincut.playernextfpoint.SetEnable( true );	
				wincut.edit1.skipnextpoint.SetEnable( true );
			}
			else if( args > item1[1] && args < item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( true );	
				wincut.edit1.skipnextpoint.SetEnable( true );
			}
			else if( args >= item1[item1[0]] )
			{
				wincut.playerpreviouspoint.SetEnable( true );
				wincut.edit1.skipuppoint.SetEnable( true );
				wincut.playernextfpoint.SetEnable( false );
				wincut.edit1.skipnextpoint.SetEnable( false );	
			}
		}
		else 
		{
			wincut.playerpreviouspoint.SetEnable( false );
			wincut.edit1.skipuppoint.SetEnable( false );
			wincut.playernextfpoint.SetEnable( false );
			wincut.edit1.skipnextpoint.SetEnable( false );	
			
		}
}

function SetCutSliderTimeString( args )
{
	if( wincut.outsourceedit.GetText() != "" )
	{
		wincut.playtime.SetText( args[2] );
	}
}

function CutClearAllListView( args )
{
	wincut.imageview2.ClearAllItem();
}

function ShowCutPointPic( args )
{
//Msg(args[2]);
//Msg( args[3] );
	//wincut.imageview2.ClearAllItem();
	var nFile = wincut.outsourceedit.GetText();
	if( nFile != "" )
		wincut.imageview2.InsertThumbNail( args[2],args[3],	args[4], false, "0" );
}

function SetView2DefaultSel( args )
{
//	Msg( args[3] );
	wincut.imageview2.SetCurSel( args[2] );
	wincut.player.SetHBitmap( args[3] );
}

//lipeng add
function set_player_bmp(args)
{
	wincut.player.SetHBitmap( args[3] );
}
//end

function OnMenuCutSelectAll( args )
{
	var nMin = wincut.playslider.GetRangeMin();
//	Msg( nMin );
	var nMax = wincut.playslider.GetRangeMax();
//	Msg( nMax );
	wincut.playslider.AddSelRange( nMin, nMax );
	
}

function OnMenuCutInvertSel( args )
{
	var nMin = wincut.playslider.GetRangeMin();
	var nMax = wincut.playslider.GetRangeMax();
//	var item1 = new Array();
	var item1 = wincut.playslider.GetSelectRange();
	var nTempMin = nMin;
	var bUseMax = false;
	wincut.playslider.ClearAllPos();
	if( item1[0] <= 0 )
	{
		wincut.playslider.AddSelRange( nMin, nMax );
	}
	else
	{
		for( var i = 0; i < item1[0]; ++i )
		{
			bUseMax = false;
			if( i % 2 == 0 )
			{
				if( item1[i+1] > nTempMin )
				{
					wincut.playslider.AddSelRange( nTempMin, item1[i+1] );
				}
			}
			else
			{
				if( item1[i+1] < nMax )
				{
					nTempMin = item1[i+1];
					bUseMax = true;
				}
			}
		}
		if( bUseMax )
			wincut.playslider.AddSelRange( nTempMin, nMax );
	}
}

function OnCutVolume( args )
{
	if( m_nCutPlayVolume == 1 )
	{
		m_nCutPlayVolume = 2;
		wincut.playervolume.SetImage( "joiner_mute.png" );
		g_videoeditor.SetVolumeMute( 1 );
	}
	else if( 2 == m_nCutPlayVolume )
	{
		m_nCutPlayVolume = 1;
		wincut.playervolume.SetImage("joiner_volume.png");
		g_videoeditor.SetVolumeMute( 0 );
	}
}

function OnCutVolumeChange( args )
{
	g_videoeditor.SetVolumeChange( args[2] );
}

function DisableCutMuteVolume( args )
{
	wincut.playervolume.SetEnable( false );
	wincut.volumeslider.SetEnable( false );
}

function OnCutIntervalZoomIn( args )
{
	//һΪŴСʱ,ڶ:ŴС
	g_videoeditor.OnCutIntervalZoom( 300, 0 );
}

function OnCutIntervalZoomOut( args )
{
	g_videoeditor.OnCutIntervalZoom( 300, 1 );
}

function CutDisableZoomIn( args )
{
	wincut.intervalzoomin.SetEnable( false );
}

function CutDisableZoomOut( args )
{
	wincut.intervalzoomout.SetEnable( false );
}

function CutEnableZoom( args )
{
	wincut.intervalzoomin.SetEnable( true );
	wincut.intervalzoomout.SetEnable( true );
}

function ErrorCutterCut( args )
{
	ShowMsg(cutoutwin, LanguageStr("_errorcutting"), Product.GetProductName(), 1 );
	if( 1 == g_msgvalue )
	{
		cutoutwin.Close();
		m_nCutFlag = 0;
	}
	cutoutwin.stdout.SetImage("defimage.png");
}

function OnclickCutImageView2( args )
{
	if( wincut.outsourceedit.GetText() != "" )
	{
		var item1 = wincut.imageview2.GetCurSel();
		if( item1[0] > 0 )
		{
			var picIndex = item1[1];
			var nTime = wincut.playslider.GetPos();
			g_videoeditor.OnclickImageView2( picIndex, nTime );
		}
	}
}

function OnclickCutImageView11( args )
{
	var item1s = wincut.imageview1.GetCurSel();
	var picIndex = item1s[1];
	if( item1s[0] > 0 && vcut_player_status == 0 && m_nplaystate < 0 )
	{
		wincut.cutterremove.SetEnable( true );
		wincut.edit1.remove1.SetEnable( true );
		wincut.imageview1edit1.remove1.SetEnable( true );
	}
	else
	{
		wincut.cutterremove.SetEnable( false );
		wincut.edit1.remove1.SetEnable( false );
		wincut.imageview1edit1.remove1.SetEnable( false );
	}
	
	//ʾ
	if( item1s[0] > 0 )
	{
		var item1 = wincut.playslider.GetSelectRange();
		var nTemp = 0;
		for( var m = 1; m < item1[0]; ++m )
		{
			for( var n = m + 1; n < item1[0] + 1 ; ++n )
			{
				if( item1[n] < item1[m] )
				{
					nTemp = item1[n];
					item1[n] = item1[m];
					item1[m] = nTemp;
				}
			}
		}
		wincut.playslider.SetHighLight( item1[picIndex*2+1], item1[picIndex*2+2] );
	}
	else
	{
		wincut.playslider.SetHighLight( -1, -1 );
	}
}

//˫
function CutOnDoubleClickIV1( args )
{
//Msg( "OK" );
	var sum = 0;
	var item1;
	item1 = wincut.playslider.GetSelectRange();

	sum = item1[0];
	if (sum <= 0) 
	{
		return;
	}
	
	var array1 = wincut.imageview1.GetCurSel();
	if( array1[0] <= 0 )
	{
		return;
	}
	
	
		//lipeng add 2007-8-1
	cut_point_item = wincut.playslider.GetSelectRange();		
	
	//liqiang add	2007-08-16
	var nTemp = 0;
	for( var m = 1; m < cut_point_item[0]; ++m ) 
		for( var n = m + 1; n < cut_point_item[0] + 1 ; ++n )
		{
			if( cut_point_item[n] < cut_point_item[m] )
			{
				nTemp = cut_point_item[n];
				cut_point_item[n] = cut_point_item[m];
				cut_point_item[m] = nTemp;
			}
		}
//		Msg(cut_point_item);
	//liqiang add	

	
	var start_point = cut_point_item[array1[1] *2 + 1]; //item1[1];

	if (vcut_player_status == 0) {
		var str_fn = g_videoeditor.get_current_play_file();
		if (str_fn.length <= 0) {
			return 1;
		}
		var start_play = 1;
		vcut_player_status = 1;
		g_videoeditor.player_manipulation(start_play, str_fn);		

		wincut.playerpreview.SetImage( "joiner_Pause.png" );
		wincut.playerpreview.SetTipText( LanguageStr("_playerpause1") );//LiQiang 2007-07-20 14:18
		
		m_nplaystate = 0;//LiQiang 2007-07-28 play
		update_cut_btn_state_onplay(1);//LiQiang 2007-07-27 play
	}
	else {
		onplay_stop_cut();
	/*	vcut_player_status = 0
		var pause_play = 2;
		g_videoeditor.player_manipulation(pause_play);
		wincut.playerpreview.SetImage("joiner_preview.png");
		wincut.playerpreview.SetTipText(LanguageStr("_playerplay2"));//LiQiang 2007-07-20 14:18
		
		m_nplaystate = 1;//LiQiang 2007-07-28 pause
		update_cut_btn_state_onplay(2);//pause//LiQiang 2007-07-27 play
	*/
	}
	
	if( vcut_player_status == 0 )
	{
		return;
	}
	
	update_player_btn_cut(7);
	if (start_preview_with_begins != 0) {
		return;
	}
	
	start_preview_with_begins = 1;



//	play_all = 0;
	var pos = wincut.playslider.GetPos();
	if(pos > 0) {
		pos++;
		g_videoeditor.VideoSeek(pos*1000); //in milliseconds
		wincut.playslider.SetPos(pos); //in senconds
	}
	else {
		wincut.playslider.SetPos(start_point); //in senconds
		g_videoeditor.VideoSeek(start_point*1000); //in milliseconds
	}
	
	play_all = 2;
	//end
}

function CutSliderBlockStateChange( args )
{
	var nPos = wincut.playslider.GetPos();
	var item1 = wincut.playslider.GetAllTick();
//	var nMin = wincut.playslider.GetRangeMin();
//	var nMax = wincut.playslider.GetRangeMax();
	
	if( nPos < item1[1] )
	{
		wincut.playerpreviouspoint.SetEnable( false );
		wincut.edit1.skipuppoint.SetEnable( false );
		wincut.playernextfpoint.SetEnable( true );
		wincut.edit1.skipnextpoint.SetEnable( true );
	}
	else if( nPos > item1[1] )
	{
		if( nPos >= item1[item1[0]] )
		{
			wincut.playerpreviouspoint.SetEnable( true );
			wincut.edit1.skipuppoint.SetEnable( true );
			wincut.playernextfpoint.SetEnable( false );
			wincut.edit1.skipnextpoint.SetEnable( false );
		}
		else
		{
			wincut.playerpreviouspoint.SetEnable( true );
			wincut.edit1.skipuppoint.SetEnable( true );
			wincut.playernextfpoint.SetEnable( true );
			wincut.edit1.skipnextpoint.SetEnable( true );
		}
	}
	else
	{
		if( nPos >= item1[item1[0]] )
		{
			wincut.playerpreviouspoint.SetEnable( false );
			wincut.edit1.skipuppoint.SetEnable( false );
			wincut.playernextfpoint.SetEnable( false );
			wincut.edit1.skipnextpoint.SetEnable( false );
		}
		else
		{
			wincut.playerpreviouspoint.SetEnable( true );
			wincut.edit1.skipuppoint.SetEnable( true );
			wincut.playernextfpoint.SetEnable( true );
			wincut.edit1.skipnextpoint.SetEnable( false );
		}
	}

}

function CutTargetEditKillFocus( args )
{
	var strTargetPath = wincut.outtargetedit.GetText();
	if( strTargetPath == "" )
	{
		return;
	}
	var bDir = g_videoeditor.PathIsDirectory( strTargetPath );
	if( !bDir )
	{
		var strSourcePath = wincut.outsourceedit.GetText();
		g_videoeditor.ResetTargetPath( strSourcePath, "", strTargetPath );
	}
	else
	{
		return;
	}
}


/////////////////////////////////////////////////////////////////////////////////////
//add by pengl
function on_player_move(args) 
{
	g_videoeditor.on_player_win_move();			
}

var play_all = 0;
var vcut_player_status = 0;
function onplay_start_cut()
{
	play_all = 0;
	if (vcut_player_status == 0) {
		var str_fn = g_videoeditor.get_current_play_file();
		if (str_fn.length <= 0) {
			return 1;
		}
		var start_play = 1;
		vcut_player_status = 1;
		g_videoeditor.player_manipulation(start_play, str_fn);		
		wincut.player1.SetImage( "joiner_Pause.png" );
		wincut.player1.SetTipText( LanguageStr("_playerpause1") );//LiQiang 2007-07-20 14:18
		update_player_btn_cut(2);
		
		m_nplaystate = 0;//LiQiang 2007-07-28 play
		update_cut_btn_state_onplay(1);//LiQiang 2007-07-27 play
	}
	else {
		vcut_player_status = 0;
		var pause_play = 2;
		g_videoeditor.player_manipulation(pause_play);
		update_player_btn_cut(6);
		wincut.player1.SetImage("joiner_play.png");
		wincut.player1.SetTipText(LanguageStr("_playerplay1"));//LiQiang 2007-07-20 14:18
		
		m_nplaystate = 1;//LiQiang 2007-07-28 pause
		update_cut_btn_state_onplay(2);//pause//LiQiang 2007-07-27 pause
	}
	
	
	// lipeng add 2007-8-1 
	var pos = wincut.playslider.GetPos()+1;
	g_videoeditor.VideoSeek(pos*1000); //in milliseconds
	// end
	return 1;
}


var cut_point_item; //all cutting time points
//var play_all_cut_point_index = -1;
var start_preview_with_begins = 0;
function onplay_all_cut()
{
	var sum = 0;
	var item1;
	item1 = wincut.playslider.GetSelectRange();

	sum = item1[0];
	if (sum <= 0) {
		return;
	}
	
	
		//lipeng add 2007-8-1
	cut_point_item = wincut.playslider.GetSelectRange();		
	
	//liqiang add	2007-08-16
	var nTemp = 0;
	for( var m = 1; m < cut_point_item[0]; ++m ) 
		for( var n = m + 1; n < cut_point_item[0] + 1 ; ++n )
		{
			if( cut_point_item[n] < cut_point_item[m] )
			{
				nTemp = cut_point_item[n];
				cut_point_item[n] = cut_point_item[m];
				cut_point_item[m] = nTemp;
			}
		}
//		Msg(cut_point_item);
	//liqiang add	

	
	var start_point = cut_point_item[1]; //item1[1];

	if (vcut_player_status == 0) {
		var str_fn = g_videoeditor.get_current_play_file();
		if (str_fn.length <= 0) {
			return 1;
		}
		var start_play = 1;
		vcut_player_status = 1;
		g_videoeditor.player_manipulation(start_play, str_fn);		

		wincut.playerpreview.SetImage( "joiner_Pause.png" );
		wincut.playerpreview.SetTipText( LanguageStr("_playerpause1") );//LiQiang 2007-07-20 14:18
		
		m_nplaystate = 0;//LiQiang 2007-07-28 play
		update_cut_btn_state_onplay(1);//LiQiang 2007-07-27 play
	}
	else {
		vcut_player_status = 0
		var pause_play = 2;
		g_videoeditor.player_manipulation(pause_play);
		wincut.playerpreview.SetImage("joiner_preview.png");
		wincut.playerpreview.SetTipText(LanguageStr("_playerplay2"));//LiQiang 2007-07-20 14:18
		
		m_nplaystate = 1;//LiQiang 2007-07-28 pause
		update_cut_btn_state_onplay(2);//pause//LiQiang 2007-07-27 play
	}
	
	update_player_btn_cut(7);
	if (start_preview_with_begins != 0) {
		return;
	}
	
	start_preview_with_begins = 1;



//	play_all = 0;
	var pos = wincut.playslider.GetPos();
	if(pos > 0) {
		pos++;
		g_videoeditor.VideoSeek(pos*1000); //in milliseconds
		wincut.playslider.SetPos(pos); //in senconds
	}
	else {
		wincut.playslider.SetPos(start_point); //in senconds
		g_videoeditor.VideoSeek(start_point*1000); //in milliseconds
	}
	
	play_all = 1;
	//end
}

function onplay_previous_cut()
{
	var previous = 3
	g_videoeditor.player_manipulation(previous);
}

function onplay_next_cut()
{
	var next = 4;
	g_videoeditor.player_manipulation(next);
}

function onplay_stop_cut()
{
	var stop = 5;
	
	m_nplaystate = -1;	
	play_all = 0;
	vcut_player_status = 0;
	start_preview_with_begins = 0;
	play_all_file_index = -1;
	g_videoeditor.play_all_video(0);
	
	g_videoeditor.player_manipulation(stop);
	wincut.player1.SetImage("joiner_play.png");
	wincut.playerpreview.SetImage("joiner_preview.png");
	wincut.player.SetImage("defimage.png")
	wincut.player1.SetTipText(LanguageStr("_playerplay1"));
	wincut.playerpreview.SetTipText(LanguageStr("_playerplay2"));
	wincut.playtime.SetText("00:00:00");
	wincut.playslider.SetPos(0);
	update_player_btn_cut(3);
	
	//liqiang add
	var fname = wincut.outsourceedit.GetText();
	if (fname.length > 0) 
	{
//		OnCutSliderToButtonStateChange(0);
		update_cut_btn_state_onplay(0);
	}
	//end
}

function update_player_btn_cut(args)
{
	if (args == 1) { //before start play
		wincut.player1.SetEnable(true);
		
		var item1 = wincut.playslider.GetSelectRange();
		if (item1[0] > 0) 
			wincut.playerpreview.SetEnable(true);
		else
			wincut.playerpreview.SetEnable(false);
			
		wincut.playerprevious.SetEnable(false);
		wincut.playernext.SetEnable(false); //next
		wincut.playerstop.SetEnable(false); //previous
	}
	else if (args == 2) { //has played
		wincut.player1.SetEnable(true);
		wincut.playerpreview.SetEnable(false);
		wincut.playerprevious.SetEnable(true);
		wincut.playernext.SetEnable(true); //next
		wincut.playerstop.SetEnable(true); //previous
	}		
	else if (args == 3) { //after click stop
		wincut.player1.SetEnable(true);
		//add liqiang 2007-09-20
		var item1 = wincut.playslider.GetSelectRange();
		//add end
		if( item1[0] > 0 )//add liqiang 2007-09-20
		{
			wincut.playerpreview.SetEnable(true);
		}
		else//add liqiang 2007-09-20
		{
			wincut.playerpreview.SetEnable(false);//add liqiang 2007-09-20
		}
		
		wincut.playerprevious.SetEnable(false);
		wincut.playernext.SetEnable(false); //next
		wincut.playerstop.SetEnable(false); //previous
	}
	else if (args == 4) { //when the mouse clicked a null items with the ctrllist
		wincut.player1.SetEnable(false);
		wincut.playerpreview.SetEnable(false);
		wincut.playerprevious.SetEnable(false);
		wincut.playernext.SetEnable(false); //next
		wincut.playerstop.SetEnable(false); //previous
	}
	else if (args == 5) { //playall button
//		wincut.player1.SetEnable(false);
		wincut.playerpreview.SetEnable(false);
		wincut.playerprevious.SetEnable(true);
		wincut.playernext.SetEnable(true); //next
		wincut.playerstop.SetEnable(true); //previous
	}
	else if (args == 6) { //after click play
		wincut.player1.SetEnable(true);
		wincut.playerpreview.SetEnable(false);
		wincut.playerprevious.SetEnable(false);
		wincut.playernext.SetEnable(false); //next
		wincut.playerstop.SetEnable(true); //previous
	}
	else if (args == 7) { //after click play all item 
		wincut.player1.SetEnable(false);
		wincut.playerpreview.SetEnable(true);
		wincut.playerprevious.SetEnable(true);
		wincut.playernext.SetEnable(true); //next
		wincut.playerstop.SetEnable(true); //previous
	}
}

function play_stop_cut()
{
	var stop = 5;
	g_videoeditor.player_manipulation(stop);
	wincut.player.SetImage("defimage.png") 
	wincut.playtime.SetText("00:00:00");
	wincut.playslider.SetPos(0);
	vcut_player_status = 0;
	play_all = 0;
	wincut.player1.SetImage("joiner_play.png");
	wincut.playerpreview.SetImage("joiner_preview.png");
	wincut.player1.SetTipText(LanguageStr("_playerplay1"));
	wincut.playerpreview.SetTipText(LanguageStr("_playerplay2"));
	update_player_btn_cut(3);
	
	//liqiang add 2007-09-07 20:12
	var fname = wincut.outsourceedit.GetText();
	if (fname.length > 0) 
	{
		OnCutSliderToButtonStateChange(0);
	}
	//end
}


function OnMessage_cut(args)
{
	var msg = args[2];
	
	if(msg == 2007001) {
		var str = args[3];
		var timedisp = "00:00:00";
		var timepos = 0;
		
		if (str.indexOf("[???]") != -1) {
			var nNum = 0;
			var strarray = str.split("[???]");
			if (strarray.length < 2) {
				timedisp = "00:00:00";
				timpos = 0;
			}
			else {
				timedisp = strarray[0];
				timepos = strarray[1];
			}
		}
		else {
			timedisp = "00:00:00";
			timepos = 0;
		}
		
//		timepos = timepos/1000;
		var time_val = timepos;
//		Msg(timepos);
		timepos = g_videoeditor.get_integer(time_val);


		var position = wincut.playslider.GetPos();
		var delta = position - timepos;
		if (delta > 2 || delta < -2) {
			timepos = position;
		}
		
		wincut.playtime.SetText(timedisp);
		wincut.playslider.SetPos(timepos);
		
		// play after edit clip different from direct play 
		if(play_all == 1) 
		{
			var ret = point_in_range(timepos);
//			Msg(ret);
			if (ret == 0) {
				ret = get_next_range(timepos);			
				if (ret != 0) {
					var point = cut_point_item[ret*2-1]; //start time
//					Msg(point);
					g_videoeditor.VideoSeek(point*1000);
					wincut.playslider.SetPos(point);
				}
				else
				{ 
					play_all = 0;
					onplay_stop_cut();
				}
			}
		}
		else if( 2 == play_all )//add liqiang 2007-09-12
		{
			var ret = point_in_range(timepos);
//			Msg(ret);
			if (ret == 0) 
			{
				play_all = 0;
				onplay_stop_cut();
			}
		}
		//add end liqiang
	}		
	if(msg == 2007002) { //play stop
		play_stop_cut();
		update_player_btn_cut(3);
	}
	if (msg == 2007003) {
		onplay_stop_cut();
		update_player_btn_cut(3);
	}
	if (msg == 2007004) { //play all video flag
		play_stop_cut();
		onplay_all_cut();
	}	
}

function point_in_range(args)
{
	var num = cut_point_item[0]/2;
	var point = args;

	for(var index = 0; index < num; index++)
	{
		var start = cut_point_item[index*2+1];		
		var end = cut_point_item[index*2+2];
		
//		Msg(point);
//		Msg(start);
//		Msg(end);
		if (point >= start-1 && point <= end) {
			return index+1;
		}
	}
	
	return 0;
}

function get_next_range(args)
{
	var point = args;
	var num = cut_point_item[0]/2;
	for(var index = 0; index < num; index++)
	{
		var start = cut_point_item[index*2+1];
//		var end = cut_point_item[index*2+2];
		
		if (point < start) {
			return index+1;
		}
		else
			continue;
	}
	
	return 0;
}


function seek_set(args)
{
	var timepos = args;

			
	wincut.playslider.SetPos(timepos);
		
	// play after edit clip different from direct play 
	if(play_all == 1) 
	{
		var ret = point_in_range(timepos);
		if (ret == 0) {
			ret = get_next_range(timepos);			
			if (ret != 0) {
				var point = cut_point_item[ret*2-1]; //start time
//				Msg(point);
				g_videoeditor.VideoSeek(point*1000);
				wincut.playslider.SetPos(point);
			}
			else
			{ 
				play_all = 0;
				onplay_stop_cut();
			}
		}
	}
}

//add liqiang 2007-08-27
function update_cut_btn_state_onplay(args)
{
	var nPos = wincut.playslider.GetPos();
	var nMin = wincut.playslider.GetRangeMin();
	var nMax = wincut.playslider.GetRangeMax();
	var item = wincut.imageview1.GetCurSel();
	
	if (args == 1/*play*/) 
	{
		wincut.playerpreviouspoint.SetEnable( false );
		wincut.edit1.skipuppoint.SetEnable( false );
		wincut.playernextfpoint.SetEnable( false );	
		wincut.edit1.skipnextpoint.SetEnable( false );
		
		wincut.cutterremove.SetEnable( false );
		wincut.edit1.remove1.SetEnable( false );
		wincut.imageview1edit1.remove1.SetEnable( false );
		wincut.cutterclear.SetEnable( false );
		
		wincut.edit1.clear.SetEnable( false );
		wincut.imageview1edit1.clear.SetEnable( false );
//		Msg( "OK" );
	}
	else if(args == 2/*pause*/)
	{
//		CutSliderBlockStateChange();
		OnCutSliderToButtonStateChange(nPos);
	}
	else if (args == 0/*stop*/) 
	{
//		CutSliderBlockStateChange();
		OnCutSliderToButtonStateChange(nPos);
		
		if( item[0] > 0 )
		{
			wincut.cutterremove.SetEnable( true );
			wincut.edit1.remove1.SetEnable( true );
			wincut.imageview1edit1.remove1.SetEnable( true );
		}
		else
		{
			wincut.cutterremove.SetEnable( false );
			wincut.edit1.remove1.SetEnable( false );
			wincut.imageview1edit1.remove1.SetEnable( false );
		}
		if( wincut.imageview1.GetItemCount() > 0 )
		{
			wincut.cutterclear.SetEnable( true );
			wincut.edit1.clear.SetEnable( true );
			wincut.imageview1edit1.clear.SetEnable( true );
		}
		else
		{
			wincut.cutterremove.SetEnable( false );
			wincut.edit1.remove1.SetEnable( false );
			wincut.imageview1edit1.remove1.SetEnable( false );
			wincut.cutterclear.SetEnable( false );
			wincut.edit1.clear.SetEnable( false );
			wincut.imageview1edit1.clear.SetEnable( false );
			
		}
	}
}
//addend


//end
/////////////////////////////////////////////////////////////////////////////////////