LoadScript("PackagePub.js");

var debug1 = IsDebug();
if( debug1 )
{
	LoadLib("videoeditordll_dbg.dll");
	LoadLib("systray_d.dll");
	LoadLib("update_d.dll");
}
else
{
	LoadLib("videoeditordll.dll");
	LoadLib("systray.dll");
	LoadLib("update.dll");
}

var WM_RBUTTONUP = 517;
var WM_LBUTTONDBLCLK = 515;
var WM_LBUTTONUP = 514;

var ve3 = new VideoEditor();
ExportObj(ve3,"g_videoeditor");
var g_Systray = new SystrayIcon();
var m_faceinterface = 0;//main face

var m_strRegExplainWord = "";

//6001~6500
var MainAccelKeyMap =
[
	[6001, "", 106],//j
	[6002, "", 74],//J
	
	[6003, "", 115],//s
	[6004, "", 83],//S
	
	[6005, "", 99],//c
	[6006, "", 67],//C
	
	[6007, "", 107],//k
	[6008, "", 75],//K
	
	[6009, "", 108],//l
	[6010, "", 76],//L
	
	[6011, "", 104],//h
	[6012, "", 72],//H
	
	[6013, "", 114],//r
	[6014, "", 82],//R
	
	[6015, "", 98],//b
	[6016, "", 66],//B
	
	[6017, "", 102],//f
	[6018, "", 70],//F
];
	


InitMainWindow();


function OnHotKeySet( args )
{
	switch( args[2] )
	{
		case 6001:
		case 6002:
			InitJoinWindow();
			winjoin.ShowModal(window1, true);
			break;
		case 6003:
		case 6004:
			InitSplitWindow();
			winsplit.ShowModal(window1, true);
			break;
		case 6005:
		case 6006:
			InitCutWindow();
			wincut.ShowModal(window1, true);
			break;
		case 6007:
		case 6008:
		//	window1.facecombo.Focus();//UILIB8δʵ
			break;
		case 6009:
		case 6010:
		//	window1.langcombo.Focus();//UILIB8δʵ
			break;
		case 6011:
		case 6012:
			onopenhelp();
			break;
		case 6013:
		case 6014:
			OnOpenRegWin();
			break;
		case 6015:
		case 6016:
			OnGoBuy();
			break;
		case 6017:
		case 6018:
			OnGoSupport();
			break;
			
	}
}


function InitMainWindow()
{
	initreg();
	//Ƥ
	var nIndex = Product.GetInt("skinindex", "", -1 );
	var str1;

	if( nIndex < 0 )
	{
		Product.SetInt( "skinindex", 1 );
		str1 = window1.facecombo.GetData( 1 );
		window1.facecombo.SetCurSel( 1 );

		LoadSkin( str1 );
		Product.SetString( "SkinName", str1 );
	}
	else
	{
		str1 = window1.facecombo.GetData( nIndex );
		window1.facecombo.SetCurSel( nIndex );

		LoadSkin( str1 );
		
		Product.SetString( "SkinName", str1 );
	}
	//
	var strlang = Product.GetString( "language" );
	
	if( strlang == "" )
	{
		strlang = Product.GetDefaultLanguage();
		
	}
	Product.SetString( "language", strlang );
	window1.langcombo.SetCurSelByData( strlang );

	RefreshLanguage( strlang );
	
	var nIndex1 = window1.langcombo.GetCurSel();
	nIndex = window1.facecombo.GetCurSel();
	AdjustLangAndSkinStatus( nIndex, nIndex1 );
	OnGoMenuBuy();
	
	window1.SetTitle( Product.GetProductName() );
	//ݼ UILIb8δ޸ĺ,ʱ
//	window1.RegisterAccelHandle( MainAccelKeyMap,"OnHotKeySet");
}

function MainSkinChange( args )
{
	LoadSkin( args[4] );
	Product.SetString( "SkinName", args[4] );
	AdjustLangAndSkinStatus( args[2], -1 );
}

function MainLanguageChange( args )
{
	RefreshLanguage( args[4] );
	Product.SetString( "language", args[4] );
	AdjustLangAndSkinStatus( -1, args[2] );
	OnGoMenuBuy();
}


var winjoinshow= false;
var winsplitshow = false;
var wincutshow = false;
function OnSelectFunction( args )
{
		if(args[2] == -1) return;
		
		if( args[2] == 1 )
		{
//			winjoinshow = true;
			//window1.SetVisible( false );
			//window1.Minimize();
			m_faceinterface = 1;
			InitJoinWindow();
			winjoin.Refresh();
			winjoin.ShowModal( window1 );
		}
		else if( args[2] == 2 )
		{
//			winsplitshow = true;
			//window1.SetVisible( false );
			//window1.Minimize();
			m_faceinterface = 2;
			InitSplitWindow();
			winsplit.Refresh();
			winsplit.ShowModal( window1 );
			
		}
		else if( args[2] == 3 )
		{
//			wincutshow = true;
			//window1.SetVisible( false );
			//window1.Minimize();
			m_faceinterface = 3;
			InitCutWindow();
			wincut.Refresh();
			wincut.ShowModal( window1 );
		}
}

function OnGoMenuBuy()
{
	InitBuyMenu();
	refreshbuymenu();
	changelang();
}

function AdjustLangAndSkinStatus( args1, args2 )
{//args1 = face;args2 = lang
	//Main
	if( args1 >= 0 )
		window1.facecombo.SetCurSel( args1 );
	if( args2 >= 0 )
	{
		window1.langcombo.SetCurSel( args2 );
//		
	}
	//Join
	if( 0 == args1 )//imtoo
	{
		window1.sysmenu.face.f1.SetCheck( true );
		window1.sysmenu.face.f2.SetCheck( false );
		winjoin.tools1.face.f1.SetCheck( true );
		winjoin.tools1.face.f2.SetCheck( false );
		winsplit.tools1.face.f1.SetCheck( true );
		winsplit.tools1.face.f2.SetCheck( false );
		wincut.tools1.face.f1.SetCheck( true );
		wincut.tools1.face.f2.SetCheck( false );
	
	}
	else if( 1 == args1 )
	{
		window1.sysmenu.face.f1.SetCheck( false );
		window1.sysmenu.face.f2.SetCheck( true );
		winjoin.tools1.face.f1.SetCheck( false );
		winjoin.tools1.face.f2.SetCheck( true );
		winsplit.tools1.face.f1.SetCheck( false );
		winsplit.tools1.face.f2.SetCheck( true );
		wincut.tools1.face.f1.SetCheck( false );
		wincut.tools1.face.f2.SetCheck( true );
	}
	
	if( 0 == args2 )//Chinese
	{
		window1.gbutton.SetxOffset( 1, 38 );
		window1.gbutton.SetxOffset( 2, 36 );
		window1.gbutton.SetxOffset( 3, 38 );
		window1.sysmenu.lang.chs.SetCheck( true );
		window1.sysmenu.lang.ens.SetCheck( false );
		window1.sysmenu.lang.deu.SetCheck( false );
		window1.sysmenu.lang.jap.SetCheck( false );
		winjoin.tools1.lang.chs.SetCheck( true );
		winjoin.tools1.lang.ens.SetCheck( false );
		winjoin.tools1.lang.deu.SetCheck( false );
		winjoin.tools1.lang.jap.SetCheck( false );
		winsplit.tools1.lang.chs.SetCheck( true );
		winsplit.tools1.lang.ens.SetCheck( false );
		winsplit.tools1.lang.deu.SetCheck( false );
		winsplit.tools1.lang.jap.SetCheck( false );
		wincut.tools1.lang.chs.SetCheck( true );
		wincut.tools1.lang.ens.SetCheck( false );
		wincut.tools1.lang.deu.SetCheck( false );
		wincut.tools1.lang.jap.SetCheck( false );
		aboutwin.aboutsta.SetText( LanguageStr("_about") + " " + Product.GetProductName() );
		window1.sysmenu.buy1.SetText( LanguageStr("_buy")+" " + Product.GetProductName());
	window1.sysmenu.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	winjoin.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winjoin.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	winsplit.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winsplit.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	wincut.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	wincut.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
		RefreshShowText();
		
		winsplit.Refresh();
	}
	else if( 1 == args2 )//English
	{
		window1.gbutton.SetxOffset( 1, 40 );
		window1.gbutton.SetxOffset( 2, 42 );
		window1.gbutton.SetxOffset( 3, 46 );
		window1.sysmenu.lang.chs.SetCheck( false );
		window1.sysmenu.lang.ens.SetCheck( true );
		window1.sysmenu.lang.deu.SetCheck( false );
		window1.sysmenu.lang.jap.SetCheck( false );
		winjoin.tools1.lang.chs.SetCheck( false );
		winjoin.tools1.lang.ens.SetCheck( true );
		winjoin.tools1.lang.deu.SetCheck( false );
		winjoin.tools1.lang.jap.SetCheck( false );
		winsplit.tools1.lang.chs.SetCheck( false );
		winsplit.tools1.lang.ens.SetCheck( true );
		winsplit.tools1.lang.deu.SetCheck( false );
		winsplit.tools1.lang.jap.SetCheck( false );
		wincut.tools1.lang.chs.SetCheck( false );
		wincut.tools1.lang.ens.SetCheck( true );
		wincut.tools1.lang.deu.SetCheck( false );
		wincut.tools1.lang.jap.SetCheck( false );
		aboutwin.aboutsta.SetText( LanguageStr("_about") + " " + Product.GetProductName() );
		window1.sysmenu.buy1.SetText( LanguageStr("_buy")+" " + Product.GetProductName());
	window1.sysmenu.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	winjoin.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winjoin.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	winsplit.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winsplit.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	wincut.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	wincut.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
		RefreshShowText();
		winsplit.Refresh();
	}
	else if( 2 == args2 )//Deutsch
	{
		window1.gbutton.SetxOffset( 1, 7 );
		window1.gbutton.SetxOffset( 2, 33 );
		window1.gbutton.SetxOffset( 3, 13 );
		window1.sysmenu.lang.chs.SetCheck( false );
		window1.sysmenu.lang.ens.SetCheck( false );
		window1.sysmenu.lang.deu.SetCheck( true );
		window1.sysmenu.lang.jap.SetCheck( false );
		winjoin.tools1.lang.chs.SetCheck( false );
		winjoin.tools1.lang.ens.SetCheck( false );
		winjoin.tools1.lang.deu.SetCheck( true );
		winjoin.tools1.lang.jap.SetCheck( false );
		winsplit.tools1.lang.chs.SetCheck( false );
		winsplit.tools1.lang.ens.SetCheck( false );
		winsplit.tools1.lang.deu.SetCheck( true );
		winsplit.tools1.lang.jap.SetCheck( false );
		wincut.tools1.lang.chs.SetCheck( false );
		wincut.tools1.lang.ens.SetCheck( false );
		wincut.tools1.lang.deu.SetCheck( true );
		wincut.tools1.lang.jap.SetCheck( false );
		aboutwin.aboutsta.SetText( LanguageStr("_about") + " " + Product.GetProductName() );
		window1.sysmenu.buy1.SetText( LanguageStr("_buy")+" " + Product.GetProductName());
	window1.sysmenu.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	winjoin.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winjoin.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	winsplit.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winsplit.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
	wincut.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	wincut.help1.aboutwin.SetText( LanguageStr("_about")+" "+ Product.GetProductName() );
		RefreshShowText();
		winsplit.Refresh();
	}
	else if( 3 == args2 )//Japanese
	{
		window1.gbutton.SetxOffset( 1, 38 );
		window1.gbutton.SetxOffset( 2, 35 );
		window1.gbutton.SetxOffset( 3, 23 );
		window1.sysmenu.lang.chs.SetCheck( false );
		window1.sysmenu.lang.ens.SetCheck( false );
		window1.sysmenu.lang.deu.SetCheck( false );
		window1.sysmenu.lang.jap.SetCheck( true );
		winjoin.tools1.lang.chs.SetCheck( false );
		winjoin.tools1.lang.ens.SetCheck( false );
		winjoin.tools1.lang.deu.SetCheck( false );
		winjoin.tools1.lang.jap.SetCheck( true );
		winsplit.tools1.lang.chs.SetCheck( false );
		winsplit.tools1.lang.ens.SetCheck( false );
		winsplit.tools1.lang.deu.SetCheck( false );
		winsplit.tools1.lang.jap.SetCheck( true );
		wincut.tools1.lang.chs.SetCheck( false );
		wincut.tools1.lang.ens.SetCheck( false );
		wincut.tools1.lang.deu.SetCheck( false );
		wincut.tools1.lang.jap.SetCheck( true );
		aboutwin.aboutsta.SetText( Product.GetProductName() + " " + LanguageStr("_about") );
		window1.sysmenu.buy1.SetText( LanguageStr("_buy")+" " + Product.GetProductName());
	window1.sysmenu.aboutwin.SetText( Product.GetProductName() + " " + LanguageStr("_about") );
	winjoin.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winjoin.help1.aboutwin.SetText( Product.GetProductName() + " " + LanguageStr("_about") );
	winsplit.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	winsplit.help1.aboutwin.SetText( Product.GetProductName() + " " + LanguageStr("_about") );
	wincut.help1.buy1.SetText( LanguageStr("_buy")+" "+ Product.GetProductName() );
	wincut.help1.aboutwin.SetText( Product.GetProductName() + " " + LanguageStr("_about") );
		RefreshShowText();
		winsplit.Refresh();
	}
	window1.SetTitle( Product.GetProductName() );
}

function RefreshShowText( args )
{
	if(!Product.IsValidateReg())
	{
		window1.title.SetText( Product.GetProductName() + " " + "(" + LanguageStr("_unreg") + ")" );
		winjoin.title.SetText( LanguageStr("_videojoiner") + " " + "(" + LanguageStr("_unreg") + ")" );
		winsplit.title.SetText( LanguageStr("_videosplitter") + " " + "(" + LanguageStr("_unreg") + ")" );
		wincut.title.SetText( LanguageStr("_videocutter") + " " + "(" + LanguageStr("_unreg") + ")" );
	}
	else
	{
		window1.title.SetText( Product.GetProductName() );
		winjoin.title.SetText( LanguageStr("_videojoiner") );
		winsplit.title.SetText( LanguageStr("_videosplitter") );
		wincut.title.SetText( LanguageStr("_videocutter") );
	}
	
	
}

function SetMainFace1( args )
{

	LoadSkin( "Imtoo" );
	Product.SetString( "SkinName", "Imtoo" );
	AdjustLangAndSkinStatus( 0, -1 );
}

function SetMainFace2( args )
{

	LoadSkin( "Xilisoft" );
	Product.SetString( "SkinName", "Xilisoft" );
	AdjustLangAndSkinStatus( 1, -1 );
}

function SetMainLang1( args )
{
	RefreshLanguage( "Chinese(Simplified)" );
	Product.SetString( "language", "Chinese(Simplified)" );
	AdjustLangAndSkinStatus( -1, 0 );
	OnGoMenuBuy();
}

function SetMainLang2( args )
{
	RefreshLanguage( "English" );
	Product.SetString( "language", "English" );
	AdjustLangAndSkinStatus( -1, 1 );
	OnGoMenuBuy();
}

function SetMainLang3( args )
{
	RefreshLanguage( "Deutsch" );
	Product.SetString( "language", "Deutsch" );
	AdjustLangAndSkinStatus( -1, 2 );
	OnGoMenuBuy();
}

function SetMainLang4( args )
{
	RefreshLanguage( "Japanese" );
	Product.SetString( "language", "Japanese" );
	AdjustLangAndSkinStatus( -1, 3 );
	OnGoMenuBuy();
}

function SetMainUserSelect()
{
	var nIndex = window1.facecombo.GetCurSel();
	
	Product.SetInt( "skinindex", nIndex );
	nIndex = window1.langcombo.GetCurSel();

	var strlang = window1.langcombo.GetData( nIndex );

	Product.SetString( "language", strlang );
}

function onopenhelp( args )
{
	var urlstr = "videoeditor.chm";
	GotoUrl(urlstr);
}

function OnGoBuy( args )
{
	var urlstr = Product.GetBuyUrl();

	if(urlstr.length <= 0)
	{
		return 1;
	}
	
	GotoUrl(urlstr);
}

function OnMainOpenRegWin( args )
{
	OnOpenRegWin(window1);
}

function SetRegExplainWord( args )
{
	m_strRegExplainWord = args[2];
}

function OnOpenRegWin( args )
{
	var reginfo = Product.GetRegInfo();
	regwin.regname.SetText(reginfo[0]);
	regwin.regnumber.SetText("");
	regwin.regok.SetEnable( false );
	regwin.oneurl.buylink.SetText( LanguageStr("_mfbuy") + " " + Product.GetProductName() );
	regwin.oneurl.buylink.SetLink( Product.GetBuyUrl() );
	regwin.emaillink.SetLink( "mailto:" + Product.GetSupportEmail() );
	regwin.emaillink.SetText( Product.GetSupportEmail() );
	
	g_videoeditor.RegExplainWord( LanguageStr("_reglimit") );
	
	regwin.limit.SetText( m_strRegExplainWord );

	regwin.ShowModal(args);
	
}

function OnGoSupport( args )
{
	var urlstr = Product.GetSupportUrl();
	if(urlstr.length <= 0)
	{
		return 1;
	}

	GotoUrl(urlstr);
}

function OnMainAbout( args )
{
	OnAbout( window1 );
}

function OnAbout( args )
{
	if (Product.IsValidateReg())
	{
		var reginfo = Product.GetRegInfo();
		aboutwin.username.SetText(reginfo[0]);
		aboutwin.RegTip.SetText(LanguageStr("_aboutstatus"));
	}else
	{
		aboutwin.RegTip.SetText(LanguageStr("_unreg"));
		aboutwin.username.SetText("");
	}
//	aboutwin.aboutsta.SetText( Product.GetProductName() + " " + LanguageStr("_about") );
	
	if( args == "" )
	{
		aboutwin.ShowModal();
	}
	else
	{
		aboutwin.ShowModal(args);
	}
}

function close_main_win()
{
	g_videoeditor.close_player();
	SetMainUserSelect();
	window1.Close();
}
	
var updatelib = new JSUpdateLib;
//1 и
//2 и
//0 ޸
function OnMainCheckUpdate( args )
{
	OnCheckUpdate( window1 );
}
var m_bNoUpdate = false;
function OnCheckUpdate( args )
{
		var ret = updatelib.CheckUpdate();

		if( ret > 0 && ret <= 50 )//и
		{
			updatelib.DoUpdate("Xilisoft Video Editor Update.exe");
		}
		else if(ret > 50 && ret <= 100 )//0 ޸
		{
			if( !m_bNoUpdate )
			{
		    ShowMsg( args,LanguageStr("_noupdate"), Product.GetProductName(), 1 );
		  }
		  m_bNoUpdate = false;
		}
		else if( ret > 100 )//ѯǲ󣬲پϸ
		{
			ShowMsg( args,LanguageStr("_updateerror"), Product.GetProductName(), 1 );
		}
}

window1.SetTimer(1,30000,"runtimer");
function runtimer(args)
{
	window1.KillTimer(1);
	NewThread("reg_thread_runtimer");
}

function reg_thread_runtimer( args )
{
	Product.ValidateRegOnNetWork(true,true);
}

window1.SetTimer(2,60000,"runtimer_autoupdate");
function runtimer_autoupdate(args)
{
	window1.KillTimer(2);
	m_bNoUpdate = true;
	NewThread("update_thread_runtimer");
}

function update_thread_runtimer( args )
{
	if( m_faceinterface == 0 )
	{
		OnCheckUpdate( window1 );
	}
	else if( m_faceinterface == 1 )
	{
		OnCheckUpdate( winjoin );
	}
	else if( m_faceinterface == 2 )
	{
		OnCheckUpdate( winsplit );
	}
	else if( m_faceinterface == 3 )
	{
		OnCheckUpdate( wincut );
	}
}

function mainmousemove( args )
{
	window1.gbutton.Invalidate();
}

function CountDownWinYes( args )
{
	countdownwin.Close();
	g_videoeditor.CountDownWinYes();
	
}

function CountDownWinNo( args )
{
	countdownwin.Close();
	g_videoeditor.CountDownWinNo();
}
