var hSplitWnd = winsplit.GetHandle();
var hSplitPlayerWnd = winsplit.player.GetHandle();
var nSplitDiskClearSizi = "";
var m_nSplitFlag = -1;
var m_strSplitDisk = "";
var m_strSplitFileTime="";
var m_strSplitFileSize = "";
var m_nSplitPlayStatus = 1;
var m_nSplitPlayVolume = 1;
var m_bsplitsystray = false;
var vsplit_player_status = 0;
var m_splitfinishedaction = -1;
var m_manuandautoselstate = 0;
var m_strSplitShowMsg = "";
//var m_nsplitcurseconds = -1;
//var m_nsplitcurMB = -1;
//var m_nsplitcursegment = -1;


//7001~7500
var SplitAccelKeyMap =
[
	[7001, "ALT|VIRTKEY", 102],//f
	[7002, "ALT|VIRTKEY", 70],//F
	
	[7003, "ALT|VIRTKEY", 101],//e
	[7004, "ALT|VIRTKEY", 69],//E
	
	[7005, "ALT|VIRTKEY", 97],//a
	[7006, "ALT|VIRTKEY", 65],//A
	
	[7007, "ALT|VIRTKEY", 116],//t
	[7008, "ALT|VIRTKEY", 84],//T
	
	[7009, "ALT|VIRTKEY", 104],//h
	[7010, "ALT|VIRTKEY", 72],//H
	
	
];

function OnSplitHotKeySet( args )
{
	switch( args[2] )
	{
		case 7001:
		case 7002:
			winsplit.file1.Popup();
			break;
		case 7003:
		case 7004:
			winsplit.edit1.Popup();
			break;
		case 7005:
		case 7006:
			winsplit.action1.Popup();
			break;
		case 7007:
		case 7008:
			winsplit.tools1.Popup();
			break;
		case 7009:
		case 7010:
			winsplit.help1.Popup();
			break;
			
	}
}

function InitSplitWindow()
{
	if(!Product.IsValidateReg())
	{
		winsplit.title.SetText( LanguageStr("_videosplitter") + " (" + LanguageStr("_unreg") +")" );
	}
	else
	{
		winsplit.title.SetText( LanguageStr("_videosplitter") );
	}
	
	InitSplitWindowState();
	
	g_videoeditor.InitVideoEditor( hSplitWnd, hSplitPlayerWnd , 1 );
	
	//UILIb8δ޸ĺ,ʱ
//	winsplit.RegisterAccelHandle( SplitAccelKeyMap,"OnSplitHotKeySet");
}

function SplitWindowMinimize(args )
{	
	window1.Minimize();
	winsplit.Minimize();
}
function CloseSplitterWin()
{
	//add by pengl
	onplay_stop_split();
	update_player_btn_split(3);
	m_faceinterface = 0;

	g_videoeditor.UnInitVideoEditor();
	window1.RestoreWindow();
	winsplit.Close();
//	winsplitshow = false;
	//window1.SetVisible( true );
}

function OnSplitCheckUpdate( args )
{
	OnCheckUpdate( winsplit );
}

function OnSplitVolumeChange( args )
{
	g_videoeditor.SetVolumeChange( args[2] );
}

function SetSplitVolumeRange( args )
{
	winsplit.volumeslider.SetRange( args[2], args[3] );
}

function SetSplitVolumeCurrent( args )
{
	winsplit.volumeslider.SetPos( args[2] );
}

function ClearUserSplitPoint( args )
{
//	Msg( "OK" );
	winsplit.playslider.ClearTick();
	winsplit.playslider.SetPos( 0 );
}

function TellUserNoSupportSplit( args )
{
	if( args[2] == 0 )
		ShowMsg(winsplit, LanguageStr("_strfileformatNO"),Product.GetProductName(),1 );
	else if( args[2] == 1 )
		ShowMsg(winsplit, LanguageStr("_strfilecodecNO"),Product.GetProductName(),1 );
}


function OnSplitSystrayShow( args )
{
	if( m_bsplitsystray )
	{
		winsplit.RestoreWindow();
	}
	window1.RestoreWindow();
	g_Systray.DeleteSysTray();
//	winsplit.RestoreWindow();
}

function OnSplitSystrayAbout( args )
{
	OnAbout(winsplit);
}

function OnSplitAbout( args )
{
	OnAbout(winsplit );
}

function SplitSysNotify(nMsg, ParentObj, ParmObj)
{
	switch(nMsg)
	{
		case WM_RBUTTONUP:
			winsplit.systray.s1.SetText( LanguageStr("_systrayshow") + " " +  Product.GetProductName() );
			winsplit.systray.s2.SetText( LanguageStr("_about") + " " +  Product.GetProductName() );
			winsplit.systray.Popup();
			break;
		case WM_LBUTTONDBLCLK:
			window1.RestoreWindow();
		//	window1.Minimize();
			g_Systray.DeleteSysTray();
			break; 
		case WM_LBUTTONUP:
			break; 
	}
	
}

function OnSplitRunBackground( args )
{
	window1.RestoreWindow();
	window1.HideWindow();
	m_bsplitsystray = false;
	g_Systray.SetParentWnd(	hSplitWnd );
	g_Systray.AddSysTray("xili-video-editor.ico", SplitSysNotify );
	g_Systray.SetTipText( Product.GetProductName() );
}



function SplitOutSysNotify(nMsg, ParentObj, ParmObj)
{
	switch(nMsg)
	{
		case WM_RBUTTONUP:
			winsplit.systray.s1.SetText( LanguageStr("_systrayshow") + " " +  Product.GetProductName() );
			winsplit.systray.s2.SetText( LanguageStr("_about") + " " +  Product.GetProductName() );
			winsplit.systray.Popup();
			break;
		case WM_LBUTTONDBLCLK:
			window1.RestoreWindow();
			winsplit.RestoreWindow();
			g_Systray.DeleteSysTray();
			break; 
		case WM_LBUTTONUP:
			break; 
	}
	
}

function OnSplitOutRunBackground( args )
{
	m_bsplitsystray = true;
	var hSplitOutWnd = splitoutwin.GetHandle();
	g_Systray.SetParentWnd(	hSplitOutWnd );
	g_Systray.AddSysTray("xili-video-editor.ico", SplitOutSysNotify);
	g_Systray.SetTipText( Product.GetProductName() );
	window1.HideWindow();
	winsplit.HideWindow();
}

function OnSplitNoOperate( args )
{
	winsplit.tools1.afterdone.noaction.SetCheck( true );
	winsplit.tools1.afterdone.autoshutdown.SetCheck( false );
	winsplit.tools1.afterdone.intodormancystate.SetCheck( false );
	winsplit.tools1.afterdone.intostandby.SetCheck( false );
	winsplit.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 0 );
	m_splitfinishedaction = 0;
	
}

function OnSplitAutoShutDown( args )
{
	winsplit.tools1.afterdone.noaction.SetCheck( false );
	winsplit.tools1.afterdone.autoshutdown.SetCheck( true );
	winsplit.tools1.afterdone.intodormancystate.SetCheck( false );
	winsplit.tools1.afterdone.intostandby.SetCheck( false );
	winsplit.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 1 );
	m_splitfinishedaction = 1;
}

function OnSplitDormancyState( args )
{
	winsplit.tools1.afterdone.noaction.SetCheck( false );
	winsplit.tools1.afterdone.autoshutdown.SetCheck( false );
	winsplit.tools1.afterdone.intodormancystate.SetCheck( true );
	winsplit.tools1.afterdone.intostandby.SetCheck( false );
	winsplit.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 2 );
	m_splitfinishedaction = 2;
}

function OnSplitIntoStandBy( args )
{
	winsplit.tools1.afterdone.noaction.SetCheck( false );
	winsplit.tools1.afterdone.autoshutdown.SetCheck( false );
	winsplit.tools1.afterdone.intodormancystate.SetCheck( false );
	winsplit.tools1.afterdone.intostandby.SetCheck( true );
	winsplit.tools1.afterdone.exitthis.SetCheck( false );
	g_videoeditor.SetFinishedAction( 3 );
	m_splitfinishedaction = 3;
}

function OnSplitExitThis( args )
{
	winsplit.tools1.afterdone.noaction.SetCheck( false );
	winsplit.tools1.afterdone.autoshutdown.SetCheck( false );
	winsplit.tools1.afterdone.intodormancystate.SetCheck( false );
	winsplit.tools1.afterdone.intostandby.SetCheck( false );
	winsplit.tools1.afterdone.exitthis.SetCheck( true );
	g_videoeditor.SetFinishedAction( 4 );
	m_splitfinishedaction = 4;
}

function SplitShowCountDownNumber( args )
{
	countdownwin.countdown.SetText( args[2] );
}

function SplitShowCountDownWin( args )
{
	countdownwin.title.SetText( Product.GetProductName() );
	countdownwin.countdown.SetText( args[2] );
//	Msg( m_splitfinishedaction );
	if( m_splitfinishedaction == 0 )//NoAction
	{
		return;
	}
	else if( m_splitfinishedaction == 1 )//ShutDown
	{
		countdownwin.message.SetText( LanguageStr("_strshoudown") );
	}
	else if( m_splitfinishedaction == 2 )//DormancyState
	{
		countdownwin.message.SetText( LanguageStr("_strDormancy") );
	}
	else if( m_splitfinishedaction == 3 )//IntoStandBy
	{
		countdownwin.message.SetText( LanguageStr("_strIntoStandBy") );
	}
	else if( m_splitfinishedaction == 4 )//ExitThis
	{
		countdownwin.message.SetText( LanguageStr("_strExitThis") );
	}
	countdownwin.ShowModal(splitoutwin);
}

function CloseSplitApp( args )
{
	splitoutwin.Close();
	winsplit.Close();
	window1.Close();
}

function SetSplitFace1( args )
{
//	Msg( args[2] );
	LoadSkin( "Imtoo" );
	Product.SetString( "SkinName", "Imtoo" );
	AdjustLangAndSkinStatus( 0, -1 );
}

function SetSplitFace2( args )
{
//	Msg( args[2] );
	LoadSkin( "Xilisoft" );
	Product.SetString( "SkinName", "Xilisoft" );
	AdjustLangAndSkinStatus( 1, -1 );
}

function SetSplitLang1( args )
{
	RefreshLanguage( "Chinese(Simplified)" );
	Product.SetString( "language", "Chinese(Simplified)" );
	AdjustLangAndSkinStatus( -1, 0 );
	OnGoMenuBuy();
//	winsplit.splitstaticsecondspre.width = "40";
}

function SetSplitLang2( args )
{
	RefreshLanguage( "English" );
	Product.SetString( "language", "English" );
	AdjustLangAndSkinStatus( -1, 1 );
	winsplit.Refresh();
	OnGoMenuBuy();
//	winsplit.splitstaticsecondspre.width = "100";
}

function SetSplitLang3( args )
{
	RefreshLanguage( "Deutsch" );
	Product.SetString( "language", "Deutsch" );
	AdjustLangAndSkinStatus( -1, 2 );
	winsplit.Refresh();
	OnGoMenuBuy();
//	winsplit.splitstaticsecondspre.width = "100";
}

function SetSplitLang4( args )
{
	RefreshLanguage( "Japanese" );
	Product.SetString( "language", "Japanese" );
	AdjustLangAndSkinStatus( -1, 3 );
	winsplit.Refresh();
	OnGoMenuBuy();
//	winsplit.splitstaticsecondspre.width = "100";
}

function InitSplitWindowState( args )
{
	winsplit.playslider.ClearTick();
	winsplit.outsourceedit.SetText( "" );
	winsplit.outtargetedit.SetText("");
	winsplit.radiogroup.SetCheck( 0 );
	winsplit.autogroup.SetCheck( 0 );
	winsplit.autogroup.SetEnable( false );
	winsplit.splitspinseconds.SetEnable( false );
	
	winsplit.splitstaticsecondspre.SetEnable( false );
	winsplit.splitstaticseconds.SetEnable( false );
	winsplit.splitspinseconds.SetValue( 600 );/////Ϊʲô?
//	m_nsplitcurseconds = 600;
	winsplit.splitspinMB.SetEnable( false );
	winsplit.splitspinMB.SetValue( 600 );
//	m_nsplitcurMB = 600;
	winsplit.splitstaticMBpre.SetEnable( false );
	winsplit.splitstaticMB.SetEnable( false );
	winsplit.splitspinsegment.SetEnable( false );
	winsplit.splitspinsegment.SetValue( 2 );
//	m_nsplitcursegment = 2;
	winsplit.averagesplitpre.SetEnable( false );
	winsplit.splitstaticsegment.SetEnable( false );
	winsplit.playslider.SetPos( 0 );
	winsplit.slidercut.SetEnable( false );
	winsplit.edit1.setsplitpoint.SetEnable( false );

	var fname = winsplit.outsourceedit.GetText();
	if (fname.length <= 0)
	{
//		winsplit.splittarget.SetEnable( false );
//		winsplit.outtargetedit.SetEnable( false );
//		winsplit.targetbtn.SetEnable( false );
		winsplit.radiogroup.SetEnable( false );
		winsplit.slidercut.SetEnable( false );
		winsplit.edit1.setsplitpoint.SetEnable( false );
		winsplit.slidercutuppoint.SetEnable( false );
		winsplit.edit1.skipuppoint.SetEnable( false );
		winsplit.slidercutnextpoint.SetEnable( false );
		winsplit.edit1.skipnextpoint.SetEnable( false );
		winsplit.sliderremove.SetEnable( false );
		winsplit.edit1.remove1.SetEnable( false );
		winsplit.sliderclear.SetEnable( false );
		winsplit.edit1.clear.SetEnable( false );
//		winsplit.playslider.SetEnable( false );


	}
	else
	{
		winsplit.splittarget.SetEnable( true );
		winsplit.outtargetedit.SetEnable( true );
		winsplit.targetbtn.SetEnable( true );
		winsplit.radiogroup.SetEnable( true );

		var nPos = winsplit.playslider.GetPos();
		var nMin = winsplit.playslider.GetRangeMin();
		var nMax = winsplit.playslider.GetRangeMax();
		if( nPos != nMax && nPos != nMin )		
		{
			winsplit.slidercut.SetEnable( true );
			winsplit.edit1.setsplitpoint.SetEnable( true );
		}
		else
		{
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
		}
//		winsplit.edit1.setsplitpoint.SetEnable( true );
		winsplit.slidercutuppoint.SetEnable( true );
		winsplit.edit1.skipuppoint.SetEnable( true );
		winsplit.slidercutnextpoint.SetEnable( true );
		winsplit.edit1.skipnextpoint.SetEnable( true );
		winsplit.sliderremove.SetEnable( true );
		winsplit.edit1.remove1.SetEnable( true );
		winsplit.sliderclear.SetEnable( true );
		winsplit.edit1.clear.SetEnable( true );
//		winsplit.playslider.SetEnable( true );
	}
	
	update_player_btn_split(4);	
}
function OnSplitSourceFile()
{

	//add by pengl
//	onplay_stop_split();
//	update_player_btn_split(3);//modify liqiang 2007-09-07,"//"
	
	g_videoeditor.OnAddfile();
	
	var fname = winsplit.outsourceedit.GetText();
	
	if (fname.length > 0) 
	{
		var strTargetPath = winsplit.outtargetedit.GetText();
		g_videoeditor.ResetTargetPath( fname, "", strTargetPath );
		
		
		onplay_stop_split();
		g_videoeditor.set_current_sel_file(fname);
		var slide_time = g_videoeditor.get_split_file_duration(); //in seconds
		
//		winsplit.playslider.SetEnable( true );//LiQiang 2007-07-23 09:40
		winsplit.playslider.SetRange(0, slide_time);
		winsplit.playtime.SetText("00:00:00");
		winsplit.playslider.SetPos(0);
		/////////LiQiang 2007-07-23 09:40////////////
		winsplit.splittarget.SetEnable( true );
		winsplit.outtargetedit.SetEnable( true );
		winsplit.targetbtn.SetEnable( true );
		winsplit.radiogroup.SetEnable( true );
		
		var nSel = winsplit.radiogroup.GetCheck();
		if( 0 == nSel )
		{
			var nPos = winsplit.playslider.GetPos();
			if( nPos != 0 && nPos != slide_time )
			{
				winsplit.slidercut.SetEnable( true );
				winsplit.edit1.setsplitpoint.SetEnable( true );
			}
			else
			{
				winsplit.slidercut.SetEnable( false );
				winsplit.edit1.setsplitpoint.SetEnable( false );
			}
//			winsplit.edit1.setsplitpoint.SetEnable( true );
			var item1 = winsplit.playslider.GetAllTick();
			if( item1[0] >= 1 )
			{
				winsplit.slidercutuppoint.SetEnable( true );
				winsplit.edit1.skipuppoint.SetEnable( true );
				winsplit.slidercutnextpoint.SetEnable( true );
				winsplit.edit1.skipnextpoint.SetEnable( true );
				winsplit.sliderremove.SetEnable( true );
				winsplit.edit1.remove1.SetEnable( true );
				winsplit.sliderclear.SetEnable( true );
				winsplit.edit1.clear.SetEnable( true );
			}
		}
		else if( 1 == nSel )
		{
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
			winsplit.slidercutuppoint.SetEnable( false );
			winsplit.edit1.skipuppoint.SetEnable( false );
			winsplit.slidercutnextpoint.SetEnable( false );
			winsplit.edit1.skipnextpoint.SetEnable( false );
			winsplit.sliderremove.SetEnable( false );
			winsplit.edit1.remove1.SetEnable( false );
			winsplit.sliderclear.SetEnable( false );
			winsplit.edit1.clear.SetEnable( false );
			
			var nselIndex = winsplit.autogroup.GetCheck();
			if( 0 == nselIndex )//seconds
			{
				winsplit.playslider.SetTick( slide_time/2, "" );
				winsplit.splitspinseconds.SetValue( slide_time/2 );
//				m_nsplitcurseconds = slide_time / 2;
			}
			else if( 1 == nselIndex )//MB
			{
				winsplit.playslider.SetTick( slide_time/2, "" );
				var nfilesize = g_videoeditor.GetFileSize();
				if( nfilesize <= 1 )
				{
					winsplit.splitspinMB.SetValue( 1 );
//					m_nsplitcurMB = 1;
				}
				else
				{
					winsplit.splitspinMB.SetValue( nfilesize/2 );
//					m_nsplitcurMB = nfilesize / 2;
				}
			}
			else if( 2 == nselIndex )//segment
			{
				winsplit.playslider.SetTick( slide_time/2, "" );
				winsplit.splitspinsegment.SetValue( 2 );
//				m_nsplitcursegment = 2;
			}
		}
				
		//////////////////////////////////////////////
		update_player_btn_split(1);
	}
	//end
}
function ShowSplitSourceFile( args )
{
	//add by pengl
	onplay_stop_split();
	update_player_btn_split(3);
	//end
	
	var strPath = args[2];
	winsplit.outsourceedit.SetText( strPath );
}
function OnSplitTargetDirectory()
{
	var fname = winsplit.outsourceedit.GetText();
	if( fname.length > 0 )
	{
		//add by pengl
		onplay_stop_split();
		update_player_btn_split(3);
		//end
	}
	g_videoeditor.SelectTargetDirectory();
}

function ShowSplitTargetDirectory( args )
{
	var strPath = args[2];
	winsplit.outtargetedit.SetText( strPath );
}

function SetSplitPlaySliderRange( args )
{
	winsplit.playslider.SetRange( args[2], args[3] );
}

function SplitSliderBlockStateChange( args )
{
	var nPos = winsplit.playslider.GetPos();
	var item1 = winsplit.playslider.GetAllTick();
	var nMin = winsplit.playslider.GetRangeMin();
	var nMax = winsplit.playslider.GetRangeMax();
	var nSel = winsplit.radiogroup.GetCheck();
		
	for( var n = 0; n < item1[0]; ++n )
	{
		if( nPos == item1[n+1] )
		{
			winsplit.sliderremove.SetEnable( true );
			winsplit.edit1.remove1.SetEnable( true );
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
			break;
		}
		else
		{
			winsplit.sliderremove.SetEnable( false );
			winsplit.edit1.remove1.SetEnable( false );
			winsplit.slidercut.SetEnable( true );
			winsplit.edit1.setsplitpoint.SetEnable( true );
		}
	}
	
	if( winsplit.outsourceedit.GetText() != "" && winsplit.radiogroup.GetCheck() == 0 )
	{
		if( nPos == nMax || nPos == nMin )
		{
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
		}
		else
		{
			winsplit.slidercut.SetEnable( true );
			winsplit.edit1.setsplitpoint.SetEnable( true );
		}
	}
	else
	{
		winsplit.slidercut.SetEnable( false );
		winsplit.edit1.setsplitpoint.SetEnable( false );
	}
	
	if( item1[0] > 0 && 0 == nSel )
	{
		winsplit.sliderclear.SetEnable( true );
		winsplit.edit1.clear.SetEnable( true );
	}
	else
	{
		winsplit.sliderclear.SetEnable( false );
		winsplit.edit1.clear.SetEnable( false );
	}
	UpdateSkipUpandDownButtonState();
}

function UpdateSkipUpandDownButtonState( args )
{
	var nPos = winsplit.playslider.GetPos();
	var item1 = winsplit.playslider.GetAllTick();
	if( nPos < item1[1] )
	{
		winsplit.slidercutuppoint.SetEnable( false );
		winsplit.edit1.skipuppoint.SetEnable( false );
		winsplit.slidercutnextpoint.SetEnable( true );
		winsplit.edit1.skipnextpoint.SetEnable( true );
	}
	else if( nPos > item1[1] )
	{
		if( nPos >= item1[item1[0]] )
		{
			winsplit.slidercutuppoint.SetEnable( true );
			winsplit.edit1.skipuppoint.SetEnable( true );
			winsplit.slidercutnextpoint.SetEnable( false );
			winsplit.edit1.skipnextpoint.SetEnable( false );
		}
		else
		{
			winsplit.slidercutuppoint.SetEnable( true );
			winsplit.edit1.skipuppoint.SetEnable( true );
			winsplit.slidercutnextpoint.SetEnable( true );
			winsplit.edit1.skipnextpoint.SetEnable( true );
		}
	}
	else
	{
		if( nPos >= item1[item1[0]] )
		{
			winsplit.slidercutuppoint.SetEnable( false );
			winsplit.edit1.skipuppoint.SetEnable( false );
			winsplit.slidercutnextpoint.SetEnable( false );
			winsplit.edit1.skipnextpoint.SetEnable( false );
		}
		else
		{
			winsplit.slidercutuppoint.SetEnable( true );
			winsplit.edit1.skipuppoint.SetEnable( true );
			winsplit.slidercutnextpoint.SetEnable( true );
			winsplit.edit1.skipnextpoint.SetEnable( true );
		}
	}
}

function SplitSliderBlockPosChange( args )
{
	//lipeng add
	var fname = winsplit.outsourceedit.GetText();
	if (fname.length <= 0) {
		return;
	}
	//end

	if (vsplit_player_status == 0) {
		
		SplitSliderBlockStateChange( args );
		var nPos = winsplit.playslider.GetPos();
		g_videoeditor.CutSliderPosChange( nPos );
	}
	else {
		//add by pengl
		split_slider_change(args);
		//end
	}
}

function SetSplitSliderTimeString( args )
{
	if( winsplit.outsourceedit.GetText() != "" )
	{
		winsplit.playtime.SetText( args[2] );
	}
}

function GetSplitTickPoint( args )
{
	var item1 = winsplit.playslider.GetAllTick();
	return item1[args[2]+1];
}

function GetSplitTickCount( args )
{
	var item1 = winsplit.playslider.GetAllTick();
	return item1[0];
}

function SetSplitEditPoint( args )
{
	var nPos = winsplit.playslider.GetPos();
	var nMin = winsplit.playslider.GetRangeMin();
	var nMax = winsplit.playslider.GetRangeMax();
//	var pause = g_videoeditor.get_player_pause_state();
	if( vsplit_player_status == 0 ) 
	{
//		if( pause == false )//stop
		{
			if( nPos > nMin && nPos < nMax )
			{
				winsplit.playslider.SetTick( nPos, "" );
				winsplit.sliderremove.SetEnable( true );
				winsplit.edit1.remove1.SetEnable( true );
				winsplit.sliderclear.SetEnable( true );
				winsplit.edit1.clear.SetEnable( true );
			}
		}
//		else//pause
		{
		}	
	}
	else if (vsplit_player_status == 1) 
	{ //play
		winsplit.playslider.SetTick( nPos, "" );
		winsplit.sliderremove.SetEnable( false );
		winsplit.edit1.remove1.SetEnable( false );
		winsplit.sliderclear.SetEnable( true );
		winsplit.edit1.clear.SetEnable( true );
		
	}
}

function SetSplitShowMsgString( args )
{
	m_strSplitShowMsg = args[2];
}

function OnSplitterSplit( args )
{
	//Դ
	var strPath = winsplit.outsourceedit.GetText();
	if( strPath == "" )
	{
		ShowMsg(winsplit, LanguageStr("_strADDFile"),Product.GetProductName(),1 );
		return;
	}
	
	//pengl
	onplay_stop_split();
	update_player_btn_split(3);
	//end
	
	//ȷָ
	var nUserSel = winsplit.radiogroup.GetCheck();
	g_videoeditor.SetUserSplitMode( nUserSel );
	if( 0 == nUserSel )
	{
		var item1 = winsplit.playslider.GetAllTick();
		if( item1[0] < 1 )
		{
			ShowMsg(winsplit, LanguageStr("_strSetSplitPoint"),Product.GetProductName(),1 );
			return;
		}
		g_videoeditor.SetSplitterSplitNumber( item1[0] + 1 );
	}
	else if( 1 == nUserSel )
	{
		var nUserSelAuto = winsplit.autogroup.GetCheck();
		var bURet;
		var curvalue;
		if( 0 == nUserSelAuto )
		{	
			curvalue = winsplit.splitspinseconds.GetValue();
			if( curvalue <= 0 )
			{
				ShowMsg(winsplit, LanguageStr( "_secondNO0" ), Product.GetProductName(), 1 );
				return;
			}
//			Msg( curvalue );
			bURet = g_videoeditor.CheckUserEnterIsValid( nUserSelAuto, LanguageStr("_strSplitTimeInvalid"), curvalue );
		}
		else if( 1 == nUserSelAuto )
		{
			curvalue = winsplit.splitspinMB.GetValue();
			if( curvalue <= 0 )
			{
				ShowMsg(winsplit, LanguageStr( "_MBNO0" ), Product.GetProductName(), 1 );
				return;
			}
			bURet = g_videoeditor.CheckUserEnterIsValid( nUserSelAuto, LanguageStr("_strSplitSizeInvalid"), curvalue );
		}
		else if( 2 == nUserSelAuto )
		{
			curvalue = winsplit.splitspinsegment.GetValue();
			if( curvalue <= 0 )
			{
				ShowMsg(winsplit, LanguageStr( "_segmentNO0" ), Product.GetProductName(), 1 );
				return;
			}
			bURet = g_videoeditor.CheckUserEnterIsValid( nUserSelAuto, "", curvalue );
		}
		if( bURet )
			g_videoeditor.SetSplitUserAutoSelect( nUserSelAuto, curvalue );
		else
		{
			if( 0 == nUserSelAuto )
			{
				ShowMsg(winsplit, m_strSplitFileTime,Product.GetProductName(),1 );
			}
			else if( 1 == nUserSelAuto )
			{
				ShowMsg(winsplit, m_strSplitFileSize,Product.GetProductName(),1 );
			}
			return;
		}
	}
	
	//ƵļǷ
	var bfileexist = g_videoeditor.CheckFileIsExist( strPath );
	if( !bfileexist )
	{
		g_videoeditor.GetFullMsgString( LanguageStr("_strFileNo"), strPath );
		ShowMsg(winsplit, m_strSplitShowMsg,Product.GetProductName(),1);
		return;
	}
	
	//ĿļǷѡ
	var strTargetPath = winsplit.outtargetedit.GetText();
	if( strTargetPath == "" )
	{
		ShowMsg(winsplit, LanguageStr("_strSelTarDir"),Product.GetProductName(),1 );
		return;
	}
	
	//Ŀ·ǷЧ
	var filepatnIsvalid = g_videoeditor.CheckFilePathIsValid( strTargetPath );
	if( 1 == filepatnIsvalid )
	{
		ShowMsg(winsplit, LanguageStr( "_pathInvalid" ), Product.GetProductName(), 1 );
		return;
	}
	
	//ĿʣǷ<ĿļС
	var bDiskFreeSpace = g_videoeditor.CheckDiskFreeSpace( strTargetPath, LanguageStr("_strDiskFreeSpace") );
//	Msg( nCutDiskClearSizi );
	if( !bDiskFreeSpace )
	{
		ShowMsg(winsplit, nSplitDiskClearSizi,Product.GetProductName(),1);
		return;
	}
	
	//ļϵͳǷ֧>4GB
	////////////////////////////
	var bSupport = g_videoeditor.FileSystemIsSupport4GB( strTargetPath, LanguageStr( "_stragainselect" ) );
	if( !bSupport )
	{
		ShowMsg(winsplit, m_strSplitDisk, Product.GetProductName(), 1 );
		return;
	}
	
	///////////////////////////////
	//ûѡļĿ¼Ƿд
	var bWriteFile = g_videoeditor.CheckFileIsWrite( strTargetPath );
	if( !bWriteFile )
	{
		ShowMsg(winsplit, LanguageStr( "_fileiswrite" ), Product.GetProductName(), 1 );
		return;
	}
	
	//ʼָļ
	g_videoeditor.OnStartEditor( strTargetPath );
}

function OnSplitOpenRegWin( args )
{
	OnOpenRegWin( winsplit );
}

function SetAutoSelectInitByFile( args )
{
	if( args[2] <= 0 )
	{
		winsplit.splitspinseconds.SetValue( 1 );
//		m_nsplitcurseconds = 1;
	}
	else
	{
		winsplit.splitspinseconds.SetValue( args[2] );
//		m_nsplitcurseconds = args[2];
	}
	if( args[3] <= 0 )
	{
		winsplit.splitspinMB.SetValue( 1 );
//		m_nsplitcurMB = 1;
	}
	else
	{
		winsplit.splitspinMB.SetValue( args[3] );
//		m_nsplitcurMB = args[3];
	}
	winsplit.splitspinsegment.SetValue( 2 );
//	m_nsplitcursegment = 2;
}

//nclass = 0:Second,1:MB,2:Segment;curvalue:editspin value
function SplitAutoSelUpdateState( nclass, curvalue )
{
	var nMin = winsplit.playslider.GetRangeMin();
	var nMax = winsplit.playslider.GetRangeMax();
	if( 0 == nclass )
	{
		var nvalue = winsplit.splitspinseconds.GetValue();//һεֵ
		if( curvalue <= 0 )
		{
			ShowMsg(winsplit, LanguageStr( "_secondNO0" ), Product.GetProductName(), 1 );
			return nvalue;
		}
		else
		{
			var bURet = g_videoeditor.CheckUserEnterIsValid( 0, LanguageStr("_strSplitTimeInvalid"), curvalue );
			if( bURet )
			{
				g_videoeditor.SetSplitUserAutoSelect( 0, curvalue );
				var nfilesegnum = g_videoeditor.GetSplitFileSegNum();
				var naveragesegtime = g_videoeditor.GetSplitAverageFileTime();
				if( nfilesegnum > 0 )
				{
					winsplit.playslider.ClearTick();
				}
				for( var i = 0; i < nfilesegnum-1; ++i )
				{
				//	Msg( (i+1) * naveragesegtime );
					winsplit.playslider.SetTick( (i+1) * naveragesegtime, "" );
				}
			}
			else
			{
				ShowMsg(winsplit, m_strSplitFileTime,Product.GetProductName(),1 );
				return nvalue;
			}
		}
	}
	else if( 1 == nclass )
	{
		var nvalue = winsplit.splitspinMB.GetValue();
		if( curvalue <= 0 )
		{
			ShowMsg(winsplit, LanguageStr( "_MBNO0" ), Product.GetProductName(), 1 );
			return nvalue;
		}
		else
		{
			var bURet = g_videoeditor.CheckUserEnterIsValid( 1 , LanguageStr("_strSplitSizeInvalid"), curvalue );
			if( bURet )
			{
				g_videoeditor.SetSplitUserAutoSelect( 1, curvalue );
				var nfilesegnum = g_videoeditor.GetSplitFileSegNum();
				var naveragesegtime = ( nMax - nMin ) / nfilesegnum;
//				var naveragesegtime = g_videoeditor.GetSplitAverageFileTime();
				if( nfilesegnum > 0 )
				{
					winsplit.playslider.ClearTick();
				}
				for( var i = 0; i < nfilesegnum-1; ++i )
				{
					winsplit.playslider.SetTick( (i+1) * naveragesegtime, "" );
				}
			}
			else
			{
				ShowMsg(winsplit, m_strSplitFileSize,Product.GetProductName(),1 );
				return nvalue;
			}
		}
	}
	else if( 2 == nclass )
	{
		var nvalue = winsplit.splitspinsegment.GetValue();
		if( curvalue <= 0 )
		{
			ShowMsg(winsplit, LanguageStr( "_segmentNO0" ), Product.GetProductName(), 1 );
			return nvalue;
		}
		else
		{
			var bURet = g_videoeditor.CheckUserEnterIsValid( 2 , "", curvalue );
			if( bURet )
			{
				g_videoeditor.SetSplitUserAutoSelect( 2, curvalue );
				var nfilesegnum = g_videoeditor.GetSplitFileSegNum();
				var naveragesegtime = ( nMax - nMin ) / nfilesegnum;
//				var naveragesegtime = g_videoeditor.GetSplitAverageFileTime();
				if( nfilesegnum > 0 )
				{
					winsplit.playslider.ClearTick();
				}
				for( var i = 0; i < nfilesegnum-1; ++i )
				{
					winsplit.playslider.SetTick( (i+1) * naveragesegtime, "" );
				}
			}
		}
	}
}

function OnSplitSecond( args )
{
//Msg("args[2]=" + args[2] );
//Msg("args[3]=" + args[3] );
	if( winsplit.outsourceedit.GetText() =="" )
		return;
	var nSel = winsplit.radiogroup.GetCheck();
	if( nSel != 1 )
	{
		return;
	}
	nSel = winsplit.autogroup.GetCheck();
	if( nSel != 0 )
	{
		return;
	}
//	m_nsplitcurseconds = args[2];
//	var curvalue = winsplit.splitspinseconds.GetValue();
//	Msg( "curvalue=" + curvalue );
	return SplitAutoSelUpdateState( 0, args[2] );
}

function OnSplitMB( args )
{
	if( winsplit.outsourceedit.GetText() =="" )
		return;
	if( winsplit.radiogroup.GetCheck() != 1 )
		return;
	if( winsplit.autogroup.GetCheck() != 1 )
		return;
//	m_nsplitcurMB = args[2];
	return SplitAutoSelUpdateState( 1, args[2] );
}

function OnSplitSegment( args )
{
//	Msg( args[2] );
	if( winsplit.outsourceedit.GetText() =="" )
		return;
	if( winsplit.radiogroup.GetCheck() != 1 )
		return;
	if( winsplit.autogroup.GetCheck() != 2 )
		return;
//	m_nsplitcursegment = args[2];
	return SplitAutoSelUpdateState( 2, args[2] );
}

function GetSplitAutoSelCheck( args )
{
	return 	winsplit.autogroup.GetCheck();
}

function SetSplitFileTotalTime( args )
{
	m_strSplitFileTime = args[2];
}

function SetSplitFileTotalSize( args )
{
	m_strSplitFileSize = args[2];
}

function GetSplitAutoSelSeconds( args )
{
	return winsplit.splitspinseconds.GetValue();
}

function GetSplitAutoSelMB( args )
{
	return winsplit.splitspinMB.GetValue();
}

function GetSplitAutoSelSegment( args )
{
	return winsplit.splitspinsegment.GetValue();
}

function OnSplitUserSelectChange( args )
{
	if( m_manuandautoselstate == args[2] )
	{
		return;
	}
	else
	{
		m_manuandautoselstate = args[2];
	}
	if( 0 == args[2] )
	{
		winsplit.playslider.ClearTick();
		winsplit.slidercut.SetEnable( true );
		winsplit.edit1.setsplitpoint.SetEnable( true );
		
		SplitSliderBlockStateChange( args );

		winsplit.autogroup.SetEnable( false );
		winsplit.splitspinseconds.SetEnable( false );
		winsplit.splitstaticsecondspre.SetEnable( false );
		winsplit.splitstaticseconds.SetEnable( false );
		winsplit.splitspinMB.SetEnable( false );
		winsplit.splitstaticMBpre.SetEnable( false );
		winsplit.splitstaticMB.SetEnable( false );
		winsplit.splitspinsegment.SetEnable( false );
		winsplit.averagesplitpre.SetEnable( false );
		winsplit.splitstaticsegment.SetEnable( false );
	}
	else if( 1 == args[2] )
	{
		var item1 = winsplit.playslider.GetAllTick();
		if( item1[0] > 0 )
		{
			ShowMsg(winsplit, LanguageStr( "_manusplitpoint" ), Product.GetProductName(), 2 );
			if( 1 == g_msgvalue )//"OK"
			{
			}
			else if( 2 == g_msgvalue )//"Cancel"
			{
				winsplit.radiogroup.SetCheck( 0 );
				return;
			}
		}
		winsplit.autogroup.SetEnable( true );
		
		winsplit.slidercut.SetEnable( false );
		winsplit.edit1.setsplitpoint.SetEnable( false );
		winsplit.sliderremove.SetEnable( false );
		winsplit.edit1.remove1.SetEnable( false );
		winsplit.sliderclear.SetEnable( false );
		winsplit.edit1.clear.SetEnable( false );
		
		
		var nSel = winsplit.autogroup.GetCheck();
		if( 0 == nSel )
		{
			winsplit.splitspinseconds.SetEnable( true );
			winsplit.splitstaticsecondspre.SetEnable( true );
			winsplit.splitstaticseconds.SetEnable( true );
			winsplit.splitspinMB.SetEnable( false );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMB.SetEnable( true );
			winsplit.splitspinsegment.SetEnable( false );
			winsplit.averagesplitpre.SetEnable( true );
			winsplit.splitstaticsegment.SetEnable( true );
			var nvalue = winsplit.splitspinseconds.GetValue();
//			Msg( "nvalue=" + nvalue );
			SplitAutoSelUpdateState( 0, nvalue );
			
		}
		else if( 1 == nSel )
		{
			winsplit.splitspinseconds.SetEnable( false );
			winsplit.splitstaticsecondspre.SetEnable( true );
			winsplit.splitstaticseconds.SetEnable( true );
			winsplit.splitspinMB.SetEnable( true );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMB.SetEnable( true );
			winsplit.splitspinsegment.SetEnable( false );
			winsplit.averagesplitpre.SetEnable( true );
			winsplit.splitstaticsegment.SetEnable( true );
			var nvalue = winsplit.splitspinMB.GetValue();
			SplitAutoSelUpdateState( 1, nvalue );
			
		}
		else if( 2 == nSel )
		{
			winsplit.splitspinseconds.SetEnable( false );
			winsplit.splitstaticsecondspre.SetEnable( true );
			winsplit.splitstaticseconds.SetEnable( true );
			winsplit.splitspinMB.SetEnable( false );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMB.SetEnable( true );
			winsplit.splitspinsegment.SetEnable( true );
			winsplit.averagesplitpre.SetEnable( true );
			winsplit.splitstaticsegment.SetEnable( true );
			var nvalue = winsplit.splitspinsegment.GetValue();
			SplitAutoSelUpdateState( 2, nvalue );
		}
		UpdateSkipUpandDownButtonState();
		
		
	}
	g_videoeditor.SetUserSplitMode( args[2] );
}

function OnSplitUserSelectAuto( args )
{
	var nSel = winsplit.autogroup.GetCheck();
	var nvalue;
		if( 0 == nSel )
		{
			winsplit.splitspinseconds.SetEnable( true );
			winsplit.splitstaticsecondspre.SetEnable( true );
			winsplit.splitstaticseconds.SetEnable( true );
			winsplit.splitspinMB.SetEnable( false );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMB.SetEnable( true );
			winsplit.splitspinsegment.SetEnable( false );
			winsplit.averagesplitpre.SetEnable( true );
			winsplit.splitstaticsegment.SetEnable( true );
			
			nvalue = winsplit.splitspinseconds.GetValue();
			SplitAutoSelUpdateState( 0, nvalue );
		}
		else if( 1 == nSel )
		{
			winsplit.splitspinseconds.SetEnable( false );
			winsplit.splitstaticsecondspre.SetEnable( true );
			winsplit.splitstaticseconds.SetEnable( true );
			winsplit.splitspinMB.SetEnable( true );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMB.SetEnable( true );
			winsplit.splitspinsegment.SetEnable( false );
			winsplit.averagesplitpre.SetEnable( true );
			winsplit.splitstaticsegment.SetEnable( true );
			nvalue = winsplit.splitspinMB.GetValue();
			SplitAutoSelUpdateState( 1, nvalue );
		}
		else if( 2 == nSel )
		{
			winsplit.splitspinseconds.SetEnable( false );
			winsplit.splitstaticsecondspre.SetEnable( true );
			winsplit.splitstaticseconds.SetEnable( true );
			winsplit.splitspinMB.SetEnable( false );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMBpre.SetEnable( true );
			winsplit.splitstaticMB.SetEnable( true );
			winsplit.splitspinsegment.SetEnable( true );
			winsplit.averagesplitpre.SetEnable( true );
			winsplit.splitstaticsegment.SetEnable( true );
			nvalue = winsplit.splitspinsegment.GetValue();
			SplitAutoSelUpdateState( 2, nvalue );
		}
	//Msg( args[2] );
	g_videoeditor.SetSplitUserAutoSelect( args[2], nvalue );
}

function ShowSplitInterface( args )
{
	m_nSplitFlag = 1;
	splitoutwin.outsplitting.SetText( LanguageStr("_outsplitting") );
	splitoutwin.splitoutputbtn.SetText( LanguageStr("_runbackground") );
	splitoutwin.splitoutputbtn.SetTipText( LanguageStr("_runbackground") );
	splitoutwin.splitabort.SetText( LanguageStr("_joinabout") );
	splitoutwin.splitabort.SetTipText( LanguageStr("_joinabout") );
	splitoutwin.progre1.SetPos( 0 );
	splitoutwin.progressscale.SetText( "0%" );
	splitoutwin.stdout.SetImage("defimage.png");
	splitoutwin.ShowModal(winsplit);
}

function SplitFileNoSupport4GB( args )
{
	m_strSplitDisk = args[2];
}

function SplitShowStdOut( args )
{
//	splitoutwin.stdout.SetText( args[2] );
}

function SplitShowStdError( args )
{
//	splitoutwin.stdError.SetText( args[2] );
}

function SetSplitOutWinPic( args )
{
//	Msg( args[2] );
	splitoutwin.stdout.SetHBitmap( args[2] );
}

function SetSplitPlayerPic( args )
{
	winsplit.player.SetHBitmap( args[2] );
}

function AbortSplitterSplit( args )
{
	splitoutwin.stdout.SetImage("defimage.png");
}

function FinishSplitterSplit( args )
{
	m_nSplitFlag = 2;
	if( !IsWindowVisible(hSplitWnd) )
	{
		window1.RestoreWindow();
		winsplit.RestoreWindow();
		g_Systray.DeleteSysTray();
	}
	splitoutwin.outsplitting.SetText( LanguageStr("_FinishSplit") );
	splitoutwin.splitoutputbtn.SetText( LanguageStr("_OpenTargetDirectory") );
	splitoutwin.splitoutputbtn.SetTipText( LanguageStr("_OpenTargetDirectory") );
	splitoutwin.splitabort.SetText( LanguageStr("_FinishSplit1") );
	splitoutwin.splitabort.SetTipText( LanguageStr("_FinishSplit1") );
	splitoutwin.progre1.SetPos( 100 );
	splitoutwin.progressscale.SetText( "100%" );
	splitoutwin.stdout.SetImage("defimage.png");
	splitoutwin.residualtimeshow.SetText( LanguageStr("_usedtimeshow") );
}

function OnSplitRunBackAndOpenFiles( args )
{
	var strPath = winsplit.outtargetedit.GetText();
	if( m_nSplitFlag == 1 )//run background button
	{
		OnSplitOutRunBackground();
	}
	else if( m_nSplitFlag == 2 )//open target dirctory button
	{
		g_videoeditor.OpenTargetDirectory( strPath );
	}
}

function OnSplitAbortAndFinish( args )
{
	if( m_nSplitFlag == 1 )//abort button
	{
		ShowMsg(splitoutwin, LanguageStr("_IsUserConfirmSplit"),Product.GetProductName(),2 );
		if( 1 == g_msgvalue )//"OK"
		{
			g_videoeditor.OnAbortEditor();
			splitoutwin.Close();
			m_nSplitFlag = 0;
		}
		
	}
	else if( m_nSplitFlag == 2 )//finish button
	{
		splitoutwin.Close();
		m_nSplitFlag = 0;
	}
}

function SetSplitProgressPos( args )
{
	splitoutwin.progre1.SetPos( args[2] );
	splitoutwin.progressscale.SetText( args[3] );
}

function SetSplitShowTimeString( args )
{
	splitoutwin.usedtimeshow.SetText( args[2] );
	splitoutwin.residualtimeshow.SetText( args[3] );
}

function OnRemoveSplitTick( args )
{
	var nPos = winsplit.playslider.GetPos();
	var nMin = winsplit.playslider.GetRangeMin();
	var nMax = winsplit.playslider.GetRangeMax();
	winsplit.playslider.DelTick( nPos );
	if( nPos != nMin && nPos != nMax )
	{
		winsplit.slidercut.SetEnable( true );
		winsplit.edit1.setsplitpoint.SetEnable( true );
	}
	else
	{
		winsplit.slidercut.SetEnable( false );
		winsplit.edit1.setsplitpoint.SetEnable( false );
	}
	winsplit.edit1.setsplitpoint.SetEnable( true );
	winsplit.sliderremove.SetEnable( false );
	winsplit.edit1.remove1.SetEnable( false );
	var item1 = winsplit.playslider.GetAllTick();
	if( item1[0] > 0 )
	{
		winsplit.sliderclear.SetEnable( true );
		winsplit.edit1.clear.SetEnable( true );
	}
	else
	{
		winsplit.sliderclear.SetEnable( false );
		winsplit.edit1.clear.SetEnable( false );
	}
	UpdateSkipUpandDownButtonState();
}

function OnClearSplitTick( args )
{
	var nPos = winsplit.playslider.GetPos();
	var nMin = winsplit.playslider.GetRangeMin();
	var nMax = winsplit.playslider.GetRangeMax();
	winsplit.playslider.ClearTick();
	if( nPos != nMin && nPos != nMax )
	{
		winsplit.slidercut.SetEnable( true );
		winsplit.edit1.setsplitpoint.SetEnable( true );
	}
	else
	{
		winsplit.slidercut.SetEnable( false );
		winsplit.edit1.setsplitpoint.SetEnable( false );
	}
//	winsplit.edit1.setsplitpoint.SetEnable( true );
	winsplit.sliderclear.SetEnable( false );
	winsplit.edit1.clear.SetEnable( false );
	winsplit.sliderremove.SetEnable( false );
	winsplit.edit1.remove1.SetEnable( false );
	
	winsplit.slidercutuppoint.SetEnable( false );
	winsplit.edit1.skipuppoint.SetEnable( false );
	winsplit.slidercutnextpoint.SetEnable( false );
	winsplit.edit1.skipnextpoint.SetEnable( false );
	
}

function SetSplitUpPoint( args )
{
	var item1 = winsplit.playslider.GetAllTick();
	var nSel = winsplit.radiogroup.GetCheck();
//	Msg( item1[0] );
	var nTemp = 0;
	for( var m = 1; m < item1[0]; ++m )
		for( var n = m + 1; n < item1[0] + 1 ; ++n )
		{
			if( item1[n] < item1[m] )
			{
				nTemp = item1[n];
				item1[n] = item1[m];
				item1[m] = nTemp;
			}
		}
/*	for( var j = 0; j < item1[0]; ++j )
	{
		Msg( item1[j+1] );
	}*/
	var pos1 = winsplit.playslider.GetPos();
	if( item1[0] > 0 && 0 == nSel )
	{
		winsplit.sliderclear.SetEnable( true );
		winsplit.edit1.clear.SetEnable( true );
	}
	else
	{
		winsplit.sliderclear.SetEnable( false );
		winsplit.edit1.clear.SetEnable( false );
	}
	for( var i = item1[0]; i > 0; --i )
	{
		if( item1[i] < pos1 )
		{
			winsplit.playslider.SetPos( item1[i] );
			if( 0 == nSel )
			{
				winsplit.sliderremove.SetEnable( true );
				winsplit.edit1.remove1.SetEnable( true );
			}
			else if( 1 == nSel )
			{
				winsplit.sliderremove.SetEnable( false );
				winsplit.edit1.remove1.SetEnable( false );
			}
			
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
			if( item1[i] <= item1[1] )
			{
				winsplit.slidercutuppoint.SetEnable( false );
				winsplit.edit1.skipuppoint.SetEnable( false );
				if( item1[i] == item1[1] )
				{
					if( item1[0] > 1 )
					{
						winsplit.slidercutnextpoint.SetEnable( true );
						winsplit.edit1.skipnextpoint.SetEnable( true );
					}
					else
					{
						winsplit.slidercutnextpoint.SetEnable( false );
						winsplit.edit1.skipnextpoint.SetEnable( false );
					}
				}
				else
				{
					winsplit.slidercutnextpoint.SetEnable( false );
					winsplit.edit1.skipnextpoint.SetEnable( false );
				}
			}
			else
			{
				if( item1[i] >= item1[item1[0]] )
				{
					winsplit.slidercutuppoint.SetEnable( true );
					winsplit.edit1.skipuppoint.SetEnable( true );
					winsplit.slidercutnextpoint.SetEnable( false );
					winsplit.edit1.skipnextpoint.SetEnable( false );
				}
				else
				{
					winsplit.slidercutuppoint.SetEnable( true );
					winsplit.edit1.skipuppoint.SetEnable( true );
					winsplit.slidercutnextpoint.SetEnable( true );
					winsplit.edit1.skipnextpoint.SetEnable( true );
				}
			}
			return;	
		}
	}
}

function SetSplitNextPoint( args )
{
	var item1 = winsplit.playslider.GetAllTick();
	var nSel = winsplit.radiogroup.GetCheck();
	var nTemp = 0;
	for( var m = 1; m < item1[0]; ++m )
		for( var n = m + 1; n < item1[0] + 1 ; ++n )
		{
			if( item1[n] < item1[m] )
			{
				nTemp = item1[n];
				item1[n] = item1[m];
				item1[m] = nTemp;
			}
		}
//	for( var j = 0; j < item1[0]; ++j )
//	{
//		Msg( item1[j+1] );
//	}
	var pos1 = winsplit.playslider.GetPos();
	if( item1[0] > 0 && 0 == nSel)
	{
		winsplit.sliderclear.SetEnable( true );
		winsplit.edit1.clear.SetEnable( true );
	}
	else
	{
		winsplit.sliderclear.SetEnable( false );
		winsplit.edit1.clear.SetEnable( false );
	}
	for( var i = 1; i < item1[0] + 1; ++i )
	{
		if( item1[i] > pos1 )
		{
			winsplit.playslider.SetPos( item1[i] );
			if( 0 == nSel )
			{
				winsplit.sliderremove.SetEnable( true );
				winsplit.edit1.remove1.SetEnable( true );
			}
			else if( 1 == nSel )
			{
				winsplit.sliderremove.SetEnable( false );
				winsplit.edit1.remove1.SetEnable( false );
			}
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
			if( item1[i] <= item1[1] )
			{
				winsplit.slidercutuppoint.SetEnable( false );
				winsplit.edit1.skipuppoint.SetEnable( false );
				if( item1[i] == item1[1] )
				{
					if( item1[0] > 1 )
					{
						winsplit.slidercutnextpoint.SetEnable( true );
						winsplit.edit1.skipnextpoint.SetEnable( true );
					}
					else
					{
						winsplit.slidercutnextpoint.SetEnable( false );
						winsplit.edit1.skipnextpoint.SetEnable( false );
					}
				}
				else
				{
					winsplit.slidercutnextpoint.SetEnable( false );
					winsplit.edit1.skipnextpoint.SetEnable( false );
				}
			}
			else
			{
				if( item1[i] >= item1[item1[0]] )
				{
					winsplit.slidercutuppoint.SetEnable( true );
					winsplit.edit1.skipuppoint.SetEnable( true );
					winsplit.slidercutnextpoint.SetEnable( false );
					winsplit.edit1.skipnextpoint.SetEnable( false );
				}
				else
				{
					winsplit.slidercutuppoint.SetEnable( true );
					winsplit.edit1.skipuppoint.SetEnable( true );
					winsplit.slidercutnextpoint.SetEnable( true );
					winsplit.edit1.skipnextpoint.SetEnable( true );
				}
			}
			return;	
		}
	}
}

function SplitShowFileOpenErroLog( args )
{
	splitlogwin.logstatic.SetText( args[2] );
	splitlogwin.ShowModal(winsplit);
}

function SetSplitClearDiskSize( args )
{
	nSplitDiskClearSizi = args[2];
}

function OnSplitVolume( args )
{
	if( m_nSplitPlayVolume == 1 )
	{
		m_nSplitPlayVolume = 2;
		winsplit.playervolume.SetImage( "joiner_mute.png" );
		g_videoeditor.SetVolumeMute( 1 );
	}
	else if( 2 == m_nSplitPlayVolume )
	{
		m_nSplitPlayVolume = 1;
		winsplit.playervolume.SetImage("joiner_volume.png");
		g_videoeditor.SetVolumeMute( 0 );
	}
}

function DisableSplitMuteVolume( args )
{
	winsplit.playervolume.SetEnable( false );
	winsplit.volumeslider.SetEnable( false );
}

function ErrorSplitterSplit( args )
{
//	splitoutwin.outjoining.SetText( LanguageStr("_errorsplitting") );
	ShowMsg(splitoutwin, LanguageStr("_errorsplitting"), Product.GetProductName(), 1 );
	if( 1 == g_msgvalue )
	{
		splitoutwin.Close();
		m_nSplitFlag = 0;
	}
	splitoutwin.stdout.SetImage("defimage.png");
}

function SplitTargetEditKillFocus( args )
{
	var strsource = winsplit.outsourceedit.GetText();
	var strtarget = winsplit.outtargetedit.GetText();
	g_videoeditor.ResetTargetPath( strsource, "", strtarget );
}

////////////////////////////////////////////////////////////////////////////////////////
//-add by pengl

function onplay_start_split()
{
	if (vsplit_player_status == 0) {
		var str_fn = g_videoeditor.get_current_play_file();
		
		if (str_fn.length <= 0) {
			return;
		}
		
		var start_play = 1;
		vsplit_player_status = 1;
		g_videoeditor.player_manipulation(start_play, str_fn);		
		update_player_btn_split(2);
		winsplit.player1.SetImage( "joiner_Pause.png" );
		winsplit.player1.SetTipText( LanguageStr("_playerpause1") );//LiQiang 2007-07-20 14:18
		
		update_split_btn_state_onplay(1); //play
	}
	else {
		var pause_play = 2;
		vsplit_player_status = 0;
		g_videoeditor.player_manipulation(pause_play);
		winsplit.player1.SetImage("joiner_play.png");
		winsplit.player1.SetTipText( LanguageStr("_playerplay1") );//LiQiang 2007-07-20 14:18
		update_player_btn_split(5);
		
		update_split_btn_state_onplay(2); //pause
	}
	return;
}

function onplayer_split_move()
{
	g_videoeditor.on_player_win_move();
}

//play the previous frame for the video
function onplay_previous_split()
{
	var previous = 3
	g_videoeditor.player_manipulation(previous);
}


//play the next frame
function onplay_next_split()
{
	var next = 4;
	g_videoeditor.player_manipulation(next);
}


//stop it
function play_stop_split()
{
	var stop = 5;
	g_videoeditor.player_manipulation(stop);
	winsplit.player.SetImage("defimage.png")
	winsplit.player1.SetTipText( LanguageStr("_playerplay1") );
	winsplit.playtime.SetText("00:00:00");
	winisplit.playslider.SetPos(0);
	vsplit_player_status = 0;
	update_player_btn_split(3);
}

function onplay_stop_split()
{
	var stop = 5;
	
	vsplit_player_status = 0;
	
	g_videoeditor.player_manipulation(stop);
	winsplit.player.SetImage("defimage.png")
	winsplit.player1.SetImage("joiner_play.png");
	winsplit.player1.SetTipText( LanguageStr("_playerplay1") );
	winsplit.playtime.SetText("00:00:00");
	winsplit.playslider.SetPos(0);
	update_player_btn_split(3);
	
	
	update_split_btn_state_onplay(0); //stop
}



//2007001: update slider's info
//2007002: stop player
function OnMessage_split(args)
{
	var msg = args[2];
	if(msg == 2007001) {
		var str = args[3];
		var timedisp = "00:00:00";
		var timepos = 0;
		
		if (str.indexOf("[???]") != -1) {
			var nNum = 0;
			var strarray = str.split("[???]");
			if (strarray.length < 2) {
				timedisp = "00:00:00";
				timpos = 0;
			}
			else {
				timedisp = strarray[0];
				timepos = strarray[1];
			}
		}
		else {
			timedisp = "00:00:00";
			timepos = 0;
		}

		var time_val = timepos;		
		timepos = g_videoeditor.get_integer(time_val);
			
		var position = winsplit.playslider.GetPos();
		var delta = position - timepos;
		if (delta > 2 || delta < -2) {
			g_videoeditor.VideoSeek(position*1000);
			timepos = position;
		}
		
		winsplit.playtime.SetText(timedisp);
		winsplit.playslider.SetPos(timepos);
	}		
	if(msg == 2007002) {
		onplay_stop_split();
		update_player_btn_split(3);
	}
	if (msg == 2007003) {
		onplay_stop_split();
		update_player_btn_split(3);
	}
}


function update_player_btn_split(args)
{
	if (args == 1) { //before start play
		winsplit.player1.SetEnable(true);
		winsplit.playerprevious.SetEnable(false);
		winsplit.playernext.SetEnable(false); //next
		winsplit.playerstop.SetEnable(false); //previous
	}
	else if (args == 2) { //has played
		winsplit.player1.SetEnable(true);
		winsplit.playerprevious.SetEnable(true);
		winsplit.playernext.SetEnable(true); //next
		winsplit.playerstop.SetEnable(true); //previous
	}		
	else if (args == 3) { //after click stop
		winsplit.player1.SetEnable(true);
		winsplit.playerprevious.SetEnable(false);
		winsplit.playernext.SetEnable(false); //next
		winsplit.playerstop.SetEnable(false); //previous
	}
	else if (args == 4) { //null file
		winsplit.player1.SetEnable(false);
		winsplit.playerprevious.SetEnable(false);
		winsplit.playernext.SetEnable(false); //next
		winsplit.playerstop.SetEnable(false); //previous
	}
	else if (args == 5) { //when user click pause 
		winsplit.player1.SetEnable(true);
		winsplit.playerprevious.SetEnable(false);
		winsplit.playernext.SetEnable(false); //next
		winsplit.playerstop.SetEnable(true); //previous
	}
}


function split_slider_change(args)
{
//	if (vsplit_player_status == 0) {
//		winsplit.playtime.SetText("00:00:00");
//		winsplit.playslider.SetPos(0);
//		return;
//	}
	
	var pos = args[2];//winsplit.playslider.GetPos();
	pos = pos * 1000;
	g_videoeditor.VideoSeek(pos);
}


//add liqiang 2007-08-20
function update_split_btn_state_onplay(args)
{
	var nPos = winsplit.playslider.GetPos();
	var nMin = winsplit.playslider.GetRangeMin();
	var nMax = winsplit.playslider.GetRangeMax();
	var nSel = winsplit.radiogroup.GetCheck();
	
	if (args == 1/*play*/) 
	{
	
		if( 0 == nSel )
		{
			winsplit.slidercut.SetEnable( true );
			winsplit.edit1.setsplitpoint.SetEnable( true );
			winsplit.slidercutuppoint.SetEnable( false );
			winsplit.edit1.skipuppoint.SetEnable( false );
			winsplit.slidercutnextpoint.SetEnable( false );
			winsplit.edit1.skipnextpoint.SetEnable( false );
			winsplit.sliderremove.SetEnable( false );
			winsplit.edit1.remove1.SetEnable( false );
	//		winsplit.sliderclear.SetEnable( false );
	//		winsplit.edit1.clear.SetEnable( false );	
		}
		else if( 1 == nSel )
		{
			winsplit.slidercut.SetEnable( false );
			winsplit.edit1.setsplitpoint.SetEnable( false );
			winsplit.slidercutuppoint.SetEnable( false );
			winsplit.edit1.skipuppoint.SetEnable( false );
			winsplit.slidercutnextpoint.SetEnable( false );
			winsplit.edit1.skipnextpoint.SetEnable( false );
			winsplit.sliderremove.SetEnable( false );
			winsplit.edit1.remove1.SetEnable( false );
			winsplit.sliderclear.SetEnable( false );
			winsplit.edit1.clear.SetEnable( false );	
		}
	}
	else if(args == 2/*pause*/){
		SplitSliderBlockStateChange();
		if( 1 == nSel )
		{
//			winsplit.slidercutuppoint.SetEnable( false );
//			winsplit.edit1.skipuppoint.SetEnable( false );
//			winsplit.slidercutnextpoint.SetEnable( false );
//			winsplit.edit1.skipnextpoint.SetEnable( false );
//			winsplit.sliderclear.SetEnable( false );
//			winsplit.edit1.clear.SetEnable( false );	
		}
	}
	else if (args == 0/*stop*/) {
		SplitSliderBlockStateChange();
		if( 1 == nSel )
		{
//			winsplit.slidercutuppoint.SetEnable( false );
//			winsplit.edit1.skipuppoint.SetEnable( false );
//			winsplit.slidercutnextpoint.SetEnable( false );
//			winsplit.edit1.skipnextpoint.SetEnable( false );
//			winsplit.sliderclear.SetEnable( false );
//			winsplit.edit1.clear.SetEnable( false );	
		}
	}
}
//addend

//end
////////////////////////////////////////////////////////////////////////////////////////