
zbOptions.init=function()
{	
	document.title=$lang("ZBrowser_options");	
	zbOptions.adjustHeight();
  zbOptions.buildSideBar();
  zbOptions.activatePage("general")  
};

zbOptions.adjustHeight=function()
{
  var B=$id("sidebar");
  var A=document.documentElement.clientHeight-B.offsetTop;
  B.style.height=A;
  var B=$id("contentBlock");
  A=document.documentElement.clientHeight-B.offsetTop-22;
  $id("pageContent").style.height=A
};

zbOptions.buildSideBar=function()
{	
  var A="";
  for(label in zbOptions.pages)
  {
    if(zbOptions.pages[label].type=="separator")
    {
      A+="<hr/>"
    }
    else
    {
      A+='<a id="sidelink_'+label+'" class="pageLink" href="javascript:;" onclick="this.blur();zbOptions.activatePage(\''+label+'\');"><img src="images/page_'+label+'.png"/> '+$lang("page_"+label)+"</a>\n"
    }
  }
  
  $("#pageLinks").html(A);  
};


zbOptions.activatePage=function(targetPage)
{
  var obj=$id("sidelink_"+zbOptions.currentPage);  
  
  if(obj)
  {
    obj.className=""
  }
  obj=$id("sidelink_"+targetPage);  
  if(obj)
  {
    obj.className="active"
  }
  zbOptions.setPageHeader(targetPage);
  zbOptions.buildPage(targetPage);
  zbOptions.currentPage=targetPage;    
};

zbOptions.setPageHeader=function(title)
{
  var s=$lang("page_"+title);
  $("#pageHeader").html(s);
};

zbOptions.buildPage=function(C)
{
  var B=$("#pageContent");
  if(!B)
  {
    alert("maxOptions.ui.buildPage :: missing 'pageContent' object")
  }
  
  var A=maxConfig.ui.buildItems(zbOptions.pages[C].items);
  A+="<br/><br/><br/><br/><br/><br/>";
  B.html(A);
};

zbOptions.toggleSidebar=function()
{
  var B=$id("sidebarWrapper");
  var A=$id("btnSidebar");
  if($toggleElement("sidebar"))
  {
    B.style.width="";
    A.src="../common/images/btn_hide_sidebar.png"
  }
  else
  {
    B.style.width="8";
    A.src="../common/images/btn_show_sidebar.png"
  }
};


zbOptions.applyChanges=function()
{
  external.SaveSettings();
  zbOptions.showMessage($lang("config_saved"),3000)
};


zbOptions.close=function(bCallClose)
{
	if(external.IsModified())
	{
		if(confirm("["+$lang("ZBrowser_options")+"]\n\n"+$lang("config_not_saved_confirm")))
		{
			zbOptions.applyChanges()
		}
		else
			external.CancelChanges();
	}
	
	if(bCallClose)
  	external.CloseSettingsCenter();
};

zbOptions.showMessage=function(C,A)
{
  var B=$id("msgBox");
  if(B)
  {
    B.innerHTML=C;
    B.style.display="block";
    window.setTimeout(zbOptions.clearMessage,A)
  }
};

zbOptions.clearMessage=function()
{
  var A=$id("msgBox");
  if(A)
  {
    A.innerHTML="";
    A.style.display="none"
  }
};