/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

public final class ZipLong
implements Cloneable {
    private static final int WORD = 4;
    private static final int BYTE_MASK = 255;
    private static final int BYTE_1 = 1;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private static final int BYTE_2 = 2;
    private static final int BYTE_2_MASK = 0xFF0000;
    private static final int BYTE_2_SHIFT = 16;
    private static final int BYTE_3 = 3;
    private static final long BYTE_3_MASK = 0xFF000000L;
    private static final int BYTE_3_SHIFT = 24;
    private long value;

    public ZipLong(long l2) {
        this.value = l2;
    }

    public ZipLong(byte[] byArray) {
        this(byArray, 0);
    }

    public ZipLong(byte[] byArray, int n2) {
        this.value = ZipLong.getValue(byArray, n2);
    }

    public final byte[] getBytes() {
        return ZipLong.getBytes(this.value);
    }

    public final long getValue() {
        return this.value;
    }

    public static byte[] getBytes(long l2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(l2 & 0xFFL);
        byArray2[1] = (byte)((l2 & 0xFF00L) >> 8);
        byArray2[2] = (byte)((l2 & 0xFF0000L) >> 16);
        byArray2[3] = (byte)((l2 & 0xFF000000L) >> 24);
        return byArray2;
    }

    public static long getValue(byte[] byArray, int n2) {
        long l2 = (long)(byArray[n2 + 3] << 24) & 0xFF000000L;
        l2 += (long)(byArray[n2 + 2] << 16 & 0xFF0000);
        l2 += (long)(byArray[n2 + 1] << 8 & 0xFF00);
        return l2 += (long)(byArray[n2] & 0xFF);
    }

    public static long getValue(byte[] byArray) {
        return ZipLong.getValue(byArray, 0);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)object).getValue();
    }

    public final int hashCode() {
        return (int)this.value;
    }
}

