/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AnimatedProgress
extends Canvas {
    static final int SLEEP = 70;
    static final int DEFAULT_WIDTH = 160;
    static final int DEFAULT_HEIGHT = 18;
    boolean active = false;
    boolean showStripes = false;
    int value;
    int orientation = 256;
    boolean showBorder = false;

    public AnimatedProgress(Composite composite, int n2) {
        super(composite, AnimatedProgress.checkStyle(n2));
        if ((n2 & 0x200) != 0) {
            this.orientation = 512;
        }
        this.showBorder = (n2 & 0x800) != 0;
        this.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                AnimatedProgress.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                AnimatedProgress.this.paint(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AnimatedProgress.this.stop();
            }
        });
    }

    private static int checkStyle(int n2) {
        int n3 = 0;
        return n2 & n3;
    }

    public synchronized void clear() {
        this.checkWidget();
        if (this.active) {
            this.stop();
        }
        this.showStripes = false;
        this.redraw();
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        Point point = null;
        point = this.orientation == 256 ? new Point(160, 18) : new Point(18, 160);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    private void drawBevelRect(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        gC.setForeground(color);
        gC.drawLine(n2, n3, n2 + n4 - 1, n3);
        gC.drawLine(n2, n3, n2, n3 + n5 - 1);
        gC.setForeground(color2);
        gC.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
        gC.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
    }

    void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        gC.fillRectangle(rectangle);
        if (this.showBorder) {
            this.drawBevelRect(gC, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, display.getSystemColor(18), display.getSystemColor(20));
        }
        this.paintStripes(gC);
    }

    void paintStripes(GC gC) {
        int n2;
        if (!this.showStripes) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        rectangle = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        gC.setLineWidth(2);
        gC.setClipping(rectangle);
        Color color = this.getDisplay().getSystemColor(26);
        gC.setBackground(color);
        gC.fillRectangle(rectangle);
        gC.setForeground(this.getBackground());
        int n3 = 12;
        int n4 = n2 = this.value == 0 ? n3 - 2 : this.value - 2;
        if (this.orientation == 256) {
            int n5 = rectangle.y - 1;
            int n6 = rectangle.width;
            int n7 = rectangle.height + 2;
            int n8 = 0;
            while (n8 < n6) {
                int n9 = n8 + n2;
                gC.drawLine(n9, n5, n9, n7);
                n8 += n3;
            }
        } else {
            int n10 = rectangle.x - 1;
            int n11 = rectangle.width + 2;
            int n12 = rectangle.height;
            int n13 = 0;
            while (n13 < n12) {
                int n14 = n13 + n2;
                gC.drawLine(n10, n14, n11, n14);
                n13 += n3;
            }
        }
        if (this.active) {
            this.value = (this.value + 2) % n3;
        }
    }

    public synchronized void start() {
        Runnable[] runnableArray;
        this.checkWidget();
        if (this.active) {
            return;
        }
        this.active = true;
        this.showStripes = true;
        final Display display = this.getDisplay();
        runnableArray = new Runnable[]{new Runnable(){

            public void run() {
                if (!AnimatedProgress.this.active) {
                    return;
                }
                GC gC = new GC(AnimatedProgress.this);
                AnimatedProgress.this.paintStripes(gC);
                gC.dispose();
                display.timerExec(70, runnableArray[0]);
            }
        }};
        display.timerExec(70, runnableArray[0]);
    }

    public synchronized void stop() {
        this.active = false;
    }
}

