/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color selectionFadeStart;
    Color selectionHighlightGradientBegin = null;
    Color[] selectionHighlightGradientColorsCache = null;
    Image bgImage;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    static Color borderColor;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 1;
    boolean showChevron = false;
    Menu showMenu;
    boolean showMin = false;
    Rectangle minRect = new Rectangle(0, 0, 0, 0);
    boolean minimized = false;
    int minImageState = 1;
    boolean showMax = false;
    Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    boolean maximized = false;
    int maxImageState = 1;
    Control topRight;
    Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    int topRightAlignment = 131072;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    int borderBottom = 0;
    int highlight_margin = 0;
    int highlight_header = 0;
    int[] curve;
    int[] topCurveHighlightStart;
    int[] topCurveHighlightEnd;
    int curveWidth = 0;
    int curveIndent = 0;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_SIZE = 18;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_LEFT_CORNER_HILITE;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_UNSELECTED_INNER_CORNER;
    static final int[] TOP_LEFT_CORNER_BORDERLESS;
    static final int[] TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int BORDER1_COLOR = 18;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int HOT = 2;
    static final int SELECTED = 3;
    static final RGB CLOSE_FILL;
    static final int CHEVRON_CHILD_ID = 0;
    static final int MINIMIZE_CHILD_ID = 1;
    static final int MAXIMIZE_CHILD_ID = 2;
    static final int EXTRA_CHILD_ID_COUNT = 3;

    static {
        int[] nArray = new int[12];
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 1;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 1;
        nArray[8] = 5;
        nArray[9] = 1;
        nArray[10] = 6;
        TOP_LEFT_CORNER = nArray;
        TOP_LEFT_CORNER_HILITE = new int[]{5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 1, 6};
        int[] nArray2 = new int[12];
        nArray2[0] = -6;
        nArray2[2] = -5;
        nArray2[3] = 1;
        nArray2[4] = -4;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = 4;
        nArray2[8] = -1;
        nArray2[9] = 5;
        nArray2[11] = 6;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -6;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -4;
        nArray3[6] = 4;
        nArray3[7] = -1;
        nArray3[8] = 5;
        nArray3[9] = -1;
        nArray3[10] = 6;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -6;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -6;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 2;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 2;
        SIMPLE_TOP_LEFT_CORNER = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = -2;
        nArray7[2] = 1;
        nArray7[3] = -1;
        nArray7[4] = 2;
        SIMPLE_BOTTOM_LEFT_CORNER = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = -2;
        nArray8[2] = -1;
        nArray8[3] = -1;
        nArray8[5] = -2;
        SIMPLE_BOTTOM_RIGHT_CORNER = nArray8;
        SIMPLE_UNSELECTED_INNER_CORNER = new int[2];
        int[] nArray9 = new int[12];
        nArray9[1] = 6;
        nArray9[2] = 1;
        nArray9[3] = 5;
        nArray9[4] = 1;
        nArray9[5] = 4;
        nArray9[6] = 4;
        nArray9[7] = 1;
        nArray9[8] = 5;
        nArray9[9] = 1;
        nArray9[10] = 6;
        TOP_LEFT_CORNER_BORDERLESS = nArray9;
        int[] nArray10 = new int[12];
        nArray10[0] = -7;
        nArray10[2] = -6;
        nArray10[3] = 1;
        nArray10[4] = -5;
        nArray10[5] = 1;
        nArray10[6] = -2;
        nArray10[7] = 4;
        nArray10[8] = -2;
        nArray10[9] = 5;
        nArray10[10] = -1;
        nArray10[11] = 6;
        TOP_RIGHT_CORNER_BORDERLESS = nArray10;
        int[] nArray11 = new int[16];
        nArray11[1] = -6;
        nArray11[2] = 1;
        nArray11[3] = -6;
        nArray11[4] = 1;
        nArray11[5] = -5;
        nArray11[6] = 2;
        nArray11[7] = -4;
        nArray11[8] = 4;
        nArray11[9] = -2;
        nArray11[10] = 5;
        nArray11[11] = -1;
        nArray11[12] = 6;
        nArray11[13] = -1;
        nArray11[14] = 6;
        BOTTOM_LEFT_CORNER_BORDERLESS = nArray11;
        int[] nArray12 = new int[16];
        nArray12[0] = -7;
        nArray12[2] = -7;
        nArray12[3] = -1;
        nArray12[4] = -6;
        nArray12[5] = -1;
        nArray12[6] = -5;
        nArray12[7] = -2;
        nArray12[8] = -3;
        nArray12[9] = -4;
        nArray12[10] = -2;
        nArray12[11] = -5;
        nArray12[12] = -2;
        nArray12[13] = -6;
        nArray12[14] = -1;
        nArray12[15] = -6;
        BOTTOM_RIGHT_CORNER_BORDERLESS = nArray12;
        int[] nArray13 = new int[6];
        nArray13[1] = 2;
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[4] = 2;
        SIMPLE_TOP_LEFT_CORNER_BORDERLESS = nArray13;
        int[] nArray14 = new int[6];
        nArray14[0] = -3;
        nArray14[2] = -2;
        nArray14[3] = 1;
        nArray14[4] = -1;
        nArray14[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER_BORDERLESS = nArray14;
        int[] nArray15 = new int[8];
        nArray15[1] = -3;
        nArray15[2] = 1;
        nArray15[3] = -2;
        nArray15[4] = 2;
        nArray15[5] = -1;
        nArray15[6] = 3;
        SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS = nArray15;
        int[] nArray16 = new int[8];
        nArray16[0] = -4;
        nArray16[2] = -3;
        nArray16[3] = -1;
        nArray16[4] = -2;
        nArray16[5] = -2;
        nArray16[6] = -1;
        nArray16[7] = -3;
        SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS = nArray16;
        CLOSE_FILL = new RGB(252, 160, 160);
    }

    public CTabFolder(Composite composite, int n2) {
        super(composite, CTabFolder.checkStyle(composite, n2));
        super.setLayout(new CTabFolderLayout());
        int n3 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (n3 & 0x400) != 0;
        this.showClose = (n3 & 0x40) != 0;
        this.single = (n3 & 4) != 0;
        this.borderRight = (n2 & 0x800) != 0 ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        this.highlight_header = (n2 & 0x800000) != 0 ? 1 : 3;
        this.highlight_margin = (n2 & 0x800000) != 0 ? 0 : 2;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        borderColor = display.getSystemColor(18);
        this.updateTabHeight(false);
        this.initAccessible();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose(event);
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 6: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 29, 15, 16, 1, 8, 3, 6, 7, 5, 4, 9, 11, 31};
        int n4 = 0;
        while (n4 < nArray.length) {
            this.addListener(nArray[n4], this.listener);
            ++n4;
        }
    }

    static int checkStyle(Composite composite, int n2) {
        int n3 = 109053126;
        if (((n2 &= n3) & 0x80) != 0) {
            n2 &= 0xFFFFFBFF;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        n2 |= 0x100000;
        String string = SWT.getPlatform();
        if ("carbon".equals(string) || "gtk".equals(string)) {
            return n2;
        }
        if ((n2 & 0x4000000) != 0) {
            return n2;
        }
        if ((composite.getStyle() & 0x8000000) != 0 && (n2 & 0x2000000) == 0) {
            return n2;
        }
        return n2 | 0x40000;
    }

    static void fillRegion(GC gC, Region region) {
        Region region2 = new Region();
        gC.getClipping(region2);
        region.intersect(region2);
        gC.setClipping(region);
        gC.fillRectangle(region.getBounds());
        gC.setClipping(region2);
        region2.dispose();
    }

    public void addCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, this.folderListeners.length);
        this.folderListeners = cTabFolder2ListenerArray;
        this.folderListeners[this.folderListeners.length - 1] = cTabFolder2Listener;
    }

    public void addCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, this.tabListeners.length);
        this.tabListeners = cTabFolderListenerArray;
        this.tabListeners[this.tabListeners.length - 1] = cTabFolderListener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void antialias(int[] nArray, RGB rGB, RGB rGB2, RGB rGB3, GC gC) {
        Color color;
        int n2;
        int n3;
        int n4;
        RGB rGB4;
        int n5;
        int n6;
        if (this.simple || "carbon".equals(SWT.getPlatform()) || "wpf".equals(SWT.getPlatform())) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (rGB3 != null) {
            int n7 = 0;
            n6 = 1;
            n5 = this.onBottom ? 0 : this.getSize().y;
            int[] nArray2 = new int[nArray.length];
            int n8 = 0;
            while (n8 < nArray.length / 2) {
                if (n6 != 0 && n7 + 3 < nArray.length) {
                    n6 = this.onBottom ? (n5 <= nArray[n7 + 3] ? 1 : 0) : (n5 >= nArray[n7 + 3] ? 1 : 0);
                    n5 = nArray[n7 + 1];
                }
                nArray2[n7] = nArray[n7++] + (n6 != 0 ? -1 : 1);
                nArray2[n7] = nArray[n7++];
                ++n8;
            }
            RGB rGB5 = rGB;
            rGB4 = rGB3;
            n4 = rGB5.red + 2 * (rGB4.red - rGB5.red) / 3;
            n3 = rGB5.green + 2 * (rGB4.green - rGB5.green) / 3;
            n2 = rGB5.blue + 2 * (rGB4.blue - rGB5.blue) / 3;
            color = new Color(this.getDisplay(), n4, n3, n2);
            gC.setForeground(color);
            gC.drawPolyline(nArray2);
            color.dispose();
        }
        if (rGB2 != null) {
            int[] nArray3 = new int[nArray.length];
            n6 = 0;
            n5 = 1;
            int n9 = this.onBottom ? 0 : this.getSize().y;
            int n10 = 0;
            while (n10 < nArray.length / 2) {
                if (n5 != 0 && n6 + 3 < nArray.length) {
                    n5 = this.onBottom ? (n9 <= nArray[n6 + 3] ? 1 : 0) : (n9 >= nArray[n6 + 3] ? 1 : 0);
                    n9 = nArray[n6 + 1];
                }
                nArray3[n6] = nArray[n6++] + (n5 != 0 ? 1 : -1);
                nArray3[n6] = nArray[n6++];
                ++n10;
            }
            RGB rGB6 = rGB;
            rGB4 = rGB2;
            n4 = rGB6.red + 2 * (rGB4.red - rGB6.red) / 3;
            n3 = rGB6.green + 2 * (rGB4.green - rGB6.green) / 3;
            n2 = rGB6.blue + 2 * (rGB4.blue - rGB6.blue) / 3;
            color = new Color(this.getDisplay(), n4, n3, n2);
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
            color.dispose();
        }
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        int n6 = n2 - this.marginWidth - this.highlight_margin - this.borderLeft;
        int n7 = n4 + this.borderLeft + this.borderRight + 2 * this.marginWidth + 2 * this.highlight_margin;
        if (this.minimized) {
            int n8 = this.onBottom ? n3 - this.borderTop : n3 - this.highlight_header - this.tabHeight - this.borderTop;
            int n9 = this.borderTop + this.borderBottom + this.tabHeight + this.highlight_header;
            return new Rectangle(n6, n8, n7, n9);
        }
        int n10 = this.onBottom ? n3 - this.marginHeight - this.highlight_margin - this.borderTop : n3 - this.marginHeight - this.highlight_header - this.tabHeight - this.borderTop;
        int n11 = n5 + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + this.highlight_header + this.highlight_margin;
        return new Rectangle(n6, n10, n7, n11);
    }

    void createItem(CTabItem cTabItem, int n2) {
        if (n2 < 0 || n2 > this.getItemCount()) {
            SWT.error(6);
        }
        cTabItem.parent = this;
        CTabItem[] cTabItemArray = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n2);
        cTabItemArray[n2] = cTabItem;
        System.arraycopy(this.items, n2, cTabItemArray, n2 + 1, this.items.length - n2);
        this.items = cTabItemArray;
        if (this.selectedIndex >= n2) {
            ++this.selectedIndex;
        }
        int[] nArray = new int[this.priority.length + 1];
        int n3 = 0;
        int n4 = this.priority.length;
        int n5 = 0;
        while (n5 < this.priority.length) {
            if (!this.mru && this.priority[n5] == n2) {
                n4 = n3++;
            }
            nArray[n3++] = this.priority[n5] >= n2 ? this.priority[n5] + 1 : this.priority[n5];
            ++n5;
        }
        nArray[n4] = n2;
        this.priority = nArray;
        if (this.items.length == 1) {
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redrawTabs();
        }
    }

    void destroyItem(CTabItem cTabItem) {
        if (this.inDispose) {
            return;
        }
        int n2 = this.indexOf(cTabItem);
        if (n2 == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = cTabItem.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            this.setButtonBounds();
            this.redraw();
            return;
        }
        CTabItem[] cTabItemArray = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n2);
        System.arraycopy(this.items, n2 + 1, cTabItemArray, n2, this.items.length - n2 - 1);
        this.items = cTabItemArray;
        int[] nArray = new int[this.priority.length - 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.priority.length) {
            if (this.priority[n4] != n2) {
                nArray[n3++] = this.priority[n4] > n2 ? this.priority[n4] - 1 : this.priority[n4];
            }
            ++n4;
        }
        this.priority = nArray;
        if (this.selectedIndex == n2) {
            Control control = cTabItem.getControl();
            this.selectedIndex = -1;
            int n5 = this.mru ? this.priority[0] : Math.max(0, n2 - 1);
            this.setSelection(n5, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > n2) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redrawTabs();
    }

    void drawBackground(GC gC, int[] nArray, boolean bl2) {
        Color color = bl2 ? this.selectionBackground : this.getBackground();
        Image image = bl2 ? this.selectionBgImage : this.bgImage;
        Color[] colorArray = bl2 ? this.selectionGradientColors : this.gradientColors;
        int[] nArray2 = bl2 ? this.selectionGradientPercents : this.gradientPercents;
        boolean bl3 = bl2 ? this.selectionGradientVertical : this.gradientVertical;
        Point point = this.getSize();
        int n2 = point.x;
        int n3 = this.tabHeight + this.highlight_header;
        int n4 = 0;
        if (this.borderLeft > 0) {
            ++n4;
            n2 -= 2;
        }
        int n5 = this.onBottom ? point.y - this.borderBottom - n3 : this.borderTop;
        this.drawBackground(gC, nArray, n4, n5, n2, n3, color, image, colorArray, nArray2, bl3);
    }

    void drawBackground(GC gC, int[] nArray, int n2, int n3, int n4, int n5, Color color, Image image, Color[] colorArray, int[] nArray2, boolean bl2) {
        Region region = new Region();
        gC.getClipping(region);
        Region region2 = new Region();
        region2.add(nArray);
        region2.intersect(region);
        gC.setClipping(region2);
        if (image != null) {
            gC.setBackground(color);
            gC.fillRectangle(n2, n3, n4, n5);
            Rectangle rectangle = image.getBounds();
            gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, n3, n4, n5);
        } else if (colorArray != null) {
            if (colorArray.length == 1) {
                Color color2 = colorArray[0] != null ? colorArray[0] : color;
                gC.setBackground(color2);
                gC.fillRectangle(n2, n3, n4, n5);
            } else if (bl2) {
                if (this.onBottom) {
                    Color color3;
                    int n6 = 0;
                    if (nArray2[nArray2.length - 1] < 100) {
                        n6 = nArray2[nArray2.length - 1] * n5 / 100;
                        gC.setBackground(color);
                        gC.fillRectangle(n2, n3, n4, n6);
                    }
                    if ((color3 = colorArray[colorArray.length - 1]) == null) {
                        color3 = color;
                    }
                    int n7 = nArray2.length - 1;
                    while (n7 >= 0) {
                        gC.setForeground(color3);
                        color3 = colorArray[n7];
                        if (color3 == null) {
                            color3 = color;
                        }
                        gC.setBackground(color3);
                        int n8 = nArray2[n7] * n5 / 100;
                        gC.fillGradientRectangle(n2, n3 + n6, n4, n8, true);
                        n6 += n8;
                        --n7;
                    }
                } else {
                    Color color4 = colorArray[0];
                    if (color4 == null) {
                        color4 = color;
                    }
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < nArray2.length) {
                        gC.setForeground(color4);
                        color4 = colorArray[n10 + 1];
                        if (color4 == null) {
                            color4 = color;
                        }
                        gC.setBackground(color4);
                        int n11 = nArray2[n10] * n5 / 100;
                        gC.fillGradientRectangle(n2, n3 + n9, n4, n11, true);
                        n9 += n11;
                        ++n10;
                    }
                    if (n9 < n5) {
                        gC.setBackground(color);
                        gC.fillRectangle(n2, n9, n4, n5 - n9 + 1);
                    }
                }
            } else {
                n3 = 0;
                n5 = this.getSize().y;
                Color color5 = colorArray[0];
                if (color5 == null) {
                    color5 = color;
                }
                int n12 = 0;
                int n13 = 0;
                while (n13 < nArray2.length) {
                    gC.setForeground(color5);
                    color5 = colorArray[n13 + 1];
                    if (color5 == null) {
                        color5 = color;
                    }
                    gC.setBackground(color5);
                    int n14 = nArray2[n13] * n4 / 100 - n12;
                    gC.fillGradientRectangle(n2 + n12, n3, n14, n5, false);
                    n12 += n14;
                    ++n13;
                }
                if (n12 < n4) {
                    gC.setBackground(color);
                    gC.fillRectangle(n2 + n12, n3, n4 - n12, n5);
                }
            }
        } else if ((this.getStyle() & 0x40000) != 0 || !color.equals(this.getBackground())) {
            gC.setBackground(color);
            gC.fillRectangle(n2, n3, n4, n5);
        }
        gC.setClipping(region);
        region.dispose();
        region2.dispose();
    }

    void drawBody(Event event) {
        int n2;
        int n3;
        int n4;
        GC gC = event.gc;
        Point point = this.getSize();
        if (!this.minimized) {
            n4 = point.x - this.borderLeft - this.borderRight - 2 * this.highlight_margin;
            n3 = point.y - this.borderTop - this.borderBottom - this.tabHeight - this.highlight_header - this.highlight_margin;
            if (this.highlight_margin > 0) {
                int[] nArray = null;
                if (this.onBottom) {
                    n2 = this.borderLeft;
                    int n5 = this.borderTop;
                    int n6 = point.x - this.borderRight;
                    int n7 = point.y - this.borderBottom - this.tabHeight - this.highlight_header;
                    nArray = new int[]{n2, n5, n6, n5, n6, n7, n6 - this.highlight_margin, n7, n6 - this.highlight_margin, n5 + this.highlight_margin, n2 + this.highlight_margin, n5 + this.highlight_margin, n2 + this.highlight_margin, n7, n2, n7};
                } else {
                    n2 = this.borderLeft;
                    int n8 = this.borderTop + this.tabHeight + this.highlight_header;
                    int n9 = point.x - this.borderRight;
                    int n10 = point.y - this.borderBottom;
                    nArray = new int[]{n2, n8, n2 + this.highlight_margin, n8, n2 + this.highlight_margin, n10 - this.highlight_margin, n9 - this.highlight_margin, n10 - this.highlight_margin, n9 - this.highlight_margin, n8, n9, n8, n9, n10, n2, n10};
                }
                if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                    this.drawBackground(gC, nArray, true);
                } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                    this.drawBackground(gC, nArray, false);
                } else {
                    gC.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                    gC.fillPolygon(nArray);
                }
            }
            if ((this.getStyle() & 0x40000) != 0) {
                gC.setBackground(this.getBackground());
                gC.fillRectangle(this.xClient - this.marginWidth, this.yClient - this.marginHeight, n4, n3);
            }
        } else if ((this.getStyle() & 0x40000) != 0 && point.y > (n4 = this.borderTop + this.tabHeight + this.highlight_header + this.borderBottom)) {
            gC.setBackground(this.getParent().getBackground());
            gC.fillRectangle(0, n4, point.x, point.y - n4);
        }
        if (this.borderLeft > 0) {
            gC.setForeground(borderColor);
            n4 = this.borderLeft - 1;
            n3 = point.x - this.borderRight;
            int n11 = this.onBottom ? this.borderTop - 1 : this.borderTop + this.tabHeight;
            n2 = this.onBottom ? point.y - this.tabHeight - this.borderBottom - 1 : point.y - this.borderBottom;
            gC.drawLine(n4, n11, n4, n2);
            gC.drawLine(n3, n11, n3, n2);
            if (this.onBottom) {
                gC.drawLine(n4, n11, n3, n11);
            } else {
                gC.drawLine(n4, n2, n3, n2);
            }
        }
    }

    void drawChevron(GC gC) {
        int n2;
        if (this.chevronRect.width == 0 || this.chevronRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        Point point = display.getDPI();
        int n3 = 720 / point.y;
        FontData fontData = this.getFont().getFontData()[0];
        fontData.setHeight(n3);
        Font font = new Font((Device)display, fontData);
        int n4 = font.getFontData()[0].getHeight() * point.y / 72;
        int n5 = Math.max(2, (this.chevronRect.height - n4 - 4) / 2);
        int n6 = this.chevronRect.x + 2;
        int n7 = this.chevronRect.y + n5;
        if (this.single) {
            n2 = this.selectedIndex == -1 ? this.items.length : this.items.length - 1;
        } else {
            int n8 = 0;
            while (n8 < this.priority.length && this.items[this.priority[n8]].showing) {
                ++n8;
            }
            n2 = this.items.length - n8;
        }
        String string = n2 > 99 ? "99+" : String.valueOf(n2);
        switch (this.chevronImageState) {
            case 1: {
                Color color = this.single ? this.getSelectionForeground() : this.getForeground();
                gC.setForeground(color);
                gC.setFont(font);
                gC.drawLine(n6, n7, n6 + 2, n7 + 2);
                gC.drawLine(n6 + 2, n7 + 2, n6, n7 + 4);
                gC.drawLine(n6 + 1, n7, n6 + 3, n7 + 2);
                gC.drawLine(n6 + 3, n7 + 2, n6 + 1, n7 + 4);
                gC.drawLine(n6 + 4, n7, n6 + 6, n7 + 2);
                gC.drawLine(n6 + 6, n7 + 2, n6 + 5, n7 + 4);
                gC.drawLine(n6 + 5, n7, n6 + 7, n7 + 2);
                gC.drawLine(n6 + 7, n7 + 2, n6 + 4, n7 + 4);
                gC.drawString(string, n6 + 7, n7 + 3, true);
                break;
            }
            case 2: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gC.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gC.drawLine(n6, n7, n6 + 2, n7 + 2);
                gC.drawLine(n6 + 2, n7 + 2, n6, n7 + 4);
                gC.drawLine(n6 + 1, n7, n6 + 3, n7 + 2);
                gC.drawLine(n6 + 3, n7 + 2, n6 + 1, n7 + 4);
                gC.drawLine(n6 + 4, n7, n6 + 6, n7 + 2);
                gC.drawLine(n6 + 6, n7 + 2, n6 + 5, n7 + 4);
                gC.drawLine(n6 + 5, n7, n6 + 7, n7 + 2);
                gC.drawLine(n6 + 7, n7 + 2, n6 + 4, n7 + 4);
                gC.drawString(string, n6 + 7, n7 + 3, true);
                break;
            }
            case 3: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gC.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gC.drawLine(n6 + 1, n7 + 1, n6 + 3, n7 + 3);
                gC.drawLine(n6 + 3, n7 + 3, n6 + 1, n7 + 5);
                gC.drawLine(n6 + 2, n7 + 1, n6 + 4, n7 + 3);
                gC.drawLine(n6 + 4, n7 + 3, n6 + 2, n7 + 5);
                gC.drawLine(n6 + 5, n7 + 1, n6 + 7, n7 + 3);
                gC.drawLine(n6 + 7, n7 + 3, n6 + 6, n7 + 5);
                gC.drawLine(n6 + 6, n7 + 1, n6 + 8, n7 + 3);
                gC.drawLine(n6 + 8, n7 + 3, n6 + 5, n7 + 5);
                gC.drawString(string, n6 + 8, n7 + 4, true);
            }
        }
        font.dispose();
    }

    void drawMaximize(GC gC) {
        if (this.maxRect.width == 0 || this.maxRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n2 = this.maxRect.x + 4;
        int n3 = this.maxRect.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (this.maxImageState) {
            case 1: {
                if (!this.maximized) {
                    gC.fillRectangle(n2, n3, 9, 9);
                    gC.drawRectangle(n2, n3, 9, 9);
                    gC.drawLine(n2 + 1, n3 + 2, n2 + 8, n3 + 2);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gC.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gC.fillRectangle(n2, n3, 9, 9);
                    gC.drawRectangle(n2, n3, 9, 9);
                    gC.drawLine(n2 + 1, n3 + 2, n2 + 8, n3 + 2);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 3: {
                gC.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gC.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gC.fillRectangle(n2 + 1, n3 + 1, 9, 9);
                    gC.drawRectangle(n2 + 1, n3 + 1, 9, 9);
                    gC.drawLine(n2 + 2, n3 + 3, n2 + 9, n3 + 3);
                    break;
                }
                gC.fillRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.fillRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.drawRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawLine(n2 + 4, n3 + 2, n2 + 7, n3 + 2);
                gC.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 5);
            }
        }
    }

    void drawMinimize(GC gC) {
        if (this.minRect.width == 0 || this.minRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n2 = this.minRect.x + 4;
        int n3 = this.minRect.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (this.minImageState) {
            case 1: {
                if (!this.minimized) {
                    gC.fillRectangle(n2, n3, 9, 3);
                    gC.drawRectangle(n2, n3, 9, 3);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gC.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gC.fillRectangle(n2, n3, 9, 3);
                    gC.drawRectangle(n2, n3, 9, 3);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 3: {
                gC.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gC.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gC.fillRectangle(n2 + 1, n3 + 1, 9, 3);
                    gC.drawRectangle(n2 + 1, n3 + 1, 9, 3);
                    break;
                }
                gC.fillRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.fillRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.drawRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawLine(n2 + 4, n3 + 2, n2 + 7, n3 + 2);
                gC.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 5);
            }
        }
    }

    void drawTabArea(Event event) {
        int n2;
        int n3;
        Object object;
        int[] nArray;
        GC gC = event.gc;
        Point point = this.getSize();
        int[] nArray2 = null;
        if (this.tabHeight == 0) {
            int n4;
            int n5 = this.getStyle();
            if ((n5 & 0x800000) != 0 && (n5 & 0x800) == 0) {
                return;
            }
            int n6 = this.borderLeft - 1;
            int n7 = point.x - this.borderRight;
            int n8 = this.onBottom ? point.y - this.borderBottom - this.highlight_header - 1 : this.borderTop + this.highlight_header;
            int n9 = n4 = this.onBottom ? point.y - this.borderBottom : this.borderTop;
            if (this.borderLeft <= 0 || this.onBottom) {
                // empty if block
            }
            nArray2 = new int[]{n6, n8, n6, --n4, n7, n4, n7, n8};
            if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                this.drawBackground(gC, nArray2, true);
            } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                this.drawBackground(gC, nArray2, false);
            } else {
                gC.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                gC.fillPolygon(nArray2);
            }
            if (this.borderLeft > 0) {
                gC.setForeground(borderColor);
                gC.drawPolyline(nArray2);
            }
            return;
        }
        int n10 = Math.max(0, this.borderLeft - 1);
        int n11 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop;
        int n12 = point.x - this.borderLeft - this.borderRight + 1;
        int n13 = this.tabHeight - 1;
        if (this.onBottom) {
            if ((this.getStyle() & 0x800) != 0) {
                nArray = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                object = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            } else {
                nArray = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS : BOTTOM_LEFT_CORNER_BORDERLESS;
                object = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS : BOTTOM_RIGHT_CORNER_BORDERLESS;
            }
            nArray2 = new int[nArray.length + ((int[])object).length + 4];
            n3 = 0;
            nArray2[n3++] = n10;
            nArray2[n3++] = n11 - this.highlight_header;
            n2 = 0;
            while (n2 < nArray.length / 2) {
                nArray2[n3++] = n10 + nArray[2 * n2];
                nArray2[n3++] = n11 + n13 + nArray[2 * n2 + 1];
                if (this.borderLeft == 0) {
                    int n14 = n3 - 1;
                    nArray2[n14] = nArray2[n14] + 1;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < ((int[])object).length / 2) {
                nArray2[n3++] = n10 + n12 + object[2 * n2];
                nArray2[n3++] = n11 + n13 + object[2 * n2 + 1];
                if (this.borderLeft == 0) {
                    int n15 = n3 - 1;
                    nArray2[n15] = nArray2[n15] + 1;
                }
                ++n2;
            }
            nArray2[n3++] = n10 + n12;
            nArray2[n3++] = n11 - this.highlight_header;
        } else {
            if ((this.getStyle() & 0x800) != 0) {
                nArray = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                object = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            } else {
                nArray = this.simple ? SIMPLE_TOP_LEFT_CORNER_BORDERLESS : TOP_LEFT_CORNER_BORDERLESS;
                object = this.simple ? SIMPLE_TOP_RIGHT_CORNER_BORDERLESS : TOP_RIGHT_CORNER_BORDERLESS;
            }
            nArray2 = new int[nArray.length + ((int[])object).length + 4];
            n3 = 0;
            nArray2[n3++] = n10;
            nArray2[n3++] = n11 + n13 + this.highlight_header + 1;
            n2 = 0;
            while (n2 < nArray.length / 2) {
                nArray2[n3++] = n10 + nArray[2 * n2];
                nArray2[n3++] = n11 + nArray[2 * n2 + 1];
                ++n2;
            }
            n2 = 0;
            while (n2 < ((int[])object).length / 2) {
                nArray2[n3++] = n10 + n12 + object[2 * n2];
                nArray2[n3++] = n11 + object[2 * n2 + 1];
                ++n2;
            }
            nArray2[n3++] = n10 + n12;
            nArray2[n3++] = n11 + n13 + this.highlight_header + 1;
        }
        boolean bl2 = this.single && this.selectedIndex != -1;
        this.drawBackground(gC, nArray2, bl2);
        object = new Region();
        ((Region)object).add(new Rectangle(n10, n11, n12 + 1, n13 + 1));
        ((Region)object).subtract(nArray2);
        gC.setBackground(this.getParent().getBackground());
        CTabFolder.fillRegion(gC, (Region)object);
        ((Region)object).dispose();
        if (!this.single) {
            n3 = 0;
            while (n3 < this.items.length) {
                if (n3 != this.selectedIndex && event.getBounds().intersects(this.items[n3].getBounds())) {
                    this.items[n3].onPaint(gC, false);
                }
                ++n3;
            }
        }
        if (this.selectedIndex != -1) {
            CTabItem cTabItem = this.items[this.selectedIndex];
            cTabItem.onPaint(gC, true);
        } else {
            n3 = this.borderLeft;
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight - 1 : this.borderTop + this.tabHeight;
            int n16 = point.x - this.borderRight;
            gC.setForeground(borderColor);
            gC.drawLine(n3, n2, n16, n2);
        }
        this.drawChevron(gC);
        this.drawMinimize(gC);
        this.drawMaximize(gC);
        if (this.borderLeft > 0) {
            RGB rGB = this.getParent().getBackground().getRGB();
            this.antialias(nArray2, borderColor.getRGB(), null, rGB, gC);
            gC.setForeground(borderColor);
            gC.drawPolyline(nArray2);
        }
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderLeft == 1;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.minimized) {
            return new Rectangle(this.xClient, this.yClient, 0, 0);
        }
        Point point = this.getSize();
        int n2 = point.x - this.borderLeft - this.borderRight - 2 * this.marginWidth - 2 * this.highlight_margin;
        int n3 = point.y - this.borderTop - this.borderBottom - 2 * this.marginHeight - this.highlight_margin - this.highlight_header;
        return new Rectangle(this.xClient, this.yClient, n2, n3 -= this.tabHeight);
    }

    public CTabItem getItem(int n2) {
        if (n2 < 0 || n2 >= this.items.length) {
            SWT.error(6);
        }
        return this.items[n2];
    }

    public CTabItem getItem(Point point) {
        if (this.items.length == 0) {
            return null;
        }
        Point point2 = this.getSize();
        if (point2.x <= this.borderLeft + this.borderRight) {
            return null;
        }
        if (this.showChevron && this.chevronRect.contains(point)) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.priority.length) {
            CTabItem cTabItem = this.items[this.priority[n2]];
            Rectangle rectangle = cTabItem.getBounds();
            if (rectangle.contains(point)) {
                return cTabItem;
            }
            ++n2;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, cTabItemArray, 0, this.items.length);
        return cTabItemArray;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return String.valueOf(string.substring(0, n2 - 1)) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    int getRightItemEdge() {
        int n2 = this.getSize().x - this.borderRight - 3;
        if (this.showMin) {
            n2 -= 18;
        }
        if (this.showMax) {
            n2 -= 18;
        }
        if (this.showChevron) {
            n2 -= 27;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            Point point = this.topRight.computeSize(-1, -1);
            n2 -= point.x + 3;
        }
        return Math.max(0, n2);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int n2 = super.getStyle();
        n2 &= 0xFFFFFB7F;
        n2 |= this.onBottom ? 1024 : 128;
        n2 &= 0xFFFFFFF9;
        n2 |= this.single ? 4 : 2;
        if (this.borderLeft != 0) {
            n2 |= 0x800;
        }
        return n2;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2] == cTabItem) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                int n2 = accessibleEvent.childID;
                if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    string = CTabFolder.this.stripMnemonic(CTabFolder.this.items[n2].getText());
                } else if (n2 == CTabFolder.this.items.length + 0) {
                    string = SWT.getMessage("SWT_ShowList");
                } else if (n2 == CTabFolder.this.items.length + 1) {
                    string = CTabFolder.this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
                } else if (n2 == CTabFolder.this.items.length + 2) {
                    string = CTabFolder.this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
                }
                accessibleEvent.result = string;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                String string = null;
                int n2 = accessibleEvent.childID;
                if (n2 == -1) {
                    string = CTabFolder.this.getToolTipText();
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    string = CTabFolder.this.items[n2].getToolTipText();
                }
                accessibleEvent.result = string;
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c2;
                String string;
                String string2 = null;
                int n2 = accessibleEvent.childID;
                if (n2 >= 0 && n2 < CTabFolder.this.items.length && (string = CTabFolder.this.items[n2].getText()) != null && (c2 = CTabFolder.this._findMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c2;
                }
                accessibleEvent.result = string2;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = CTabFolder.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                int n2 = -2;
                int n3 = 0;
                while (n3 < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[n3].getBounds().contains(point)) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                if (n2 == -2) {
                    if (CTabFolder.this.showChevron && CTabFolder.this.chevronRect.contains(point)) {
                        n2 = CTabFolder.this.items.length + 0;
                    } else if (CTabFolder.this.showMin && CTabFolder.this.minRect.contains(point)) {
                        n2 = CTabFolder.this.items.length + 1;
                    } else if (CTabFolder.this.showMax && CTabFolder.this.maxRect.contains(point)) {
                        n2 = CTabFolder.this.items.length + 2;
                    } else {
                        Rectangle rectangle = CTabFolder.this.getBounds();
                        rectangle.height -= CTabFolder.this.getClientArea().height;
                        if (rectangle.contains(point)) {
                            n2 = -1;
                        }
                    }
                }
                accessibleControlEvent.childID = n2;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = null;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    rectangle = CTabFolder.this.getBounds();
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    rectangle = CTabFolder.this.items[n2].getBounds();
                } else if (CTabFolder.this.showChevron && n2 == CTabFolder.this.items.length + 0) {
                    rectangle = CTabFolder.this.chevronRect;
                } else if (CTabFolder.this.showMin && n2 == CTabFolder.this.items.length + 1) {
                    rectangle = CTabFolder.this.minRect;
                } else if (CTabFolder.this.showMax && n2 == CTabFolder.this.items.length + 2) {
                    rectangle = CTabFolder.this.maxRect;
                }
                if (rectangle != null) {
                    Point point = CTabFolder.this.toDisplay(rectangle.x, rectangle.y);
                    accessibleControlEvent.x = point.x;
                    accessibleControlEvent.y = point.y;
                    accessibleControlEvent.width = rectangle.width;
                    accessibleControlEvent.height = rectangle.height;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = CTabFolder.this.items.length + 3;
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                String string = null;
                int n2 = accessibleControlEvent.childID;
                if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    string = SWT.getMessage("SWT_Switch");
                }
                if (n2 >= CTabFolder.this.items.length && n2 < CTabFolder.this.items.length + 3) {
                    string = SWT.getMessage("SWT_Press");
                }
                accessibleControlEvent.result = string;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                int n2 = -2;
                if (CTabFolder.this.isFocusControl()) {
                    n2 = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                accessibleControlEvent.childID = n2;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n2 = 0;
                int n3 = accessibleControlEvent.childID;
                if (n3 == -1) {
                    n2 = 60;
                } else if (n3 >= 0 && n3 < CTabFolder.this.items.length) {
                    n2 = 37;
                } else if (n3 >= CTabFolder.this.items.length && n3 < CTabFolder.this.items.length + 3) {
                    n2 = 43;
                }
                accessibleControlEvent.detail = n2;
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n2 = 0;
                int n3 = accessibleControlEvent.childID;
                if (n3 == -1) {
                    n2 = 0;
                } else if (n3 >= 0 && n3 < CTabFolder.this.items.length) {
                    n2 = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        n2 |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == n3) {
                        n2 |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            n2 |= 4;
                        }
                    }
                } else if (n3 == CTabFolder.this.items.length + 0) {
                    n2 = CTabFolder.this.showChevron ? 0 : 32768;
                } else if (n3 == CTabFolder.this.items.length + 1) {
                    n2 = CTabFolder.this.showMin ? 0 : 32768;
                } else if (n3 == CTabFolder.this.items.length + 2) {
                    n2 = CTabFolder.this.showMax ? 0 : 32768;
                }
                accessibleControlEvent.detail = n2;
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n2 = CTabFolder.this.items.length + 3;
                Object[] objectArray = new Object[n2];
                int n3 = 0;
                while (n3 < n2) {
                    objectArray[n3] = new Integer(n3);
                    ++n3;
                }
                accessibleControlEvent.children = objectArray;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int n2;
                int n3;
                int n4 = this.items.length;
                if (n4 == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int n5 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n6 = n3 = event.keyCode == n5 ? -1 : 1;
                if (!this.mru) {
                    n2 = this.selectedIndex + n3;
                } else {
                    int[] nArray = new int[this.items.length];
                    int n7 = 0;
                    int n8 = -1;
                    int n9 = 0;
                    while (n9 < this.items.length) {
                        if (this.items[n9].showing) {
                            if (n9 == this.selectedIndex) {
                                n8 = n7;
                            }
                            nArray[n7++] = n9;
                        }
                        ++n9;
                    }
                    if (n8 + n3 >= 0 && n8 + n3 < n7) {
                        n2 = nArray[n8 + n3];
                    } else {
                        if (this.showChevron) {
                            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                            cTabFolderEvent.widget = this;
                            cTabFolderEvent.time = event.time;
                            cTabFolderEvent.x = this.chevronRect.x;
                            cTabFolderEvent.y = this.chevronRect.y;
                            cTabFolderEvent.width = this.chevronRect.width;
                            cTabFolderEvent.height = this.chevronRect.height;
                            cTabFolderEvent.doit = true;
                            int n10 = 0;
                            while (n10 < this.folderListeners.length) {
                                this.folderListeners[n10].showList(cTabFolderEvent);
                                ++n10;
                            }
                            if (cTabFolderEvent.doit && !this.isDisposed()) {
                                this.showList(this.chevronRect);
                            }
                        }
                        return;
                    }
                }
                if (n2 < 0 || n2 >= n4) {
                    return;
                }
                this.setSelection(n2, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int n2 = this.items.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.items[n3] != null) {
                this.items[n3].dispose();
            }
            ++n3;
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.disposeSelectionHighlightGradientColors();
    }

    void onDragDetect(Event event) {
        boolean bl2 = false;
        if (this.chevronRect.contains(event.x, event.y) || this.minRect.contains(event.x, event.y) || this.maxRect.contains(event.x, event.y)) {
            bl2 = true;
        } else {
            int n2 = 0;
            while (n2 < this.items.length) {
                if (this.items[n2].closeRect.contains(event.x, event.y)) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
        }
        if (bl2) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event) {
        char c2 = event.character;
        int n2 = 0;
        while (n2 < this.items.length) {
            char c3;
            if (this.items[n2] != null && (c3 = this._findMnemonic(this.items[n2].getText())) != '\u0000' && Character.toLowerCase(c2) == c3) {
                this.setSelection(n2, true);
                return true;
            }
            ++n2;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = this.getItem(new Point(event.x, event.y));
        if (event2.item != null) {
            this.notifyListeners(14, event2);
        }
    }

    void onMouse(Event event) {
        int n2 = event.x;
        int n3 = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                if (this.minImageState != 1) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                int n4 = 0;
                while (n4 < this.items.length) {
                    CTabItem cTabItem = this.items[n4];
                    if (n4 != this.selectedIndex && cTabItem.closeImageState != 0) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if (n4 == this.selectedIndex && cTabItem.closeImageState != 1) {
                        cTabItem.closeImageState = 1;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    ++n4;
                }
                break;
            }
            case 3: {
                if (this.minRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.minImageState = 3;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    this.update();
                    return;
                }
                if (this.maxRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.maxImageState = 3;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.chevronImageState = this.chevronImageState != 2 ? 2 : 3;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n2, n3)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    int n5 = 0;
                    while (n5 < this.items.length) {
                        Rectangle rectangle = this.items[n5].getBounds();
                        if (rectangle.contains(n2, n3)) {
                            cTabItem = this.items[n5];
                        }
                        ++n5;
                    }
                }
                if (cTabItem == null) break;
                if (cTabItem.closeRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    cTabItem.closeImageState = 3;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    this.update();
                    return;
                }
                int n6 = this.indexOf(cTabItem);
                if (cTabItem.showing) {
                    this.setSelection(n6, true);
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                if (this.minRect.contains(n2, n3)) {
                    bl3 = true;
                    if (this.minImageState != 3 && this.minImageState != 2) {
                        this.minImageState = 2;
                        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    }
                }
                if (this.maxRect.contains(n2, n3)) {
                    bl4 = true;
                    if (this.maxImageState != 3 && this.maxImageState != 2) {
                        this.maxImageState = 2;
                        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    }
                }
                if (this.chevronRect.contains(n2, n3)) {
                    bl5 = true;
                    if (this.chevronImageState != 3 && this.chevronImageState != 2) {
                        this.chevronImageState = 2;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.minImageState != 1 && !bl3) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1 && !bl4) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1 && !bl5) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                int n7 = 0;
                while (n7 < this.items.length) {
                    CTabItem cTabItem = this.items[n7];
                    bl2 = false;
                    if (cTabItem.getBounds().contains(n2, n3)) {
                        bl2 = true;
                        if (cTabItem.closeRect.contains(n2, n3)) {
                            if (cTabItem.closeImageState != 3 && cTabItem.closeImageState != 2) {
                                cTabItem.closeImageState = 2;
                                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                            }
                        } else if (cTabItem.closeImageState != 1) {
                            cTabItem.closeImageState = 1;
                            this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                        }
                    }
                    if (n7 != this.selectedIndex && cTabItem.closeImageState != 0 && !bl2) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if (n7 == this.selectedIndex && cTabItem.closeImageState != 1 && !bl2) {
                        cTabItem.closeImageState = 1;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    ++n7;
                }
                break;
            }
            case 4: {
                Object object;
                Serializable serializable;
                if (event.button != 1) {
                    return;
                }
                if (this.chevronRect.contains(n2, n3)) {
                    boolean bl6;
                    boolean bl7 = bl6 = this.chevronImageState == 3;
                    if (!bl6) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = this.chevronRect.x;
                    cTabFolderEvent.y = this.chevronRect.y;
                    cTabFolderEvent.width = this.chevronRect.width;
                    cTabFolderEvent.height = this.chevronRect.height;
                    cTabFolderEvent.doit = true;
                    int n8 = 0;
                    while (n8 < this.folderListeners.length) {
                        this.folderListeners[n8].showList(cTabFolderEvent);
                        ++n8;
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                    return;
                }
                if (this.minRect.contains(n2, n3)) {
                    boolean bl8 = this.minImageState == 3;
                    this.minImageState = 2;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    if (!bl8) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    int n9 = 0;
                    while (n9 < this.folderListeners.length) {
                        if (this.minimized) {
                            this.folderListeners[n9].restore(cTabFolderEvent);
                        } else {
                            this.folderListeners[n9].minimize(cTabFolderEvent);
                        }
                        ++n9;
                    }
                    return;
                }
                if (this.maxRect.contains(n2, n3)) {
                    boolean bl9 = this.maxImageState == 3;
                    this.maxImageState = 2;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    if (!bl9) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    int n10 = 0;
                    while (n10 < this.folderListeners.length) {
                        if (this.maximized) {
                            this.folderListeners[n10].restore(cTabFolderEvent);
                        } else {
                            this.folderListeners[n10].maximize(cTabFolderEvent);
                        }
                        ++n10;
                    }
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n2, n3)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    int n11 = 0;
                    while (n11 < this.items.length) {
                        serializable = this.items[n11].getBounds();
                        if (serializable.contains(n2, n3)) {
                            cTabItem = this.items[n11];
                        }
                        ++n11;
                    }
                }
                if (cTabItem == null || !cTabItem.closeRect.contains(n2, n3)) break;
                boolean bl10 = cTabItem.closeImageState == 3;
                cTabItem.closeImageState = 2;
                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                if (!bl10) {
                    return;
                }
                serializable = new CTabFolderEvent(this);
                ((CTabFolderEvent)serializable).widget = this;
                ((CTabFolderEvent)serializable).time = event.time;
                ((CTabFolderEvent)serializable).item = cTabItem;
                ((CTabFolderEvent)serializable).doit = true;
                int n12 = 0;
                while (n12 < this.folderListeners.length) {
                    object = this.folderListeners[n12];
                    object.close((CTabFolderEvent)serializable);
                    ++n12;
                }
                n12 = 0;
                while (n12 < this.tabListeners.length) {
                    object = this.tabListeners[n12];
                    object.itemClosed((CTabFolderEvent)serializable);
                    ++n12;
                }
                if (((CTabFolderEvent)serializable).doit) {
                    cTabItem.dispose();
                    Display display = this.getDisplay();
                    object = display.getCursorLocation();
                    object = display.map(null, this, ((Point)object).x, ((Point)object).y);
                    CTabItem cTabItem2 = this.getItem((Point)object);
                    if (cTabItem2 != null) {
                        if (cTabItem2.closeRect.contains((Point)object)) {
                            if (cTabItem2.closeImageState != 3 && cTabItem2.closeImageState != 2) {
                                cTabItem2.closeImageState = 2;
                                this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                            }
                        } else if (cTabItem2.closeImageState != 1) {
                            cTabItem2.closeImageState = 1;
                            this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    boolean onPageTraversal(Event event) {
        int n2 = this.items.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = this.selectedIndex;
        if (n3 == -1) {
            n3 = 0;
        } else {
            int n4;
            int n5 = n4 = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                n3 = (this.selectedIndex + n4 + n2) % n2;
            } else {
                int[] nArray = new int[this.items.length];
                int n6 = 0;
                int n7 = -1;
                int n8 = 0;
                while (n8 < this.items.length) {
                    if (this.items[n8].showing) {
                        if (n8 == this.selectedIndex) {
                            n7 = n6;
                        }
                        nArray[n6++] = n8;
                    }
                    ++n8;
                }
                if (n7 + n4 >= 0 && n7 + n4 < n6) {
                    n3 = nArray[n7 + n4];
                } else {
                    if (this.showChevron) {
                        CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                        cTabFolderEvent.widget = this;
                        cTabFolderEvent.time = event.time;
                        cTabFolderEvent.x = this.chevronRect.x;
                        cTabFolderEvent.y = this.chevronRect.y;
                        cTabFolderEvent.width = this.chevronRect.width;
                        cTabFolderEvent.height = this.chevronRect.height;
                        cTabFolderEvent.doit = true;
                        int n9 = 0;
                        while (n9 < this.folderListeners.length) {
                            this.folderListeners[n9].showList(cTabFolderEvent);
                            ++n9;
                        }
                        if (cTabFolderEvent.doit && !this.isDisposed()) {
                            this.showList(this.chevronRect);
                        }
                    }
                    return true;
                }
            }
        }
        this.setSelection(n3, true);
        return true;
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gC = event.gc;
        Font font2 = gC.getFont();
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        this.drawBody(event);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.drawTabArea(event);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
    }

    void onResize() {
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point point = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && point.y != this.oldSize.y) {
            this.redraw();
        } else {
            int n2 = Math.min(point.x, this.oldSize.x);
            if (point.x != this.oldSize.x) {
                n2 -= this.borderRight + this.highlight_margin + 2;
            }
            if (!this.simple) {
                n2 -= 5;
            }
            int n3 = Math.min(point.y, this.oldSize.y);
            if (point.y != this.oldSize.y) {
                n3 -= this.borderBottom + this.highlight_margin;
            }
            int n4 = Math.max(point.x, this.oldSize.x);
            int n5 = Math.max(point.y, this.oldSize.y);
            this.redraw(0, n3, n4, n5 - n3, false);
            this.redraw(n2, 0, n4 - n2, n5, false);
        }
        this.oldSize = point;
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control control = this.getDisplay().getFocusControl();
                if (control != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event);
                if (!event.doit) break;
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point point = this.getSize();
        if (this.onBottom) {
            this.redraw(0, point.y - this.borderBottom - this.tabHeight - this.highlight_header - 1, point.x, this.borderBottom + this.tabHeight + this.highlight_header + 1, false);
        } else {
            this.redraw(0, 0, point.x, this.borderTop + this.tabHeight + this.highlight_header + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.folderListeners.length) {
            if (cTabFolder2Listener == this.folderListeners[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, n2);
        System.arraycopy(this.folderListeners, n2 + 1, cTabFolder2ListenerArray, n2, this.folderListeners.length - n2 - 1);
        this.folderListeners = cTabFolder2ListenerArray;
    }

    public void removeCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.tabListeners.length) {
            if (cTabFolderListener == this.tabListeners[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, n2);
        System.arraycopy(this.tabListeners, n2 + 1, cTabFolderListenerArray, n2, this.tabListeners.length - n2 - 1);
        this.tabListeners = cTabFolderListenerArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    void setBackground(Color[] colorArray, int[] nArray, boolean bl2) {
        int n2;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 > 0 && nArray[n2] < nArray[n2 - 1]) {
                    SWT.error(5);
                }
                ++n2;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.bgImage == null) {
            if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
                n2 = 0;
                int n3 = 0;
                while (n3 < this.gradientColors.length) {
                    n2 = this.gradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.gradientColors[n3].equals(colorArray[n3]) ? 1 : 0);
                    if (n2 == 0) break;
                    ++n3;
                }
                if (n2 != 0) {
                    n3 = 0;
                    while (n3 < this.gradientPercents.length) {
                        int n4 = n2 = this.gradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                        ++n3;
                    }
                }
                if (n2 != 0 && this.gradientVertical == bl2) {
                    return;
                }
            }
        } else {
            this.bgImage = null;
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground((Color)null);
        } else {
            this.gradientColors = new Color[colorArray.length];
            n2 = 0;
            while (n2 < colorArray.length) {
                this.gradientColors[n2] = colorArray[n2];
                ++n2;
            }
            this.gradientPercents = new int[nArray.length];
            n2 = 0;
            while (n2 < nArray.length) {
                this.gradientPercents[n2] = nArray[n2];
                ++n2;
            }
            this.gradientVertical = bl2;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    void setBackground(Image image) {
        this.checkWidget();
        if (image == this.bgImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.bgImage = image;
        this.redraw();
    }

    public void setBorderVisible(boolean bl2) {
        this.checkWidget();
        if (this.borderLeft == 1 == bl2) {
            return;
        }
        this.borderRight = bl2 ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds() {
        int n2;
        int n3;
        int n4;
        Point point = this.getSize();
        int n5 = this.maxRect.x;
        int n6 = this.maxRect.y;
        int n7 = this.maxRect.width;
        int n8 = this.maxRect.height;
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            this.maxRect.x = point.x - this.borderRight - 18 - 3;
            if (this.borderRight > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.maxRect.width = 18;
            this.maxRect.height = 18;
        }
        if (n5 != this.maxRect.x || n7 != this.maxRect.width || n6 != this.maxRect.y || n8 != this.maxRect.height) {
            n4 = Math.min(n5, this.maxRect.x);
            n3 = Math.max(n5 + n7, this.maxRect.x + this.maxRect.width);
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n4, n2, n3 - n4, this.tabHeight, false);
        }
        n5 = this.minRect.x;
        n6 = this.minRect.y;
        n7 = this.minRect.width;
        n8 = this.minRect.height;
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            this.minRect.x = point.x - this.borderRight - this.maxRect.width - 18 - 3;
            if (this.borderRight > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.minRect.width = 18;
            this.minRect.height = 18;
        }
        if (n5 != this.minRect.x || n7 != this.minRect.width || n6 != this.minRect.y || n8 != this.minRect.height) {
            n4 = Math.min(n5, this.minRect.x);
            n3 = Math.max(n5 + n7, this.minRect.x + this.minRect.width);
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n4, n2, n3 - n4, this.tabHeight, false);
        }
        n5 = this.topRightRect.x;
        n6 = this.topRightRect.y;
        n7 = this.topRightRect.width;
        n8 = this.topRightRect.height;
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    n4 = point.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        n4 -= 2;
                    }
                    if (this.single) {
                        if (this.items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = this.borderLeft + 3;
                            this.topRightRect.width = n4 - this.topRightRect.x;
                        } else {
                            CTabItem cTabItem = this.items[this.selectedIndex];
                            if (cTabItem.x + cTabItem.width + 7 + 27 >= n4) break;
                            this.topRightRect.x = cTabItem.x + cTabItem.width + 7 + 27;
                            this.topRightRect.width = n4 - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (this.items.length == 0) {
                            this.topRightRect.x = this.borderLeft + 3;
                        } else {
                            CTabItem cTabItem = this.items[this.items.length - 1];
                            this.topRightRect.x = cTabItem.x + cTabItem.width;
                            if (!this.simple && this.items.length - 1 == this.selectedIndex) {
                                this.topRightRect.x += this.curveWidth - this.curveIndent;
                            }
                        }
                        this.topRightRect.width = Math.max(0, n4 - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point point2 = this.topRight.computeSize(-1, this.tabHeight, false);
                    n3 = point.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        n3 -= 2;
                    }
                    this.topRightRect.x = n3 - point2.x;
                    this.topRightRect.width = point2.x;
                    this.topRightRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        if (n5 != this.topRightRect.x || n7 != this.topRightRect.width || n6 != this.topRightRect.y || n8 != this.topRightRect.height) {
            int n9 = Math.min(n5, this.topRightRect.x);
            int n10 = Math.max(n5 + n7, this.topRightRect.x + this.topRightRect.width);
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n9, n2, n10 - n9, this.tabHeight, false);
        }
        n5 = this.chevronRect.x;
        n6 = this.chevronRect.y;
        n7 = this.chevronRect.width;
        n8 = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.single) {
            if (this.selectedIndex == -1 || this.items.length > 1) {
                this.chevronRect.width = 27;
                this.chevronRect.height = 18;
                int n11 = this.chevronRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = point.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem cTabItem = this.items[this.selectedIndex];
                    int n12 = point.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        n12 -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(cTabItem.x + cTabItem.width + 3, n12);
                }
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = 27;
            this.chevronRect.height = 18;
            int n13 = 0;
            int n14 = -1;
            while (n13 < this.priority.length && this.items[this.priority[n13]].showing) {
                n14 = Math.max(n14, this.priority[n13++]);
            }
            if (n14 == -1) {
                n14 = this.firstIndex;
            }
            CTabItem cTabItem = this.items[n14];
            int n15 = cTabItem.x + cTabItem.width + 3;
            if (!this.simple && n14 == this.selectedIndex) {
                n15 += this.curveWidth - 2 * this.curveIndent;
            }
            this.chevronRect.x = Math.min(n15, this.getRightItemEdge());
            int n16 = this.chevronRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
        }
        if (n5 != this.chevronRect.x || n7 != this.chevronRect.width || n6 != this.chevronRect.y || n8 != this.chevronRect.height) {
            int n17 = Math.min(n5, this.chevronRect.x);
            int n18 = Math.max(n5 + n7, this.chevronRect.x + this.chevronRect.width);
            int n19 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n17, n19, n18 - n17, this.tabHeight, false);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem cTabItem, boolean bl2) {
        this.checkWidget();
    }

    public void setInsertMark(int n2, boolean bl2) {
        this.checkWidget();
        if (n2 < -1 || n2 >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation() {
        int n2;
        boolean bl2 = false;
        if (this.items.length == 0) {
            return false;
        }
        Point point = this.getSize();
        int n3 = n2 = this.onBottom ? Math.max(this.borderBottom, point.y - this.borderBottom - this.tabHeight) : this.borderTop;
        if (this.single) {
            int n4 = this.getDisplay().getBounds().width + 10;
            int n5 = 0;
            while (n5 < this.items.length) {
                CTabItem cTabItem = this.items[n5];
                if (n5 == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int n6 = cTabItem.x;
                    int n7 = cTabItem.y;
                    cTabItem.x = this.borderLeft;
                    cTabItem.y = n2;
                    cTabItem.showing = true;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.x = this.borderLeft + 4;
                        int n8 = cTabItem.closeRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    }
                    if (cTabItem.x != n6 || cTabItem.y != n7) {
                        bl2 = true;
                    }
                } else {
                    cTabItem.x = n4;
                    cTabItem.showing = false;
                }
                ++n5;
            }
        } else {
            int n9 = this.getRightItemEdge();
            int n10 = n9 - this.borderLeft;
            int n11 = 0;
            int n12 = 0;
            while (n12 < this.priority.length) {
                CTabItem cTabItem = this.items[this.priority[n12]];
                boolean bl3 = n12 == 0 ? true : (cTabItem.showing = cTabItem.width > 0 && (n11 += cTabItem.width) <= n10);
                if (!this.simple && this.priority[n12] == this.selectedIndex) {
                    n11 += this.curveWidth - 2 * this.curveIndent;
                }
                ++n12;
            }
            n12 = 0;
            int n13 = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            int n14 = 0;
            while (n14 < this.items.length) {
                CTabItem cTabItem = this.items[n14];
                if (!cTabItem.showing) {
                    if (cTabItem.x != n13) {
                        bl2 = true;
                    }
                    cTabItem.x = n13;
                } else {
                    this.firstIndex = Math.min(this.firstIndex, n14);
                    if (cTabItem.x != n12 || cTabItem.y != n2) {
                        bl2 = true;
                    }
                    cTabItem.x = n12;
                    cTabItem.y = n2;
                    if (n14 == this.selectedIndex) {
                        int n15 = Math.min(cTabItem.x + cTabItem.width, n9);
                        cTabItem.closeRect.x = n15 - 4 - 18;
                    } else {
                        cTabItem.closeRect.x = cTabItem.x + cTabItem.width - 4 - 18;
                    }
                    cTabItem.closeRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    n12 += cTabItem.width;
                    if (!this.simple && n14 == this.selectedIndex) {
                        n12 += this.curveWidth - 2 * this.curveIndent;
                    }
                }
                ++n14;
            }
        }
        return bl2;
    }

    boolean setItemSize() {
        int n2;
        int[] nArray;
        boolean bl2 = false;
        if (this.isDisposed()) {
            return bl2;
        }
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return bl2;
        }
        this.xClient = this.borderLeft + this.marginWidth + this.highlight_margin;
        this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
        this.showChevron = false;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem cTabItem = this.items[this.selectedIndex];
                GC gC = new GC(this);
                int n3 = cTabItem.preferredWidth(gC, true, false);
                gC.dispose();
                n3 = Math.min(n3, this.getRightItemEdge() - this.borderLeft);
                if (cTabItem.height != this.tabHeight || cTabItem.width != n3) {
                    bl2 = true;
                    cTabItem.shortenedText = null;
                    cTabItem.shortenedTextWidth = 0;
                    cTabItem.height = this.tabHeight;
                    cTabItem.width = n3;
                    cTabItem.closeRect.height = 0;
                    cTabItem.closeRect.width = 0;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.width = 18;
                        cTabItem.closeRect.height = 18;
                    }
                }
            }
            return bl2;
        }
        if (this.items.length == 0) {
            return bl2;
        }
        GC gC = new GC(this);
        int n4 = point.x - this.borderLeft - this.borderRight - 3;
        if (this.showMin) {
            n4 -= 18;
        }
        if (this.showMax) {
            n4 -= 18;
        }
        if (this.topRightAlignment == 131072 && this.topRight != null) {
            Point point2 = this.topRight.computeSize(-1, -1, false);
            n4 -= point2.x + 3;
        }
        if (!this.simple) {
            n4 -= this.curveWidth - 2 * this.curveIndent;
        }
        n4 = Math.max(0, n4);
        int n5 = 0;
        int[] nArray2 = new int[this.items.length];
        int n6 = 0;
        while (n6 < this.priority.length) {
            int n7 = this.priority[n6];
            nArray2[n7] = this.items[n7].preferredWidth(gC, n7 == this.selectedIndex, true);
            if ((n5 += nArray2[n7]) > n4) break;
            ++n6;
        }
        if (n5 > n4) {
            boolean bl3 = this.showChevron = this.items.length > 1;
            if (this.showChevron) {
                n4 -= 27;
            }
            nArray = nArray2;
            int n8 = n6 = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (n4 < nArray[n6]) {
                nArray[n6] = Math.max(0, n4);
            }
        } else {
            n6 = 0;
            int[] nArray3 = new int[this.items.length];
            n2 = 0;
            while (n2 < this.items.length) {
                nArray3[n2] = this.items[n2].preferredWidth(gC, n2 == this.selectedIndex, false);
                n6 += nArray3[n2];
                ++n2;
            }
            if (n6 <= n4) {
                nArray = nArray3;
            } else {
                int n9;
                n2 = (n4 - n5) / this.items.length;
                while (true) {
                    n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    while (n11 < this.items.length) {
                        if (nArray3[n11] > nArray2[n11] + n2) {
                            n10 += nArray2[n11] + n2;
                            ++n9;
                        } else {
                            n10 += nArray3[n11];
                        }
                        ++n11;
                    }
                    if (n10 >= n4) {
                        --n2;
                        break;
                    }
                    if (n9 == 0 || n4 - n10 < n9) break;
                    ++n2;
                }
                nArray = new int[this.items.length];
                n9 = 0;
                while (n9 < this.items.length) {
                    nArray[n9] = Math.min(nArray3[n9], nArray2[n9] + n2);
                    ++n9;
                }
            }
        }
        gC.dispose();
        n6 = 0;
        while (n6 < this.items.length) {
            CTabItem cTabItem = this.items[n6];
            n2 = nArray[n6];
            if (cTabItem.height != this.tabHeight || cTabItem.width != n2) {
                bl2 = true;
                cTabItem.shortenedText = null;
                cTabItem.shortenedTextWidth = 0;
                cTabItem.height = this.tabHeight;
                cTabItem.width = n2;
                cTabItem.closeRect.height = 0;
                cTabItem.closeRect.width = 0;
                if ((this.showClose || cTabItem.showClose) && (n6 == this.selectedIndex || this.showUnselectedClose)) {
                    cTabItem.closeRect.width = 18;
                    cTabItem.closeRect.height = 18;
                }
            }
            ++n6;
        }
        return bl2;
    }

    public void setMaximizeVisible(boolean bl2) {
        this.checkWidget();
        if (this.showMax == bl2) {
            return;
        }
        this.showMax = bl2;
        this.updateItems();
        this.redraw();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl2) {
        this.checkWidget();
        if (this.maximized == bl2) {
            return;
        }
        if (bl2 && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = bl2;
        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
    }

    public void setMinimizeVisible(boolean bl2) {
        this.checkWidget();
        if (this.showMin == bl2) {
            return;
        }
        this.showMin = bl2;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean bl2) {
        this.checkWidget();
        if (this.minimized == bl2) {
            return;
        }
        if (bl2 && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = bl2;
        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
    }

    public void setMinimumCharacters(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            SWT.error(6);
        }
        if (this.minChars == n2) {
            return;
        }
        this.minChars = n2;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setMRUVisible(boolean bl2) {
        this.checkWidget();
        if (this.mru == bl2) {
            return;
        }
        this.mru = bl2;
        if (!this.mru) {
            int n2 = this.firstIndex;
            int n3 = 0;
            int n4 = this.firstIndex;
            while (n4 < this.items.length) {
                this.priority[n3++] = n4++;
            }
            n4 = 0;
            while (n4 < n2) {
                this.priority[n3++] = n4++;
            }
            if (this.updateItems()) {
                this.redrawTabs();
            }
        }
    }

    public void setSelection(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n2 = this.indexOf(cTabItem);
        this.setSelection(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 >= this.items.length) {
            return;
        }
        CTabItem cTabItem = this.items[n2];
        if (this.selectedIndex == n2) {
            this.showItem(cTabItem);
            return;
        }
        int n3 = this.selectedIndex;
        this.selectedIndex = n2;
        if (n3 != -1) {
            this.items[n3].closeImageState = 0;
        }
        cTabItem.closeImageState = 1;
        cTabItem.showing = false;
        Control control = cTabItem.control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (n3 != -1 && (control = this.items[n3].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.showItem(cTabItem);
        this.redraw();
    }

    void setSelection(int n2, boolean bl2) {
        int n3 = this.selectedIndex;
        this.setSelection(n2);
        if (bl2 && this.selectedIndex != n3 && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray) {
        this.setSelectionBackground(colorArray, nArray, false);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl2) {
        int n2;
        int n3;
        this.checkWidget();
        Color color = null;
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1 && nArray.length != colorArray.length - 2) {
                SWT.error(5);
            }
            n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] < 0 || nArray[n3] > 100) {
                    SWT.error(5);
                }
                if (n3 > 0 && nArray[n3] < nArray[n3 - 1]) {
                    SWT.error(5);
                }
                ++n3;
            }
            if (nArray.length == colorArray.length - 2) {
                color = colorArray[colorArray.length - 1];
                n2 = colorArray.length - 1;
            } else {
                n2 = colorArray.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[n2 - 1]};
                n2 = colorArray.length;
                nArray = new int[]{};
            }
        } else {
            n2 = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colorArray != null && this.selectionGradientColors.length == n2) {
                n3 = 0;
                int n4 = 0;
                while (n4 < this.selectionGradientColors.length) {
                    n3 = this.selectionGradientColors[n4] == null ? (colorArray[n4] == null ? 1 : 0) : (int)(this.selectionGradientColors[n4].equals(colorArray[n4]) ? 1 : 0);
                    if (n3 == 0) break;
                    ++n4;
                }
                if (n3 != 0) {
                    n4 = 0;
                    while (n4 < this.selectionGradientPercents.length) {
                        int n5 = n3 = this.selectionGradientPercents[n4] == nArray[n4] ? 1 : 0;
                        if (n3 == 0) break;
                        ++n4;
                    }
                }
                if (n3 != 0 && this.selectionGradientVertical == bl2) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colorArray == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[n2];
            n3 = 0;
            while (n3 < n2) {
                this.selectionGradientColors[n3] = colorArray[n3];
                ++n3;
            }
            this.selectionGradientPercents = new int[nArray.length];
            n3 = 0;
            while (n3 < nArray.length) {
                this.selectionGradientPercents[n3] = nArray[n3];
                ++n3;
            }
            this.selectionGradientVertical = bl2;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(color);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color color) {
        this.selectionHighlightGradientBegin = null;
        if (color == null) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (this.selectionGradientColors.length < 2) {
            return;
        }
        this.selectionHighlightGradientBegin = color;
        if (!this.isSelectionHighlightColorsCacheHit(color)) {
            this.createSelectionHighlightGradientColors(color);
        }
    }

    boolean isSelectionHighlightColorsCacheHit(Color color) {
        if (this.selectionHighlightGradientColorsCache == null) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length < 2) {
            return false;
        }
        Color color2 = this.selectionHighlightGradientColorsCache[0];
        Color color3 = this.selectionHighlightGradientColorsCache[this.selectionHighlightGradientColorsCache.length - 1];
        if (!color2.equals(color)) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length != this.tabHeight) {
            return false;
        }
        return color3.equals(this.selectionBackground);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void createSelectionHighlightGradientColors(Color color) {
        this.disposeSelectionHighlightGradientColors();
        if (color == null) {
            return;
        }
        int n2 = this.tabHeight;
        RGB rGB = color.getRGB();
        RGB rGB2 = this.selectionBackground.getRGB();
        this.selectionHighlightGradientColorsCache = new Color[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3 - n4;
            int n6 = n4;
            int n7 = (rGB2.red * n6 + rGB.red * n5) / n3;
            int n8 = (rGB2.green * n6 + rGB.green * n5) / n3;
            int n9 = (rGB2.blue * n6 + rGB.blue * n5) / n3;
            this.selectionHighlightGradientColorsCache[n4] = new Color(this.getDisplay(), n7, n8, n9);
            ++n4;
        }
    }

    void disposeSelectionHighlightGradientColors() {
        if (this.selectionHighlightGradientColorsCache == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.selectionHighlightGradientColorsCache.length) {
            this.selectionHighlightGradientColorsCache[n2].dispose();
            ++n2;
        }
        this.selectionHighlightGradientColorsCache = null;
    }

    Color getSelectionBackgroundGradientBegin() {
        if (this.selectionGradientColors == null) {
            return this.getSelectionBackground();
        }
        if (this.selectionGradientColors.length == 0) {
            return this.getSelectionBackground();
        }
        return this.selectionGradientColors[0];
    }

    public void setSimple(boolean bl2) {
        this.checkWidget();
        if (this.simple != bl2) {
            this.simple = bl2;
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean bl2) {
        this.checkWidget();
        if (this.single != bl2) {
            this.single = bl2;
            if (!bl2) {
                int n2 = 0;
                while (n2 < this.items.length) {
                    if (n2 != this.selectedIndex && this.items[n2].closeImageState == 1) {
                        this.items[n2].closeImageState = 0;
                    }
                    ++n2;
                }
            }
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTabHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = n2;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int n2) {
        this.checkWidget();
        if (n2 != 128 && n2 != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (n2 == 1024)) {
            this.onBottom = n2 == 1024;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderRight;
            this.updateTabHeight(true);
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int n2) {
        this.checkWidget();
        if (n2 != 131072 && n2 != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        this.topRight = control;
        this.topRightAlignment = n2;
        if (this.updateItems()) {
            this.redraw();
        }
    }

    public void setUnselectedCloseVisible(boolean bl2) {
        this.checkWidget();
        if (this.showUnselectedClose == bl2) {
            return;
        }
        this.showUnselectedClose = bl2;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean bl2) {
        this.checkWidget();
        if (this.showUnselectedImage == bl2) {
            return;
        }
        this.showUnselectedImage = bl2;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem cTabItem) {
        int n2;
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        if (cTabItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n2 = this.indexOf(cTabItem)) == -1) {
            SWT.error(5);
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.priority.length) {
            if (this.priority[n4] == n2) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (this.mru) {
            int[] nArray = new int[this.priority.length];
            System.arraycopy(this.priority, 0, nArray, 1, n3);
            System.arraycopy(this.priority, n3 + 1, nArray, n3 + 1, this.priority.length - n3 - 1);
            nArray[0] = n2;
            this.priority = nArray;
        }
        if (cTabItem.isShowing()) {
            return;
        }
        this.updateItems(n2);
        this.redrawTabs();
    }

    void showList(Rectangle rectangle) {
        Object object;
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this);
        } else {
            MenuItem[] menuItemArray = this.showMenu.getItems();
            int n2 = 0;
            while (n2 < menuItemArray.length) {
                menuItemArray[n2].dispose();
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < this.items.length) {
            CTabItem cTabItem = this.items[n3];
            if (!cTabItem.showing) {
                object = new MenuItem(this.showMenu, 0);
                ((MenuItem)object).setText(cTabItem.getText());
                ((MenuItem)object).setImage(cTabItem.getImage());
                ((Widget)object).setData("CTabFolder_showList_Index", cTabItem);
                ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MenuItem menuItem = (MenuItem)selectionEvent.widget;
                        int n2 = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                        CTabFolder.this.setSelection(n2, true);
                    }
                });
            }
            ++n3;
        }
        n3 = rectangle.x;
        int n4 = rectangle.y + rectangle.height;
        object = this.getDisplay().map(this, null, n3, n4);
        this.showMenu.setLocation(((Point)object).x, ((Point)object).y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int n2, int n3) {
        String string = this.getToolTipText();
        String string2 = this._getToolTip(n2, n3);
        if (string2 == null || !string2.equals(string)) {
            this.setToolTipText(string2);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int n2) {
        int n4;
        if (!this.single && !this.mru && n2 != -1) {
            int n3;
            n4 = n2;
            if (this.priority[0] < n2) {
                int n5;
                int n32 = this.getRightItemEdge() - this.borderLeft;
                if (!this.simple) {
                    n5 = n32 - (this.curveWidth - 2 * this.curveIndent);
                }
                n3 = 0;
                int[] nArray = new int[this.items.length];
                GC gC = new GC(this);
                int n6 = this.priority[0];
                while (n6 <= n2) {
                    nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                    if ((n3 += nArray[n6]) > n5) break;
                    ++n6;
                }
                if (n3 > n5) {
                    n3 = 0;
                    n6 = n2;
                    while (n6 >= 0) {
                        if (nArray[n6] == 0) {
                            nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                        }
                        if ((n3 += nArray[n6]) <= n5) {
                            n4 = n6--;
                            continue;
                        }
                        break;
                    }
                } else {
                    n4 = this.priority[0];
                    n6 = n2 + 1;
                    while (n6 < this.items.length) {
                        nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                        if ((n3 += nArray[n6]) >= n5) break;
                        ++n6;
                    }
                    if (n3 < n5) {
                        n6 = this.priority[0] - 1;
                        while (n6 >= 0) {
                            if (nArray[n6] == 0) {
                                nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                            }
                            if ((n3 += nArray[n6]) <= n5) {
                                n4 = n6--;
                                continue;
                            }
                            break;
                        }
                    }
                }
                gC.dispose();
            }
            if (n4 != this.priority[0]) {
                boolean bl2 = false;
                n3 = n4;
                while (n3 < this.items.length) {
                    this.priority[++var3_6] = n3++;
                }
                n3 = 0;
                while (n3 < n4) {
                    this.priority[++var3_7] = n3++;
                }
            }
        }
        n4 = this.showChevron;
        int n8 = this.setItemSize();
        n8 = n8 | this.setItemLocation();
        this.setButtonBounds();
        boolean bl3 = n8 | this.showChevron ^ n4;
        if (bl3 && this.getToolTipText() != null) {
            Point point = this.getDisplay().getCursorLocation();
            point = this.toControl(point);
            this._setToolTipText(point.x, point.y);
        }
        return bl3;
    }

    boolean updateTabHeight(boolean bl2) {
        int n2;
        int n3 = this.getStyle();
        if (this.fixedTabHeight == 0 && (n3 & 0x800000) != 0 && (n3 & 0x800) == 0) {
            this.highlight_header = 0;
        }
        int n4 = this.tabHeight;
        if (this.fixedTabHeight != -1) {
            this.tabHeight = this.fixedTabHeight == 0 ? 0 : this.fixedTabHeight + 1;
        } else {
            n2 = 0;
            GC gC = new GC(this);
            if (this.items.length == 0) {
                n2 = gC.textExtent((String)"Default", (int)9).y + 2 + 2;
            } else {
                int n5 = 0;
                while (n5 < this.items.length) {
                    n2 = Math.max(n2, this.items[n5].preferredHeight(gC));
                    ++n5;
                }
            }
            gC.dispose();
            this.tabHeight = n2;
        }
        if (!bl2 && this.tabHeight == n4) {
            return false;
        }
        this.oldSize = null;
        if (this.onBottom) {
            n2 = this.tabHeight - 12;
            int[] nArray = new int[40];
            nArray[1] = 13 + n2;
            nArray[3] = 12 + n2;
            nArray[4] = 2;
            nArray[5] = 12 + n2;
            nArray[6] = 3;
            nArray[7] = 11 + n2;
            nArray[8] = 5;
            nArray[9] = 11 + n2;
            nArray[10] = 6;
            nArray[11] = 10 + n2;
            nArray[12] = 7;
            nArray[13] = 10 + n2;
            nArray[14] = 9;
            nArray[15] = 8 + n2;
            nArray[16] = 10;
            nArray[17] = 8 + n2;
            nArray[18] = 11;
            nArray[19] = 7 + n2;
            nArray[20] = 11 + n2;
            nArray[21] = 7;
            nArray[22] = 12 + n2;
            nArray[23] = 6;
            nArray[24] = 13 + n2;
            nArray[25] = 6;
            nArray[26] = 15 + n2;
            nArray[27] = 4;
            nArray[28] = 16 + n2;
            nArray[29] = 4;
            nArray[30] = 17 + n2;
            nArray[31] = 3;
            nArray[32] = 19 + n2;
            nArray[33] = 3;
            nArray[34] = 20 + n2;
            nArray[35] = 2;
            nArray[36] = 22 + n2;
            nArray[37] = 2;
            nArray[38] = 23 + n2;
            nArray[39] = 1;
            this.curve = nArray;
            this.curveWidth = 26 + n2;
            this.curveIndent = this.curveWidth / 3;
        } else {
            n2 = this.tabHeight - 12;
            int[] nArray = new int[40];
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 1;
            nArray[6] = 3;
            nArray[7] = 2;
            nArray[8] = 5;
            nArray[9] = 2;
            nArray[10] = 6;
            nArray[11] = 3;
            nArray[12] = 7;
            nArray[13] = 3;
            nArray[14] = 9;
            nArray[15] = 5;
            nArray[16] = 10;
            nArray[17] = 5;
            nArray[18] = 11;
            nArray[19] = 6;
            nArray[20] = 11 + n2;
            nArray[21] = 6 + n2;
            nArray[22] = 12 + n2;
            nArray[23] = 7 + n2;
            nArray[24] = 13 + n2;
            nArray[25] = 7 + n2;
            nArray[26] = 15 + n2;
            nArray[27] = 9 + n2;
            nArray[28] = 16 + n2;
            nArray[29] = 9 + n2;
            nArray[30] = 17 + n2;
            nArray[31] = 10 + n2;
            nArray[32] = 19 + n2;
            nArray[33] = 10 + n2;
            nArray[34] = 20 + n2;
            nArray[35] = 11 + n2;
            nArray[36] = 22 + n2;
            nArray[37] = 11 + n2;
            nArray[38] = 23 + n2;
            nArray[39] = 12 + n2;
            this.curve = nArray;
            this.curveWidth = 26 + n2;
            this.curveIndent = this.curveWidth / 3;
            int[] nArray2 = new int[22];
            nArray2[1] = 2;
            nArray2[2] = 1;
            nArray2[3] = 2;
            nArray2[4] = 2;
            nArray2[5] = 2;
            nArray2[6] = 3;
            nArray2[7] = 3;
            nArray2[8] = 4;
            nArray2[9] = 3;
            nArray2[10] = 5;
            nArray2[11] = 3;
            nArray2[12] = 6;
            nArray2[13] = 4;
            nArray2[14] = 7;
            nArray2[15] = 4;
            nArray2[16] = 8;
            nArray2[17] = 5;
            nArray2[18] = 9;
            nArray2[19] = 6;
            nArray2[20] = 10;
            nArray2[21] = 6;
            this.topCurveHighlightStart = nArray2;
            this.topCurveHighlightEnd = new int[]{10 + n2, 6 + n2, 11 + n2, 7 + n2, 12 + n2, 8 + n2, 13 + n2, 8 + n2, 14 + n2, 9 + n2, 15 + n2, 10 + n2, 16 + n2, 10 + n2, 17 + n2, 11 + n2, 18 + n2, 11 + n2, 19 + n2, 11 + n2, 20 + n2, 12 + n2, 21 + n2, 12 + n2, 22 + n2, 12 + n2};
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    String _getToolTip(int n2, int n3) {
        if (this.showMin && this.minRect.contains(n2, n3)) {
            return this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
        }
        if (this.showMax && this.maxRect.contains(n2, n3)) {
            return this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
        }
        if (this.showChevron && this.chevronRect.contains(n2, n3)) {
            return SWT.getMessage("SWT_ShowList");
        }
        CTabItem cTabItem = this.getItem(new Point(n2, n3));
        if (cTabItem == null) {
            return null;
        }
        if (!cTabItem.showing) {
            return null;
        }
        if ((this.showClose || cTabItem.showClose) && cTabItem.closeRect.contains(n2, n3)) {
            return SWT.getMessage("SWT_Close");
        }
        return cTabItem.getToolTipText();
    }
}

