/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashFormData;
import org.eclipse.swt.custom.SashFormLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class SashForm
extends Composite {
    public int SASH_WIDTH = 3;
    int sashStyle;
    Sash[] sashes = new Sash[0];
    Color background = null;
    Color foreground = null;
    Control[] controls = new Control[0];
    Control maxControl = null;
    Listener sashListener;
    static final int DRAG_MINIMUM = 20;

    public SashForm(Composite composite, int n2) {
        super(composite, SashForm.checkStyle(n2));
        super.setLayout(new SashFormLayout());
        int n3 = this.sashStyle = (n2 & 0x200) != 0 ? 256 : 512;
        if ((n2 & 0x800) != 0) {
            this.sashStyle |= 0x800;
        }
        if ((n2 & 0x10000) != 0) {
            this.sashStyle |= 0x10000;
        }
        this.sashListener = new Listener(){

            public void handleEvent(Event event) {
                SashForm.this.onDragSash(event);
            }
        };
    }

    static int checkStyle(int n2) {
        int n3 = 0x6000800;
        return n2 & n3;
    }

    public int getOrientation() {
        return (this.sashStyle & 0x200) != 0 ? 256 : 512;
    }

    public int getStyle() {
        int n2 = super.getStyle();
        n2 |= this.getOrientation() == 512 ? 512 : 256;
        if ((this.sashStyle & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        return n2;
    }

    public Control getMaximizedControl() {
        return this.maxControl;
    }

    public int[] getWeights() {
        this.checkWidget();
        Control[] controlArray = this.getControls(false);
        int[] nArray = new int[controlArray.length];
        int n2 = 0;
        while (n2 < controlArray.length) {
            Object object = controlArray[n2].getLayoutData();
            nArray[n2] = object != null && object instanceof SashFormData ? (int)(((SashFormData)object).weight * 1000L >> 16) : 200;
            ++n2;
        }
        return nArray;
    }

    Control[] getControls(boolean bl2) {
        Control[] controlArray = this.getChildren();
        Control[] controlArray2 = new Control[]{};
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (!(controlArray[n2] instanceof Sash || bl2 && !controlArray[n2].getVisible())) {
                Control[] controlArray3 = new Control[controlArray2.length + 1];
                System.arraycopy(controlArray2, 0, controlArray3, 0, controlArray2.length);
                controlArray3[controlArray2.length] = controlArray[n2];
                controlArray2 = controlArray3;
            }
            ++n2;
        }
        return controlArray2;
    }

    void onDragSash(Event event) {
        Sash sash = (Sash)event.widget;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.sashes.length) {
            if (this.sashes[n3] == sash) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        Control control = this.controls[n2];
        Control control2 = this.controls[n2 + 1];
        Rectangle rectangle = control.getBounds();
        Rectangle rectangle2 = control2.getBounds();
        Rectangle rectangle3 = sash.getBounds();
        Rectangle rectangle4 = this.getClientArea();
        boolean bl2 = false;
        if (this.getOrientation() == 256) {
            Object object;
            Object object2;
            bl2 = rectangle.width < 20 || rectangle2.width < 20;
            int n4 = rectangle2.x + rectangle2.width - rectangle.x;
            int n5 = event.x - rectangle3.x;
            rectangle.width += n5;
            rectangle2.x += n5;
            rectangle2.width -= n5;
            if (rectangle.width < 20) {
                rectangle.width = 20;
                rectangle2.x = rectangle.x + rectangle.width + rectangle3.width;
                rectangle2.width = n4 - rectangle2.x;
                event.x = rectangle.x + rectangle.width;
                event.doit = false;
            }
            if (rectangle2.width < 20) {
                rectangle.width = n4 - 20 - rectangle3.width;
                rectangle2.x = rectangle.x + rectangle.width + rectangle3.width;
                rectangle2.width = 20;
                event.x = rectangle.x + rectangle.width;
                event.doit = false;
            }
            if ((object2 = control.getLayoutData()) == null || !(object2 instanceof SashFormData)) {
                object2 = new SashFormData();
                control.setLayoutData(object2);
            }
            if ((object = control2.getLayoutData()) == null || !(object instanceof SashFormData)) {
                object = new SashFormData();
                control2.setLayoutData(object);
            }
            ((SashFormData)object2).weight = (((long)rectangle.width << 16) + (long)rectangle4.width - 1L) / (long)rectangle4.width;
            ((SashFormData)object).weight = (((long)rectangle2.width << 16) + (long)rectangle4.width - 1L) / (long)rectangle4.width;
        } else {
            Object object;
            Object object3;
            bl2 = rectangle.height < 20 || rectangle2.height < 20;
            int n6 = rectangle2.y + rectangle2.height - rectangle.y;
            int n7 = event.y - rectangle3.y;
            rectangle.height += n7;
            rectangle2.y += n7;
            rectangle2.height -= n7;
            if (rectangle.height < 20) {
                rectangle.height = 20;
                rectangle2.y = rectangle.y + rectangle.height + rectangle3.height;
                rectangle2.height = n6 - rectangle2.y;
                event.y = rectangle.y + rectangle.height;
                event.doit = false;
            }
            if (rectangle2.height < 20) {
                rectangle.height = n6 - 20 - rectangle3.height;
                rectangle2.y = rectangle.y + rectangle.height + rectangle3.height;
                rectangle2.height = 20;
                event.y = rectangle.y + rectangle.height;
                event.doit = false;
            }
            if ((object3 = control.getLayoutData()) == null || !(object3 instanceof SashFormData)) {
                object3 = new SashFormData();
                control.setLayoutData(object3);
            }
            if ((object = control2.getLayoutData()) == null || !(object instanceof SashFormData)) {
                object = new SashFormData();
                control2.setLayoutData(object);
            }
            ((SashFormData)object3).weight = (((long)rectangle.height << 16) + (long)rectangle4.height - 1L) / (long)rectangle4.height;
            ((SashFormData)object).weight = (((long)rectangle2.height << 16) + (long)rectangle4.height - 1L) / (long)rectangle4.height;
        }
        if (bl2 || event.doit && event.detail != 1) {
            control.setBounds(rectangle);
            sash.setBounds(event.x, event.y, event.width, event.height);
            control2.setBounds(rectangle2);
        }
    }

    public void setOrientation(int n2) {
        this.checkWidget();
        if (this.getOrientation() == n2) {
            return;
        }
        if (n2 != 256 && n2 != 512) {
            SWT.error(5);
        }
        this.sashStyle &= 0xFFFFFCFF;
        this.sashStyle |= n2 == 512 ? 256 : 512;
        int n3 = 0;
        while (n3 < this.sashes.length) {
            this.sashes[n3].dispose();
            this.sashes[n3] = new Sash(this, this.sashStyle);
            this.sashes[n3].setBackground(this.background);
            this.sashes[n3].setForeground(this.foreground);
            this.sashes[n3].addListener(13, this.sashListener);
            ++n3;
        }
        this.layout(false);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        int n2 = 0;
        while (n2 < this.sashes.length) {
            this.sashes[n2].setBackground(this.background);
            ++n2;
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        int n2 = 0;
        while (n2 < this.sashes.length) {
            this.sashes[n2].setForeground(this.foreground);
            ++n2;
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximizedControl(Control control) {
        this.checkWidget();
        if (control == null) {
            if (this.maxControl != null) {
                this.maxControl = null;
                this.layout(false);
                int n2 = 0;
                while (n2 < this.sashes.length) {
                    this.sashes[n2].setVisible(true);
                    ++n2;
                }
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.sashes.length) {
            this.sashes[n3].setVisible(false);
            ++n3;
        }
        this.maxControl = control;
        this.layout(false);
    }

    public void setWeights(int[] nArray) {
        this.checkWidget();
        Control[] controlArray = this.getControls(false);
        if (nArray == null || nArray.length != controlArray.length) {
            SWT.error(5);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < 0) {
                SWT.error(5);
            }
            n2 += nArray[n3];
            ++n3;
        }
        if (n2 == 0) {
            SWT.error(5);
        }
        n3 = 0;
        while (n3 < controlArray.length) {
            Object object = controlArray[n3].getLayoutData();
            if (object == null || !(object instanceof SashFormData)) {
                object = new SashFormData();
                controlArray[n3].setLayoutData(object);
            }
            ((SashFormData)object).weight = (((long)nArray[n3] << 16) + (long)n2 - 1L) / (long)n2;
            ++n3;
        }
        this.layout(false);
    }
}

