/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite composite, int n2) {
        super(composite, n2);
    }

    void clearArea(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            RECT rECT = new RECT();
            OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
            int n6 = OS.GetDCEx(this.handle, 0, 26);
            this.drawBackground(n6, rECT);
            OS.ReleaseDC(this.handle, n6);
        }
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    void releaseChildren(boolean bl2) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        super.releaseChildren(bl2);
    }

    public void drawBackground(GC gC, int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n6 = gC.handle;
        int n7 = this.background == -1 ? gC.getBackground().handle : -1;
        this.drawBackground(n6, rECT, n7);
    }

    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8;
        int n9;
        boolean bl3;
        this.checkWidget();
        this.forceResize();
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n4, n5, n4 + n6, n5 + n7);
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        if (OS.IntersectRect(rECT2, rECT, rECT2)) {
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.handle);
            } else {
                n9 = 384;
                OS.RedrawWindow(this.handle, null, 0, n9);
            }
        }
        n9 = n2 - n4;
        int n10 = n3 - n5;
        if (this.findImageControl() != null) {
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n8 = 1029;
                if (bl2) {
                    n8 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0, n8);
            }
            OS.OffsetRect(rECT, n9, n10);
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n8 = 1029;
                if (bl2) {
                    n8 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0, n8);
            }
        } else {
            n8 = 6;
            OS.ScrollWindowEx(this.handle, n9, n10, rECT, null, 0, null, n8);
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            int n11 = 0;
            while (n11 < controlArray.length) {
                Control control = controlArray[n11];
                Rectangle rectangle = control.getBounds();
                if (Math.min(n4 + n6, rectangle.x + rectangle.width) >= Math.max(n4, rectangle.x) && Math.min(n5 + n7, rectangle.y + rectangle.height) >= Math.max(n5, rectangle.y)) {
                    control.setLocation(rectangle.x + n9, rectangle.y + n10);
                }
                ++n11;
            }
        }
        if (bl3) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        if (n3 == Display.SWT_RESTORECARET && (this.state & 2) != 0 && this.caret != null) {
            this.caret.killFocus();
            this.caret.setFocus();
            return 1;
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    LRESULT WM_IME_COMPOSITION(int n2, int n3) {
        POINT pOINT;
        short s2;
        short s3;
        LRESULT lRESULT = super.WM_IME_COMPOSITION(n2, n3);
        if (!OS.IsWinCE && OS.WIN32_VERSION == OS.VERSION(5, 1) && OS.IsDBLocale && (s3 = OS.PRIMARYLANGID(s2 = OS.GetSystemDefaultUILanguage())) == 18 && this.caret != null && this.caret.isFocusCaret() && OS.GetCaretPos(pOINT = new POINT())) {
            COMPOSITIONFORM cOMPOSITIONFORM = new COMPOSITIONFORM();
            cOMPOSITIONFORM.dwStyle = 2;
            cOMPOSITIONFORM.x = pOINT.x;
            cOMPOSITIONFORM.y = pOINT.y;
            int n4 = OS.ImmGetContext(this.handle);
            OS.ImmSetCompositionWindow(n4, cOMPOSITIONFORM);
            OS.ImmReleaseContext(this.handle, n4);
        }
        return lRESULT;
    }

    LRESULT WM_INPUTLANGCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_INPUTLANGCHANGE(n2, n3);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setIMEFont();
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGED(int n2, int n3) {
        boolean bl2;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGED(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl3 = bl2 = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        boolean bl2;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl3 = bl2 = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        return lRESULT;
    }
}

