/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    static final int INCREMENT = 1;
    static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n2) {
        super(composite, Sash.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    static int checkStyle(int n2) {
        return Sash.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = this.getBorderWidth();
        int n5 = n4 * 2;
        int n6 = n4 * 2;
        if ((this.style & 0x100) != 0) {
            n5 += 64;
            n6 += 3;
        } else {
            n5 += 3;
            n6 += 64;
        }
        if (n2 != -1) {
            n5 = n2 + n4 * 2;
        }
        if (n3 != -1) {
            n6 = n3 + n4 * 2;
        }
        return new Point(n5, n6);
    }

    void drawBand(int n2, int n3, int n4, int n5) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        int n6 = this.parent.handle;
        byte[] byArray = new byte[16];
        byArray[0] = -86;
        byArray[2] = 85;
        byArray[4] = -86;
        byArray[6] = 85;
        byArray[8] = -86;
        byArray[10] = 85;
        byArray[12] = -86;
        byArray[14] = 85;
        byte[] byArray2 = byArray;
        int n7 = OS.CreateBitmap(8, 8, 1, 1, byArray2);
        int n8 = OS.CreatePatternBrush(n7);
        int n9 = OS.GetDCEx(n6, 0, 2);
        int n10 = OS.SelectObject(n9, n8);
        OS.PatBlt(n9, n2, n3, n4, n5, 5898313);
        OS.SelectObject(n9, n10);
        OS.ReleaseDC(n6, n9);
        OS.DeleteObject(n8);
        OS.DeleteObject(n7);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_ERASEBKGND(int n2, int n3) {
        super.WM_ERASEBKGND(n2, n3);
        this.drawBackground(n2);
        return LRESULT.ONE;
    }

    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (OS.GetKeyState(1) < 0) {
                    return lRESULT;
                }
                int n4 = OS.GetKeyState(17) < 0 ? 1 : 9;
                POINT pOINT = new POINT();
                if ((this.style & 0x200) != 0) {
                    if (n2 == 38 || n2 == 40) break;
                    pOINT.x = n2 == 37 ? -n4 : n4;
                } else {
                    if (n2 == 37 || n2 == 39) break;
                    pOINT.y = n2 == 38 ? -n4 : n4;
                }
                int n5 = this.parent.handle;
                OS.MapWindowPoints(this.handle, n5, pOINT, 1);
                RECT rECT = new RECT();
                RECT rECT2 = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n6 = rECT.right - rECT.left;
                int n7 = rECT.bottom - rECT.top;
                OS.GetClientRect(n5, rECT2);
                int n8 = rECT2.right - rECT2.left;
                int n9 = rECT2.bottom - rECT2.top;
                int n10 = this.lastX;
                int n11 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n10 = Math.min(Math.max(0, pOINT.x - this.startX), n8 - n6);
                } else {
                    n11 = Math.min(Math.max(0, pOINT.y - this.startY), n9 - n7);
                }
                if (n10 == this.lastX && n11 == this.lastY) {
                    return lRESULT;
                }
                POINT pOINT2 = new POINT();
                pOINT2.x = pOINT.x;
                pOINT2.y = pOINT.y;
                OS.ClientToScreen(n5, pOINT2);
                if ((this.style & 0x200) != 0) {
                    pOINT2.y += n7 / 2;
                } else {
                    pOINT2.x += n6 / 2;
                }
                OS.SetCursorPos(pOINT2.x, pOINT2.y);
                Event event = new Event();
                event.x = n10;
                event.y = n11;
                event.width = n6;
                event.height = n7;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                if (event.doit && (this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, n6, n7);
                }
                return lRESULT;
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n2, int n3) {
        return new LRESULT(256);
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        int n4 = this.parent.handle;
        POINT pOINT = new POINT();
        pOINT.x = (short)(n3 & 0xFFFF);
        pOINT.y = (short)(n3 >> 16);
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        OS.MapWindowPoints(this.handle, 0, pOINT, 1);
        this.startX = pOINT.x - rECT.left;
        this.startY = pOINT.y - rECT.top;
        OS.MapWindowPoints(0, n4, rECT, 2);
        this.lastX = rECT.left;
        this.lastY = rECT.top;
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n5;
        event.height = n6;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            this.menuShell().bringToTop();
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            if (OS.IsWinCE) {
                OS.UpdateWindow(n4);
            } else {
                int n7 = 384;
                OS.RedrawWindow(n4, null, 0, n7);
            }
            this.drawBand(event.x, event.y, n5, n6);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, n5, n6);
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.dragging) {
            return lRESULT;
        }
        this.dragging = false;
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n4;
        event.height = n5;
        this.drawBand(event.x, event.y, n4, n5);
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, n4, n5);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_MOUSEMOVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.dragging || (n2 & 1) == 0) {
            return lRESULT;
        }
        POINT pOINT = new POINT();
        pOINT.x = (short)(n3 & 0xFFFF);
        pOINT.y = (short)(n3 >> 16);
        int n5 = this.parent.handle;
        OS.MapWindowPoints(this.handle, n5, pOINT, 1);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        OS.GetClientRect(n5, rECT2);
        int n8 = this.lastX;
        int n9 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n4 = rECT2.right - rECT2.left;
            n8 = Math.min(Math.max(0, pOINT.x - this.startX), n4 - n6);
        } else {
            n4 = rECT2.bottom - rECT2.top;
            n9 = Math.min(Math.max(0, pOINT.y - this.startY), n4 - n7);
        }
        if (n8 == this.lastX && n9 == this.lastY) {
            return lRESULT;
        }
        this.drawBand(this.lastX, this.lastY, n6, n7);
        Event event = new Event();
        event.x = n8;
        event.y = n9;
        event.width = n6;
        event.height = n7;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
        }
        if (OS.IsWinCE) {
            OS.UpdateWindow(n5);
        } else {
            int n10 = 384;
            OS.RedrawWindow(n5, null, 0, n10);
        }
        this.drawBand(this.lastX, this.lastY, n6, n7);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(this.lastX, this.lastY, n6, n7);
        }
        return lRESULT;
    }

    LRESULT WM_SETCURSOR(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETCURSOR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = n3 & 0xFFFF;
        if (n4 == 1) {
            int n5 = 0;
            n5 = (this.style & 0x100) != 0 ? OS.LoadCursor(0, 32645) : OS.LoadCursor(0, 32644);
            OS.SetCursor(n5);
            return LRESULT.ONE;
        }
        return lRESULT;
    }
}

