/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n2) {
        this.data = new byte[n2];
    }

    public ByteVector putByte(int n2) {
        int n3 = this.length;
        if (n3 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    ByteVector put11(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        this.data[n4++] = (byte)n2;
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putShort(int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        this.data[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    ByteVector put12(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] byArray = this.data;
        this.data[n4++] = (byte)n2;
        byArray[n4++] = (byte)(n3 >>> 8);
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putInt(int n2) {
        int n3 = this.length;
        if (n3 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        this.data[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putLong(long l2) {
        int n2 = this.length;
        if (n2 + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] byArray = this.data;
        int n3 = (int)(l2 >>> 32);
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        n3 = (int)l2;
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        this.length = n2;
        return this;
    }

    public ByteVector putUTF8(String string) {
        int n2 = string.length();
        if (this.length + 2 + n2 > this.data.length) {
            this.enlarge(2 + n2);
        }
        int n3 = this.length;
        byte[] byArray = this.data;
        this.data[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5 = string.charAt(i2);
            if (n5 >= 1 && n5 <= 127) {
                byArray[n3++] = (byte)n5;
                continue;
            }
            int n6 = i2;
            for (n4 = i2; n4 < n2; ++n4) {
                n5 = string.charAt(n4);
                if (n5 >= 1 && n5 <= 127) {
                    ++n6;
                    continue;
                }
                if (n5 > 2047) {
                    n6 += 3;
                    continue;
                }
                n6 += 2;
            }
            byArray[this.length] = (byte)(n6 >>> 8);
            byArray[this.length + 1] = (byte)n6;
            if (this.length + 2 + n6 > byArray.length) {
                this.length = n3;
                this.enlarge(2 + n6);
                byArray = this.data;
            }
            for (n4 = i2; n4 < n2; ++n4) {
                int n7;
                int n8;
                byte[] byArray2;
                n5 = string.charAt(n4);
                if (n5 >= 1 && n5 <= 127) {
                    byArray2 = byArray;
                    n8 = n3++;
                    n7 = n5;
                } else {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    byte[] byArray3;
                    if (n5 > 2047) {
                        byArray[n3++] = (byte)(0xE0 | n5 >> 12 & 0xF);
                        byArray3 = byArray;
                        n12 = n3++;
                        n11 = 128;
                        n10 = n5 >> 6;
                        n9 = 63;
                    } else {
                        byArray3 = byArray;
                        n12 = n3++;
                        n11 = 192;
                        n10 = n5 >> 6;
                        n9 = 31;
                    }
                    byArray3[n12] = (byte)(n11 | n10 & n9);
                    byArray2 = byArray;
                    n8 = n3++;
                    n7 = 0x80 | n5 & 0x3F;
                }
                byArray2[n8] = (byte)n7;
            }
            break;
        }
        this.length = n3;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n2, int n3) {
        if (this.length + n3 > this.data.length) {
            this.enlarge(n3);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n2, this.data, this.length, n3);
        }
        this.length += n3;
        return this;
    }

    private void enlarge(int n2) {
        int n3 = 2 * this.data.length;
        int n4 = this.length + n2;
        byte[] byArray = new byte[n3 > n4 ? n3 : n4];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        this.data = byArray;
    }
}

