
*- This is a template file for your wizard's engine file.
*- In this file, define a subclass of the WizEngineAll class (located in the
*- WZENGINE.PRG file). This class will contain special members and methods/procedures
*- that are required by your wizard.
*-
*- Special initialization code can be put in the Init2 method. This method is
*- always called in the Wizard initialization code. Return .F. if your special
*- initialization code fails.

#INCLUDE "htmlwiz.h"
		

*--------------------------------------
DEFINE CLASS HTMLEngine AS WizEngineAll
*--------------------------------------


	*----------------------------------
	PROCEDURE Init2
	*----------------------------------
	
		*- special initialization code for your wizard
		
		RETURN .T.

	ENDPROC


	*----------------------------------
	PROCEDURE ProcessOutput
	*----------------------------------
		*- the ProcessOutput method of the sample wizard will call this function

		LOCAL cNewFile, cValue, i, iNumFields, iRow, cTagName, cDate
		
		m.cNewFile = THIS.cOutFile
		iNumFields = ALEN(THIS.aWizFields,1)
		
		*- make an array of the fields we will be using, with field type, width and dec places
		LOCAL ARRAY aFldList[1,1]
		LOCAL ARRAY aHTMLFields[iNumFields,4]		

		=ACOPY(THIS.aWizFList,aFldList)
		FOR i = 1 TO iNumFields
			aHTMLFields[i, 1] = THIS.aWizFields[i,1]
			iRow = THIS.AColScan(@aFldList, UPPER(aHTMLFields[i, 1]), 1, .T.)
			IF iRow > 0
				aHTMLFields[i,2] = THIS.aWizFList[iRow, 2]
				aHTMLFields[i,3] = THIS.aWizFList[iRow, 3]
				aHTMLFields[i,4] = THIS.aWizFList[iRow, 4]
			ENDIF
		NEXT

		*- if the user selected a sort order, implement that here
		IF !EMPTY(THIS.aWizSorts[1])
			IF THIS.lHasSortTag
				m.cTagName = THIS.aWizSorts[1]
			ELSE
				m.cTagName = THIS.AddCdxTag("aWizSorts","aWizFList")
			ENDIF
		ENDIF
		
		IF TYPE("m.cTagName") = 'C' AND !EMPTY(m.cTagName)
			SET ORDER TO TAG (m.cTagName)
		ENDIF
			
		*- here's where we do the actual work in generating our special output
		SET TEXTMERGE TO (THIS.cOutFile)
		SET TEXTMERGE ON NOSHOW
		
		*- Generate HTML header information	
#IF 0
		\\HTTP/1.0 200 OK
		\Content-Type: text/html
		* The next line tells browsers not to refresh the page from the local cache,
		* but to re-request the page from the server. Note the date just needs to be
		* a date in the past.
		\Expires: Sunday 15-May-94 14:00:01 GMT
		\
#ENDIF
		\<HTML>
		\
		\<!-- <<EVAL(GENHTML_LOC)>> -->
		\
		\<font size=4 face="Lucida Console">
		\<title><<THIS.cWizTitle>></title>

		*- generate a table of the selected data
		
		*- first, the table headings
		\<H3><<THIS.cWizTitle>></H3>
		\<P>
		\<P>
		\<TABLE BORDER>
		\<TR>
		FOR i = 1 TO iNumFields
			\<<C_TAB>><TH><<aHTMLFields[i,1]>></TH>
		NEXT
		\</TR>
		*- process the data
		SELECT (THIS.cWizAlias)
		SCAN
			\<TR>
			\<<C_TAB>>
			FOR i = 1 TO iNumFields
				cValue = THIS.MakeString(aHTMLFields[i,1],;
					aHTMLFields[i,2],aHTMLFields[i,3],aHTMLFields[i,4])
				\\<TD><<EVAL(cValue)>></TD>
			NEXT
			\</TR>
		ENDSCAN		
		\</TABLE>
		*- done
		\<P>
		\<P>
		cDate = GENDATE_LOC + DTOC(DATE())
		\<I><<cDate>></I>
		\<P>
		\</HTML>
		SET TEXTMERGE OFF
		SET TEXTMERGE TO

		*-
		*- handle selected follow-up action
		*-
		m.cNewFile = [']+m.cNewFile+[']

		DO CASE
			CASE THIS.nWizAction = 2
				*- open HTML file in a browser
				*- how do we want to do this? create a form, add a browser control?
				*- determine if Netscape or IE3.0? And use OLE automation?
				THIS.MakeBrowser(I_SHOW_MODAL)
			CASE THIS.nWizAction = 3
				*- open HTML file in a text editor
				_SHELL = [MODIFY FILE &cNewFile NOWAIT]
		ENDCASE
		
		RETURN .T.
		
	ENDPROC


	*----------------------------------
	PROCEDURE MakeString
	*----------------------------------
		*- Routine returns theValue as a character expression
		*- character expressions are trimmed, with an arbitrary max of N_MAX_WIDTH chars

		LPARAMETER theValue,cDataType,nDataWid,nDataDec

		#DEFINE N_MAX_WIDTH	40
		
		DO CASE
			CASE m.cDataType = DT_CHAR AND m.nDataWid > N_MAX_WIDTH
				RETURN "TRIM(LEFT("+m.theValue+"," + LTRIM(STR(N_MAX_WIDTH)) + "))"
			CASE m.cDataType = DT_CHAR
				RETURN "TRIM(" + m.theValue +")"
			CASE m.cDataType = DT_LOGIC
				RETURN "IIF("+m.theValue+",C_YES_LOC,C_NO_LOC)"
			CASE m.cDataType = DT_INTEGER
				RETURN "STR("+m.theValue+")"
			CASE INLIST(m.cDataType,DT_NUM,DT_FLOAT)
				RETURN "STR("+m.theValue+","+ALLT(STR(m.nDataWid))+;
					","+ALLT(STR(m.nDataDec))+")"
			CASE m.cDataType = DT_CURRENCY
				RETURN "ALLT(STR("+m.theValue+",16,4))"
			CASE m.cDataType = DT_DOUBLE
				RETURN "ALLT(STR(SIGN("+m.theValue+")*IIF("+m.theValue+"=0,0,LOG10(ABS("+m.theValue+"))),20,16))"
			CASE m.cDataType = DT_DATE
				RETURN "DTOS("+m.theValue+")"
			CASE m.cDataType = DT_DATETIME
				RETURN "DTOS(TTOD("+m.theValue+"))+STR(HOUR("+m.theValue+;
					"),2)+STR(MINUTE("+m.theValue+"),2)+STR(SEC("+m.theValue+"),2)"
			OTHERWISE  	&& don't display
				RETURN "<N/A>"
		ENDCASE
	ENDPROC

	*----------------------------------
	PROCEDURE MakeBrowser
	*----------------------------------
		*- create a simple browser that we can run from within VFP
		PARAMETER iShowMode
		
		LOCAL oForm, cRun
		
#IF 0
		*- turn file name into a URL
		cURL = CHRTRAN(THIS.cOutFile,":\","|/")
		cURL = STRTRAN(cURL," ","%20")
#ENDIF

		THIS.SetErrorOff = .T.		&& this suppresses error messages. If an error occurs
									&& THIS.HadError will be .T.
		oForm = CREATEOBJECT("MyInternetExplorer")
		THIS.SetErrorOff = .F.		&& turn error reporting back on
		IF THIS.HadError OR TYPE("oForm") # 'O'
			THIS.Alert(C_NOBROWSER_LOC)
			RETURN
		ENDIF
		oForm.oWeb.Navigate(THIS.cOutFile)  && insert your URL here
		oForm.Show(iShowMode)
				
ENDDEFINE		&& HTMLEngine

*--------------------------------------
DEFINE CLASS MyInternetExplorer AS form
*--------------------------------------

	*- an extra class -- this is our VFP browser
	
	ADD OBJECT oWeb AS CWeb
	caption = "HTML Wizard Internet Explorer"
	
	PROCEDURE Init
		THISFORM.Left = 0
		THISFORM.Width = SYSMETRIC(1) * 3/4
		THISFORM.Height = SYSMETRIC(2) * 3/4
		THIS.Resize
		
	PROCEDURE Resize
		THIS.oWeb.resize
	
ENDDEFINE


*--------------------------------------
DEFINE CLASS CWeb AS OleControl
*--------------------------------------

	*- an extra class -- this is our browser OLE Control
	OleClass = "Shell.Explorer.1"
	
	PROCEDURE Resize
		THIS.Width = THISFORM.Width
		THIS.Height = THISFORM.Height
	
	PROCEDURE Error
		*- do nothing
		RETURN
		
	PROCEDURE Refresh
		NODEFAULT
		
ENDDEFINE


*- eof
