/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MultiImagePanel
extends JPanel {
    private static final int a = 10;
    private List<? extends Image> images;
    private final Font font;

    public MultiImagePanel() {
        this.setBackground(Color.white);
        this.font = UIManager.getDefaults().getFont("Label.font");
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.images != null) {
            graphics.setFont(this.font);
            int n2 = 0;
            int n3 = this.font.getSize() + 10;
            for (Image image : this.images) {
                int n4 = image.getWidth(null);
                int n5 = image.getHeight(null);
                if (n4 >= 0 && n5 >= 0) {
                    graphics.drawString(n4 + " x " + n5, 0, n2 + this.font.getSize() + 3);
                }
                graphics.drawImage(image, 0, n2 + n3, this);
                n2 += n5 + n3 + 10;
            }
        }
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public void setImages(List<? extends Image> list) {
        this.images = list;
        this.repaint();
    }

    public void clearImages() {
        this.images = null;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.images != null) {
            int n2 = 0;
            int n3 = 0;
            for (Image image : this.images) {
                n3 += image.getHeight(null) + this.font.getSize() + 10 + 10;
                n2 = Math.max(n2, image.getWidth(null));
            }
            return new Dimension(n2, n3);
        }
        return super.getPreferredSize();
    }
}

