/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.GistIntegrationConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.GistIntegrationSettingsPanel$2;
import com.xk72.charles.gui.settings.GistIntegrationSettingsPanel$3;
import com.xk72.charles.gui.settings.ImportExportPanel;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.g;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class GistIntegrationSettingsPanel
extends SettingsPanel
implements ImportExportPanel<GistIntegrationConfiguration> {
    private static final Logger a = Logger.getLogger("com.xk72.charles.gui.settings.GistIntegrationSettingsPanel");
    private static final URI b;
    private final JCheckBox openGist = new JCheckBox("Open Gist after publishing");
    private final JRadioButton secret = new JRadioButton("Secret", true);
    private final JRadioButton pub = new JRadioButton("Public", false);
    private final JTextField publishLimit = new JTextField(7);
    private final JComponent tokenMessage = FormUtils.e("Charles is authorized to publish to your GitHub account.");
    private final JComponent requestTokenMessage = FormUtils.e("Gists will be published anonymously, as you have not authorized Charles to use a GitHub account.\n\nAnonymous Gists are not associated with any account and cannot be deleted.\n\nAuthorize Charles to publish Gists using your GitHub account. This will open GitHub.com where you can grant Charles access to publish with your account.");
    private final JButton requestToken;
    private final JButton clearToken;
    private final JLabel token = new JLabel();
    private final JCheckBox enterpriseGitHub = new JCheckBox("Use GitHub Enterprise");
    private final JTextField enterpriseURL = new JTextField(20);

    public GistIntegrationSettingsPanel() {
        super("Publish");
        this.setLayout(new MigLayout("wrap, fillx", "[label][]"));
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.secret);
        ((ButtonGroup)serializable).add(this.pub);
        this.add(new JLabel("Publish as:"));
        this.add((Component)this.secret, "split 2");
        this.add(this.pub);
        this.add(new JLabel("Publish limit (MB):"));
        this.add(this.publishLimit);
        this.add((Component)this.openGist, "skip");
        this.add((Component)this.enterpriseGitHub, "skip");
        this.enterpriseURL.setEnabled(this.enterpriseGitHub.isSelected());
        this.enterpriseGitHub.addChangeListener(new g(this));
        this.add(new EnableAwareJLabel("GitHub location:", this.enterpriseURL));
        this.add(this.enterpriseURL);
        serializable = new JPanel();
        this.add((Component)serializable, "span, growx");
        ((Container)serializable).setLayout(FormUtils.a(null, false, false));
        ((JComponent)serializable).setBorder(FormUtils.a("Authorization"));
        ((JComponent)serializable).setMinimumSize(new Dimension(400, 1));
        Font font = this.token.getFont();
        font = font.deriveFont(font.getSize2D() - 2.0f);
        this.token.setFont(font);
        ((Container)serializable).add(this.tokenMessage, "hidemode 1,span,left,growx");
        ((Container)serializable).add(this.token, "split 2,hidemode 1");
        this.clearToken = new JButton(new GistIntegrationSettingsPanel$2(this, "Clear"));
        ((Container)serializable).add(this.clearToken, "hidemode 1");
        ((Container)serializable).add(this.requestTokenMessage, "hidemode 1,span,left,growx");
        this.requestToken = new JButton(new GistIntegrationSettingsPanel$3(this, "Authorize", font));
        ((Container)serializable).add(this.requestToken, "hidemode 1");
        serializable = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        this.setImportedConfiguration((GistIntegrationConfiguration)serializable);
    }

    private void a(String object) {
        if (object == null || ((String)object).isEmpty()) {
            this.b();
            return;
        }
        this.token.setText((String)object);
        this.tokenMessage.setVisible(true);
        this.token.setVisible(true);
        this.clearToken.setVisible(true);
        this.requestTokenMessage.setVisible(false);
        this.requestToken.setVisible(false);
        this.revalidate();
        object = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (object != null) {
            ((Window)object).pack();
        }
    }

    private void b() {
        this.token.setText("");
        this.tokenMessage.setVisible(false);
        this.token.setVisible(false);
        this.clearToken.setVisible(false);
        this.requestTokenMessage.setVisible(true);
        this.requestToken.setVisible(true);
        this.revalidate();
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (dialog != null) {
            dialog.pack();
        }
    }

    @Override
    public GistIntegrationConfiguration getExportConfiguration() {
        GistIntegrationConfiguration gistIntegrationConfiguration = new GistIntegrationConfiguration();
        this.a(gistIntegrationConfiguration);
        return gistIntegrationConfiguration;
    }

    @Override
    public void setImportedConfiguration(GistIntegrationConfiguration gistIntegrationConfiguration) {
        this.openGist.setSelected(gistIntegrationConfiguration.isOpenGist());
        if (gistIntegrationConfiguration.isSecret()) {
            this.secret.setSelected(true);
        } else {
            this.pub.setSelected(true);
        }
        this.publishLimit.setText(String.valueOf(gistIntegrationConfiguration.getPublishLimit()));
        this.a(GistIntegrationSettingsPanel.b(gistIntegrationConfiguration.getAuthToken()));
        this.enterpriseGitHub.setSelected(gistIntegrationConfiguration.isEnterpriseGitHub());
        this.enterpriseURL.setText(GistIntegrationSettingsPanel.b(gistIntegrationConfiguration.getEnterpriseURL()));
    }

    @Override
    public boolean preSave() {
        int n2 = this.prefToInt("Publish Limit", this.publishLimit.getText());
        if (n2 < 0) {
            throw new SettingsException("Publish Limit", "Please enter a non-negative number.");
        }
        if (this.enterpriseGitHub.isSelected()) {
            Object object = GistIntegrationSettingsPanel.c(this.enterpriseURL.getText());
            if (object == null) {
                throw new SettingsException("GitHub Location", "Please enter a location for your installation e.g. https://api.github.com");
            }
            try {
                object = GistIntegrationConfiguration.a((String)object);
                String string = ((URI)object).getPath();
                if (string != null && !string.equals("/") && string.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
                string = ((URI)object).getQuery();
                if (string != null && string.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
                if ((object = ((URI)object).getFragment()) != null && ((String)object).length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                a.log(Level.WARNING, "Error parsing URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
                throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
            }
        }
        return super.preSave();
    }

    @Override
    public boolean save() {
        GistIntegrationConfiguration gistIntegrationConfiguration = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        this.a(gistIntegrationConfiguration);
        return true;
    }

    private void a(GistIntegrationConfiguration gistIntegrationConfiguration) {
        gistIntegrationConfiguration.setOpenGist(this.openGist.isSelected());
        gistIntegrationConfiguration.setSecret(this.secret.isSelected());
        gistIntegrationConfiguration.setPublishLimit(this.prefToIntSafe(this.publishLimit.getText()));
        gistIntegrationConfiguration.setAuthToken(GistIntegrationSettingsPanel.c(this.token.getText()));
        gistIntegrationConfiguration.setEnterpriseGitHub(this.enterpriseGitHub.isSelected());
        gistIntegrationConfiguration.setEnterpriseURL(GistIntegrationSettingsPanel.c(this.enterpriseURL.getText()));
    }

    private static String b(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String c(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    static /* synthetic */ JCheckBox a(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        return gistIntegrationSettingsPanel.enterpriseGitHub;
    }

    static /* synthetic */ JTextField b(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        return gistIntegrationSettingsPanel.enterpriseURL;
    }

    static /* synthetic */ void c(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        gistIntegrationSettingsPanel.b();
    }

    static /* synthetic */ URI a() {
        return b;
    }

    static /* synthetic */ void a(GistIntegrationSettingsPanel gistIntegrationSettingsPanel, String string) {
        gistIntegrationSettingsPanel.a(string);
    }

    static {
        try {
            b = new URI("http://www.charlesproxy.com/github/auth.do");
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

