/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.RecordingConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.ExtendedJOptionPane;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.F;
import com.xk72.charles.gui.settings.RecordingSettingsPanel;
import com.xk72.charles.gui.settings.RecordingSettingsPanel$AbstractRecordingSettingsPanel;
import com.xk72.charles.gui.settings.SettingsException;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class RecordingSettingsPanel$LimitsPanel
extends RecordingSettingsPanel$AbstractRecordingSettingsPanel {
    private final JCheckBox cbLimit;
    private final JTextField fLimit;
    private final JTextField fMaxTransactions;
    private final JLabel lMaxTransactions;
    final /* synthetic */ RecordingSettingsPanel this$0;

    public RecordingSettingsPanel$LimitsPanel(RecordingSettingsPanel object) {
        this.this$0 = object;
        super((RecordingSettingsPanel)object, CharlesContext.getInstance().getBundle().getString("settings.recording.limits.name"));
        this.cbLimit = new JCheckBox("Limit recording history");
        this.fLimit = new JTextField(4);
        this.fMaxTransactions = new JTextField(4);
        this.lMaxTransactions = new EnableAwareJLabel("Max requests:", this.fMaxTransactions);
        this.setHelp(CharlesContext.getInstance().getBundle().getString("settings.recording.limits.help"));
        this.cbLimit.addItemListener(new F(this, (RecordingSettingsPanel)object));
        this.fMaxTransactions.setEnabled(this.cbLimit.isSelected());
        this.setLayout(FormUtils.e());
        object = new JPanel(new MigLayout("wrap,fill", "[label][fill,grow]"));
        ((JComponent)object).setBorder(new TitledBorder("Recording Limits"));
        ((Container)object).add((Component)this.cbLimit, "span,align left");
        ((Container)object).add((Component)this.lMaxTransactions, "gap indent");
        ((Container)object).add(this.fMaxTransactions);
        ((Container)object).add(new JLabel("Recording size limit (MB):"));
        ((Container)object).add(this.fLimit);
        this.add((Component)object);
    }

    @Override
    public boolean preSave() {
        if (this.cbLimit.isSelected()) {
            if (this.fMaxTransactions.getText().length() > 0) {
                int n2 = this.prefToInt("Max Requests", this.fMaxTransactions.getText());
                if (n2 <= 0) {
                    throw new SettingsException("Max Requests", "Value must be empty or greater than 0.");
                }
                ExtendedJOptionPane.a(this, "A recording limit means that old requests will automatically be cleared from the session when the limit is reached. Please ensure that the limit is set high enough so that you do not unexpectedly lose data.", "Recording Limits", 1);
            } else {
                throw new SettingsException("Max Requests", "Value must be empty or greater than 0.");
            }
        }
        this.prefToInt("Recording Size Limit", this.fLimit.getText());
        return true;
    }

    @Override
    protected void getPanelConfiguration(RecordingConfiguration recordingConfiguration) {
        recordingConfiguration.setLimit(this.prefToIntSafe(this.fLimit.getText()));
        if (this.cbLimit.isSelected() && this.fMaxTransactions.getText().length() > 0) {
            int n2 = this.prefToIntSafe(this.fMaxTransactions.getText());
            recordingConfiguration.setMaxTransactions(n2);
            return;
        }
        recordingConfiguration.setMaxTransactions(0);
    }

    @Override
    protected void setPanelConfiguration(RecordingConfiguration recordingConfiguration) {
        this.fLimit.setText(String.valueOf(recordingConfiguration.getLimit()));
        this.cbLimit.setSelected(recordingConfiguration.getMaxTransactions() > 0);
        this.fMaxTransactions.setText(recordingConfiguration.getMaxTransactions() > 0 ? String.valueOf(recordingConfiguration.getMaxTransactions()) : "");
    }

    static /* synthetic */ JCheckBox a(RecordingSettingsPanel$LimitsPanel recordingSettingsPanel$LimitsPanel) {
        return recordingSettingsPanel$LimitsPanel.cbLimit;
    }

    static /* synthetic */ JTextField b(RecordingSettingsPanel$LimitsPanel recordingSettingsPanel$LimitsPanel) {
        return recordingSettingsPanel$LimitsPanel.fMaxTransactions;
    }
}

