/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.gui.settings.N;
import com.xk72.charles.gui.settings.SettingsDialog;
import com.xk72.charles.gui.settings.SettingsException;
import javax.swing.JPanel;

public abstract class SettingsPanel
extends JPanel {
    protected CharlesContext ctx;
    private final String title;
    private String help;

    public SettingsPanel(String string) {
        this.title = string;
        this.ctx = CharlesContext.getInstance();
    }

    protected void init() {
    }

    protected final void test() {
        SettingsDialog settingsDialog = new SettingsDialog(null, "", this);
        settingsDialog.setVisible(true);
        settingsDialog.addWindowListener(new N(this));
    }

    public boolean preSave() {
        return true;
    }

    public abstract boolean save();

    protected int prefToInt(String string, String string2) {
        return this.prefToInt(string, string2, false);
    }

    protected int prefToInt(String string, String string2, boolean bl) {
        try {
            int n2 = this.prefToIntSafe(string2);
            if (n2 == -1) {
                throw new SettingsException(string, "Please enter a number.");
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingsException(string, "Please enter a valid whole number.");
        }
    }

    protected double prefToDouble(String string, String string2) {
        return this.prefToDouble(string, string2, false);
    }

    protected double prefToDouble(String string, String string2, boolean bl) {
        try {
            double d2 = this.prefToDoubleSafe(string2);
            if (d2 == -1.0) {
                throw new SettingsException(string, "Please enter a number.");
            }
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingsException(string, "Please enter a valid number.");
        }
    }

    protected int prefToIntSafe(String string) {
        if (string.length() > 0) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    protected double prefToDoubleSafe(String string) {
        if (string.length() > 0) {
            return Double.parseDouble(string);
        }
        return -1.0;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String string) {
        this.help = string;
    }
}

