/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.am;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.T;
import com.xk72.charles.macosx.m;
import com.xk72.charles.win32.a;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.SystemTray;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class UISettingsPanel
extends SettingsPanel {
    private final JComboBox cFont;
    private final JComboBox cFontSize;
    private final JCheckBox bShowTrayIcon = new JCheckBox(m.b() ? "Show Charles in menu bar" : "Show system tray icon");
    private final JCheckBox bMinimiseToTray = new JCheckBox("Minimise to system tray");
    private final JCheckBox bShowMemoryUsage = new JCheckBox("Show memory usage");
    private final JCheckBox bEnableHotkeys = new JCheckBox("Enable global hotkeys");
    private final JCheckBox bAlwaysOnTop = new JCheckBox("Window always on top");
    private final JCheckBox bHighlightTreeChanges = new JCheckBox("Highlight changes in the structure tree");

    public UISettingsPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.ui.name"));
        this.setHelp(this.ctx.getBundle().getString("settings.ui.help"));
        Serializable serializable = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.cFont = new JComboBox<String>(stringArray);
        this.cFont.insertItemAt("Default", 0);
        this.cFont.setSelectedIndex(0);
        if (((UserInterfaceConfiguration)serializable).getDisplayFont() != null) {
            this.cFont.setSelectedItem(((UserInterfaceConfiguration)serializable).getDisplayFont());
        }
        this.cFontSize = new JComboBox();
        this.cFontSize.addItem("Default");
        for (int i2 = 9; i2 <= 24; ++i2) {
            this.cFontSize.addItem(new Integer(i2));
        }
        if (((UserInterfaceConfiguration)serializable).getDisplayFontSize() != null) {
            this.cFontSize.setSelectedItem(((UserInterfaceConfiguration)serializable).getDisplayFontSize());
        }
        this.bShowTrayIcon.setSelected(((UserInterfaceConfiguration)serializable).isShowTrayIcon());
        this.bMinimiseToTray.setSelected(((UserInterfaceConfiguration)serializable).isMinimiseToTray());
        this.bMinimiseToTray.setEnabled(this.bShowTrayIcon.isSelected());
        this.bShowTrayIcon.addChangeListener(new T(this));
        this.bShowMemoryUsage.setSelected(((UserInterfaceConfiguration)serializable).isShowMemoryUsage());
        this.bEnableHotkeys.setSelected(((UserInterfaceConfiguration)serializable).isEnableHotkeys());
        this.bAlwaysOnTop.setSelected(((UserInterfaceConfiguration)serializable).isAlwaysOnTop());
        this.bHighlightTreeChanges.setSelected(((UserInterfaceConfiguration)serializable).isHighlightTreeChanges());
        this.setLayout(FormUtils.a(null, false, false));
        JPanel jPanel = new JPanel(new MigLayout("wrap, fill", "[label][fill]", "[]u[]"));
        jPanel.setBorder(new TitledBorder("Display"));
        jPanel.add(new JLabel("Display font:"));
        jPanel.add(this.cFont);
        jPanel.add(new JLabel("Display font size:"));
        jPanel.add(this.cFontSize);
        this.add(jPanel);
        serializable = new JPanel(FormUtils.a(null, false, false));
        ((JComponent)serializable).setBorder(new TitledBorder("Other"));
        if (SystemTray.isSupported()) {
            ((Container)serializable).add(this.bShowTrayIcon);
        }
        if (a.a()) {
            ((Container)serializable).add(this.bMinimiseToTray);
            ((Container)serializable).add(this.bEnableHotkeys);
        }
        if (CharlesContext.getJavaVersion() >= 15) {
            ((Container)serializable).add(this.bAlwaysOnTop);
        }
        ((Container)serializable).add(this.bHighlightTreeChanges);
        ((Container)serializable).add(this.bShowMemoryUsage);
        this.add((Component)serializable);
    }

    public static void main(String[] stringArray) {
        new UISettingsPanel().test();
    }

    @Override
    public boolean save() {
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        Object object = this.cFont.getSelectedItem().toString();
        Integer n2 = this.cFontSize.getSelectedItem() instanceof Integer ? (Integer)this.cFontSize.getSelectedItem() : null;
        boolean bl = !UISettingsPanel.a(userInterfaceConfiguration.getDisplayFont(), object) || !UISettingsPanel.a(userInterfaceConfiguration.getDisplayFontSize(), n2);
        userInterfaceConfiguration.setDisplayFont((String)object);
        userInterfaceConfiguration.setDisplayFontSize(n2);
        if (bl) {
            am.a(this.cFont.getSelectedItem().toString(), userInterfaceConfiguration.getDisplayFontSize());
            object = this;
            while (((Component)object).getParent() != null) {
                object = ((Component)object).getParent();
            }
            UISettingsPanel.a((Component)object);
        }
        userInterfaceConfiguration.setShowTrayIcon(this.bShowTrayIcon.isSelected());
        userInterfaceConfiguration.setMinimiseToTray(this.bMinimiseToTray.isSelected());
        userInterfaceConfiguration.setShowMemoryUsage(this.bShowMemoryUsage.isSelected());
        userInterfaceConfiguration.setEnableHotkeys(this.bEnableHotkeys.isSelected());
        userInterfaceConfiguration.setAlwaysOnTop(this.bAlwaysOnTop.isSelected());
        userInterfaceConfiguration.setHighlightTreeChanges(this.bHighlightTreeChanges.isSelected());
        return true;
    }

    private static boolean a(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    private Component a() {
        Container container = this;
        while (container.getParent() != null) {
            container = container.getParent();
        }
        return container;
    }

    public static void a(Component component) {
        UISettingsPanel.b(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void b(Component component) {
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                UISettingsPanel.b(component2);
            }
        }
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    static /* synthetic */ JCheckBox a(UISettingsPanel uISettingsPanel) {
        return uISettingsPanel.bShowTrayIcon;
    }

    static /* synthetic */ JCheckBox b(UISettingsPanel uISettingsPanel) {
        return uISettingsPanel.bMinimiseToTray;
    }
}

