/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.AbstractConfiguration;
import com.xk72.charles.config.ProtobufConfiguration;
import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.U;
import com.xk72.charles.gui.settings.ViewersSettingsPanel$1;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ViewersSettingsPanel
extends SettingsPanel {
    private final JCheckBox bShowLineNumbers = new JCheckBox("Show line numbers");
    private final JCheckBox bLineWrap = new JCheckBox("Line wrap");
    private final JRadioButton rSessionNavStructureHorizontal = new JRadioButton("Tall");
    private final JRadioButton rSessionNavStructureVertical = new JRadioButton("Wide");
    private final JRadioButton rSessionNavSequenceVertical = new JRadioButton("Wide");
    private final JCheckBox bCombineHeadersAndBodyViewers = new JCheckBox("Combine header and body viewers");
    private final JCheckBox bCombineRequestAndResponse = new JCheckBox("Combine request and response");
    private final JComboBox cTime;
    private final JComboBox cSpeed;
    private final JRadioButton rSessionNavSequenceHorizontal = new JRadioButton("Tall");
    private final JCheckBox bHideProtobufUnvaluedFields = new JCheckBox("Hide unspecified fields");
    private final JCheckBox bCacheProtobufDescriptors = new JCheckBox("Cache protobuf descriptors");
    private final JTextField fCacheTTL = new JTextField(7);

    public ViewersSettingsPanel() {
        super("Viewers");
        Serializable serializable = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        this.bShowLineNumbers.setSelected(((UserInterfaceConfiguration)serializable).isShowLineNumbers());
        this.bLineWrap.setSelected(((UserInterfaceConfiguration)serializable).isLineWrap());
        Serializable serializable2 = new ButtonGroup();
        ((ButtonGroup)serializable2).add(this.rSessionNavStructureHorizontal);
        ((ButtonGroup)serializable2).add(this.rSessionNavStructureVertical);
        this.rSessionNavStructureHorizontal.setSelected(((UserInterfaceConfiguration)serializable).getSessionNavStructureLayout() == 0);
        this.rSessionNavStructureVertical.setSelected(((UserInterfaceConfiguration)serializable).getSessionNavStructureLayout() == 1);
        serializable2 = new ButtonGroup();
        ((ButtonGroup)serializable2).add(this.rSessionNavSequenceHorizontal);
        ((ButtonGroup)serializable2).add(this.rSessionNavSequenceVertical);
        this.rSessionNavSequenceHorizontal.setSelected(((UserInterfaceConfiguration)serializable).getSessionNavSequenceLayout() == 0);
        this.rSessionNavSequenceVertical.setSelected(((UserInterfaceConfiguration)serializable).getSessionNavSequenceLayout() == 1);
        this.bCombineHeadersAndBodyViewers.setSelected(((UserInterfaceConfiguration)serializable).isCombineHeadersAndBody());
        this.bCombineRequestAndResponse.setSelected(((UserInterfaceConfiguration)serializable).isCombineRequestAndResponse());
        this.cSpeed = new JComboBox();
        this.cSpeed.addItem("bytes / second");
        this.cSpeed.addItem("bits / second");
        this.cSpeed.setSelectedIndex(((UserInterfaceConfiguration)serializable).getUnitsSpeed());
        this.cTime = new JComboBox();
        this.cTime.addItem("seconds");
        this.cTime.addItem("milliseconds");
        this.cTime.setSelectedIndex(((UserInterfaceConfiguration)serializable).getUnitsTime());
        serializable = this.ctx.getConfiguration().getProtobufConfiguration();
        this.bHideProtobufUnvaluedFields.setSelected(((ProtobufConfiguration)serializable).isHideUnvaluedFields());
        this.bCacheProtobufDescriptors.setSelected(((ProtobufConfiguration)serializable).isCacheDescriptors());
        this.fCacheTTL.setText(String.valueOf(((ProtobufConfiguration)serializable).getHeuristicTTL() / 1000L));
        this.setLayout(FormUtils.a(null, false, false));
        serializable = new JPanel(new MigLayout("wrap,fillx", "[][fill][fill,grow]", "[]u[]"));
        ((JComponent)serializable).setBorder(FormUtils.a("Layout"));
        ((Container)serializable).add(this.bCombineHeadersAndBodyViewers, "span");
        ((Container)serializable).add(this.bCombineRequestAndResponse, "span");
        ((Container)serializable).add(new JLabel("Structure view:"), "label");
        ((Container)serializable).add(this.rSessionNavStructureHorizontal);
        ((Container)serializable).add(this.rSessionNavStructureVertical);
        ((Container)serializable).add(new JLabel("Sequence view:"), "label");
        ((Container)serializable).add(this.rSessionNavSequenceHorizontal);
        ((Container)serializable).add(this.rSessionNavSequenceVertical);
        this.add((Component)serializable);
        serializable = new JPanel(FormUtils.a(null, false, false));
        ((JComponent)serializable).setBorder(FormUtils.a("Text"));
        ((Container)serializable).add(this.bShowLineNumbers);
        ((Container)serializable).add(this.bLineWrap);
        this.add((Component)serializable);
        serializable = new JPanel(new MigLayout("wrap,fillx", "[label][fill,grow]"));
        ((JComponent)serializable).setBorder(FormUtils.a("Display Units"));
        ((Container)serializable).add(new JLabel("Speed:"));
        ((Container)serializable).add(this.cSpeed);
        ((Container)serializable).add(new JLabel("Time:"));
        ((Container)serializable).add(this.cTime);
        this.add((Component)serializable);
        serializable = new JPanel(new MigLayout("wrap", "[][]"));
        ((JComponent)serializable).setBorder(FormUtils.a("Protocol Buffers"));
        ((Container)serializable).add(this.bHideProtobufUnvaluedFields, "span");
        ((Container)serializable).add(this.bCacheProtobufDescriptors, "span, gaptop u");
        ((Container)serializable).add(new EnableAwareJLabel("Heuristic cache TTL (seconds):", this.fCacheTTL), "gapleft i");
        ((Container)serializable).add(this.fCacheTTL);
        JTextField jTextField = this.fCacheTTL;
        JCheckBox jCheckBox = this.bCacheProtobufDescriptors;
        serializable2 = this;
        ((Component)jTextField).setEnabled(((Component)serializable2).isEnabled() && jCheckBox.isSelected());
        jCheckBox.addChangeListener(new U((ViewersSettingsPanel)serializable2, jTextField, jCheckBox));
        serializable2 = new JButton("Clear Cached Resources");
        ((AbstractButton)serializable2).addActionListener(new ViewersSettingsPanel$1(this));
        ((Container)serializable).add((Component)serializable2, "span, gaptop u");
        this.add((Component)serializable);
    }

    private void a(JCheckBox jCheckBox, Component component) {
        component.setEnabled(this.isEnabled() && jCheckBox.isSelected());
        jCheckBox.addChangeListener(new U(this, component, jCheckBox));
    }

    public static void main(String[] stringArray) {
        new ViewersSettingsPanel().test();
    }

    @Override
    public boolean preSave() {
        int n2 = this.prefToInt("Heuristic Cache TTL", this.fCacheTTL.getText());
        if (n2 < 0) {
            throw new SettingsException("Heuristic Cache TTL", "Please enter a non-negative number.");
        }
        return super.preSave();
    }

    @Override
    public boolean save() {
        AbstractConfiguration abstractConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        ((UserInterfaceConfiguration)abstractConfiguration).setShowLineNumbers(this.bShowLineNumbers.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setLineWrap(this.bLineWrap.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setSessionNavStructureLayout(this.rSessionNavStructureHorizontal.isSelected() ? 0 : 1);
        ((UserInterfaceConfiguration)abstractConfiguration).setSessionNavSequenceLayout(this.rSessionNavSequenceHorizontal.isSelected() ? 0 : 1);
        ((UserInterfaceConfiguration)abstractConfiguration).setCombineHeadersAndBody(this.bCombineHeadersAndBodyViewers.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setCombineRequestAndResponse(this.bCombineRequestAndResponse.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setUnitsSpeed(this.cSpeed.getSelectedIndex());
        ((UserInterfaceConfiguration)abstractConfiguration).setUnitsTime(this.cTime.getSelectedIndex());
        abstractConfiguration = this.ctx.getConfiguration().getProtobufConfiguration();
        ((ProtobufConfiguration)abstractConfiguration).setHideUnvaluedFields(this.bHideProtobufUnvaluedFields.isSelected());
        ((ProtobufConfiguration)abstractConfiguration).setHeuristicTTL((long)this.prefToIntSafe(this.fCacheTTL.getText()) * 1000L);
        ((ProtobufConfiguration)abstractConfiguration).setCacheDescriptors(this.bCacheProtobufDescriptors.isSelected());
        return true;
    }
}

