/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.summary;

import com.xk72.charles.gui.lib.B;
import com.xk72.charles.gui.lib.C;
import com.xk72.charles.gui.lib.af;
import com.xk72.charles.model.ModelEvent;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.Transaction;
import com.xk72.charles.model.e;
import com.xk72.charles.model.s;
import com.xk72.charles.validator.d;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SummaryTableModel
extends AbstractTableModel
implements B,
af,
e {
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private ModelNode[] source;
    private int size;
    private int totalHeaderBytes;
    private int totalBodyBytes;
    private long totalTimes;
    private long duration;
    private static final String[] a = new String[]{"#", "Resource", "Host", "Code", "Mime Type", "Header", "Body", "Time"};
    private static final Class<?>[] b = new Class[]{Integer.class, Transaction.class, String.class, Integer.class, String.class, String.class, String.class, String.class};
    private final C formatter = new C();

    public void view(ModelNode[] object) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                ModelNode modelNode = this.transactions.get(i2);
                modelNode.removeModelListener(this);
            }
            this.source = object;
            this.transactions.clear();
            s s2 = new s(this.transactions);
            s2.b((ModelNode[])object);
            if (((ModelNode[])object).length == 1 && object[0] instanceof Transaction) {
                s2.a((Transaction)object[0]);
                for (int i3 = 1; i3 < this.transactions.size(); ++i3) {
                    this.transactions.get(i3).addModelListener(this);
                }
            }
            this.size = this.transactions.size();
            this.totalHeaderBytes = 0;
            this.totalBodyBytes = 0;
            this.totalTimes = 0L;
            Date date = null;
            object = null;
            for (int i4 = 0; i4 < this.size; ++i4) {
                Transaction transaction = this.transactions.get(i4);
                this.totalHeaderBytes += transaction.getResponseHeaderSize();
                this.totalBodyBytes = (int)((long)this.totalBodyBytes + transaction.getResponseSize());
                if (transaction.getStartTime() != null && (date == null || transaction.getStartTime().before(date))) {
                    date = transaction.getStartTime();
                }
                if (transaction.getEndTime() != null && (object == null || transaction.getEndTime().after((Date)object))) {
                    object = transaction.getEndTime();
                }
                if (transaction.getEndTime() == null || transaction.getStartTime() == null) continue;
                this.totalTimes += transaction.getEndTime().getTime() - transaction.getStartTime().getTime();
            }
            this.duration = date != null && object != null ? object.getTime() - date.getTime() : 0L;
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        this.source = null;
        List<Transaction> list = this.transactions;
        synchronized (list) {
            this.transactions.clear();
        }
        this.size = 0;
        this.totalTimes = 0L;
        this.totalHeaderBytes = 0;
        this.totalBodyBytes = 0;
        this.duration = 0L;
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return b[n2];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int n2, int n3) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            void var2_2;
            if (n2 < this.size) {
                Transaction transaction = this.transactions.get(n2);
                switch (var2_2) {
                    case 0: {
                        return new Integer(n2 + 1);
                    }
                    case 1: {
                        return transaction;
                    }
                    case 2: {
                        if (transaction.getPort() == -1) return transaction.getHost();
                        return transaction.getHost() + ":" + transaction.getPort();
                    }
                    case 3: {
                        return new Integer(transaction.getResponseStatus());
                    }
                    case 4: {
                        if (transaction.getResponseHeader() == null) return null;
                        return com.xk72.charles.lib.d.b(transaction.getResponseHeader());
                    }
                    case 5: {
                        if (transaction.getResponseHeader() == null) return null;
                        return this.formatter.b(transaction.getResponseHeaderSize());
                    }
                    case 6: {
                        if (!transaction.hasResponseBody()) return null;
                        return this.formatter.b(transaction.getResponseSize());
                    }
                    case 7: {
                        if (transaction.getEndTime() == null) return null;
                        if (transaction.getStartTime() == null) return null;
                        return C.d(transaction.getEndTime().getTime() - transaction.getStartTime().getTime());
                    }
                    case -1: {
                        return transaction;
                    }
                }
                return null;
            }
            if (n2 == this.size) {
                switch (var2_2) {
                    case 1: {
                        return "Total";
                    }
                    case 5: {
                        return this.formatter.b(this.totalHeaderBytes);
                    }
                    case 6: {
                        return this.formatter.b(this.totalBodyBytes);
                    }
                    case 7: {
                        return C.d(this.totalTimes);
                    }
                }
                return null;
            }
            if (n2 == this.size + 1) {
                switch (var2_2) {
                    case 1: {
                        return "Grand Total";
                    }
                    case 6: {
                        return this.formatter.b(this.totalHeaderBytes + this.totalBodyBytes);
                    }
                }
                return null;
            }
            if (n2 != this.size + 2) return null;
            switch (var2_2) {
                case 1: {
                    return "Duration";
                }
                case 7: {
                    return C.d(this.duration);
                }
            }
            return null;
        }
    }

    @Override
    public int getRowCount() {
        return this.size + this.getFooterRows();
    }

    @Override
    public int getColumnCount() {
        return a.length;
    }

    @Override
    public String getColumnName(int n2) {
        return a[n2];
    }

    @Override
    public int getFooterRows() {
        return 3;
    }

    @Override
    public Class<?> getComparableColumnClass(int n2) {
        switch (n2) {
            case 1: {
                return String.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: 
            case 7: {
                return Long.class;
            }
        }
        return this.getColumnClass(n2);
    }

    @Override
    public Object getComparableValueAt(int n2, int n3) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            if (n2 < this.size) {
                Transaction transaction = this.transactions.get(n2);
                switch (n3) {
                    case 1: {
                        return transaction.getFileName();
                    }
                    case 5: {
                        if (transaction.getResponseHeader() != null) {
                            return new Integer(transaction.getResponseHeaderSize());
                        }
                        return null;
                    }
                    case 6: {
                        if (transaction.hasResponseBody()) {
                            return new Long(transaction.getResponseSize());
                        }
                        return null;
                    }
                    case 7: {
                        return d.a(transaction, null);
                    }
                }
                return this.getValueAt(n2, n3);
            }
            return null;
        }
    }

    @Override
    public void modelChildAdded(ModelEvent modelEvent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modelChanged(ModelEvent modelEvent) {
        this.view(this.source);
    }

    @Override
    public void modelChildRemoved(ModelEvent modelEvent) {
        throw new UnsupportedOperationException();
    }
}

