/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.tools;

import com.xk72.charles.config.Configuration;
import com.xk72.charles.tools.CharlesToolFilter;
import com.xk72.charles.tools.lib.EnabledToolConfiguration;
import com.xk72.charles.tools.lib.SelectedHostsToolConfiguration;
import com.xk72.charles.tools.lib.SettingsPanelTool;

public abstract class AbstractFilterTool
extends SettingsPanelTool {
    protected CharlesToolFilter filter;

    public AbstractFilterTool(String string) {
        super(string);
    }

    public void activatePreferSelectedHosts() {
        if (this.isActive()) {
            return;
        }
        Configuration configuration = this.getConfiguration();
        if (configuration instanceof SelectedHostsToolConfiguration) {
            ((SelectedHostsToolConfiguration)configuration).setUseSelectedLocations(true);
        }
        this.activate(true);
    }

    @Override
    public boolean isSupportsActivate() {
        return true;
    }

    @Override
    public void activate(boolean bl) {
        EnabledToolConfiguration enabledToolConfiguration = (EnabledToolConfiguration)this.getConfiguration();
        if (enabledToolConfiguration.isToolEnabled() != bl) {
            enabledToolConfiguration.setToolEnabled(bl);
            this.update();
            this.ctx.saveConfig();
        }
    }

    protected boolean isActiveConfiguration(EnabledToolConfiguration enabledToolConfiguration) {
        return enabledToolConfiguration.isToolEnabled();
    }

    @Override
    public void update() {
        EnabledToolConfiguration enabledToolConfiguration = (EnabledToolConfiguration)this.getConfiguration();
        if (this.isActiveConfiguration(enabledToolConfiguration)) {
            if (!this.isActive()) {
                this.filter = this.newFilter();
                this.ctx.getProxyManager().a(this.filter);
                this.fireToolActivated();
            }
            this.filter.update(enabledToolConfiguration);
            return;
        }
        if (this.isActive()) {
            this.ctx.getProxyManager().b(this.filter);
            this.filter = null;
            this.fireToolDeactivated();
        }
    }

    @Override
    public boolean isActive() {
        return this.filter != null;
    }

    protected abstract CharlesToolFilter newFilter();
}

