/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy;

import com.xk72.net.Location;
import com.xk72.proxy.Fields;
import com.xk72.proxy.n;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProxyEvent
extends EventObject
implements Cloneable {
    public static final int STATUS_BEFORE = 0;
    public static final int STATUS_RECEIVED_REQUEST_FIRST_LINE = 5;
    public static final int STATUS_RECEIVED_REQUEST_URL = 10;
    public static final int STATUS_RECEIVED_REQUEST_HEADER = 20;
    public static final int STATUS_RESOLVING = 23;
    public static final int STATUS_CONNECTING = 24;
    public static final int STATUS_CONNECTED = 25;
    public static final int STATUS_RECEIVING_REQUEST_BODY = 30;
    public static final int STATUS_RECEIVED_REQUEST_BODY = 40;
    public static final int STATUS_RECEIVED_RESPONSE_HEADER = 50;
    public static final int STATUS_RECEIVING_RESPONSE_BODY = 60;
    public static final int STATUS_RECEIVED_RESPONSE_BODY = 70;
    public static final int STATUS_COMPLETE = 80;
    public static final int STATUS_EXCEPTION = 90;
    private Date startTime;
    private Date endTime;
    private Date requestBeginTime;
    private Date requestCompleteTime;
    private Date responseBeginTime;
    private Long dnsDuration;
    private Long connectDuration;
    private Long sslDuration;
    private boolean keptAlive;
    private Fields requestHeader;
    private long requestSize;
    private int requestHeaderSize;
    private Fields responseHeader;
    private int responseHeaderSize;
    private long responseSize;
    private String host;
    private int port;
    private String path;
    private String file;
    private String query;
    private String method;
    private String protocol;
    private Exception exception;
    private InetAddress clientAddress;
    private InetAddress clientLocalAddress;
    private int clientPort;
    private int clientLocalPort;
    private int remotePort;
    private int remoteLocalPort;
    private String protocolVersion;
    private InetAddress remoteAddress;
    private int defaultPort = -1;
    private byte[] receivingBuffer;
    private int receivingBufferLength;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private int status;
    private boolean requestBodyDecoded;
    private boolean responseBodyDecoded;
    private boolean wantResponseBodyDecoded;
    private boolean bufferResponseBody;
    private boolean bufferRequestBody;
    public static final String NOTES_ATTRIBUTE = "com.xk72.charles.NOTES";

    public ProxyEvent(n n2) {
        super(n2);
    }

    public void initWithClientSocket(Socket socket) {
        this.setClientAddress(socket.getInetAddress());
        this.setClientPort(socket.getPort());
        this.setClientLocalAddress(socket.getLocalAddress());
        this.setClientLocalPort(socket.getLocalPort());
    }

    public void initWithTransaction(ProxyEvent proxyEvent) {
        this.setClientAddress(proxyEvent.getClientAddress());
        this.setClientPort(proxyEvent.getClientPort());
        this.setClientLocalAddress(proxyEvent.getClientLocalAddress());
        this.setClientLocalPort(proxyEvent.getClientLocalPort());
        this.setDefaultPort(proxyEvent.getDefaultPort());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.method != null) {
            stringBuffer.append(this.method);
            stringBuffer.append(" ");
        }
        if (this.protocol != null) {
            stringBuffer.append(this.protocol);
            stringBuffer.append("://");
        }
        stringBuffer.append(this.host);
        if (this.port != -1) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        if (this.file != null) {
            stringBuffer.append(this.file);
        }
        return stringBuffer.toString();
    }

    public URL toURL() {
        return new URL(this.protocol, this.host, this.port, this.file != null ? this.file : "");
    }

    public Location toLocation() {
        return new Location(this.protocol, this.host, this.getPortOrDefault(), this.path, this.query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("ProxyTransactionEvent could not clone itself: " + cloneNotSupportedException);
        }
    }

    public int getPortOrDefault() {
        int n2 = this.getPort();
        if (n2 != -1) {
            return n2;
        }
        return this.getDefaultPort();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public void setTransactionEndIfUnset(Date date) {
        if (this.endTime == null) {
            this.endTime = date;
        }
    }

    public Date getRequestBeginTime() {
        return this.requestBeginTime;
    }

    public void setRequestBeginTime(Date date) {
        this.requestBeginTime = date;
    }

    public Date getRequestCompleteTime() {
        return this.requestCompleteTime;
    }

    public void setRequestCompleteTime(Date date) {
        this.requestCompleteTime = date;
    }

    public Date getResponseBeginTime() {
        return this.responseBeginTime;
    }

    public void setResponseBeginTime(Date date) {
        this.responseBeginTime = date;
    }

    public Fields getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(Fields fields) {
        this.requestHeader = fields;
    }

    public Fields getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(Fields fields) {
        this.responseHeader = fields;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
        this.a();
    }

    private void a() {
        if (this.path != null) {
            if (this.query != null) {
                this.file = this.path + "?" + this.query;
                return;
            }
            this.file = this.path;
            return;
        }
        if (this.query != null) {
            this.file = "?" + this.query;
            return;
        }
        this.file = null;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        if (string != null) {
            int n2 = string.indexOf(63);
            if (n2 != -1) {
                this.path = string.substring(0, n2);
                this.query = string.substring(n2 + 1);
            } else {
                this.path = string;
                this.query = null;
            }
        } else {
            this.path = null;
            this.query = null;
        }
        this.a();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
        this.a();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress inetAddress) {
        this.clientAddress = inetAddress;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String string) {
        this.protocolVersion = string;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetAddress inetAddress) {
        this.remoteAddress = inetAddress;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int n2) {
        this.defaultPort = n2;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public void setRequestSize(long l2) {
        this.requestSize = l2;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(long l2) {
        this.responseSize = l2;
    }

    public byte[] getReceivingBuffer() {
        return this.receivingBuffer;
    }

    public void setReceivingBuffer(byte[] byArray) {
        this.receivingBuffer = byArray;
    }

    public int getReceivingBufferLength() {
        return this.receivingBufferLength;
    }

    public void setReceivingBufferLength(int n2) {
        this.receivingBufferLength = n2;
    }

    public Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    public void setAttribute(Object object, Object object2) {
        this.attributes.put(object, object2);
    }

    public void removeAttribute(Object object) {
        this.attributes.remove(object);
    }

    public List<?> getListAttribute(Object object) {
        if ((object = this.getAttribute(object)) != null) {
            if (object instanceof List) {
                return (List)object;
            }
            return Collections.singletonList(object);
        }
        return null;
    }

    public void addToListAttribute(Object object, Object object2) {
        Object object3 = this.getAttribute(object);
        if (object3 != null) {
            if (object3 instanceof List) {
                ((List)object3).add(object2);
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object3);
            arrayList.add(object2);
            this.setAttribute(object, arrayList);
            return;
        }
        this.setAttribute(object, object2);
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(int n2) {
        this.responseHeaderSize = n2;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public void setRequestHeaderSize(int n2) {
        this.requestHeaderSize = n2;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n2) {
        this.status = n2;
    }

    public boolean isRequestBodyDecoded() {
        return this.requestBodyDecoded;
    }

    public void setRequestBodyDecoded(boolean bl) {
        this.requestBodyDecoded = bl;
    }

    public boolean isResponseBodyDecoded() {
        return this.responseBodyDecoded;
    }

    public void setResponseBodyDecoded(boolean bl) {
        this.responseBodyDecoded = bl;
    }

    public boolean isWantResponseBodyDecoded() {
        return this.wantResponseBodyDecoded;
    }

    public void setWantResponseBodyDecoded() {
        this.wantResponseBodyDecoded = true;
    }

    public boolean isBufferResponseBody() {
        return this.bufferResponseBody;
    }

    public void setBufferResponseBody() {
        this.bufferResponseBody = true;
    }

    public boolean isBufferRequestBody() {
        return this.bufferRequestBody;
    }

    public void setBufferRequestBody() {
        this.bufferRequestBody = true;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int n2) {
        this.clientPort = n2;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int n2) {
        this.remotePort = n2;
    }

    public InetAddress getClientLocalAddress() {
        return this.clientLocalAddress;
    }

    public void setClientLocalAddress(InetAddress inetAddress) {
        this.clientLocalAddress = inetAddress;
    }

    public int getClientLocalPort() {
        return this.clientLocalPort;
    }

    public void setClientLocalPort(int n2) {
        this.clientLocalPort = n2;
    }

    public int getRemoteLocalPort() {
        return this.remoteLocalPort;
    }

    public void setRemoteLocalPort(int n2) {
        this.remoteLocalPort = n2;
    }

    public Long getDnsDuration() {
        return this.dnsDuration;
    }

    public void setDnsDuration(Long l2) {
        this.dnsDuration = l2;
    }

    public Long getConnectDuration() {
        return this.connectDuration;
    }

    public void setConnectDuration(Long l2) {
        this.connectDuration = l2;
    }

    public Long getSslDuration() {
        return this.sslDuration;
    }

    public void setSslDuration(Long l2) {
        this.sslDuration = l2;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean bl) {
        this.keptAlive = bl;
    }
}

