/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.VP8StatusCode;
import com.luciad.imageio.webp.WebPReadParam;
import com.luciad.imageio.webp.WebPWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Hashtable;

final class WebP {
    private static boolean NATIVE_LIBRARY_LOADED = false;

    static synchronized void loadNativeLibrary() {
        if (!NATIVE_LIBRARY_LOADED) {
            NATIVE_LIBRARY_LOADED = true;
            System.loadLibrary("webp-imageio");
        }
    }

    private WebP() {
    }

    public static BufferedImage decode(WebPReadParam webPReadParam, byte[] byArray, int n, int n2) throws IOException {
        if (webPReadParam == null) {
            throw new NullPointerException("Decoder options may not be null");
        }
        if (byArray == null) {
            throw new NullPointerException("Input data may not be null");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Offset/length exceeds array size");
        }
        int[] nArray = new int[4];
        int[] nArray2 = WebP.decode(webPReadParam.fPointer, byArray, n, n2, nArray, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        VP8StatusCode vP8StatusCode = VP8StatusCode.getStatusCode(nArray[0]);
        switch (vP8StatusCode) {
            case VP8_STATUS_OK: {
                break;
            }
            case VP8_STATUS_OUT_OF_MEMORY: {
                throw new OutOfMemoryError();
            }
            default: {
                throw new IOException("Decode returned code " + (Object)((Object)vP8StatusCode));
            }
        }
        int n3 = nArray[1];
        int n4 = nArray[2];
        boolean bl = nArray[3] != 0;
        DirectColorModel directColorModel = bl ? new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216) : new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        SampleModel sampleModel = ((ColorModel)directColorModel).createCompatibleSampleModel(n3, n4);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray2, n3 * n4);
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleModel, dataBufferInt, null);
        return new BufferedImage(directColorModel, writableRaster, false, new Hashtable());
    }

    private static native int[] decode(long var0, byte[] var2, int var3, int var4, int[] var5, boolean var6);

    public static int[] getInfo(byte[] byArray, int n, int n2) throws IOException {
        int[] nArray = new int[2];
        int n3 = WebP.getInfo(byArray, n, n2, nArray);
        if (n3 == 0) {
            throw new IOException("Invalid WebP data");
        }
        return nArray;
    }

    private static native int getInfo(byte[] var0, int var1, int var2, int[] var3);

    public static byte[] encode(WebPWriteParam webPWriteParam, RenderedImage renderedImage) throws IOException {
        if (webPWriteParam == null) {
            throw new NullPointerException("Encoder options may not be null");
        }
        if (renderedImage == null) {
            throw new NullPointerException("Image may not be null");
        }
        boolean bl = WebP.hasTranslucency(renderedImage);
        if (bl) {
            byte[] byArray = WebP.getRGBA(renderedImage);
            return WebP.encodeRGBA(webPWriteParam.getPointer(), byArray, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getWidth() * 4);
        }
        byte[] byArray = WebP.getRGB(renderedImage);
        return WebP.encodeRGB(webPWriteParam.getPointer(), byArray, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getWidth() * 3);
    }

    private static native byte[] encodeRGBA(long var0, byte[] var2, int var3, int var4, int var5);

    private static native byte[] encodeRGB(long var0, byte[] var2, int var3, int var4, int var5);

    private static boolean hasTranslucency(RenderedImage renderedImage) {
        return renderedImage.getColorModel().hasAlpha();
    }

    private static int getShift(int n) {
        int n2 = 0;
        while ((n >> n2 & 1) == 0) {
            ++n2;
        }
        return n2;
    }

    private static byte[] getRGB(RenderedImage renderedImage) throws IOException {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
            int n3 = componentSampleModel.getTransferType();
            if (n3 == 0) {
                return WebP.extractComponentRGBByte(n, n2, componentSampleModel, (DataBufferByte)renderedImage.getData().getDataBuffer());
            }
            if (n3 == 3) {
                return WebP.extractComponentRGBInt(n, n2, componentSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        if (colorModel instanceof DirectColorModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)renderedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getTransferType();
            if (n4 == 3) {
                return WebP.extractDirectRGBInt(n, n2, (DirectColorModel)colorModel, singlePixelPackedSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        return WebP.extractGenericRGB(renderedImage, n, n2, colorModel);
    }

    private static byte[] extractGenericRGB(RenderedImage renderedImage, int n, int n2, ColorModel colorModel) {
        Object object = null;
        byte[] byArray = new byte[n * n2 * 3];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                object = renderedImage.getData().getDataElements(n4, i, object);
                byArray[n3] = (byte)colorModel.getRed(object);
                byArray[n3 + 1] = (byte)colorModel.getGreen(object);
                byArray[n3 + 2] = (byte)colorModel.getBlue(object);
                ++n4;
                n3 += 3;
            }
        }
        return byArray;
    }

    private static byte[] extractDirectRGBInt(int n, int n2, DirectColorModel directColorModel, SinglePixelPackedSampleModel singlePixelPackedSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 3];
        int n3 = directColorModel.getRedMask();
        int n4 = directColorModel.getGreenMask();
        int n5 = directColorModel.getBlueMask();
        int n6 = WebP.getShift(n3);
        int n7 = WebP.getShift(n4);
        int n8 = WebP.getShift(n5);
        int[] nArray = dataBufferInt.getBankData()[0];
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < n2; ++i) {
            int n12 = n10;
            int n13 = 0;
            while (n13 < n) {
                int n14 = nArray[n12++];
                byArray[n11] = (byte)((n14 & n3) >>> n6);
                byArray[n11 + 1] = (byte)((n14 & n4) >>> n7);
                byArray[n11 + 2] = (byte)((n14 & n5) >>> n8);
                ++n13;
                n11 += 3;
            }
            n10 += n9;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBInt(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 3];
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = dataBufferInt.getBankData()[nArray[0]];
        int[] nArray3 = dataBufferInt.getBankData()[nArray[1]];
        int[] nArray4 = dataBufferInt.getBankData()[nArray[2]];
        int[] nArray5 = componentSampleModel.getBandOffsets();
        int n3 = nArray5[0];
        int n4 = nArray5[1];
        int n5 = nArray5[2];
        int n6 = componentSampleModel.getPixelStride();
        int n7 = componentSampleModel.getScanlineStride();
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            int n9 = n3;
            int n10 = n4;
            int n11 = n5;
            int n12 = 0;
            while (n12 < n) {
                byArray[n8] = (byte)nArray2[n9];
                n9 += n6;
                byArray[n8 + 1] = (byte)nArray3[n10];
                n10 += n6;
                byArray[n8 + 2] = (byte)nArray4[n11];
                n11 += n6;
                ++n12;
                n8 += 3;
            }
            n3 += n7;
            n4 += n7;
            n5 += n7;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBByte(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferByte dataBufferByte) {
        byte[] byArray = new byte[n * n2 * 3];
        int[] nArray = componentSampleModel.getBankIndices();
        byte[] byArray2 = dataBufferByte.getBankData()[nArray[0]];
        byte[] byArray3 = dataBufferByte.getBankData()[nArray[1]];
        byte[] byArray4 = dataBufferByte.getBankData()[nArray[2]];
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = componentSampleModel.getPixelStride();
        int n7 = componentSampleModel.getScanlineStride();
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            int n9 = n3;
            int n10 = n4;
            int n11 = n5;
            int n12 = 0;
            while (n12 < n) {
                byArray[n8] = byArray2[n9];
                n9 += n6;
                byArray[n8 + 1] = byArray3[n10];
                n10 += n6;
                byArray[n8 + 2] = byArray4[n11];
                n11 += n6;
                ++n12;
                n8 += 3;
            }
            n3 += n7;
            n4 += n7;
            n5 += n7;
        }
        return byArray;
    }

    private static byte[] getRGBA(RenderedImage renderedImage) throws IOException {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
            int n3 = componentSampleModel.getTransferType();
            if (n3 == 0) {
                return WebP.extractComponentRGBAByte(n, n2, componentSampleModel, (DataBufferByte)renderedImage.getData().getDataBuffer());
            }
            if (n3 == 3) {
                return WebP.extractComponentRGBAInt(n, n2, componentSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        if (colorModel instanceof DirectColorModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)renderedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getTransferType();
            if (n4 == 3) {
                return WebP.extractDirectRGBAInt(n, n2, (DirectColorModel)colorModel, singlePixelPackedSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        return WebP.extractGenericRGBA(renderedImage, n, n2, colorModel);
    }

    private static byte[] extractGenericRGBA(RenderedImage renderedImage, int n, int n2, ColorModel colorModel) {
        Object object = null;
        byte[] byArray = new byte[n * n2 * 4];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                object = renderedImage.getData().getDataElements(n4, i, object);
                byArray[n3] = (byte)colorModel.getRed(object);
                byArray[n3 + 1] = (byte)colorModel.getGreen(object);
                byArray[n3 + 2] = (byte)colorModel.getBlue(object);
                byArray[n3 + 3] = (byte)colorModel.getAlpha(object);
                ++n4;
                n3 += 4;
            }
        }
        return byArray;
    }

    private static byte[] extractDirectRGBAInt(int n, int n2, DirectColorModel directColorModel, SinglePixelPackedSampleModel singlePixelPackedSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 4];
        int n3 = directColorModel.getRedMask();
        int n4 = directColorModel.getGreenMask();
        int n5 = directColorModel.getBlueMask();
        int n6 = directColorModel.getAlphaMask();
        int n7 = WebP.getShift(n3);
        int n8 = WebP.getShift(n4);
        int n9 = WebP.getShift(n5);
        int n10 = WebP.getShift(n6);
        int[] nArray = dataBufferInt.getBankData()[0];
        int n11 = singlePixelPackedSampleModel.getScanlineStride();
        int n12 = 0;
        int n13 = 0;
        for (int i = 0; i < n2; ++i) {
            int n14 = n12;
            int n15 = 0;
            while (n15 < n) {
                int n16 = nArray[n14++];
                byArray[n13] = (byte)((n16 & n3) >>> n7);
                byArray[n13 + 1] = (byte)((n16 & n4) >>> n8);
                byArray[n13 + 2] = (byte)((n16 & n5) >>> n9);
                byArray[n13 + 3] = (byte)((n16 & n6) >>> n10);
                ++n15;
                n13 += 4;
            }
            n12 += n11;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBAInt(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 4];
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = dataBufferInt.getBankData()[nArray[0]];
        int[] nArray3 = dataBufferInt.getBankData()[nArray[1]];
        int[] nArray4 = dataBufferInt.getBankData()[nArray[2]];
        int[] nArray5 = dataBufferInt.getBankData()[nArray[3]];
        int[] nArray6 = componentSampleModel.getBandOffsets();
        int n3 = nArray6[0];
        int n4 = nArray6[1];
        int n5 = nArray6[2];
        int n6 = nArray6[3];
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        int n9 = 0;
        for (int i = 0; i < n2; ++i) {
            int n10 = n3;
            int n11 = n4;
            int n12 = n5;
            int n13 = n6;
            int n14 = 0;
            while (n14 < n) {
                byArray[n9] = (byte)nArray2[n10];
                n10 += n7;
                byArray[n9 + 1] = (byte)nArray3[n11];
                n11 += n7;
                byArray[n9 + 2] = (byte)nArray4[n12];
                n12 += n7;
                byArray[n9 + 3] = (byte)nArray5[n13];
                n13 += n7;
                ++n14;
                n9 += 4;
            }
            n3 += n8;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBAByte(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferByte dataBufferByte) {
        byte[] byArray = new byte[n * n2 * 4];
        int[] nArray = componentSampleModel.getBankIndices();
        byte[] byArray2 = dataBufferByte.getBankData()[nArray[0]];
        byte[] byArray3 = dataBufferByte.getBankData()[nArray[1]];
        byte[] byArray4 = dataBufferByte.getBankData()[nArray[2]];
        byte[] byArray5 = dataBufferByte.getBankData()[nArray[3]];
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        int n9 = 0;
        for (int i = 0; i < n2; ++i) {
            int n10 = n3;
            int n11 = n4;
            int n12 = n5;
            int n13 = n6;
            int n14 = 0;
            while (n14 < n) {
                byArray[n9] = byArray2[n10];
                n10 += n7;
                byArray[n9 + 1] = byArray3[n11];
                n11 += n7;
                byArray[n9 + 2] = byArray4[n12];
                n12 += n7;
                byArray[n9 + 3] = byArray5[n13];
                n13 += n7;
                ++n14;
                n9 += 4;
            }
            n3 += n8;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        return byArray;
    }

    static {
        WebP.loadNativeLibrary();
    }
}

