/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    private String description = null;
    private List<String> extensions = new ArrayList<String>();

    public DefaultFileFilter(String extensions, String description) {
        this.setExtensions(extensions);
        this.description = description;
    }

    public void addExtension(String extension) {
        this.extensions.add(extension);
    }

    public void setExtensions(String extensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensions, " \t\n\r\f;,.:");
        while (tokenizer.hasMoreTokens()) {
            this.extensions.add(tokenizer.nextToken());
        }
    }

    @Override
    public boolean accept(File file) {
        boolean result = false;
        if (file != null) {
            if (file.isFile()) {
                String ext = this.getExtension(file);
                if (ext != null && this.isSupportedExtension(ext)) {
                    result = true;
                }
            } else if (file.isDirectory()) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer(this.description);
        if (this.extensions.size() > 0) {
            result.append(" (");
            for (int i = 0; i < this.extensions.size(); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append("*.");
                result.append(this.extensions.get(i));
            }
            result.append(")");
        }
        return result.toString();
    }

    private boolean isSupportedExtension(String extension) {
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!this.extensions.get(i).equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    private String getExtension(File file) {
        String filename;
        int i;
        if (file != null && (i = (filename = file.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

