/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class DocumentInputReader
extends Reader {
    private static final int BUFFERLEN = 10240;
    private final char[] buffer = new char[10240];
    private DocumentInputStream stream = null;
    public long pos = 0L;
    private long chpos = 0x100000000L;
    private int pushBack = -1;
    private int lastChar = -1;
    private int currentIndex = 0;
    private int numChars = 0;

    public DocumentInputReader(Document document) {
        this.stream = new DocumentInputStream(document);
    }

    public void setRange(int start, int end) throws IOException {
        this.stream.setRange(start, end);
        this.pos = 0L;
        this.chpos = 0x100000000L;
        this.pushBack = -1;
        this.lastChar = -1;
        this.currentIndex = 0;
        this.numChars = 0;
    }

    @Override
    public int read() throws IOException {
        this.lastChar = this.readInternal();
        return this.lastChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    /*
     * Unable to fully structure code
     */
    private int readInternal() throws IOException {
        block9: {
            block8: {
                this.pos = this.chpos++;
                i = this.pushBack;
                if (i != -1) break block8;
                if (this.currentIndex < this.numChars) ** GOTO lbl10
                this.numChars = this.stream.read(this.buffer);
                if (this.numChars == -1) {
                    i = -1;
                } else {
                    this.currentIndex = 0;
lbl10:
                    // 2 sources

                    i = this.buffer[this.currentIndex++];
                }
                break block9;
            }
            this.pushBack = -1;
        }
        switch (i) {
            case 10: {
                this.chpos += 0x100000000L;
                return 10;
            }
            case 13: {
                i = this.getNextChar();
                if (i != 10) {
                    this.pushBack = i;
                } else {
                    ++this.chpos;
                }
                this.chpos += 0x100000000L;
                return 10;
            }
        }
        return i;
    }

    private int getNextChar() throws IOException {
        if (this.currentIndex >= this.numChars) {
            this.numChars = this.stream.read(this.buffer);
            if (this.numChars == -1) {
                return -1;
            }
            this.currentIndex = 0;
        }
        return this.buffer[this.currentIndex++];
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] ac, int i, int j) throws IOException {
        return 0;
    }

    private static class DocumentInputStream
    extends InputStream {
        private Segment segment = new Segment();
        private Document document = null;
        private int end = 0;
        private int pos = 0;
        private int index = 0;

        public DocumentInputStream(Document doc) {
            this.document = doc;
            this.end = this.document.getLength();
            this.pos = 0;
            try {
                this.loadSegment();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void setRange(int start, int end) throws IOException {
            this.end = end;
            this.pos = start;
            this.loadSegment();
        }

        @Override
        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.end) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        public int read(char[] chars) throws IOException {
            return this.read(chars, 0, chars.length);
        }

        public int read(char[] chars, int i, int j) throws IOException {
            int i1;
            if (chars == null) {
                throw new NullPointerException();
            }
            if (i < 0 || j < 0 || j > chars.length - i) {
                throw new IndexOutOfBoundsException();
            }
            if (j == 0) {
                return 0;
            }
            int k = this.read();
            if (k == -1) {
                return -1;
            }
            chars[i] = (char)k;
            try {
                int l;
                for (i1 = 1; i1 < j && (l = this.read()) != -1; ++i1) {
                    chars[i + i1] = (char)l;
                }
            }
            catch (IOException ioexception) {
            }
            return i1;
        }

        private void loadSegment() throws IOException {
            try {
                int n = Math.min(1024, this.end - this.pos);
                this.document.getText(this.pos, n, this.segment);
                this.pos += n;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e) {
                throw new IOException("Bad location");
            }
        }
    }
}

