/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.bounce.text.SyntaxHighlightingScanner;

class XMLViewUtilities {
    XMLViewUtilities() {
    }

    public static void updateScanner(SyntaxHighlightingScanner scanner, Document doc, int start, int end) {
        try {
            if (!scanner.isValid()) {
                scanner.setRange(XMLViewUtilities.getTagEnd(doc, start), end);
                scanner.setValid(true);
            }
            while (scanner.getEndOffset() <= start && end > scanner.getEndOffset()) {
                scanner.scan();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static int getTagEnd(Document doc, int p) {
        int elementEnd = 0;
        if (p > 0) {
            try {
                int commentStart;
                String s = doc.getText(0, p);
                int cdataStart = s.lastIndexOf("<![CDATA[");
                int index = cdataStart > 0 && cdataStart > s.lastIndexOf("]]>") ? s.lastIndexOf(">", cdataStart) : ((commentStart = s.lastIndexOf("<!--")) > 0 && commentStart > s.lastIndexOf("-->") ? s.lastIndexOf(">", commentStart) : s.lastIndexOf(">"));
                if (index != -1) {
                    elementEnd = index;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return elementEnd;
    }
}

