/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.viewer.xml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import org.bounce.viewer.xml.DOMNodeCellRenderer;
import org.bounce.viewer.xml.Line;
import org.bounce.viewer.xml.StyledString;

public class DOMNodeCellRendererUI
extends MetalLabelUI {
    protected static DOMNodeCellRendererUI labelUI = new DOMNodeCellRendererUI();
    private static final Color SELECTION_BACKGROUND = new Color(204, 204, 204);
    private static final Color SELECTION_FOREGROUND = Color.black;

    public static ComponentUI createUI(JComponent c) {
        return labelUI;
    }

    protected void paintLine(JLabel l, Graphics g, Line line, int x, int y) {
        List<StyledString> strings = line.getStyledStrings();
        if (((DOMNodeCellRenderer)l).isSelected()) {
            g.setColor(SELECTION_BACKGROUND);
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(x, y - fm.getAscent(), fm.stringWidth(line.getText()) - 1, fm.getHeight());
        }
        for (StyledString string : strings) {
            if (((DOMNodeCellRenderer)l).isSelected()) {
                g.setColor(SELECTION_FOREGROUND);
            } else {
                g.setColor(string.getColor());
            }
            g.drawString(string.getText(), x, y);
            x += (int)g.getFontMetrics().getStringBounds(string.getText(), g).getWidth();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        DOMNodeCellRenderer renderer = (DOMNodeCellRenderer)c;
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getAscent();
        for (Line line : renderer.getLines()) {
            this.paintLine(renderer, g, line, 0, y);
            y += fm.getHeight();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        DOMNodeCellRenderer renderer = (DOMNodeCellRenderer)c;
        List<Line> lines = renderer.getLines();
        Graphics gc = renderer.getGraphics();
        int height = 0;
        int width = 0;
        if (gc != null) {
            FontMetrics fm = gc.getFontMetrics();
            if (lines.size() > 0) {
                for (Line line : lines) {
                    width = Math.max(width, fm.stringWidth(line.getText()));
                }
                height = fm.getHeight() * lines.size();
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

