/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.summary;

import com.xk72.charles.gui.lib.J;
import com.xk72.charles.gui.lib.ax;
import com.xk72.charles.gui.transaction.viewers.protobuf.b;
import com.xk72.charles.lib.d;
import com.xk72.charles.lib.g;
import com.xk72.charles.lib.j;
import com.xk72.charles.model.B;
import com.xk72.charles.model.ModelEvent;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.Transaction;
import com.xk72.charles.model.f;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SummaryTableModel
extends AbstractTableModel
implements J,
ax,
f {
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private ModelNode[] source;
    private int size;
    private int totalHeaderBytes;
    private int totalBodyBytes;
    private long totalTimes;
    private long duration;
    private static final String[] a = new String[]{"#", "Resource", "Host", "Code", "Mime Type", "Header", "Body", "Time"};
    private static final Class<?>[] b = new Class[]{Integer.class, Transaction.class, String.class, Integer.class, String.class, String.class, String.class, String.class};
    private final j formatter = new d();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void view(ModelNode[] object) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                ModelNode modelNode = this.transactions.get(i2);
                modelNode.removeModelListener(this);
            }
            this.source = object;
            this.transactions.clear();
            B b2 = new B(this.transactions);
            b2.b((ModelNode[])object);
            if (((ModelNode[])object).length == 1 && object[0] instanceof Transaction) {
                b2.a((Transaction)object[0]);
                for (int i3 = 1; i3 < this.transactions.size(); ++i3) {
                    this.transactions.get(i3).addModelListener(this);
                }
            }
            this.size = this.transactions.size();
            this.totalHeaderBytes = 0;
            this.totalBodyBytes = 0;
            this.totalTimes = 0L;
            Date date = null;
            object = null;
            for (int i4 = 0; i4 < this.size; ++i4) {
                Transaction transaction = this.transactions.get(i4);
                this.totalHeaderBytes += transaction.getResponseHeaderSize();
                this.totalBodyBytes = (int)((long)this.totalBodyBytes + transaction.getResponseSize());
                if (transaction.getStartTime() != null && (date == null || transaction.getStartTime().before(date))) {
                    date = transaction.getStartTime();
                }
                if (transaction.getEndTime() != null && (object == null || transaction.getEndTime().after((Date)object))) {
                    object = transaction.getEndTime();
                }
                if (transaction.getEndTime() == null || transaction.getStartTime() == null) continue;
                this.totalTimes += transaction.getEndTime().getTime() - transaction.getStartTime().getTime();
            }
            this.duration = date != null && object != null ? object.getTime() - date.getTime() : 0L;
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.source = null;
        List<Transaction> list = this.transactions;
        synchronized (list) {
            this.transactions.clear();
        }
        this.size = 0;
        this.totalTimes = 0L;
        this.totalHeaderBytes = 0;
        this.totalBodyBytes = 0;
        this.duration = 0L;
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return b[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n2, int n3) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            if (n2 < this.size) {
                Transaction transaction = this.transactions.get(n2);
                switch (n3) {
                    case 0: {
                        return new Integer(n2 + 1);
                    }
                    case 1: {
                        return transaction;
                    }
                    case 2: {
                        if (transaction.getPort() != -1) {
                            return transaction.getHost() + ":" + transaction.getPort();
                        }
                        return transaction.getHost();
                    }
                    case 3: {
                        return new Integer(transaction.getResponseStatus());
                    }
                    case 4: {
                        if (transaction.getResponseHeader() != null) {
                            return g.b(transaction.getResponseHeader());
                        }
                        return null;
                    }
                    case 5: {
                        if (transaction.getResponseHeader() != null) {
                            return this.formatter.c(transaction.getResponseHeaderSize());
                        }
                        return null;
                    }
                    case 6: {
                        if (transaction.hasResponseBody()) {
                            return this.formatter.c(transaction.getResponseSize());
                        }
                        return null;
                    }
                    case 7: {
                        if (transaction.getEndTime() != null && transaction.getStartTime() != null) {
                            return this.formatter.e(transaction.getEndTime().getTime() - transaction.getStartTime().getTime());
                        }
                        return null;
                    }
                    case -1: {
                        return transaction;
                    }
                }
                return null;
            }
            if (n2 == this.size) {
                switch (n3) {
                    case 1: {
                        return "Total";
                    }
                    case 5: {
                        return this.formatter.c(this.totalHeaderBytes);
                    }
                    case 6: {
                        return this.formatter.c(this.totalBodyBytes);
                    }
                    case 7: {
                        return this.formatter.e(this.totalTimes);
                    }
                }
                return null;
            }
            if (n2 == this.size + 1) {
                switch (n3) {
                    case 1: {
                        return "Grand Total";
                    }
                    case 6: {
                        return this.formatter.c(this.totalHeaderBytes + this.totalBodyBytes);
                    }
                }
                return null;
            }
            if (n2 == this.size + 2) {
                switch (n3) {
                    case 1: {
                        return "Duration";
                    }
                    case 7: {
                        return this.formatter.e(this.duration);
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.size + this.getFooterRows();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int n2) {
        return a[n2];
    }

    @Override
    public int getFooterRows() {
        return 3;
    }

    @Override
    public Class<?> getComparableColumnClass(int n2) {
        switch (n2) {
            case 1: {
                return String.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: 
            case 7: {
                return Long.class;
            }
        }
        return this.getColumnClass(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getComparableValueAt(int n2, int n3) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            if (n2 < this.size) {
                Transaction transaction = this.transactions.get(n2);
                switch (n3) {
                    case 1: {
                        return transaction.getFileName();
                    }
                    case 5: {
                        if (transaction.getResponseHeader() != null) {
                            return new Integer(transaction.getResponseHeaderSize());
                        }
                        return null;
                    }
                    case 6: {
                        if (transaction.hasResponseBody()) {
                            return new Long(transaction.getResponseSize());
                        }
                        return null;
                    }
                    case 7: {
                        return com.xk72.charles.gui.transaction.viewers.protobuf.b.a(transaction, null);
                    }
                }
                return this.getValueAt(n2, n3);
            }
        }
        return null;
    }

    @Override
    public void modelChildAdded(ModelEvent modelEvent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modelChanged(ModelEvent modelEvent) {
        this.view(this.source);
    }

    @Override
    public void modelChildRemoved(ModelEvent modelEvent) {
        throw new UnsupportedOperationException();
    }
}

