/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bounce.event.CardEvent;
import org.bounce.event.CardPanelListener;

public class CardPanel<C extends JComponent>
extends JPanel {
    private static final long serialVersionUID = 3258135768999737650L;
    private List<CardPanelListener<C>> listenerList = new ArrayList<CardPanelListener<C>>();
    private CardLayout layout = new CardLayout();
    private JPanel center = new JPanel(this.layout);
    private JScrollPane scroller = null;
    private C current = null;

    public CardPanel() {
        this(false);
    }

    protected CardPanel(boolean scrollable) {
        super(new BorderLayout());
        if (scrollable) {
            this.scroller = new JScrollPane(this.center, 20, 30);
            this.scroller.setPreferredSize(new Dimension(160, 100));
            this.add((Component)this.scroller, "Center");
        } else {
            this.add((Component)this.center, "Center");
        }
    }

    public void add(C card) {
        this.center.add((Component)card, CardPanel.toString(card));
        this.fireCardAdded(card);
    }

    public void show(C card) {
        this.current = card;
        this.layout.show(this.center, CardPanel.toString(card));
        this.fireCardChanged(card);
    }

    public void remove(C card) {
        this.center.remove((Component)card);
        this.fireCardRemoved(card);
    }

    public C selected() {
        return this.current;
    }

    public void addCardPanelListener(CardPanelListener<C> l) {
        this.listenerList.add(l);
    }

    public void removeCardPanelListener(CardPanelListener<C> l) {
        this.listenerList.remove(l);
    }

    protected void fireCardChanged(C card) {
        ArrayList<CardPanelListener<C>> listeners = new ArrayList<CardPanelListener<C>>(this.listenerList);
        CardEvent<C> e = new CardEvent<C>(this, card);
        for (CardPanelListener cardPanelListener : listeners) {
            cardPanelListener.cardChanged(e);
        }
    }

    protected void fireCardAdded(C card) {
        ArrayList<CardPanelListener<C>> listeners = new ArrayList<CardPanelListener<C>>(this.listenerList);
        CardEvent<C> e = new CardEvent<C>(this, card);
        for (CardPanelListener cardPanelListener : listeners) {
            cardPanelListener.cardAdded(e);
        }
    }

    protected void fireCardRemoved(C card) {
        ArrayList<CardPanelListener<C>> listeners = new ArrayList<CardPanelListener<C>>(this.listenerList);
        CardEvent<C> e = new CardEvent<C>(this, card);
        for (CardPanelListener cardPanelListener : listeners) {
            cardPanelListener.cardRemoved(e);
        }
    }

    private static final String toString(Object panel) {
        return panel.getClass().getName() + "@" + Integer.toHexString(panel.hashCode());
    }
}

