/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumberMargin
extends JComponent {
    private static final long serialVersionUID = 1421386204383391804L;
    private FontMetrics fontMetrics = null;
    private JTextComponent editor = null;
    private int lines = 0;

    public LineNumberMargin(JTextComponent editor) {
        this.editor = editor;
        this.setBackground(UIManager.getColor("control"));
        this.setForeground(UIManager.getColor("textText"));
        this.setFont(editor.getFont());
        editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                if (LineNumberMargin.this.getLines() != LineNumberMargin.this.lines) {
                    LineNumberMargin.this.revalidate();
                    LineNumberMargin.this.repaint();
                    LineNumberMargin.this.lines = LineNumberMargin.this.getLines();
                }
            }
        });
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 0, 1, UIManager.getColor("controlShadow")), new EmptyBorder(0, 1, 0, 1)));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineNumberMargin.this.mouseClicked(e);
            }
        });
    }

    protected void mouseClicked(MouseEvent event) {
        this.selectLineForOffset(event.getY());
        this.editor.requestFocusInWindow();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isVisible()) {
            return new Dimension(this.getInsets().left + this.getMarginwidth() + this.getInsets().right, this.editor.getPreferredSize().height);
        }
        return null;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isVisible()) {
            return new Dimension(this.getInsets().left + this.getMarginwidth() + this.getInsets().right, this.editor.getPreferredSize().height);
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isVisible()) {
            return new Dimension(this.getInsets().left + this.getMarginwidth() + this.getInsets().right, this.editor.getPreferredSize().height);
        }
        return null;
    }

    private int getMarginwidth() {
        int lines = this.getLines();
        int width = 0;
        if (this.fontMetrics != null) {
            width = lines >= 1000000 ? this.fontMetrics.stringWidth("9999999") : (lines >= 100000 ? this.fontMetrics.stringWidth("999999") : (lines >= 10000 ? this.fontMetrics.stringWidth("99999") : (lines >= 1000 ? this.fontMetrics.stringWidth("9999") : this.fontMetrics.stringWidth("999"))));
        }
        return width;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            this.fontMetrics = this.getFontMetrics(font);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.fontMetrics != null) {
            Rectangle bounds = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(this.getForeground());
            FontMetrics editorMetrics = this.getFontMetrics(this.editor.getFont());
            int startLine = this.getLineNumber(bounds.y);
            int endLine = this.getLineNumber(bounds.y + bounds.height);
            if (endLine < this.getLines()) {
                ++endLine;
            }
            for (int line = startLine; line < endLine; ++line) {
                String lineNumber = String.valueOf(line + 1);
                try {
                    int start = this.getLineStart(line);
                    if (start == -1) continue;
                    g.drawString(lineNumber, this.getInsets().left + (this.getMarginwidth() - this.fontMetrics.stringWidth(lineNumber)), start + (editorMetrics.getHeight() - editorMetrics.getMaxDescent()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private int getLines() {
        return this.editor.getDocument().getDefaultRootElement().getElementCount();
    }

    private int getLineStart(int i) throws BadLocationException {
        Element line = this.editor.getDocument().getDefaultRootElement().getElement(i);
        Rectangle result = this.editor.modelToView(line.getStartOffset());
        if (result != null) {
            return result.y;
        }
        return -1;
    }

    private int getLineNumber(int y) {
        int pos = this.editor.viewToModel(new Point(0, y));
        return this.editor.getDocument().getDefaultRootElement().getElementIndex(pos);
    }

    private void selectLineForOffset(int y) {
        Element root;
        Element elem;
        int pos = this.editor.viewToModel(new Point(0, y));
        if (pos >= 0 && (elem = (root = this.editor.getDocument().getDefaultRootElement()).getElement(root.getElementIndex(pos))) != null) {
            int start = elem.getStartOffset();
            int end = elem.getEndOffset();
            this.editor.select(start, Math.max(end - 1, 0));
        }
    }
}

