/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;

public class ScrollableEditorPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 3978147659863437620L;
    private JEditorPane editor = null;

    public ScrollableEditorPanel(JEditorPane editor) {
        super(new BorderLayout());
        this.editor = editor;
        this.add((Component)editor, "Center");
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.editor.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.editor.getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        View view = this.editor.getUI().getRootView(this.editor).getView(0);
        if (view instanceof WrappedPlainView) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

