/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class AnimationController {
    public static final int MINIMUM_DURATION = 100;
    public static final int MINIMUM_REPAINT_INTERVAL = 20;
    protected final Animation animation;
    protected final int desiredRepaintInterval;
    protected final int defaultDuration;
    private long startTime = 0L;
    private long endTime = 0L;
    private float duration;
    private Timer timer;

    public AnimationController(Animation animation, int defaultDuration) {
        this(animation, 20, defaultDuration);
    }

    public AnimationController(Animation animation, int repaintInterval, int defaultDuration) {
        this.animation = animation;
        this.desiredRepaintInterval = Math.max(20, repaintInterval);
        this.defaultDuration = Math.max(0, defaultDuration);
    }

    public void start() {
        this.start(this.defaultDuration);
    }

    public synchronized void start(int duration) {
        if (this.animation != null) {
            if (duration < 100) {
                this.animation.setAnimationState(1.0f);
            } else {
                this.animation.setAnimationState(0.0f);
                this.startTime = System.currentTimeMillis();
                this.endTime = this.startTime + (long)duration;
                this.duration = duration;
                if (this.timer == null) {
                    this.timer = new Timer(this.desiredRepaintInterval, new MyTimerAction());
                } else {
                    this.timer.stop();
                }
                this.timer.start();
            }
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.startTime = 0L;
        this.endTime = 0L;
        this.duration = 0.0f;
    }

    public synchronized boolean isRunning() {
        return this.startTime > 0L;
    }

    private synchronized void timerUpdate() {
        if (this.timer != null) {
            if (this.animation != null && this.startTime > 0L) {
                long time = System.currentTimeMillis();
                if (time >= this.endTime) {
                    this.animation.setAnimationState(1.0f);
                } else if (time >= this.startTime) {
                    float animationState = (float)(time - this.startTime) / this.duration;
                    this.animation.setAnimationState(animationState);
                    return;
                }
            }
            this.timer.stop();
        }
    }

    private class MyTimerAction
    implements ActionListener {
        private MyTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimationController.this.timerUpdate();
        }
    }

    public static interface Animation {
        public void setAnimationState(float var1);
    }
}

