/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import sun.awt.image.MultiResolutionCachedImage;
import sun.awt.image.MultiResolutionImage;

public class Aqua8MappedMultiResolutionImage
extends MultiResolutionCachedImage {
    private final Image baseImage;
    private final Image mappedBaseImage;
    private final Function<Image, Image> mapper;

    public Aqua8MappedMultiResolutionImage(MultiResolutionImage source, Function<Image, Image> mapper) {
        super(Aqua8MappedMultiResolutionImage.getImageWidth(source), Aqua8MappedMultiResolutionImage.getImageHeight(source), new MyVariantMapper(source, mapper));
        this.baseImage = (Image)source;
        this.mappedBaseImage = mapper.apply(this.baseImage);
        this.mapper = mapper;
    }

    private static int getImageWidth(MultiResolutionImage source) {
        int width = ((Image)source).getWidth(null);
        if (width < 0) {
            throw new IllegalStateException("Multiresolution image has unknown width");
        }
        return width;
    }

    private static int getImageHeight(MultiResolutionImage source) {
        int height = ((Image)source).getHeight(null);
        if (height < 0) {
            throw new IllegalStateException("Multiresolution image has unknown height");
        }
        return height;
    }

    @Override
    public List<Image> getResolutionVariants() {
        ArrayList<Image> result = new ArrayList<Image>();
        MultiResolutionImage source = (MultiResolutionImage)this.baseImage;
        for (Image sourceVariant : source.getResolutionVariants()) {
            Image mappedVariant = this.mapper.apply(sourceVariant);
            result.add(mappedVariant);
        }
        return result;
    }

    @Override
    public Aqua8MappedMultiResolutionImage map(Function<Image, Image> mapper) {
        return new Aqua8MappedMultiResolutionImage((MultiResolutionImage)this, mapper);
    }

    @Override
    protected Image getBaseImage() {
        return this.mappedBaseImage;
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.baseImage.getWidth(imageObserver);
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.baseImage.getHeight(imageObserver);
    }

    private static class MyVariantMapper
    implements BiFunction<Integer, Integer, Image> {
        private final MultiResolutionImage source;
        private final Function<Image, Image> mapper;

        public MyVariantMapper(MultiResolutionImage source, Function<Image, Image> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public Image apply(Integer width, Integer height) {
            Image sourceVariant = this.source.getResolutionVariant(width.intValue(), height.intValue());
            return this.mapper.apply(sourceVariant);
        }
    }
}

