/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.violetlib.aqua.Aqua8MappedMultiResolutionImage;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.Images;
import sun.awt.image.MultiResolutionCachedImage;
import sun.awt.image.MultiResolutionImage;

public class Aqua8MultiResolutionImage
extends AquaMultiResolutionImage
implements MultiResolutionImage {
    public Aqua8MultiResolutionImage(BufferedImage im) {
        super(im);
    }

    public Aqua8MultiResolutionImage(int width, int height, BufferedImage im) {
        super(im, width, height);
    }

    public Image getResolutionVariant(int width, int height) {
        return this.baseImage;
    }

    public List<Image> getResolutionVariants() {
        ArrayList<Image> result = new ArrayList<Image>();
        result.add(this.baseImage);
        return result;
    }

    @Override
    public AquaMultiResolutionImage map(AquaMultiResolutionImage.Mapper mapper) {
        return new Aqua8MultiResolutionImage(mapper.map(this.baseImage, 1));
    }

    @Override
    public AquaMultiResolutionImage map(Function<Image, Image> mapper) {
        return new Aqua8MultiResolutionImage(Images.toBufferedImage(mapper.apply(this.baseImage)));
    }

    public static Image apply(Image image, ImageFilter filter) {
        if (image instanceof MultiResolutionImage) {
            Function<Image, Image> f = rv -> Aqua8MultiResolutionImage.createFilteredImage(rv, filter);
            return Aqua8MultiResolutionImage.apply(image, f);
        }
        return Aqua8MultiResolutionImage.createFilteredImage(image, filter);
    }

    private static Image createFilteredImage(Image image, ImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Aqua8MultiResolutionImage.waitForImage(Toolkit.getDefaultToolkit().createImage(prod));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image waitForImage(Image image) {
        boolean[] mutex = new boolean[]{false};
        ImageObserver observer = (img, infoflags, x, y, width, height) -> {
            if (width != -1 && height != -1 && (infoflags & 0x20) != 0 || (infoflags & 0x80) != 0) {
                boolean[] blArray = mutex;
                synchronized (mutex) {
                    mutex[0] = true;
                    mutex.notify();
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return false;
                }
            }
            return true;
        };
        boolean[] blArray = mutex;
        synchronized (mutex) {
            while (!mutex[0] && image.getWidth(observer) == -1) {
                try {
                    mutex.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return image;
        }
    }

    public static Image apply(Image source, Function<Image, Image> mapper) {
        if (source instanceof MultiResolutionCachedImage) {
            MultiResolutionCachedImage s = (MultiResolutionCachedImage)source;
            return s.map(mapper::apply);
        }
        if (source instanceof AquaMultiResolutionImage) {
            AquaMultiResolutionImage s = (AquaMultiResolutionImage)source;
            return s.map(mapper);
        }
        if (source instanceof MultiResolutionImage) {
            MultiResolutionImage s = (MultiResolutionImage)source;
            return new Aqua8MappedMultiResolutionImage(s, mapper);
        }
        return mapper.apply(source);
    }

    public static Image apply(Image source, AquaMultiResolutionImage.Mapper mapper) {
        if (source instanceof MultiResolutionCachedImage) {
            MultiResolutionCachedImage s = (MultiResolutionCachedImage)source;
            int width = s.getWidth(null);
            return s.map((Image rv) -> mapper.map((Image)rv, rv.getWidth(null) / width));
        }
        if (source instanceof AquaMultiResolutionImage) {
            AquaMultiResolutionImage s = (AquaMultiResolutionImage)source;
            return s.map(mapper);
        }
        if (source instanceof MultiResolutionImage) {
            MultiResolutionImage im = (MultiResolutionImage)source;
            try {
                Method m = im.getClass().getMethod("map", Function.class);
                m.setAccessible(true);
                Object o = m.invoke((Object)im, mapper);
                if (o instanceof Image) {
                    return (Image)o;
                }
            }
            catch (NoSuchMethodException m) {
            }
            catch (Exception ex) {
                if (ex instanceof InvocationTargetException) {
                    Throwable th = ((InvocationTargetException)ex).getTargetException();
                    System.err.println("Unable to map image: " + th);
                }
                System.err.println("Unable to map image: " + ex);
            }
        }
        if (source instanceof MultiResolutionImage) {
            MultiResolutionImage s = (MultiResolutionImage)source;
            int width = source.getWidth(null);
            return new Aqua8MappedMultiResolutionImage(s, rv -> mapper.map((Image)rv, rv.getWidth(null) / width));
        }
        return mapper.map(source, 1);
    }
}

