/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BackgroundPainter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;

public class AquaBoxPainter
implements BackgroundPainter {
    private static final int topInset = 10;
    private static final int sideInset = 15;
    private static final int topBorderInset = 15;
    private static final int sideBorderInset = 23;
    private static final int titleIndent = 10;
    private static Border titledBorder = new BorderUIResource.EmptyBorderUIResource(26, 23, 15, 23);
    private static Border titlelessBorder = new BorderUIResource.EmptyBorderUIResource(15, 23, 15, 23);
    protected final AquaUIPainter painter = AquaPainting.create();
    private static final AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaBoxPainter> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaBoxPainter>(AquaBoxPainter.class);

    public static AquaBoxPainter getInstance() {
        return (AquaBoxPainter)instance.get();
    }

    public static Border getBorderForTitledBox() {
        return titledBorder;
    }

    public static Border getTitlelessBorder() {
        return titlelessBorder;
    }

    @Override
    public void paintBackground(JComponent c, Graphics g, int x, int y, int width, int height) {
        Insets s = c.getInsets();
        int boxLeft = Math.max(0, s.left - 15);
        int boxTop = Math.max(0, s.top - 10);
        int boxWidth = Math.max(0, width - boxLeft - Math.max(0, s.right - 15));
        int boxHeight = Math.max(0, height - boxTop - Math.max(0, s.bottom - 10));
        this.painter.configure(boxWidth, boxHeight);
        Configuration bg = this.getConfiguration();
        this.painter.getPainter(bg).paint(g, boxLeft, boxTop);
        Object o = c.getClientProperty("Aqua.groupBoxTitle");
        if (o instanceof String) {
            String title = (String)o;
            JLabel titleLabel = new JLabel(title);
            titleLabel.setFont(AquaFonts.getControlTextSmallFont());
            Dimension size = titleLabel.getPreferredSize();
            int labelW = size.width;
            int labelH = size.height;
            if (boxTop >= labelH) {
                int labelX = boxLeft + 10;
                int labelY = boxTop - labelH;
                g.translate(labelX, labelY);
                titleLabel.setSize(labelW, labelH);
                titleLabel.paint(g);
                g.translate(-labelX, -labelY);
            }
        }
    }

    protected Configuration getConfiguration() {
        return new GroupBoxConfiguration(AquaUIPainter.State.ACTIVE, false);
    }
}

