/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonIcon;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaDisclosureButtonBorder;
import org.violetlib.aqua.AquaDisclosureTriangleButtonBorder;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaIconToggleButtonBorder;
import org.violetlib.aqua.AquaPushButtonBorder;
import org.violetlib.aqua.AquaToggleButtonBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BackgroundPainter;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.fc.EmptyIcon;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;

public abstract class AquaButtonBorder
extends AquaBorder
implements BackgroundPainter,
FocusRingOutlineProvider {
    public static final AquaUtils.RecyclableSingleton<AquaPushButtonBorder> fPush = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaPushButtonBorder>(AquaPushButtonBorder.class);
    private static final AquaUtils.RecyclableSingleton<AquaToggleButtonBorder> fToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaToggleButtonBorder>(AquaToggleButtonBorder.class);
    private static final AquaUtils.RecyclableSingleton<AquaIconToggleButtonBorder> fIconToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaIconToggleButtonBorder>(AquaIconToggleButtonBorder.class);
    public static final AquaUtils.RecyclableSingleton<AquaDisclosureTriangleButtonBorder> fDisclosureTriangle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaDisclosureTriangleButtonBorder>(AquaDisclosureTriangleButtonBorder.class);
    public static final AquaUtils.RecyclableSingleton<AquaDisclosureButtonBorder> fDisclosure = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaDisclosureButtonBorder>(AquaDisclosureButtonBorder.class);
    protected static final Icon regularToolbarSizingIcon = new EmptyIcon(32, 32);
    protected static final Icon smallToolbarSizingIcon = new EmptyIcon(24, 24);

    public static AquaButtonBorder getPushButtonBorder() {
        return fPush.get();
    }

    public static AquaButtonBorder getToggleButtonBorder() {
        return fToggle.get();
    }

    public static AquaButtonBorder getIconToggleButtonBorder() {
        return fIconToggle.get();
    }

    public static AquaButtonBorder getToolBarPushButtonBorder() {
        return fPush.get();
    }

    public static AquaButtonBorder getToolBarToggleButtonBorder() {
        return fToggle.get();
    }

    public static AquaButtonBorder getDisclosureTriangleButtonBorder() {
        return fDisclosureTriangle.get();
    }

    public static AquaButtonBorder getDisclosureButtonBorder() {
        return fDisclosure.get();
    }

    protected AquaButtonBorder() {
    }

    @Override
    public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    @Override
    public final void paintBackground(JComponent c, Graphics g, int x, int y, int width, int height) {
        AbstractButton b = (AbstractButton)c;
        this.doButtonPaint(b, g, x, y, width, height);
    }

    protected void doButtonPaint(AbstractButton b, Graphics g, int x, int y, int width, int height) {
        Configuration bg = this.getConfiguration(b, width, height);
        if (bg != null) {
            ButtonConfiguration btg;
            if (bg instanceof ButtonConfiguration && (btg = (ButtonConfiguration)bg).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
                Color c = b.getBackground();
                g.setColor(c);
                g.fillRect(x + 4, y + 4, width - 8, height - 8);
            }
            this.painter.configure(width, height);
            Painter p = this.painter.getPainter(bg);
            p.paint(g, x, y);
        }
    }

    protected AquaUIPainter.State getState(AbstractButton b) {
        boolean isActive = AquaFocusHandler.isActive(b);
        if (!b.isEnabled()) {
            return isActive ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (!isActive) {
            return AquaUIPainter.State.INACTIVE;
        }
        ButtonModel model = b.getModel();
        if (model.isArmed() && model.isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        if (model.isRollover()) {
            return AquaUIPainter.State.ROLLOVER;
        }
        if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
            return AquaUIPainter.State.ACTIVE_DEFAULT;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    public boolean allowsContent() {
        return true;
    }

    public boolean isRolloverEnabled(AbstractButton b) {
        AquaButtonExtendedTypes.WidgetInfo info = this.getWidgetInfo(b);
        return info != null && info.isRolloverEnabled();
    }

    public Font getCustomDefaultFont(AbstractButton b, AquaUIPainter.Size size, Font df) {
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g instanceof ButtonLayoutConfiguration) {
            ButtonLayoutConfiguration bg = (ButtonLayoutConfiguration)g;
            AquaUIPainter.ButtonWidget widget = bg.getButtonWidget();
            return AquaButtonExtendedTypes.getFont(df, (Object)widget, size);
        }
        if (g instanceof SegmentedButtonLayoutConfiguration) {
            SegmentedButtonLayoutConfiguration bg = (SegmentedButtonLayoutConfiguration)g;
            AquaUIPainter.SegmentedButtonWidget widget = bg.getWidget();
            return AquaButtonExtendedTypes.getFont(df, (Object)widget, size);
        }
        return df;
    }

    public Color getForegroundColor(AbstractButton b, AquaButtonExtendedTypes.ColorDefaults colorDefaults, boolean isIcon) {
        AquaButtonExtendedTypes.WidgetInfo info = this.getWidgetInfo(b);
        boolean isEnabled = b.getModel().isEnabled();
        boolean useNonexclusive = this.shouldUseNonexclusiveStyle(b, info);
        Color existingColor = b.getForeground();
        if (existingColor == null || existingColor instanceof UIResource || !isEnabled || useNonexclusive) {
            AquaUIPainter.State state = this.getState(b);
            AquaUIPainter.ButtonState bs = this.getButtonState(b);
            return info.getForeground(state, bs, colorDefaults, useNonexclusive, isIcon);
        }
        return existingColor;
    }

    protected boolean shouldUseNonexclusiveStyle(AbstractButton b, AquaButtonExtendedTypes.WidgetInfo info) {
        DefaultButtonModel dm;
        ButtonModel m;
        return info.isSegmented() && info.isTextured() && b.getModel().isSelected() && (m = b.getModel()) instanceof DefaultButtonModel && (dm = (DefaultButtonModel)m).getGroup() == null;
    }

    public int getIconTextGap(AbstractButton b) {
        AquaButtonExtendedTypes.WidgetInfo info = this.getWidgetInfo(b);
        int gap = info.getIconTextGap();
        return gap > 0 ? gap : 4;
    }

    @Override
    public final Insets getBorderInsets(Component c) {
        if (c == null || !(c instanceof AbstractButton)) {
            return new Insets(0, 0, 0, 0);
        }
        AbstractButton b = (AbstractButton)c;
        Insetter s = this.getContentInsets(b);
        Insets adjustments = this.getMarginAdjustments(b);
        return AquaUtils.combineAsInsets(s, adjustments);
    }

    public final Insets2D getBorderInsets2D(Component c) {
        if (c == null || !(c instanceof AbstractButton)) {
            return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
        }
        AbstractButton b = (AbstractButton)c;
        Insetter s = this.getContentInsets(b);
        Insets adjustments = this.getMarginAdjustments(b);
        return AquaUtils.combineAsInsets2D(s, adjustments);
    }

    protected Insets getMarginAdjustments(AbstractButton b) {
        Insets margin = b.getMargin();
        if (margin != null && !(margin instanceof UIResource)) {
            return margin;
        }
        Insets specialInsets = this.getSpecialMarginAdjustments(b);
        return specialInsets != null ? specialInsets : margin;
    }

    protected Insets getSpecialMarginAdjustments(AbstractButton b) {
        SegmentedButtonLayoutConfiguration sg;
        AquaUIPainter.SegmentedButtonWidget w;
        int m = this.getMargin(b);
        int top = 0;
        int left = m;
        int bottom = 0;
        int right = m;
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g instanceof SegmentedButtonLayoutConfiguration && ((w = (sg = (SegmentedButtonLayoutConfiguration)g).getWidget()) == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB) && sg.getSize() == AquaUIPainter.Size.MINI) {
            top = 1;
        }
        return new Insets(top, left, bottom, right);
    }

    protected int getMargin(AbstractButton b) {
        AquaButtonExtendedTypes.WidgetInfo info = this.getWidgetInfo(b);
        return info.getMargin();
    }

    protected Insetter getContentInsets(AbstractButton b) {
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        return g != null ? this.painter.getLayoutInfo().getContentInsets(g) : null;
    }

    public Insets getContentInsets(AbstractButton b, int w, int h) {
        Insetter s;
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g != null && (s = this.painter.getLayoutInfo().getContentInsets(g)) != null) {
            return s.asInsets();
        }
        return null;
    }

    public AquaButtonIcon createIcon(AbstractButton b, boolean isTemplate, AquaButtonExtendedTypes.ColorDefaults colorDefaults) {
        return new MyButtonIcon(b, isTemplate, colorDefaults);
    }

    public Dimension getMinimumButtonSize(AbstractButton b) {
        Dimension d = new Dimension(10, 10);
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g != null) {
            LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(g);
            int minimumWidth = (int)Math.ceil(layoutInfo.getMinimumVisualWidth());
            int minimumHeight = (int)Math.ceil(layoutInfo.getMinimumVisualHeight());
            if (minimumWidth > 0) {
                d.width = minimumWidth;
            }
            if (minimumHeight > 0) {
                d.height = minimumHeight;
            }
        }
        Icon substituteIcon = this.getSizingIcon(b);
        Dimension preferred = AquaButtonUI.getPreferredButtonSize(b, b.getIconTextGap(), substituteIcon);
        if (preferred != null) {
            d.width = Math.max(d.width, preferred.width);
            d.height = Math.max(d.height, preferred.height);
        }
        return d;
    }

    public Dimension getPreferredButtonSize(AbstractButton b) {
        Dimension min = this.getMinimumButtonSize(b);
        Icon substituteIcon = this.getSizingIcon(b);
        Dimension d = AquaButtonUI.getPreferredButtonSize(b, b.getIconTextGap(), substituteIcon);
        if (d == null) {
            return null;
        }
        if (min != null) {
            if (min.width > d.width) {
                d.width = min.width;
            }
            if (min.height > d.height) {
                d.height = min.height;
            }
        }
        return d;
    }

    public Icon getSizingIcon(AbstractButton b) {
        ButtonLayoutConfiguration bg;
        AquaUIPainter.ButtonWidget widget;
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g instanceof ButtonLayoutConfiguration && (widget = (bg = (ButtonLayoutConfiguration)g).getButtonWidget()) == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            AquaUIPainter.Size size = bg.getSize();
            switch (size) {
                case SMALL: 
                case MINI: {
                    return smallToolbarSizingIcon;
                }
            }
            return regularToolbarSizingIcon;
        }
        return null;
    }

    protected AquaButtonExtendedTypes.WidgetInfo getWidgetInfo(AbstractButton b) {
        Enum widget = null;
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g instanceof ButtonLayoutConfiguration) {
            widget = ((ButtonLayoutConfiguration)g).getButtonWidget();
        }
        if (g instanceof SegmentedButtonLayoutConfiguration) {
            widget = ((SegmentedButtonLayoutConfiguration)g).getWidget();
        }
        return AquaButtonExtendedTypes.getWidgetInfo(widget);
    }

    public Configuration getConfiguration(AbstractButton b, int width, int height) {
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g instanceof ButtonLayoutConfiguration) {
            AquaUIPainter.State state = this.getState(b);
            boolean isFocused = state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.INACTIVE && b.isFocusPainted() && b.hasFocus();
            AquaUIPainter.ButtonState bs = this.getButtonState(b);
            return new ButtonConfiguration((ButtonLayoutConfiguration)g, state, isFocused, bs);
        }
        if (g instanceof SegmentedButtonLayoutConfiguration) {
            AquaUIPainter.State state = this.getState(b);
            boolean isFocused = state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.INACTIVE && b.isFocusPainted() && b.hasFocus();
            boolean isSelected = b.getModel().isSelected();
            AquaUIPainter.Direction d = AquaUIPainter.Direction.NONE;
            return new SegmentedButtonConfiguration((SegmentedButtonLayoutConfiguration)g, state, isSelected, isFocused, d, SegmentedButtonConfiguration.DividerState.NONE, SegmentedButtonConfiguration.DividerState.NONE);
        }
        return null;
    }

    public LayoutConfiguration getLayoutConfiguration(AbstractButton b) {
        return (LayoutConfiguration)b.getClientProperty("Aqua.Button.LayoutConfiguration");
    }

    public LayoutConfiguration determineLayoutConfiguration(AbstractButton b) {
        Object widget = this.getButtonWidget(b);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(b);
        if (widget instanceof AquaUIPainter.ButtonWidget) {
            AquaUIPainter.ButtonWidget bw = (AquaUIPainter.ButtonWidget)((Object)widget);
            AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(b);
            return new ButtonLayoutConfiguration(bw, size, ld);
        }
        if (widget instanceof AquaUIPainter.SegmentedButtonWidget) {
            AquaUIPainter.SegmentedButtonWidget bw = (AquaUIPainter.SegmentedButtonWidget)((Object)widget);
            return new SegmentedButtonLayoutConfiguration(bw, size, AquaUIPainter.Position.ONLY);
        }
        return null;
    }

    public Object getButtonWidget(AbstractButton b) {
        return null;
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        LayoutConfiguration g = this.getLayoutConfiguration((AbstractButton)c);
        if (g != null) {
            int width = c.getWidth();
            int height = c.getHeight();
            this.painter.configure(width, height);
            return this.painter.getOutline(g);
        }
        return null;
    }

    protected boolean isProposedButtonWidgetUsable(AbstractButton b, Object widget) {
        LayoutConfiguration g;
        Enum w;
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(b);
        if (widget instanceof AquaUIPainter.ButtonWidget) {
            w = (AquaUIPainter.ButtonWidget)((Object)widget);
            AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(b);
            g = new ButtonLayoutConfiguration((AquaUIPainter.ButtonWidget)w, size, ld);
        } else if (widget instanceof AquaUIPainter.SegmentedButtonWidget) {
            w = (AquaUIPainter.SegmentedButtonWidget)((Object)widget);
            g = new SegmentedButtonLayoutConfiguration((AquaUIPainter.SegmentedButtonWidget)w, size, AquaUIPainter.Position.MIDDLE);
        } else {
            return false;
        }
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(g);
        int fixedHeight = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
        if (fixedHeight == 0) {
            return true;
        }
        Insetter insetter = this.painter.getLayoutInfo().getContentInsets(g);
        if (insetter == null || !insetter.isInvertible()) {
            return true;
        }
        Font font = AquaUtilControlSize.isOKToInstallDefaultFont(b) ? AquaButtonExtendedTypes.getFont(AquaButtonUI.getGenericDefaultFont(b), widget, size) : b.getFont();
        Dimension contentSize = AquaButtonUI.getPreferredContentSize(b, font, b.getIconTextGap());
        Dimension requiredSize = insetter.expand(contentSize);
        return requiredSize.height <= fixedHeight;
    }

    protected AquaUIPainter.ButtonState getButtonState(AbstractButton b) {
        ButtonLayoutConfiguration bg;
        if (b instanceof JToggleButton) {
            return b.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        }
        LayoutConfiguration g = this.getLayoutConfiguration(b);
        if (g instanceof ButtonLayoutConfiguration && (bg = (ButtonLayoutConfiguration)g).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return b.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        }
        return AquaUIPainter.ButtonState.STATELESS;
    }

    protected class MyButtonIcon
    extends AquaButtonIcon {
        protected final AbstractButton b;

        public MyButtonIcon(AbstractButton b, boolean isTemplate, AquaButtonExtendedTypes.ColorDefaults colorDefaults) {
            super(AquaIcon.getImageForIcon(b.getIcon()), isTemplate, colorDefaults);
            this.b = b;
        }

        @Override
        protected Color getExistingColor() {
            return this.b.getForeground();
        }

        @Override
        protected AquaButtonIcon.Key getRenderingKey() {
            AquaButtonExtendedTypes.WidgetInfo info = AquaButtonBorder.this.getWidgetInfo(this.b);
            AquaUIPainter.State state = AquaButtonBorder.this.getState(this.b);
            AquaUIPainter.ButtonState bs = AquaButtonBorder.this.getButtonState(this.b);
            return new AquaButtonIcon.Key(info, state, bs);
        }

        @Override
        protected boolean isNonexclusiveStyle(AquaButtonIcon.Key key) {
            return AquaButtonBorder.this.shouldUseNonexclusiveStyle(this.b, key.getWidgetInfo());
        }
    }
}

