/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonToggleUI;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaNamedButtonBorder;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaButtonExtendedTypes {
    protected static final AquaUtils.RecyclableSingleton<Map<String, TypeSpecifier>> typeDefinitions = new AquaUtils.RecyclableSingleton<Map<String, TypeSpecifier>>(){

        @Override
        protected Map<String, TypeSpecifier> getInstance() {
            return AquaButtonExtendedTypes.getAllTypes();
        }
    };
    protected static final WidgetInfo defaultButtonWidgetInfo = new WidgetInfo();
    protected static final WidgetInfo defaultSegmentedButtonWidgetInfo = new WidgetInfo().withSegmented();
    protected static final AquaUtils.RecyclableSingleton<Map<Object, WidgetInfo>> widgetDefinitions = new AquaUtils.RecyclableSingleton<Map<Object, WidgetInfo>>(){

        @Override
        protected Map<Object, WidgetInfo> getInstance() {
            return AquaButtonExtendedTypes.getAllWidgets();
        }
    };

    public static TypeSpecifier getTypeSpecifier(AbstractButton b) {
        Object buttonTypeProperty = b.getClientProperty("JButton.buttonType");
        Object segmentPositionProperty = b.getClientProperty("JButton.segmentPosition");
        if (buttonTypeProperty == null) {
            if (segmentPositionProperty != null || b.getUI().getClass() == AquaButtonToggleUI.class) {
                buttonTypeProperty = "segmented";
            } else {
                return null;
            }
        }
        if (buttonTypeProperty instanceof String) {
            String buttonType = (String)buttonTypeProperty;
            if (segmentPositionProperty instanceof String) {
                String typeName;
                TypeSpecifier specifier;
                String segmentPosition = (String)segmentPositionProperty;
                if (buttonType.equals("segmented")) {
                    if (AquaButtonUI.isOnToolbar(b)) {
                        buttonType = "segmentedTextured";
                    }
                } else if (buttonType.equals("segmentedSeparated") && AquaButtonUI.isOnToolbar(b)) {
                    buttonType = "segmentedTexturedSeparated";
                }
                if ((specifier = AquaButtonExtendedTypes.getSpecifierByName(b, typeName = buttonType + "-" + AquaButtonExtendedTypes.getRealPositionForLogicalPosition(segmentPosition, b.getComponentOrientation().isLeftToRight()))) != null) {
                    return specifier;
                }
            }
            if (buttonType.equals("round") && AquaButtonUI.isOnToolbar(b)) {
                buttonType = "roundTextured";
            }
            return AquaButtonExtendedTypes.getSpecifierByName(b, buttonType);
        }
        return null;
    }

    public static WidgetInfo getTabWidgetInfo(AquaUIPainter.Size sz, AquaUIPainter.Position pos) {
        return widgetDefinitions.get().get((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB);
    }

    protected static String getRealPositionForLogicalPosition(String logicalPosition, boolean leftToRight) {
        if (!leftToRight) {
            if ("first".equalsIgnoreCase(logicalPosition)) {
                return "last";
            }
            if ("last".equalsIgnoreCase(logicalPosition)) {
                return "first";
            }
        }
        return logicalPosition;
    }

    public static TypeSpecifier getSpecifierByName(AbstractButton b, String name) {
        if (AquaButtonUI.isOnToolbar(b)) {
            String toolbarName = name + "-onToolbar";
            TypeSpecifier specifier = typeDefinitions.get().get(toolbarName);
            if (specifier != null) {
                return specifier;
            }
        }
        return typeDefinitions.get().get(name);
    }

    public static Font getFont(Font buttonFont, Object widget, AquaUIPainter.Size size) {
        WidgetInfo info = AquaButtonExtendedTypes.getWidgetInfo(widget);
        assert (info != null);
        Font font = info.getFont(size);
        if (font != null) {
            return font;
        }
        if (size != null && size != AquaUIPainter.Size.REGULAR) {
            float fontSize = AquaButtonExtendedTypes.getFontSize(size);
            return buttonFont.deriveFont(fontSize);
        }
        return buttonFont;
    }

    protected static float getFontSize(AquaUIPainter.Size size) {
        switch (size) {
            case SMALL: {
                return 11.0f;
            }
            case MINI: {
                return 9.0f;
            }
        }
        return 13.0f;
    }

    public static WidgetInfo getWidgetInfo(Object widget) {
        WidgetInfo info = widgetDefinitions.get().get(widget);
        if (info != null) {
            return info;
        }
        if (widget instanceof AquaUIPainter.SegmentedButtonWidget) {
            return defaultSegmentedButtonWidgetInfo;
        }
        if (widget instanceof AquaUIPainter.ButtonWidget) {
            return defaultButtonWidgetInfo;
        }
        return defaultButtonWidgetInfo;
    }

    protected static Map<Object, WidgetInfo> getAllWidgets() {
        HashMap<Object, WidgetInfo> result = new HashMap<Object, WidgetInfo>();
        ColorUIResource black34 = new ColorUIResource(new Color(34, 34, 34));
        ColorUIResource dark64 = new ColorUIResource(new Color(0, 0, 0, 64));
        ColorUIResource dark140 = new ColorUIResource(new Color(0, 0, 0, 140));
        ColorUIResource dark170 = new ColorUIResource(new Color(0, 0, 0, 170));
        ColorUIResource dark220 = new ColorUIResource(new Color(0, 0, 0, 220));
        ColorUIResource light150 = new ColorUIResource(new Color(255, 255, 255, 150));
        ColorUIResource light180 = new ColorUIResource(new Color(255, 255, 255, 180));
        ColorUIResource white = new ColorUIResource(Color.WHITE);
        ColorUIResource pressedWhite = new ColorUIResource(new Color(255, 255, 255, 220));
        ColorUIResource defaultWhite = new ColorUIResource(250, 250, 250);
        Color texturedUnselected = UIManager.getColor("Button.texturedUnselectedColor");
        Color texturedSelected = UIManager.getColor("Button.texturedSelectedColor");
        Color texturedDisabledUnselected = UIManager.getColor("Button.texturedDisabledUnselectedColor");
        Color texturedDisabledSelected = UIManager.getColor("Button.texturedDisabledSelectedColor");
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX, new WidgetInfo());
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_RADIO, new WidgetInfo());
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_PUSH, new WidgetInfo().withMargin(5).withForeground(black34, dark64, pressedWhite).withActiveDefaultButtonForeground(defaultWhite));
        WidgetInfo segmentedRounded = new WidgetInfo().withSegmented().withMargin(9).withForeground(black34, white, null, null).withDisabledForeground(new GrayUIResource(172), dark64).withInactiveForeground(black34, null);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, segmentedRounded);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB, segmentedRounded);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, segmentedRounded);
        WidgetInfo gradient = new WidgetInfo().withForeground(dark220, dark220, dark64, null);
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_GRADIENT, gradient.withMargin(2));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL, gradient.withMargin(4));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND, gradient.withMargin(6));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT, gradient.withMargin(4));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUND, new WidgetInfo().withForeground(dark220, white, dark64, null));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM, new WidgetInfo().withForeground(new GrayUIResource(89), new GrayUIResource(81), null, null).withDisabledForeground(new GrayUIResource(134), new GrayUIResource(150)).withInactiveForeground(new GrayUIResource(153), new GrayUIResource(172)).withInactiveDisabledForeground(new GrayUIResource(198), new GrayUIResource(173)).withFont(size -> size == AquaUIPainter.Size.SMALL || size == AquaUIPainter.Size.MINI ? UIManager.getFont("IconButton.smallFont") : UIManager.getFont("IconButton.font")).withIconTextGap(2));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_INLINE, new WidgetInfo().withFont(UIManager.getFont("Button.inline.font")).withForeground(white, new GrayUIResource(240)).withIconPressed(pressedWhite));
        WidgetInfo textured = new WidgetInfo().withTextured().withEnabledForeground(texturedSelected, texturedUnselected).withPressed(white, black34).withDisabledForeground(texturedDisabledSelected, texturedDisabledUnselected).withInactiveForeground(new GrayUIResource(164), new GrayUIResource(178)).withInactiveDisabledForeground(new GrayUIResource(195), new GrayUIResource(211));
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED, textured);
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR, textured);
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED, textured);
        WidgetInfo segmentedTextured = textured.copy().withSegmented().withMargin(9);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, segmentedTextured);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, segmentedTextured);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, segmentedTextured);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, segmentedTextured);
        WidgetInfo segmentedGradient = gradient.copy().withSegmented().withMargin(9);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, segmentedGradient);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, segmentedGradient);
        result.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, segmentedGradient);
        result.put((Object)AquaUIPainter.ButtonWidget.BUTTON_RECESSED, new WidgetInfo().withFont(UIManager.getFont("Button.recessed.font")).withRolloverEnabled(UIManager.getColor("Button.recessed.rolloverText")).withForeground(dark170, white).withDisabledForeground(light150, dark64).withInactiveForeground(dark64).withInactiveDisabledForeground(light180, dark64).withPressed(white));
        WidgetInfo pushPopUp = new WidgetInfo().withMargin(5).withForeground(black34, dark64, dark220);
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN, pushPopUp);
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP, pushPopUp);
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_RECESSED));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_RECESSED));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_GRADIENT));
        result.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT, (WidgetInfo)result.get((Object)AquaUIPainter.ButtonWidget.BUTTON_GRADIENT));
        return result;
    }

    protected static Map<String, TypeSpecifier> getAllTypes() {
        TypeSpecifier[] specifiers;
        HashMap<String, TypeSpecifier> specifiersByName = new HashMap<String, TypeSpecifier>();
        for (TypeSpecifier specifier : specifiers = new TypeSpecifier[]{new FixedBorderTypeSpecifier("toolbar", AquaButtonBorder.getToolBarToggleButtonBorder()), new FixedBorderTypeSpecifier("icon", AquaButtonBorder.getIconToggleButtonBorder()), new FixedBorderTypeSpecifier("text", (AquaButtonBorder)UIManager.getBorder("Button.border")), new FixedBorderTypeSpecifier("toggle", AquaButtonBorder.getToggleButtonBorder()), new FixedBorderTypeSpecifier("disclosureTriangle", AquaButtonBorder.getDisclosureTriangleButtonBorder()), new FixedBorderTypeSpecifier("disclosure", AquaButtonBorder.getDisclosureButtonBorder()), new BorderDefinedTypeSpecifier("checkbox", AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX), new BorderDefinedTypeSpecifier("radio", AquaUIPainter.ButtonWidget.BUTTON_RADIO), new BorderDefinedTypeSpecifier("square", AquaUIPainter.ButtonWidget.BUTTON_BEVEL), new BorderDefinedTypeSpecifier("gradient", AquaUIPainter.ButtonWidget.BUTTON_GRADIENT), new BorderDefinedTypeSpecifier("bevel", AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND), new BorderDefinedTypeSpecifier("textured", AquaUIPainter.ButtonWidget.BUTTON_TEXTURED), new BorderDefinedTypeSpecifier("textured-onToolbar", AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR), new BorderDefinedTypeSpecifier("roundRect", AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT), new BorderDefinedTypeSpecifier("recessed", AquaUIPainter.ButtonWidget.BUTTON_RECESSED), new BorderDefinedTypeSpecifier("inline", AquaUIPainter.ButtonWidget.BUTTON_INLINE), new BorderDefinedTypeSpecifier("well", AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM), new BorderDefinedTypeSpecifier("toolbarItem", AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM), new BorderDefinedTypeSpecifier("help", AquaUIPainter.ButtonWidget.BUTTON_HELP), new BorderDefinedTypeSpecifier("round", AquaUIPainter.ButtonWidget.BUTTON_ROUND), new BorderDefinedTypeSpecifier("round-onToolbar", OSXSystemProperties.OSVersion >= 1011 ? AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR : AquaUIPainter.ButtonWidget.BUTTON_ROUND), new BorderDefinedTypeSpecifier("texturedRound", AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET), new BorderDefinedTypeSpecifier("roundTextured", AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED), new BorderDefinedTypeSpecifier("roundTextured-onToolbar", OSXSystemProperties.OSVersion >= 1011 ? AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR : AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED), new BorderDefinedTypeSpecifier("roundInset", AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET), new BorderDefinedTypeSpecifier("colorWell", AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL), new SegmentedTypeSpecifier("segmented-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmented-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmented-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmented-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedSeparated-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedSeparated-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedSeparated-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedSeparated-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedRoundRect-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedRoundRect-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedRoundRect-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedRoundRect-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedRounded-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedRounded-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedRounded-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedRounded-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTextured-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTextured-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTextured-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTextured-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTextured-first-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTextured-middle-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTextured-last-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTextured-only-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedCapsule-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedCapsule-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedCapsule-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedCapsule-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedGradient-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedGradient-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedGradient-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedGradient-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedSeparated-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedSeparated-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedSeparated-first-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-middle-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedSeparated-last-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-only-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.ONLY)}) {
            specifiersByName.put(specifier.name, specifier);
        }
        return specifiersByName;
    }

    protected static class GrayUIResource
    extends ColorUIResource {
        public GrayUIResource(int c) {
            super(new Color(c, c, c));
        }
    }

    public static class WidgetInfo
    implements Cloneable {
        private boolean isSegmented;
        private boolean isTextured;
        private Color foreground;
        private Color selectedForeground;
        private Color inactiveForeground;
        private Color inactiveSelectedForeground;
        private Color disabledForeground;
        private Color disabledSelectedForeground;
        private Color inactiveDisabledForeground;
        private Color inactiveDisabledSelectedForeground;
        private Color rolloverForeground;
        private Color pressedForeground;
        private Color selectedPressedForeground;
        private Color iconPressedForeground;
        private Color activeDefaultButtonForeground;
        private Font font;
        private FontFinder fontFinder;
        private float fontSize;
        private boolean isRolloverEnabled;
        private int iconTextGap;
        private int margin;

        WidgetInfo() {
        }

        WidgetInfo copy() {
            try {
                return (WidgetInfo)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Unable to clone WidgetInfo");
            }
        }

        WidgetInfo withSegmented() {
            this.isSegmented = true;
            return this;
        }

        WidgetInfo withTextured() {
            this.isTextured = true;
            return this;
        }

        WidgetInfo withFont(Font f) {
            this.font = f;
            return this;
        }

        WidgetInfo withFont(FontFinder ff) {
            this.fontFinder = ff;
            return this;
        }

        WidgetInfo withFontSize(float fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        WidgetInfo withIconTextGap(int gap) {
            this.iconTextGap = gap;
            return this;
        }

        WidgetInfo withMargin(int margin) {
            this.margin = margin;
            return this;
        }

        WidgetInfo withPressed(Color pressed) {
            this.pressedForeground = pressed;
            return this;
        }

        WidgetInfo withPressed(Color selected, Color unselected) {
            this.selectedPressedForeground = selected;
            this.pressedForeground = unselected;
            return this;
        }

        WidgetInfo withIconPressed(Color pressed) {
            this.iconPressedForeground = pressed;
            return this;
        }

        WidgetInfo withForeground(Color fg) {
            this.foreground = fg;
            return this;
        }

        WidgetInfo withForeground(Color fg, Color disabled) {
            this.foreground = fg;
            this.disabledForeground = disabled;
            return this;
        }

        WidgetInfo withForeground(Color fg, Color disabled, Color pressed) {
            this.foreground = fg;
            this.disabledForeground = disabled;
            this.pressedForeground = pressed;
            return this;
        }

        WidgetInfo withForeground(Color fg, Color selected, Color disabled, Color pressed) {
            this.foreground = fg;
            this.selectedForeground = selected;
            this.disabledForeground = disabled;
            this.pressedForeground = pressed;
            return this;
        }

        WidgetInfo withEnabledForeground(Color selected, Color unselected) {
            this.foreground = unselected;
            this.selectedForeground = selected;
            return this;
        }

        WidgetInfo withDisabledForeground(Color selected, Color unselected) {
            this.disabledSelectedForeground = selected;
            this.disabledForeground = unselected;
            return this;
        }

        WidgetInfo withInactiveForeground(Color c) {
            this.inactiveForeground = c;
            return this;
        }

        WidgetInfo withInactiveForeground(Color selected, Color unselected) {
            this.inactiveSelectedForeground = selected;
            this.inactiveForeground = unselected;
            return this;
        }

        WidgetInfo withInactiveDisabledForeground(Color c) {
            this.inactiveDisabledForeground = c;
            return this;
        }

        WidgetInfo withInactiveDisabledForeground(Color selected, Color unselected) {
            this.inactiveDisabledSelectedForeground = selected;
            this.inactiveDisabledForeground = unselected;
            return this;
        }

        WidgetInfo withActiveDefaultButtonForeground(Color c) {
            this.activeDefaultButtonForeground = c;
            return this;
        }

        WidgetInfo withRolloverEnabled(Color rolloverForeground) {
            this.isRolloverEnabled = true;
            this.rolloverForeground = rolloverForeground;
            return this;
        }

        public int getIconTextGap() {
            return this.iconTextGap;
        }

        public int getMargin() {
            return this.margin;
        }

        public Font getFont(AquaUIPainter.Size size) {
            if (this.fontFinder != null) {
                return this.fontFinder.getFont(size);
            }
            if (this.font != null && size != null && size != AquaUIPainter.Size.REGULAR) {
                float fontSize = AquaButtonExtendedTypes.getFontSize(size);
                return this.font.deriveFont(fontSize);
            }
            return this.font;
        }

        public Color getForeground(AquaUIPainter.State state, AquaUIPainter.ButtonState bs, ColorDefaults colorDefaults, boolean useNonexclusiveStyle, boolean isIcon) {
            if (useNonexclusiveStyle) {
                if (state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE) {
                    return UIManager.getColor("Button.texturedDisabledNonexclusiveSelectedColor");
                }
                return UIManager.getColor("Button.texturedNonexclusiveSelectedColor");
            }
            if (this.isRolloverEnabled && state == AquaUIPainter.State.ROLLOVER && this.rolloverForeground != null) {
                return this.rolloverForeground;
            }
            if (state == AquaUIPainter.State.PRESSED) {
                if (isIcon && this.iconPressedForeground != null) {
                    return this.iconPressedForeground;
                }
                if (bs == AquaUIPainter.ButtonState.ON && this.selectedPressedForeground != null) {
                    return this.selectedPressedForeground;
                }
                if (this.pressedForeground != null) {
                    return this.pressedForeground;
                }
            }
            if (state == AquaUIPainter.State.DISABLED_INACTIVE) {
                if (bs == AquaUIPainter.ButtonState.ON && this.inactiveDisabledSelectedForeground != null) {
                    return this.inactiveDisabledSelectedForeground;
                }
                if (this.inactiveDisabledForeground != null) {
                    return this.inactiveDisabledForeground;
                }
                state = AquaUIPainter.State.DISABLED;
            }
            if (state == AquaUIPainter.State.DISABLED) {
                if (bs == AquaUIPainter.ButtonState.ON && this.disabledSelectedForeground != null) {
                    return this.disabledSelectedForeground;
                }
                if (this.disabledForeground != null) {
                    return this.disabledForeground;
                }
                return colorDefaults.disabledTextColor;
            }
            if (state == AquaUIPainter.State.INACTIVE) {
                if (bs == AquaUIPainter.ButtonState.ON && this.inactiveSelectedForeground != null) {
                    return this.inactiveSelectedForeground;
                }
                if (this.inactiveForeground != null) {
                    return this.inactiveForeground;
                }
            }
            if (bs == AquaUIPainter.ButtonState.ON) {
                if (this.selectedForeground != null) {
                    return this.selectedForeground;
                }
                if (colorDefaults.selectedTextColor != null) {
                    return colorDefaults.selectedTextColor;
                }
            }
            if (state == AquaUIPainter.State.ACTIVE_DEFAULT && this.activeDefaultButtonForeground != null) {
                return this.activeDefaultButtonForeground;
            }
            if (this.foreground != null) {
                return this.foreground;
            }
            return colorDefaults.enabledTextColor;
        }

        public Color getTemplateSelectedColor(boolean useNonexclusive, ColorDefaults colorDefaults) {
            return this.getForeground(AquaUIPainter.State.ACTIVE, AquaUIPainter.ButtonState.ON, colorDefaults, useNonexclusive, true);
        }

        public Color getTemplateDisabledSelectedColor(boolean useNonexclusive, ColorDefaults colorDefaults) {
            return this.getForeground(AquaUIPainter.State.DISABLED, AquaUIPainter.ButtonState.ON, colorDefaults, useNonexclusive, true);
        }

        public Color getTemplateUnselectedColor(ColorDefaults colorDefaults) {
            return this.getForeground(AquaUIPainter.State.ACTIVE, AquaUIPainter.ButtonState.OFF, colorDefaults, false, true);
        }

        public Color getTemplateDisabledUnselectedColor(ColorDefaults colorDefaults) {
            return this.getForeground(AquaUIPainter.State.DISABLED, AquaUIPainter.ButtonState.OFF, colorDefaults, false, true);
        }

        public boolean isSegmented() {
            return this.isSegmented;
        }

        public boolean isTextured() {
            return this.isTextured;
        }

        public boolean isRolloverEnabled() {
            return this.isRolloverEnabled;
        }
    }

    protected static interface FontFinder {
        public Font getFont(AquaUIPainter.Size var1);
    }

    public static class SegmentedTypeSpecifier
    extends TypeSpecifier {
        private final AquaUIPainter.SegmentedButtonWidget widget;
        private final WidgetInfo info;
        private final AquaUIPainter.Position position;

        public SegmentedTypeSpecifier(String name, AquaUIPainter.SegmentedButtonWidget widget, AquaUIPainter.Position position) {
            super(name);
            this.widget = widget;
            this.info = AquaButtonExtendedTypes.getWidgetInfo((Object)widget);
            this.position = position;
        }

        @Override
        public AquaButtonBorder getBorder() {
            return new AquaSegmentedButtonBorder(this.widget, this.info, this.position);
        }
    }

    public static class BorderDefinedTypeSpecifier
    extends TypeSpecifier {
        private final AquaUIPainter.ButtonWidget widget;
        private final WidgetInfo info;

        public BorderDefinedTypeSpecifier(String name, AquaUIPainter.ButtonWidget widget) {
            super(name);
            this.widget = widget;
            this.info = AquaButtonExtendedTypes.getWidgetInfo((Object)widget);
        }

        @Override
        public AquaButtonBorder getBorder() {
            return new AquaNamedButtonBorder(this.widget, this.info);
        }
    }

    public static class FixedBorderTypeSpecifier
    extends TypeSpecifier {
        private final AquaButtonBorder border;

        public FixedBorderTypeSpecifier(String name, AquaButtonBorder border) {
            super(name);
            this.border = border;
        }

        @Override
        public AquaButtonBorder getBorder() {
            return this.border;
        }
    }

    public static abstract class TypeSpecifier {
        final String name;

        protected TypeSpecifier(String name) {
            this.name = name;
        }

        public abstract Border getBorder();
    }

    public static class ColorDefaults {
        public Color enabledTextColor;
        public Color selectedTextColor;
        public Color disabledTextColor;

        public Color getTextColor(boolean isEnabled, boolean isSelected) {
            if (isEnabled) {
                return isSelected ? this.selectedTextColor : this.enabledTextColor;
            }
            return this.disabledTextColor;
        }
    }
}

