/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.jnr.aqua.AquaUIPainter;

public abstract class AquaButtonIcon
implements Icon,
UIResource {
    protected final Image source;
    protected final boolean isTemplate;
    protected final Map<Key, Image> imageCache;
    protected final AquaButtonExtendedTypes.ColorDefaults colorDefaults;

    public AquaButtonIcon(Image source, boolean isTemplate, AquaButtonExtendedTypes.ColorDefaults colorDefaults) {
        this.source = source;
        this.isTemplate = isTemplate;
        this.colorDefaults = colorDefaults;
        this.imageCache = new HashMap<Key, Image>();
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Override
    public int getIconWidth() {
        return this.source.getWidth(null);
    }

    @Override
    public int getIconHeight() {
        return this.source.getHeight(null);
    }

    protected abstract Color getExistingColor();

    protected abstract Key getRenderingKey();

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean isComplete;
        Key key = this.getRenderingKey();
        Image im = this.imageCache.get(key);
        if (im == null) {
            im = this.createImage(key);
            this.imageCache.put(key, im);
        }
        if (!(isComplete = g.drawImage(im, x, y, c))) {
            new ImageIcon(im);
            if (!g.drawImage(im, x, y, c)) {
                System.err.println("Button icon not drawn!");
            }
        }
    }

    protected boolean isNonexclusiveStyle(Key key) {
        return false;
    }

    protected Color getTemplateColor(Key key) {
        Color color;
        AquaUIPainter.State state = key.getState();
        boolean isNonexclusiveStyle = this.isNonexclusiveStyle(key);
        if (state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.DISABLED_INACTIVE && !isNonexclusiveStyle && (color = this.getExistingColor()) != null && !(color instanceof UIResource)) {
            return color;
        }
        AquaUIPainter.ButtonState bs = key.getButtonState();
        AquaButtonExtendedTypes.WidgetInfo info = key.getWidgetInfo();
        return info.getForeground(state, bs, this.colorDefaults, isNonexclusiveStyle, true);
    }

    protected Image createImage(Key key) {
        Image im;
        Color color;
        if (this.isTemplate && (color = this.getTemplateColor(key)) != null && (im = AquaImageFactory.createImageFromTemplate(this.source, color)) != null) {
            return im;
        }
        return this.createImageForKey(key);
    }

    protected Image createImageForKey(Key key) {
        AquaUIPainter.State st = key.getState();
        if (st == AquaUIPainter.State.PRESSED) {
            return AquaImageFactory.generatePressedDarkImage(this.source);
        }
        if (st == AquaUIPainter.State.DISABLED || st == AquaUIPainter.State.DISABLED_INACTIVE) {
            return AquaImageFactory.generateDisabledLightImage(this.source);
        }
        return this.source;
    }

    public static final class Key {
        private AquaButtonExtendedTypes.WidgetInfo widgetInfo;
        private AquaUIPainter.State state;
        private AquaUIPainter.ButtonState bs;

        public Key(AquaButtonExtendedTypes.WidgetInfo widgetInfo, AquaUIPainter.State state, AquaUIPainter.ButtonState bs) {
            this.widgetInfo = widgetInfo;
            this.state = state;
            this.bs = bs;
        }

        public AquaButtonExtendedTypes.WidgetInfo getWidgetInfo() {
            return this.widgetInfo;
        }

        public AquaUIPainter.State getState() {
            return this.state;
        }

        public AquaUIPainter.ButtonState getButtonState() {
            return this.bs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.widgetInfo, key.widgetInfo) && this.state == key.state && this.bs == key.bs;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.widgetInfo, this.state, this.bs});
        }
    }
}

