/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.text.View;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaLabeledButtonBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public abstract class AquaButtonLabeledUI
extends AquaButtonUI {
    protected RecyclableSizingIcon regularIcon;
    protected RecyclableSizingIcon smallIcon;
    protected RecyclableSizingIcon miniIcon;
    protected final AquaLabeledButtonBorder widgetBorder;

    public AquaButtonLabeledUI(AquaLabeledButtonBorder border) {
        this.widgetBorder = border;
    }

    @Override
    protected Border getDefaultBorder(AbstractButton b) {
        return this.widgetBorder;
    }

    public Icon getDefaultIcon(JComponent c) {
        AquaUIPainter.Size componentSize;
        if (this.regularIcon == null) {
            this.regularIcon = this.createDefaultIcon(AquaUIPainter.Size.REGULAR);
            this.smallIcon = this.createDefaultIcon(AquaUIPainter.Size.SMALL);
            this.miniIcon = this.createDefaultIcon(AquaUIPainter.Size.MINI);
        }
        if ((componentSize = AquaUtilControlSize.getUserSizeFrom(c)) == AquaUIPainter.Size.REGULAR) {
            return (Icon)this.regularIcon.get();
        }
        if (componentSize == AquaUIPainter.Size.SMALL) {
            return (Icon)this.smallIcon.get();
        }
        if (componentSize == AquaUIPainter.Size.MINI) {
            return (Icon)this.miniIcon.get();
        }
        return (Icon)this.regularIcon.get();
    }

    protected RecyclableSizingIcon createDefaultIcon(AquaUIPainter.Size size) {
        return this.widgetBorder.createDefaultIcon(size);
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        FontMetrics fm = AquaUtils.getFontMetrics(c, null, f);
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(b.getWidth(), b.getHeight());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Icon icon = b.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(b);
        }
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        AquaUtils.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        return this.widgetBorder.getFocusRingOutline(b, iconRect);
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        Border border;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Dimension size = b.getSize();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(b.getWidth(), b.getHeight());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Icon altIcon = b.getIcon();
        boolean isCellEditor = c.getParent() instanceof CellRendererPane;
        if (b.isOpaque() || isCellEditor) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (((AbstractButton)c).isBorderPainted() && !isCellEditor && (border = c.getBorder()) instanceof AquaButtonBorder) {
            ((AquaButtonBorder)border).paintBackground(c, g, viewRect.x, viewRect.y, viewRect.width, viewRect.height);
        }
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        String text = AquaUtils.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(b), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (altIcon == null) {
            this.widgetBorder.paintBackground(c, g, iconRect.x, iconRect.y, iconRect.width, iconRect.height);
        } else {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon(b);
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle prefViewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Rectangle prefIconRect = new Rectangle();
        Rectangle prefTextRect = new Rectangle();
        AquaUtils.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        int x1 = Math.min(prefIconRect.x, prefTextRect.x);
        int x2 = Math.max(prefIconRect.x + prefIconRect.width, prefTextRect.x + prefTextRect.width);
        int y1 = Math.min(prefIconRect.y, prefTextRect.y);
        int y2 = Math.max(prefIconRect.y + prefIconRect.height, prefTextRect.y + prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        Insets prefInsets = b.getInsets();
        return new Dimension(width += prefInsets.left + prefInsets.right, height += prefInsets.top + prefInsets.bottom);
    }

    public static class RecyclableSizingIcon
    extends AquaUtils.RecyclableSingleton<Icon> {
        final int iconWidth;
        final int iconHeight;

        public RecyclableSizingIcon(int iconSize) {
            this.iconWidth = this.iconHeight = iconSize;
        }

        public RecyclableSizingIcon(int iconWidth, int iconHeight) {
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
        }

        @Override
        protected Icon getInstance() {
            return new ImageIcon(new BufferedImage(this.iconWidth, this.iconHeight, 3));
        }
    }
}

