/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonIcon;
import org.violetlib.aqua.AquaComboBoxButton;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaPushButtonBorder;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaSharedColorChooser;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.aqua.SharedColorChooserOwner;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaButtonUI
extends BasicButtonUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    public static final String BUTTON_TYPE = "JButton.buttonType";
    public static final String SEGMENTED_BUTTON_POSITION = "JButton.segmentPosition";
    public static final String SELECTED_STATE_KEY = "JButton.selectedState";
    public static final float OUTLINE_OFFSET = 0.0f;
    public static final float OUTLINE_CORNER = 9.0f;
    public static final String LAYOUT_CONFIGURATION_PROPERTY = "Aqua.Button.LayoutConfiguration";
    public static final String DEFAULT_FONT_PROPERTY = "Aqua.Button.DefaultFont";
    protected static final String COLOR_CHOOSER_OWNER_PROPERTY = "Aqua.Button.ColorChooserOwner";
    protected static final String SPECIAL_ICON_PROPERTY = "Aqua.Button.SpecialIcon";
    protected static final AquaUtils.RecyclableSingleton<AquaButtonUI> buttonUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaButtonUI>(AquaButtonUI.class);
    private AquaButtonExtendedTypes.ColorDefaults colorDefaults;
    static final AquaUtils.RecyclableSingleton<AquaHierarchyButtonListener> fHierListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaHierarchyButtonListener>(AquaHierarchyButtonListener.class);

    public static ComponentUI createUI(JComponent c) {
        return buttonUI.get();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.removeCachedIcons((AbstractButton)c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        String pp = this.getPropertyPrefix();
        if (this.colorDefaults == null) {
            this.colorDefaults = new AquaButtonExtendedTypes.ColorDefaults();
            this.colorDefaults.enabledTextColor = UIManager.getColor(pp + "foreground");
            this.colorDefaults.selectedTextColor = UIManager.getColor(pp + "selectedText");
            this.colorDefaults.disabledTextColor = UIManager.getColor(pp + "disabledText");
        }
        this.setButtonMarginIfNeeded(b, UIManager.getInsets(pp + "margin"));
        LookAndFeel.installColorsAndFont(b, pp + "background", pp + "foreground", pp + "font");
        LookAndFeel.installProperty(b, "opaque", UIManager.getBoolean(pp + "opaque"));
        b.putClientProperty(DEFAULT_FONT_PROPERTY, b.getFont());
        this.configure(b);
    }

    public void configure(AbstractButton b) {
        AquaButtonExtendedTypes.TypeSpecifier type = AquaButtonExtendedTypes.getTypeSpecifier(b);
        this.installBorder(b, type);
        LayoutConfiguration g = null;
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder bb = (AquaButtonBorder)border;
            g = bb.determineLayoutConfiguration(b);
            if (bb.isRolloverEnabled(b)) {
                LookAndFeel.installProperty(b, "rolloverEnabled", true);
            }
            int iconTextGap = bb.getIconTextGap(b);
            LookAndFeel.installProperty(b, "iconTextGap", iconTextGap);
        }
        b.putClientProperty(LAYOUT_CONFIGURATION_PROPERTY, g);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(b);
        if (AquaUtilControlSize.isOKToInstallDefaultFont(b)) {
            Font df = this.getDefaultFont(b, size);
            df = this.getCustomDefaultFont(b, size, df);
            AquaUtilControlSize.installDefaultFont(b, df);
        }
        this.updateTemplateIconStatus(b);
        b.setRequestFocusEnabled(false);
        b.revalidate();
        b.repaint();
    }

    protected void updateTemplateIconStatus(AbstractButton b) {
        Object o = b.getClientProperty(SPECIAL_ICON_PROPERTY);
        if (o instanceof AquaButtonIcon) {
            AquaButtonIcon icon = (AquaButtonIcon)o;
            boolean isTemplate = this.determineTemplateIconStatus(b);
            if (icon.isTemplate != isTemplate) {
                this.removeCachedIcons(b);
            }
        }
    }

    protected boolean determineTemplateIconStatus(AbstractButton b) {
        Icon standardIcon = b.getIcon();
        if (standardIcon instanceof ImageIcon) {
            ImageIcon im = (ImageIcon)standardIcon;
            Image image = im.getImage();
            return !this.isApplicationDefined(b.getPressedIcon()) && !this.isApplicationDefined(AquaButtonUI.getDisabledIcon(b)) && !this.isApplicationDefined(b.getSelectedIcon()) && !this.isApplicationDefined(AquaButtonUI.getDisabledSelectedIcon(b)) && !this.isApplicationDefined(b.getRolloverIcon()) && !this.isApplicationDefined(b.getRolloverSelectedIcon()) && AquaImageFactory.isTemplateImage(image);
        }
        return false;
    }

    protected boolean isApplicationDefined(Icon ic) {
        return ic != null && !(ic instanceof UIResource);
    }

    protected void installBorder(AbstractButton b, AquaButtonExtendedTypes.TypeSpecifier type) {
        Border customBorder;
        Border border = customBorder = type != null ? type.getBorder() : null;
        if (customBorder != null) {
            b.setBorder(customBorder);
        } else {
            Border oldBorder = b.getBorder();
            if (oldBorder == null || oldBorder instanceof UIResource) {
                Border border2 = this.getDefaultBorder(b);
                if (border2 == null) {
                    border2 = new AquaPushButtonBorder();
                }
                b.setBorder(border2);
            }
        }
    }

    protected Border getDefaultBorder(AbstractButton b) {
        if (AquaButtonUI.isOnToolbar(b)) {
            if (b instanceof JToggleButton) {
                return AquaButtonBorder.getToolBarToggleButtonBorder();
            }
            return AquaButtonBorder.getToolBarPushButtonBorder();
        }
        if (b instanceof JToggleButton) {
            return AquaButtonBorder.getToggleButtonBorder();
        }
        return AquaButtonBorder.getPushButtonBorder();
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        Border border = c.getBorder();
        if (border instanceof FocusRingOutlineProvider) {
            FocusRingOutlineProvider bb = (FocusRingOutlineProvider)((Object)border);
            return bb.getFocusRingOutline(c);
        }
        int width = c.getWidth();
        int height = c.getHeight();
        return new RoundRectangle2D.Double(0.0, 0.0, (float)width - 0.0f, (float)height - 0.0f, 9.0, 9.0);
    }

    @Override
    public void applySizeFor(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        this.configure((AbstractButton)c);
    }

    public static Font getGenericDefaultFont(AbstractButton b) {
        Font f = (Font)b.getClientProperty(DEFAULT_FONT_PROPERTY);
        if (f != null) {
            return f;
        }
        return b.getFont();
    }

    protected Font getDefaultFont(AbstractButton b, AquaUIPainter.Size size) {
        if (AquaButtonUI.shouldUseIconFont(b)) {
            return size == AquaUIPainter.Size.SMALL || size == AquaUIPainter.Size.MINI ? UIManager.getFont("IconButton.smallFont") : UIManager.getFont("IconButton.font");
        }
        return (Font)b.getClientProperty(DEFAULT_FONT_PROPERTY);
    }

    protected static boolean shouldUseIconFont(AbstractButton b) {
        return b.getIcon() != null || b.getComponentCount() > 0;
    }

    protected Font getCustomDefaultFont(AbstractButton b, AquaUIPainter.Size size, Font df) {
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder bb = (AquaButtonBorder)border;
            return bb.getCustomDefaultFont(b, size, df);
        }
        return AquaUtilControlSize.getFontForSize(df, size);
    }

    protected Color getForegroundColor(AbstractButton b) {
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder bb = (AquaButtonBorder)border;
            return bb.getForegroundColor(b, this.colorDefaults, false);
        }
        boolean isEnabled = b.getModel().isEnabled();
        Color existingColor = b.getForeground();
        if (existingColor == null || existingColor instanceof UIResource || !isEnabled) {
            boolean isSelected = b.getModel().isSelected();
            return this.colorDefaults.getTextColor(isEnabled, isSelected);
        }
        return existingColor;
    }

    public static boolean isOnToolbar(AbstractButton b) {
        for (Container parent = b.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    protected void setButtonMarginIfNeeded(AbstractButton b, Insets insets) {
        Insets margin = b.getMargin();
        if (margin == null || margin instanceof UIResource) {
            b.setMargin(insets);
        }
    }

    @Override
    protected void installListeners(AbstractButton b) {
        AquaButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.putClientProperty(this, listener);
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
            b.addAncestorListener(listener);
            b.addActionListener(listener);
        }
        this.installHierListener(b);
        AquaUtilControlSize.addSizePropertyListener(b);
        AquaFullKeyboardFocusableHandler.addListener(b);
    }

    @Override
    protected void installKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        if (listener != null) {
            listener.installKeyboardActions(b);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions((AbstractButton)c);
        this.uninstallListeners((AbstractButton)c);
        this.uninstallDefaults((AbstractButton)c);
        this.removeCachedIcons((AbstractButton)c);
    }

    @Override
    protected void uninstallKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        if (listener != null) {
            listener.uninstallKeyboardActions(b);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        AquaButtonListener listener = (AquaButtonListener)b.getClientProperty(this);
        b.putClientProperty(this, null);
        if (listener != null) {
            b.removeMouseListener(listener);
            b.removeMouseMotionListener(listener);
            b.removeFocusListener(listener);
            b.removeChangeListener(listener);
            b.removePropertyChangeListener(listener);
            b.removeAncestorListener(listener);
            b.removeActionListener(listener);
        }
        this.uninstallHierListener(b);
        AquaUtilControlSize.removeSizePropertyListener(b);
        AquaFullKeyboardFocusableHandler.removeListener(b);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        LookAndFeel.uninstallBorder(b);
        AquaUtilControlSize.uninstallDefaultFont(b);
    }

    protected void removeCachedIcons(AbstractButton b) {
        if (b.getSelectedIcon() instanceof UIResource) {
            b.setSelectedIcon(null);
        }
        if (AquaButtonUI.getDisabledIcon(b) instanceof UIResource) {
            b.setDisabledIcon(null);
        }
        if (AquaButtonUI.getDisabledSelectedIcon(b) instanceof UIResource) {
            b.setDisabledSelectedIcon(null);
        }
        if (b.getPressedIcon() instanceof UIResource) {
            b.setPressedIcon(null);
        }
        if (b.getRolloverIcon() instanceof UIResource) {
            b.setRolloverIcon(null);
        }
        if (b.getRolloverSelectedIcon() instanceof UIResource) {
            b.setRolloverSelectedIcon(null);
        }
        b.putClientProperty(SPECIAL_ICON_PROPERTY, null);
    }

    @Override
    protected AquaButtonListener createButtonListener(AbstractButton b) {
        return new AquaButtonListener(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Insets i = c.getInsets();
        int width = b.getWidth();
        int height = b.getHeight();
        Rectangle viewRect = new Rectangle(width, height);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        if (b.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
        }
        AquaButtonBorder aquaBorder = null;
        if (((AbstractButton)c).isBorderPainted()) {
            Border border = c.getBorder();
            if (border instanceof AquaButtonBorder) {
                aquaBorder = (AquaButtonBorder)border;
                aquaBorder.paintBackground(c, g, viewRect.x, viewRect.y, viewRect.width, viewRect.height);
            }
        } else if (b.isOpaque()) {
            viewRect.x = i.left - 2;
            viewRect.y = i.top - 2;
            viewRect.width = width - (i.right + viewRect.x) + 4;
            viewRect.height = height - (i.bottom + viewRect.y) + 4;
            if (b.isContentAreaFilled() || model.isSelected()) {
                if (model.isSelected()) {
                    g.setColor(c.getBackground().darker());
                } else {
                    g.setColor(c.getBackground());
                }
                g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
            }
        }
        if (aquaBorder != null && !aquaBorder.allowsContent()) {
            return;
        }
        Icon sizingIcon = null;
        if (aquaBorder != null) {
            sizingIcon = aquaBorder.getSizingIcon(b);
        }
        String text = this.layoutAndGetText(g, b, aquaBorder, i, viewRect, iconRect, textRect, sizingIcon);
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (textRect.width == 0) {
            textRect.width = 50;
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
    }

    protected String layoutAndGetText(Graphics g, AbstractButton b, AquaButtonBorder aquaBorder, Insets i, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Icon sizingIcon) {
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        g.setFont(b.getFont());
        FontMetrics fm = g.getFontMetrics();
        String originalText = b.getText();
        Icon ic = sizingIcon != null ? sizingIcon : b.getIcon();
        String text = AquaUtils.layoutCompoundLabel(b, fm, originalText, ic, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, originalText == null ? 0 : b.getIconTextGap());
        if (text == originalText || aquaBorder == null) {
            return text;
        }
        Insets alternateContentInsets = aquaBorder.getContentInsets(b, b.getWidth(), b.getHeight());
        if (alternateContentInsets != null) {
            return this.layoutAndGetText(g, b, null, alternateContentInsets, viewRect, iconRect, textRect, sizingIcon);
        }
        return text;
    }

    protected void paintIcon(Graphics g, AbstractButton b, Rectangle localIconRect) {
        Icon icon = this.getIcon(b);
        Graphics2D gg = null;
        if (icon.getIconWidth() != localIconRect.width || icon.getIconHeight() != localIconRect.height) {
            gg = (Graphics2D)g.create();
            g = gg;
            gg.translate(localIconRect.x, localIconRect.y);
            gg.scale(localIconRect.getWidth() / (double)icon.getIconWidth(), localIconRect.getHeight() / (double)icon.getIconHeight());
            gg.translate(-localIconRect.x, -localIconRect.y);
        }
        icon.paintIcon(b, g, localIconRect.x, localIconRect.y);
        if (gg != null) {
            gg.dispose();
        }
    }

    protected Icon getIcon(AbstractButton b) {
        ButtonIconState bs = AquaButtonUI.getIconState(b);
        Icon definedIcon = AquaButtonUI.getDefinedIcon(b, bs);
        if (definedIcon != null && bs != ButtonIconState.DEFAULT) {
            return definedIcon;
        }
        AquaButtonIcon icon = this.getSpecialIcon(b);
        if (icon != null) {
            return icon;
        }
        return definedIcon;
    }

    public static ButtonIconState getIconState(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return ButtonIconState.DISABLED_SELECTED;
            }
            return ButtonIconState.DISABLED;
        }
        if (model.isPressed() && model.isArmed()) {
            return ButtonIconState.PRESSED;
        }
        if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isSelected()) {
                return ButtonIconState.ROLLOVER_SELECTED;
            }
            return ButtonIconState.ROLLOVER;
        }
        if (model.isSelected()) {
            return ButtonIconState.SELECTED;
        }
        return ButtonIconState.DEFAULT;
    }

    public static Icon getDefinedIcon(AbstractButton b, ButtonIconState bs) {
        switch (bs) {
            case DISABLED: {
                return AquaButtonUI.getDisabledIcon(b);
            }
            case DISABLED_SELECTED: {
                return AquaButtonUI.getDisabledSelectedIcon(b);
            }
            case PRESSED: {
                return b.getPressedIcon();
            }
            case ROLLOVER_SELECTED: {
                return b.getRolloverSelectedIcon();
            }
            case ROLLOVER: {
                return b.getRolloverIcon();
            }
            case SELECTED: {
                return b.getSelectedIcon();
            }
        }
        return b.getIcon();
    }

    protected AquaButtonIcon getSpecialIcon(AbstractButton b) {
        Object o = b.getClientProperty(SPECIAL_ICON_PROPERTY);
        if (o instanceof AquaButtonIcon) {
            return (AquaButtonIcon)o;
        }
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder bb = (AquaButtonBorder)border;
            boolean isTemplate = this.determineTemplateIconStatus(b);
            AquaButtonIcon icon = bb.createIcon(b, isTemplate, this.colorDefaults);
            b.putClientProperty(SPECIAL_ICON_PROPERTY, icon);
            return icon;
        }
        return null;
    }

    public Icon createDisabledIcon(AbstractButton b, ImageIcon source) {
        AquaButtonIcon specialIcon = this.getSpecialIcon(b);
        if (specialIcon != null) {
            return specialIcon;
        }
        return this.createDefaultDisabledIcon(source);
    }

    public Icon createDisabledSelectedIcon(AbstractButton b, ImageIcon source) {
        AquaButtonIcon specialIcon = this.getSpecialIcon(b);
        if (specialIcon != null) {
            return specialIcon;
        }
        return this.createDefaultDisabledIcon(source);
    }

    protected ImageIcon createDefaultDisabledIcon(ImageIcon source) {
        return new ImageIconUIResource(AquaImageFactory.generateDisabledLightImage(source.getImage()));
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle localTextRect, String text) {
        this.paintText(g, (JComponent)b, localTextRect, text);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle localTextRect, String text) {
        Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = AquaMnemonicHandler.isMnemonicHidden() ? -1 : b.getDisplayedMnemonicIndex();
        Color foreground = this.getForegroundColor(b);
        g.setColor(foreground);
        AquaUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, localTextRect.x, localTextRect.y + fm.getAscent());
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.paint(g, b);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d;
        AbstractButton b = (AbstractButton)c;
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder bb = (AquaButtonBorder)border;
            d = bb.getMinimumButtonSize(b);
        } else {
            d = this.getPreferredSize(b);
        }
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder bb = (AquaButtonBorder)border;
            return bb.getPreferredButtonSize(b);
        }
        return AquaButtonUI.getPreferredButtonSize(b, b.getIconTextGap(), null);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    static AquaHierarchyButtonListener getAquaHierarchyButtonListener() {
        return fHierListener.get();
    }

    private boolean shouldInstallHierListener(AbstractButton b) {
        return b instanceof JButton || b instanceof JToggleButton && !(b instanceof AquaComboBoxButton) && !(b instanceof JCheckBox) && !(b instanceof JRadioButton);
    }

    protected void installHierListener(AbstractButton b) {
        if (this.shouldInstallHierListener(b)) {
            b.addHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    protected void uninstallHierListener(AbstractButton b) {
        if (this.shouldInstallHierListener(b)) {
            b.removeHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    protected Object willHandleButtonPress(AbstractButton b) {
        return null;
    }

    protected void didHandleButtonPress(AbstractButton b, Object data) {
    }

    protected void toggleColorChooser(final AbstractButton b) {
        Object o = b.getClientProperty(COLOR_CHOOSER_OWNER_PROPERTY);
        if (o instanceof SharedColorChooserOwner) {
            SharedColorChooserOwner owner = (SharedColorChooserOwner)o;
            AquaSharedColorChooser.disconnect(owner);
            b.setSelected(false);
            b.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, null);
            return;
        }
        SharedColorChooserOwner owner = new SharedColorChooserOwner(){

            @Override
            public void applyColor(Color c) {
                b.setBackground(c);
            }

            @Override
            public void disconnected() {
                b.setSelected(false);
                b.putClientProperty(AquaButtonUI.COLOR_CHOOSER_OWNER_PROPERTY, null);
            }
        };
        if (AquaSharedColorChooser.connect(owner)) {
            b.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, owner);
            b.setSelected(true);
        }
    }

    public static Icon getDisabledIcon(AbstractButton b) {
        boolean oldValue = AquaLookAndFeel.suppressCreationOfDisabledButtonIcons;
        AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = true;
        try {
            Icon icon = b.getDisabledIcon();
            return icon;
        }
        finally {
            AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = oldValue;
        }
    }

    public static Icon getDisabledSelectedIcon(AbstractButton b) {
        boolean oldValue = AquaLookAndFeel.suppressCreationOfDisabledButtonIcons;
        AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = true;
        try {
            Icon icon = b.getDisabledSelectedIcon();
            return icon;
        }
        finally {
            AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = oldValue;
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap, Icon substituteIcon) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = substituteIcon != null ? substituteIcon : b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    public static Dimension getPreferredContentSize(AbstractButton b, Font font, int textIconGap) {
        Icon icon = b.getIcon();
        String text = b.getText();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        return r.getSize();
    }

    class AquaButtonListener
    extends BasicButtonListener
    implements ActionListener,
    AncestorListener {
        protected final AbstractButton b;

        public AquaButtonListener(AbstractButton b) {
            super(b);
            this.b = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionListener[] listeners;
            ButtonLayoutConfiguration bg;
            Object o = this.b.getClientProperty(AquaButtonUI.LAYOUT_CONFIGURATION_PROPERTY);
            if (o instanceof ButtonLayoutConfiguration && (bg = (ButtonLayoutConfiguration)o).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL && (listeners = this.b.getActionListeners()).length == 1) {
                AquaButtonUI.this.toggleColorChooser(this.b);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            ((Component)e.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ((Component)e.getSource()).repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Border border;
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if ("Frame.active".equals(propertyName)) {
                this.b.repaint();
                return;
            }
            if ("icon".equals(propertyName) || "text".equals(propertyName)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if (propertyName != null && !propertyName.contains(".") && propertyName.endsWith("Icon")) {
                AquaButtonUI.this.updateTemplateIconStatus(this.b);
                return;
            }
            if (AquaButtonUI.BUTTON_TYPE.equals(propertyName)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if (AquaButtonUI.SEGMENTED_BUTTON_POSITION.equals(propertyName)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if ("verticalAlignment".equals(propertyName)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if ("componentOrientation".equals(propertyName) && (border = this.b.getBorder()) instanceof AquaSegmentedButtonBorder) {
                AquaButtonUI.this.configure(this.b);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            this.updateDefaultButton();
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
            this.updateDefaultButton();
        }

        protected void updateDefaultButton() {
            if (!(this.b instanceof JButton)) {
                return;
            }
            if (!((JButton)this.b).isDefaultButton()) {
                return;
            }
            JRootPane rootPane = this.b.getRootPane();
            if (rootPane == null) {
                return;
            }
            RootPaneUI ui = rootPane.getUI();
            if (!(ui instanceof AquaRootPaneUI)) {
                return;
            }
            ((AquaRootPaneUI)ui).updateDefaultButton(rootPane);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AbstractButton b;
            if (SwingUtilities.isLeftMouseButton(e) && (b = (AbstractButton)e.getSource()).contains(e.getX(), e.getY())) {
                Object data = AquaButtonUI.this.willHandleButtonPress(b);
                super.mousePressed(e);
                AquaButtonUI.this.didHandleButtonPress(b, data);
            }
        }
    }

    static class AquaHierarchyButtonListener
    implements HierarchyListener {
        AquaHierarchyButtonListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) == 0L) {
                return;
            }
            Object o = e.getSource();
            if (!(o instanceof AbstractButton)) {
                return;
            }
            AbstractButton b = (AbstractButton)o;
            ButtonUI ui = b.getUI();
            if (!(ui instanceof AquaButtonUI)) {
                return;
            }
            ((AquaButtonUI)ui).configure(b);
        }
    }

    static enum ButtonIconState {
        DISABLED,
        DISABLED_SELECTED,
        PRESSED,
        ROLLOVER,
        ROLLOVER_SELECTED,
        SELECTED,
        DEFAULT;

    }
}

